/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Lazy;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.i18n.UTF8Control;
import org.jackhuang.hmcl.util.platform.JavaVersion;

public final class Locales {
    public static final SupportedLocale DEFAULT = new SupportedLocale(Locale.getDefault(), "lang.default");
    public static final SupportedLocale EN = new SupportedLocale(Locale.ROOT);
    public static final SupportedLocale ZH = new SupportedLocale(Locale.TRADITIONAL_CHINESE);
    public static final SupportedLocale ZH_CN = new SupportedLocale(Locale.SIMPLIFIED_CHINESE);
    public static final SupportedLocale ES = new SupportedLocale(new Locale("es"));
    public static final SupportedLocale RU = new SupportedLocale(new Locale("ru"));
    public static final SupportedLocale JA = new SupportedLocale(Locale.JAPANESE);
    public static final List<SupportedLocale> LOCALES = Lang.immutableListOf(DEFAULT, EN, ZH_CN, ZH, ES, RU, JA);
    public static final Lazy<SimpleDateFormat> SIMPLE_DATE_FORMAT = new Lazy<SimpleDateFormat>(() -> new SimpleDateFormat(I18n.i18n("world.time")));
    public static final Lazy<DateTimeFormatter> DATE_TIME_FORMATTER = new Lazy<DateTimeFormatter>(() -> DateTimeFormatter.ofPattern(I18n.i18n("world.time")).withZone(ZoneId.systemDefault()));

    private Locales() {
    }

    public static SupportedLocale getLocaleByName(String name) {
        if (name == null) {
            return DEFAULT;
        }
        switch (name.toLowerCase()) {
            case "en": {
                return EN;
            }
            case "zh": {
                return ZH;
            }
            case "zh_cn": {
                return ZH_CN;
            }
            case "es": {
                return ES;
            }
            case "ru": {
                return RU;
            }
            case "ja": {
                return JA;
            }
        }
        return DEFAULT;
    }

    public static String getNameByLocale(SupportedLocale locale) {
        if (locale == EN) {
            return "en";
        }
        if (locale == ZH) {
            return "zh";
        }
        if (locale == ZH_CN) {
            return "zh_CN";
        }
        if (locale == ES) {
            return "es";
        }
        if (locale == RU) {
            return "ru";
        }
        if (locale == JA) {
            return "ja";
        }
        if (locale == DEFAULT) {
            return "def";
        }
        throw new IllegalArgumentException("Unknown locale: " + locale);
    }

    @JsonAdapter(value=TypeAdapter.class)
    public static class SupportedLocale {
        private final Locale locale;
        private final String name;
        private final ResourceBundle resourceBundle;

        SupportedLocale(Locale locale) {
            this(locale, null);
        }

        SupportedLocale(Locale locale, String name) {
            this.locale = locale;
            this.name = name;
            this.resourceBundle = JavaVersion.CURRENT_JAVA.getParsedVersion() == 8 ? ResourceBundle.getBundle("assets.lang.I18N", locale, UTF8Control.INSTANCE) : ResourceBundle.getBundle("assets.lang.I18N", locale);
        }

        public Locale getLocale() {
            return this.locale;
        }

        public ResourceBundle getResourceBundle() {
            return this.resourceBundle;
        }

        public String getName(ResourceBundle newResourceBundle) {
            if (this.name == null) {
                return this.resourceBundle.getString("lang");
            }
            return newResourceBundle.getString(this.name);
        }

        public static class TypeAdapter
        extends com.google.gson.TypeAdapter<SupportedLocale> {
            @Override
            public void write(JsonWriter out, SupportedLocale value) throws IOException {
                out.value(Locales.getNameByLocale(value));
            }

            @Override
            public SupportedLocale read(JsonReader in) throws IOException {
                return Locales.getLocaleByName(in.nextString());
            }
        }
    }
}

