/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jetbrains.annotations.NotNull;

public final class CompressingUtils {
    private static final FileSystemProvider ZIPFS_PROVIDER = FileSystemProvider.installedProviders().stream().filter(it -> "jar".equalsIgnoreCase(it.getScheme())).findFirst().orElseThrow(() -> new IllegalStateException("Zipfs not supported"));

    private CompressingUtils() {
    }

    @NotNull
    private static FileVisitResult testZipPath(Path file, Path root, AtomicBoolean result) {
        try {
            root.relativize(file).toString();
            return FileVisitResult.CONTINUE;
        }
        catch (Exception e) {
            result.set(false);
            return FileVisitResult.TERMINATE;
        }
    }

    public static boolean testEncoding(Path zipFile, Charset encoding) throws IOException {
        final AtomicBoolean result = new AtomicBoolean(true);
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(zipFile, encoding);){
            final Path root = fs.getPath("/", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    return CompressingUtils.testZipPath(file, root, result);
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return CompressingUtils.testZipPath(dir, root, result);
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        return result.get();
    }

    public static Charset findSuitableEncoding(Path zipFile) throws IOException {
        return CompressingUtils.findSuitableEncoding(zipFile, Charset.availableCharsets().values());
    }

    public static Charset findSuitableEncoding(Path zipFile, Collection<Charset> candidates) throws IOException {
        if (CompressingUtils.testEncoding(zipFile, StandardCharsets.UTF_8)) {
            return StandardCharsets.UTF_8;
        }
        if (OperatingSystem.NATIVE_CHARSET != StandardCharsets.UTF_8 && CompressingUtils.testEncoding(zipFile, OperatingSystem.NATIVE_CHARSET)) {
            return OperatingSystem.NATIVE_CHARSET;
        }
        for (Charset charset : candidates) {
            if (charset == null || !CompressingUtils.testEncoding(zipFile, charset)) continue;
            return charset;
        }
        throw new IOException("Cannot find suitable encoding for the zip.");
    }

    public static Builder readonly(Path zipFile) {
        return new Builder(zipFile, false);
    }

    public static Builder writable(Path zipFile) {
        return new Builder(zipFile, true).setUseTempFile(true);
    }

    public static FileSystem createReadOnlyZipFileSystem(Path zipFile) throws IOException {
        return CompressingUtils.createReadOnlyZipFileSystem(zipFile, null);
    }

    public static FileSystem createReadOnlyZipFileSystem(Path zipFile, Charset charset) throws IOException {
        return CompressingUtils.createZipFileSystem(zipFile, false, false, charset);
    }

    public static FileSystem createWritableZipFileSystem(Path zipFile) throws IOException {
        return CompressingUtils.createWritableZipFileSystem(zipFile, null);
    }

    public static FileSystem createWritableZipFileSystem(Path zipFile, Charset charset) throws IOException {
        return CompressingUtils.createZipFileSystem(zipFile, true, true, charset);
    }

    public static FileSystem createZipFileSystem(Path zipFile, boolean create, boolean useTempFile, Charset encoding) throws IOException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (create) {
            env.put("create", "true");
        }
        if (encoding != null) {
            env.put("encoding", encoding.name());
        }
        if (useTempFile) {
            env.put("useTempFile", true);
        }
        try {
            return ZIPFS_PROVIDER.newFileSystem(zipFile, env);
        }
        catch (ZipError error) {
            throw new ZipException(error.getMessage());
        }
        catch (UnsupportedOperationException ex) {
            throw new ZipException("Not a zip file");
        }
        catch (FileSystemNotFoundException ex) {
            throw new ZipException("Java Environment is broken");
        }
    }

    public static String readTextZipEntry(File zipFile, String name) throws IOException {
        try (ZipFile s = new ZipFile(zipFile);){
            String string = IOUtils.readFullyAsString(s.getInputStream(s.getEntry(name)), StandardCharsets.UTF_8);
            return string;
        }
    }

    public static String readTextZipEntry(Path zipFile, String name, Charset encoding) throws IOException {
        try (ZipFile s = new ZipFile(zipFile.toFile(), encoding.name());){
            String string = IOUtils.readFullyAsString(s.getInputStream(s.getEntry(name)), StandardCharsets.UTF_8);
            return string;
        }
    }

    public static Optional<String> readTextZipEntryQuietly(File file, String name) {
        try {
            return Optional.of(CompressingUtils.readTextZipEntry(file, name));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public static Optional<String> readTextZipEntryQuietly(Path file, String name, Charset encoding) {
        try {
            return Optional.of(CompressingUtils.readTextZipEntry(file, name, encoding));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public static final class Builder {
        private boolean autoDetectEncoding = false;
        private Collection<Charset> charsetCandidates;
        private Charset encoding = StandardCharsets.UTF_8;
        private boolean useTempFile = false;
        private final boolean create;
        private final Path zip;

        public Builder(Path zip, boolean create) {
            this.zip = zip;
            this.create = create;
        }

        public Builder setAutoDetectEncoding(boolean autoDetectEncoding) {
            this.autoDetectEncoding = autoDetectEncoding;
            return this;
        }

        public Builder setCharsetCandidates(Collection<Charset> charsetCandidates) {
            this.charsetCandidates = charsetCandidates;
            return this;
        }

        public Builder setEncoding(Charset encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setUseTempFile(boolean useTempFile) {
            this.useTempFile = useTempFile;
            return this;
        }

        public FileSystem build() throws IOException {
            if (this.autoDetectEncoding && !CompressingUtils.testEncoding(this.zip, this.encoding)) {
                if (this.charsetCandidates == null) {
                    this.charsetCandidates = Charset.availableCharsets().values();
                }
                this.encoding = CompressingUtils.findSuitableEncoding(this.zip, this.charsetCandidates);
            }
            return CompressingUtils.createZipFileSystem(this.zip, this.create, this.useTempFile, this.encoding);
        }
    }
}

