/*
 * Decompiled with CFR 0.152.
 */
package coolalias.structuregenapi.util;

import coolalias.structuregenapi.StructureGenerator;
import coolalias.structuregenapi.util.LogHelper;
import coolalias.structuregenapi.util.Structure;
import coolalias.structuregenapi.util.StructureGeneratorBase;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class LinkedStructureGenerator {
    private StructureGeneratorBase gen = null;
    private final List<Structure> structures = new LinkedList<Structure>();
    private final List<int[]> offsets = new LinkedList<int[]>();
    private final List<Byte> rots = new LinkedList<Byte>();
    private static final byte X = 0;
    private static final byte Y = 1;
    private static final byte Z = 2;
    private int rotation = 0;

    public <T extends StructureGeneratorBase> void setGenerator(T generator) {
        this.gen = generator;
    }

    public void rotateStructures() {
        ++this.rotation;
        this.rotation %= 4;
    }

    public void setRotation(int rot) {
        this.rotation = rot % 4;
    }

    public void addStructure(Structure structure) {
        this.addStructureWithOffset(structure, 0, 0, 0);
    }

    public void addStructureWithOffset(Structure structure, int x, int y, int z) {
        this.addStructureWithOffsetAndRotation(structure, x, y, z, 0);
    }

    public void addStructureWithOffsetAndRotation(Structure structure, int x, int y, int z, int rot) {
        this.structures.add(structure);
        this.addOffset(x, y, z);
        this.rots.add((byte)(rot % 4));
    }

    private void addOffset(int x, int y, int z) {
        this.offsets.add(new int[]{-z, y, x});
    }

    public void setLastOffset(int x, int y, int z) {
        if (!this.structures.isEmpty()) {
            if (this.offsets.size() < this.structures.size()) {
                this.addOffset(x, y, z);
            } else {
                this.offsets.set(this.offsets.size() - 1, new int[]{-z, y, x});
            }
        }
    }

    public void setLastRotation(int rot) {
        if (!this.rots.isEmpty()) {
            this.rots.set(this.rots.size() - 1, (byte)(rot % 4));
        }
    }

    public void generateLinkedStructures(World world, Random random, int x, int y, int z) {
        this.generateLinkedStructures(null, world, random, x, y, z);
    }

    public void generateLinkedStructures(EntityPlayer player, World world, Random random, int x, int y, int z) {
        int i = 0;
        if (this.structures.size() != this.offsets.size() || this.structures.size() != this.rots.size()) {
            LogHelper.log(Level.ERROR, "Structure List and Offset List are not the same size, aborting generation.");
            return;
        }
        if (this.gen == null) {
            this.gen = new StructureGenerator();
        }
        if (player != null) {
            this.gen.setPlayerFacing((Entity)player);
        }
        this.setOffsetFromRotation(player != null ? this.gen.getPlayerFacing() : -1);
        for (Structure structure : this.structures) {
            int[] offset = this.offsets.get(i);
            this.gen.setStructureWithRotation(structure, this.rotation + this.rots.get(i));
            this.gen.func_76484_a(world, random, x + offset[0], y + offset[1] + structure.getOffsetY(), z + offset[2]);
            ++i;
        }
    }

    private final void setOffsetFromRotation(int facing) {
        for (int[] offset : this.offsets) {
            for (int i = 0; i < (facing > 0 ? facing : 0); ++i) {
                int x = -offset[2];
                int z = offset[0];
                offset[0] = x;
                offset[2] = z;
            }
        }
    }
}

