/*
 * Decompiled with CFR 0.152.
 */
package coolalias.structuregenapi.util;

import com.mojang.authlib.GameProfile;
import coolalias.structuregenapi.util.BlockData;
import coolalias.structuregenapi.util.LogHelper;
import coolalias.structuregenapi.util.Structure;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHangingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S10PacketSpawnPainting;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.logging.log4j.Level;

public abstract class StructureGeneratorBase
extends WorldGenerator {
    public static final int SET_NO_BLOCK = Integer.MAX_VALUE;
    public static final int SOUTH = 0;
    public static final int WEST = 1;
    public static final int NORTH = 2;
    public static final int EAST = 3;
    private int structureFacing = 3;
    private int manualRotations = 0;
    private int facing;
    private int offsetX = 0;
    private int offsetY = 0;
    private int offsetZ = 0;
    private boolean removeStructure = false;
    private static final Map<Integer, ROTATION> blockRotationData = new HashMap<Integer, ROTATION>();
    private int[][][][] blockArray;
    private final List<int[][][][]> blockArrayList = new LinkedList<int[][][][]>();
    private final List<BlockData> postGenBlocks = new LinkedList<BlockData>();
    private static final GameProfile generatorName = new GameProfile(UUID.fromString("54acf800-054d-11e4-9191-0800200c9a66"), "fake");

    public StructureGeneratorBase() {
        super(true);
    }

    public StructureGeneratorBase(Entity entity, int[][][][] blocks) {
        this(entity, blocks, 3, 0, 0, 0);
    }

    public StructureGeneratorBase(Entity entity, int[][][][] blocks, int structureFacing) {
        this(entity, blocks, structureFacing, 0, 0, 0);
    }

    public StructureGeneratorBase(Entity entity, int[][][][] blocks, int structureFacing, int offX, int offY, int offZ) {
        super(true);
        this.setPlayerFacing(entity);
        this.setBlockArray(blocks);
        this.setStructureFacing(structureFacing);
        this.setOffset(offX, offY, offZ);
    }

    public abstract int getRealBlockID(int var1, int var2);

    public abstract void onCustomBlockAdded(World var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static final boolean registerCustomBlockRotation(int blockID, ROTATION rotationType) {
        return StructureGeneratorBase.registerCustomBlockRotation(blockID, rotationType, false);
    }

    public static final boolean registerCustomBlockRotation(int blockID, ROTATION rotationType, boolean override) {
        if (Block.func_149729_e((int)blockID) == null || blockID < 0 || blockID > 4095) {
            throw new IllegalArgumentException("[STRUCTURE GEN API] Error setting custom block rotation for block ID " + blockID + (Block.func_149729_e((int)blockID) == null ? "; block was not found in Block.blocksList. Please register your block." : "Valid ids are (0-4095)"));
        }
        if (blockRotationData.containsKey(blockID)) {
            LogHelper.log(Level.WARN, "Block " + blockID + " already has a rotation type." + (override ? " Overriding previous data." : ""));
            if (override) {
                blockRotationData.remove(blockID);
            } else {
                return false;
            }
        }
        blockRotationData.put(blockID, rotationType);
        return true;
    }

    public static final boolean addItemToTileInventory(World world, ItemStack itemstack, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof IInventory)) {
            LogHelper.log(Level.WARN, "Tile Entity at " + x + "/" + y + "/" + z + " is " + (tile != null ? "not an IInventory" : "null"));
            return false;
        }
        if (itemstack.field_77994_a < 1) {
            LogHelper.log(Level.OFF, "Trying to add ItemStack of size 0 to Tile Inventory");
            return false;
        }
        IInventory inventory = (IInventory)tile;
        int remaining = itemstack.field_77994_a;
        for (int i = 0; i < inventory.func_70302_i_() && remaining > 0; ++i) {
            ItemStack slotstack = inventory.func_70301_a(i);
            if (slotstack == null && inventory.func_94041_b(i, itemstack)) {
                itemstack.field_77994_a = (remaining -= inventory.func_70297_j_()) > 0 ? inventory.func_70297_j_() : itemstack.field_77994_a;
                inventory.func_70299_a(i, itemstack);
                inventory.func_70296_d();
                continue;
            }
            if (slotstack == null || !itemstack.func_77985_e() || !inventory.func_94041_b(i, itemstack) || Item.func_150891_b((Item)slotstack.func_77973_b()) != Item.func_150891_b((Item)itemstack.func_77973_b()) || itemstack.func_77981_g() && itemstack.func_77960_j() != slotstack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)slotstack)) continue;
            int l = slotstack.field_77994_a + remaining;
            if (l <= itemstack.func_77976_d() && l <= inventory.func_70297_j_()) {
                remaining = 0;
                slotstack.field_77994_a = l;
                inventory.func_70296_d();
                continue;
            }
            if (slotstack.field_77994_a >= itemstack.func_77976_d() || itemstack.func_77976_d() > inventory.func_70297_j_()) continue;
            remaining -= itemstack.func_77976_d() - slotstack.field_77994_a;
            slotstack.field_77994_a = itemstack.func_77976_d();
            inventory.func_70296_d();
        }
        return remaining < 1;
    }

    public static final boolean setEntityInStructure(World world, Entity entity, int x, int y, int z) {
        if (entity == null) {
            return false;
        }
        int iMax = entity.field_70130_N > 1.0f ? 16 : 4;
        world.func_147468_f(x, y, z);
        entity.func_70012_b((double)x, (double)y, (double)z, 0.0f, 0.0f);
        block6: for (int i = 0; entity.func_70094_T() && i < iMax; ++i) {
            if (i == 4 && entity.func_70094_T() && entity.field_70130_N > 1.0f) {
                entity.func_70012_b((double)x, (double)y, (double)z, 90.0f, 0.0f);
                LogHelper.log(Level.TRACE, "Large entity; rotating 90 degrees");
            } else if (i == 8 && entity.func_70094_T() && entity.field_70130_N > 1.0f) {
                entity.func_70012_b((double)x, (double)y, (double)z, 180.0f, 0.0f);
                LogHelper.log(Level.TRACE, "Large entity; rotating 180 degrees");
            } else if (i == 12 && entity.func_70094_T() && entity.field_70130_N > 1.0f) {
                entity.func_70012_b((double)x, (double)y, (double)z, 270.0f, 0.0f);
                LogHelper.log(Level.TRACE, "Large entity; rotating 270 degrees");
            }
            LogHelper.log(Level.TRACE, "Entity inside opaque block at " + entity.field_70165_t + "/" + entity.field_70163_u + "/" + entity.field_70161_v);
            switch (i % 4) {
                case 0: {
                    entity.func_70107_b(entity.field_70165_t + 0.5, entity.field_70163_u, entity.field_70161_v + 0.5);
                    continue block6;
                }
                case 1: {
                    entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v - 1.0);
                    continue block6;
                }
                case 2: {
                    entity.func_70107_b(entity.field_70165_t - 1.0, entity.field_70163_u, entity.field_70161_v);
                    continue block6;
                }
                case 3: {
                    entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v + 1.0);
                }
            }
        }
        if (entity.func_70094_T()) {
            LogHelper.log(Level.WARN, "Failed to set entity in open space. Returning to default position.");
            entity.func_70107_b(entity.field_70165_t + 0.5, entity.field_70163_u, entity.field_70161_v + 0.5);
            return false;
        }
        return true;
    }

    public static final boolean spawnEntityInStructure(World world, Entity entity, int x, int y, int z) {
        if (world.field_72995_K || entity == null) {
            return false;
        }
        boolean collided = StructureGeneratorBase.setEntityInStructure(world, entity, x, y, z);
        world.func_72838_d(entity);
        LogHelper.log(Level.TRACE, "Spawned entity at " + entity.field_70165_t + "/" + entity.field_70163_u + "/" + entity.field_70161_v);
        return collided;
    }

    public static final AxisAlignedBB getHangingEntityAxisAligned(int x, int y, int z, int direction) {
        double minX = x;
        double minZ = z;
        double maxX = minX;
        double maxZ = minZ;
        switch (direction) {
            case 2: {
                minX += 0.25;
                maxX += 0.75;
                minZ += 0.5;
                maxZ += 1.5;
                break;
            }
            case 3: {
                minX += 0.25;
                maxX += 0.75;
                minZ -= 0.5;
                maxZ += 0.5;
                break;
            }
            case 4: {
                minX += 0.5;
                maxX += 1.5;
                minZ += 0.25;
                maxZ += 0.75;
                break;
            }
            case 5: {
                minX -= 0.5;
                maxX += 0.5;
                minZ += 0.25;
                maxZ += 0.75;
            }
        }
        return AxisAlignedBB.func_72330_a((double)minX, (double)y, (double)minZ, (double)maxX, (double)((double)y + 1.0), (double)maxZ);
    }

    public static final int setHangingEntity(World world, ItemStack hanging, int x, int y, int z) {
        if (hanging.func_77973_b() == null || !(hanging.func_77973_b() instanceof ItemHangingEntity)) {
            return -1;
        }
        if (world.func_72805_g(x, y, z) < 1 || world.func_72805_g(x, y, z) > 5) {
            LogHelper.log(Level.WARN, "Hanging entity has invalid metadata of " + world.func_72805_g(x, y, z) + ". Valid values are 1,2,3,4");
            return -1;
        }
        int[] metaToFacing = new int[]{5, 4, 3, 2};
        int direction = metaToFacing[world.func_72805_g(x, y, z) - 1];
        FakePlayer player = new FakePlayer((WorldServer)world, generatorName);
        world.func_147468_f(x, y, z);
        switch (direction) {
            case 2: {
                ++z;
                break;
            }
            case 3: {
                --z;
                break;
            }
            case 4: {
                ++x;
                break;
            }
            case 5: {
                --x;
            }
        }
        ((ItemHangingEntity)hanging.func_77973_b()).func_77648_a(hanging, (EntityPlayer)player, world, x, y, z, direction, 0.0f, 0.0f, 0.0f);
        return direction;
    }

    public static final void setItemFrameStack(World world, ItemStack itemstack, int x, int y, int z, int direction) {
        StructureGeneratorBase.setItemFrameStack(world, itemstack, x, y, z, direction, 0);
    }

    public static final void setItemFrameStack(World world, ItemStack itemstack, int x, int y, int z, int direction, int itemRotation) {
        List frames = world.func_72872_a(EntityItemFrame.class, StructureGeneratorBase.getHangingEntityAxisAligned(x, y, z, direction));
        if (frames != null && !frames.isEmpty()) {
            for (EntityItemFrame frame : frames) {
                frame.func_82334_a(itemstack);
                frame.func_82336_g(itemRotation);
            }
        }
    }

    public static final boolean setPaintingArt(World world, String name, int x, int y, int z, int direction) {
        List paintings = world.func_72872_a(EntityPainting.class, StructureGeneratorBase.getHangingEntityAxisAligned(x, y, z, direction));
        if (paintings != null && !paintings.isEmpty() && name.length() > 0) {
            for (EntityPainting toEdit : paintings) {
                for (EntityPainting.EnumArt enumart : EntityPainting.EnumArt.values()) {
                    if (!enumart.field_75702_A.equals(name)) continue;
                    toEdit.field_70522_e = enumart;
                    MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                    if (server != null) {
                        server.func_71203_ab().func_148541_a((double)x, (double)y, (double)z, 64.0, world.field_73011_w.field_76574_g, (Packet)new S10PacketSpawnPainting(toEdit));
                    } else {
                        LogHelper.log(Level.INFO, "Attempt to send packet to all around without a server instance available");
                    }
                    return true;
                }
                LogHelper.log(Level.WARN, name + " does not match any values in EnumArt; unable to set painting art.");
            }
        }
        LogHelper.log(Level.WARN, "No EntityPainting was found at " + x + "/" + y + "/" + z);
        return false;
    }

    public static final boolean setSignText(World world, String[] text, int x, int y, int z) {
        TileEntitySign sign;
        TileEntitySign tileEntitySign = sign = world.func_147438_o(x, y, z) instanceof TileEntitySign ? (TileEntitySign)world.func_147438_o(x, y, z) : null;
        if (sign != null) {
            for (int i = 0; i < sign.field_145915_a.length && i < text.length; ++i) {
                if (text[i] == null) {
                    LogHelper.log(Level.WARN, "Uninitialized String element while setting sign text at index " + i);
                    continue;
                }
                if (text[i].length() > 15) {
                    LogHelper.log(Level.WARN, text[i] + " is too long to fit on a sign; maximum length is 15 characters.");
                    sign.field_145915_a[i] = text[i].substring(0, 15);
                    continue;
                }
                sign.field_145915_a[i] = text[i];
            }
            return true;
        }
        LogHelper.log(Level.WARN, "No TileEntitySign was found at " + x + "/" + y + "/" + z);
        return false;
    }

    public static final boolean setSkullData(World world, int type, int x, int y, int z) {
        return StructureGeneratorBase.setSkullData(world, type, -1, x, y, z);
    }

    public static final boolean setSkullData(World world, int type, int rot, int x, int y, int z) {
        TileEntitySkull skull;
        TileEntitySkull tileEntitySkull = skull = world.func_147438_o(x, y, z) instanceof TileEntitySkull ? (TileEntitySkull)world.func_147438_o(x, y, z) : null;
        if (skull != null) {
            if (type > 4 || type < 0) {
                LogHelper.log(Level.WARN, "Custom data value " + type + " not valid for skulls. Valid values are 0 to 4.");
                type = 0;
            }
            skull.func_152107_a(3);
            if (rot > -1) {
                skull.func_145903_a(rot % 16);
            }
            return true;
        }
        LogHelper.log(Level.WARN, "No TileEntitySkull found at " + x + "/" + y + "/" + z);
        return false;
    }

    public final int getPlayerFacing() {
        return this.facing;
    }

    public final void setPlayerFacing(Entity entity) {
        if (entity == null) {
            LogHelper.log(Level.WARN, "Null Pointer Exception! Cannot set facing from a null entity.");
        } else {
            this.facing = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        }
    }

    public final void setStructureFacing(int facing) {
        this.structureFacing = facing % 4;
    }

    public final void rotateStructureFacing() {
        ++this.structureFacing;
        this.structureFacing %= 4;
        ++this.manualRotations;
        this.manualRotations %= 4;
    }

    public final void rotateStructureFacing(int rotations) {
        this.structureFacing = (this.structureFacing + rotations) % 4;
        this.manualRotations = (this.manualRotations + rotations) % 4;
    }

    public final String currentStructureFacing() {
        return this.structureFacing == 3 ? "East" : (this.structureFacing == 1 ? "West" : (this.structureFacing == 2 ? "North" : "South"));
    }

    public final void addBlockArray(int[][][][] blocks) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.blockArrayList.add(blocks);
            if (this.blockArray == null) {
                this.blockArray = blocks;
            }
        }
    }

    public final void setBlockArray(int[][][][] blocks) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.blockArrayList.clear();
            this.blockArrayList.add(blocks);
            this.blockArray = blocks;
        }
    }

    public final void addBlockArrayList(List<int[][][][]> list) {
        this.blockArrayList.addAll(list);
        if (this.blockArray == null && list.size() > 0) {
            this.blockArray = list.get(0);
        }
    }

    public final void setBlockArrayList(List<int[][][][]> list) {
        this.blockArrayList.clear();
        this.blockArrayList.addAll(list);
        this.blockArray = list.size() > 0 ? list.get(0) : (int[][][][])null;
    }

    public final void setStructure(Structure structure) {
        if (structure != null) {
            this.reset();
            this.setBlockArrayList(structure.blockArrayList());
            this.setStructureFacing(structure.getFacing());
        } else {
            LogHelper.log(Level.ERROR, "NULL Structure cannot be set!");
        }
    }

    public final void setStructureWithRotation(Structure structure, int rotations) {
        this.setStructure(structure);
        this.manualRotations = 0;
        for (int i = 0; i < rotations % 4; ++i) {
            this.rotateStructureFacing();
        }
    }

    public final int getWidthX() {
        return this.blockArray != null ? this.blockArray[0].length : 0;
    }

    public final int getWidthZ() {
        return this.blockArray != null ? this.blockArray[0][0].length : 0;
    }

    public final int getHeight() {
        return this.blockArray != null ? this.blockArray.length : 0;
    }

    public final int getOriginalFacing() {
        return (this.structureFacing + (4 - this.manualRotations)) % 4;
    }

    public final boolean isOppositeAxis() {
        return this.getOriginalFacing() % 2 != this.structureFacing % 2;
    }

    public final void setOffset(int offX, int offY, int offZ) {
        this.offsetX = offX;
        this.offsetY = offY;
        this.offsetZ = offZ;
    }

    public final void setDefaultOffset() {
        this.setDefaultOffset(0, 0, 0);
    }

    public final void setDefaultOffset(int x, int y, int z) {
        boolean flag1;
        boolean flagNS = this.getOriginalFacing() % 2 == 0;
        int length = flagNS ? this.getWidthX() : this.getWidthZ();
        int adj1 = length - (flagNS ? this.getWidthZ() : this.getWidthX());
        boolean bl = flagNS ? this.getWidthX() % 2 == 0 && adj1 % 2 == 1 || this.getWidthX() % 2 == 1 && adj1 % 2 == -1 : (flag1 = this.getWidthX() % 2 == 0 && adj1 % 2 == -1 || this.getWidthX() % 2 == 1 && adj1 % 2 == 1);
        if (flag1 && !flagNS) {
            adj1 = -adj1;
        }
        int adj2 = (length + 1) % 2;
        int adj3 = adj1 % 2;
        int adj4 = adj1 / 2 + adj3;
        switch (this.getOriginalFacing()) {
            case 0: {
                this.offsetZ = x + length / 2 - (this.manualRotations == 0 ? adj1 / 2 + (adj3 == 0 ? 0 : (adj1 < 0 && flag1 ? adj3 : adj2)) : (this.manualRotations == 1 ? (adj3 == 0 ? adj2 : (adj1 > 0 && flag1 ? adj3 : 0)) : (this.manualRotations == 2 ? adj1 / 2 + (adj3 == 0 || flag1 ? adj2 : adj3) : 0)));
                this.offsetX = -z + (this.manualRotations == 0 ? adj2 + (adj3 > 0 && !flag1 ? adj4 : 0) : (this.manualRotations == 1 ? (adj3 == 0 ? adj2 : (flag1 ? (adj3 < 0 ? -adj3 : 0) : adj3)) : (this.manualRotations == 2 ? (adj3 > 0 && !flag1 ? adj4 : 0) : 0)));
                break;
            }
            case 1: {
                this.offsetX = x + length / 2 - (this.manualRotations == 0 ? (flag1 ? -adj4 : adj1 / 2) : (this.manualRotations == 2 ? (flag1 ? (adj1 > 0 ? -adj1 / 2 : -adj4) : adj1 / 2 + (adj3 == 0 ? adj2 : 0)) : (this.manualRotations == 3 ? (adj3 == 0 || flag1 ? adj2 : -adj3) : 0)));
                this.offsetZ = z + (this.manualRotations == 1 ? (adj3 < 0 && !flag1 ? adj4 : (adj3 > 0 && flag1 ? (adj1 > 1 ? -adj1 / 2 : -adj4) : 0)) + (adj3 == 0 ? -adj2 : 0) : (this.manualRotations == 2 ? (adj3 == 0 || flag1 ? -adj2 : adj3) : (this.manualRotations == 3 ? (adj3 < 0 && !flag1 ? adj4 : 0) : 0)));
                break;
            }
            case 2: {
                this.offsetZ = -x - length / 2 + (this.manualRotations == 0 ? adj1 / 2 + (adj3 == 0 || flag1 ? adj2 : adj3) : (this.manualRotations == 2 ? (flag1 ? adj4 : adj1 / 2) : (this.manualRotations == 3 ? (adj3 == 0 || flag1 ? adj2 : 0) : 0)));
                this.offsetX = z - (this.manualRotations == 0 ? (adj3 > 0 ? adj3 - adj2 : 0) : (this.manualRotations == 2 ? (adj3 > 0 ? adj3 : adj2) : (this.manualRotations == 3 ? (adj3 > 0 ? adj3 - adj2 : (adj3 < 0 ? -adj3 : adj2)) : 0)));
                break;
            }
            case 3: {
                this.offsetX = -x - length / 2 + (this.manualRotations == 0 ? adj1 / 2 + (adj3 == 0 ? adj2 : (flag1 ? -adj1 + (adj1 > 0 ? adj3 : 0) : 0)) : (this.manualRotations == 1 ? (adj3 == 0 || flag1 ? adj2 : -adj3) : (this.manualRotations == 2 ? (flag1 ? -adj4 : adj1 / 2) : 0)));
                this.offsetZ = -z - (this.manualRotations == 0 ? (adj3 == 0 || flag1 ? -adj2 : adj3) : (this.manualRotations == 1 ? (adj3 != 0 && !flag1 ? adj4 : 0) : (this.manualRotations == 3 ? (adj3 < 0 && !flag1 ? adj4 : (adj3 > 0 && flag1 ? -adj4 : 0)) + (adj3 == 0 ? -adj2 : (flag1 && adj1 > 1 ? adj3 : 0)) : 0)));
            }
        }
        this.offsetY = 1 + y;
    }

    public final boolean toggleRemoveStructure() {
        this.removeStructure = !this.removeStructure;
        return this.removeStructure;
    }

    public final void setRemoveStructure(boolean value) {
        this.removeStructure = value;
    }

    public final boolean canGenerate() {
        return this.blockArrayList.size() > 0 || this.blockArray != null;
    }

    public final boolean func_76484_a(World world, Random random, int posX, int posY, int posZ) {
        if (world.field_72995_K || !this.canGenerate()) {
            return false;
        }
        boolean generated = true;
        int rotations = ((this.isOppositeAxis() ? this.structureFacing + 2 : this.structureFacing) + this.facing) % 4;
        this.setOffsetFromRotation();
        for (int[][][][] blocks : this.blockArrayList) {
            if (!generated) break;
            this.blockArray = blocks;
            generated = this.generateLayer(world, random, posX, posY, posZ, rotations);
            this.offsetY += blocks.length;
        }
        if (generated) {
            this.doPostGenProcessing(world);
        }
        this.reset();
        return generated;
    }

    private final boolean generateLayer(World world, Random random, int posX, int posY, int posZ, int rotations) {
        int y;
        int centerX = this.blockArray[0].length / 2;
        int centerZ = this.blockArray[0][0].length / 2;
        int n = y = this.removeStructure ? this.blockArray.length - 1 : 0;
        while (this.removeStructure ? y >= 0 : y < this.blockArray.length) {
            for (int x = 0; x < this.blockArray[y].length; ++x) {
                for (int z = 0; z < this.blockArray[y][x].length; ++z) {
                    int realID;
                    if (this.blockArray[y][x][z].length == 0 || this.blockArray[y][x][z][0] == Integer.MAX_VALUE) continue;
                    int rotX = posX;
                    int rotZ = posZ;
                    int rotY = posY + y + this.offsetY;
                    switch (rotations) {
                        case 0: {
                            rotX += x - centerX + this.offsetX;
                            rotZ += z - centerZ + this.offsetZ;
                            break;
                        }
                        case 1: {
                            rotX += -(z - centerZ + this.offsetZ);
                            rotZ += x - centerX + this.offsetX;
                            break;
                        }
                        case 2: {
                            rotX += -(x - centerX + this.offsetX);
                            rotZ += -(z - centerZ + this.offsetZ);
                            break;
                        }
                        case 3: {
                            rotX += z - centerZ + this.offsetZ;
                            rotZ += -(x - centerX + this.offsetX);
                            break;
                        }
                        default: {
                            LogHelper.log(Level.WARN, "Error computing number of rotations.");
                        }
                    }
                    int customData1 = this.blockArray[y][x][z].length > 2 ? this.blockArray[y][x][z][2] : 0;
                    int fakeID = this.blockArray[y][x][z][0];
                    int n2 = realID = Math.abs(fakeID) > 4095 ? this.getRealBlockID(fakeID, customData1) : fakeID;
                    if (this.removeStructure) {
                        if (this.removeBlockAt(world, fakeID, realID, rotX, rotY, rotZ, rotations)) continue;
                        return false;
                    }
                    if (Math.abs(realID) > 4095) {
                        LogHelper.log(Level.WARN, "Invalid block ID. Initial ID: " + fakeID + ", returned id from getRealID: " + realID);
                        continue;
                    }
                    int customData2 = this.blockArray[y][x][z].length > 3 ? this.blockArray[y][x][z][3] : 0;
                    int meta = this.blockArray[y][x][z].length > 1 ? this.blockArray[y][x][z][1] : 0;
                    this.setBlockAt(world, fakeID, realID, meta, customData1, customData2, rotX, rotY, rotZ);
                }
            }
            y = this.removeStructure ? --y : ++y;
        }
        return true;
    }

    private final void setBlockAt(World world, int fakeID, int realID, int meta, int customData1, int customData2, int x, int y, int z) {
        if (realID >= 0 || world.func_147437_c(x, y, z) || world.func_147439_a(x, y, z) != null && world.func_147439_a(x, y, z).func_149688_o().func_76230_c()) {
            if (blockRotationData.containsKey(realID)) {
                meta = this.getMetadata(Math.abs(realID), meta, this.facing);
            }
            if (blockRotationData.containsKey(realID) && (blockRotationData.get(realID) == ROTATION.WALL_MOUNTED || blockRotationData.get(realID) == ROTATION.LEVER)) {
                LogHelper.log(Level.TRACE, "Block " + realID + " requires post-processing. Adding to list. Meta = " + meta);
                this.postGenBlocks.add(new BlockData(x, y, z, fakeID, meta, customData1, customData2));
            } else {
                world.func_147465_d(x, y, z, Block.func_149729_e((int)realID), meta, 2);
                if (blockRotationData.containsKey(realID)) {
                    this.setMetadata(world, x, y, z, meta, this.facing);
                }
                if (Math.abs(fakeID) > 4095) {
                    this.onCustomBlockAdded(world, x, y, z, fakeID, customData1, customData2);
                }
            }
        }
    }

    private final boolean removeBlockAt(World world, int fakeID, int realID, int x, int y, int z, int rotations) {
        int worldID = Block.func_149682_b((Block)world.func_147439_a(x, y, z));
        if (realID == 0 || Block.func_149729_e((int)worldID) == null || realID < 0 && worldID != Math.abs(realID)) {
            return true;
        }
        if (Math.abs(realID) == worldID || this.materialsMatch(realID, worldID)) {
            world.func_147468_f(x, y, z);
            List list = world.func_72872_a(Entity.class, StructureGeneratorBase.getHangingEntityAxisAligned(x, y, z, Direction.field_71582_c[rotations]).func_72314_b(1.0, 1.0, 1.0));
            for (Entity entity : list) {
                if (entity instanceof EntityPlayer) continue;
                entity.func_70106_y();
            }
        } else {
            LogHelper.log(Level.INFO, "Incorrect location for structure removal, aborting. Last block id checked: world " + worldID + ", real " + realID + ", fake " + fakeID);
            return false;
        }
        return true;
    }

    private final boolean materialsMatch(int realID, int worldID) {
        return Block.func_149729_e((int)worldID).func_149688_o() == Material.field_151577_b && Block.func_149729_e((int)Math.abs(realID)).func_149688_o() == Material.field_151578_c || Block.func_149729_e((int)worldID).func_149688_o().func_76224_d() && Block.func_149729_e((int)Math.abs(realID)).func_149688_o() == Block.func_149729_e((int)worldID).func_149688_o() || Block.func_149729_e((int)worldID).func_149688_o() == Material.field_151588_w && Block.func_149729_e((int)Math.abs(realID)).func_149688_o() == Material.field_151586_h || Block.func_149729_e((int)worldID).func_149688_o() == Material.field_76233_E && Block.func_149729_e((int)Math.abs(realID)).func_149688_o() == Material.field_76233_E || Block.func_149729_e((int)worldID) instanceof BlockRedstoneTorch && Block.func_149729_e((int)Math.abs(realID)) instanceof BlockRedstoneTorch || Block.func_149729_e((int)worldID) instanceof BlockRedstoneRepeater && Block.func_149729_e((int)Math.abs(realID)) instanceof BlockRedstoneRepeater;
    }

    private final void doPostGenProcessing(World world) {
        for (BlockData block : this.postGenBlocks) {
            int realID;
            int fakeID = block.getBlockID();
            int n = realID = Math.abs(fakeID) > 4095 ? this.getRealBlockID(fakeID, block.getCustomData1()) : fakeID;
            if (Math.abs(realID) > 4095) {
                LogHelper.log(Level.WARN, "Invalid block ID. Initial ID: " + fakeID + ", returned id from getRealID: " + realID);
                continue;
            }
            LogHelper.log(Level.TRACE, "Post-gen processing for initial ID: " + fakeID + ", returned id from getRealID: " + realID);
            if (realID < 0 && !world.func_147437_c(block.getPosX(), block.getPosY(), block.getPosZ()) && (world.func_147439_a(block.getPosX(), block.getPosY(), block.getPosZ()) == null || world.func_147439_a(block.getPosX(), block.getPosY(), block.getPosZ()).func_149688_o().func_76230_c())) continue;
            world.func_147465_d(block.getPosX(), block.getPosY(), block.getPosZ(), Block.func_149729_e((int)Math.abs(realID)), block.getMetaData(), 3);
            if (world.func_72805_g(block.getPosX(), block.getPosY(), block.getPosZ()) != block.getMetaData()) {
                LogHelper.log(Level.WARN, "Mismatched metadata. Meta from world: " + world.func_72805_g(block.getPosX(), block.getPosY(), block.getPosZ()) + ", original: " + block.getMetaData());
            }
            if (Math.abs(fakeID) <= 4095) continue;
            this.onCustomBlockAdded(world, block.getPosX(), block.getPosY(), block.getPosZ(), fakeID, block.getCustomData1(), block.getCustomData2());
        }
        this.postGenBlocks.clear();
    }

    private final void setMetadata(World world, int x, int y, int z, int origMeta, int facing) {
        int id = Block.func_149682_b((Block)world.func_147439_a(x, y, z));
        if (blockRotationData.get(id) == null) {
            return;
        }
        switch (blockRotationData.get(id)) {
            case PISTON_CONTAINER: {
                world.func_72921_c(x, y, z, origMeta, 2);
                break;
            }
            case RAIL: {
                world.func_72921_c(x, y, z, origMeta, 2);
                break;
            }
        }
    }

    private final int getMetadata(int id, int origMeta, int facing) {
        if (blockRotationData.get(id) == null) {
            return 0;
        }
        int rotations = ((this.isOppositeAxis() ? this.structureFacing + 2 : this.structureFacing) + facing) % 4;
        int meta = origMeta;
        int tickDelay = meta >> 2;
        int bit9 = meta >> 3;
        int bit4 = meta & 4;
        int bit8 = meta & 8;
        int extra = meta & 0xFFFFFFFC;
        block17: for (int i = 0; i < rotations; ++i) {
            int bitface = meta % 4;
            switch (blockRotationData.get(id)) {
                case ANVIL: {
                    meta ^= 1;
                    continue block17;
                }
                case DOOR: {
                    if (bit8 != 0) {
                        return meta;
                    }
                    meta = bitface == 3 ? 0 : bitface + 1;
                    meta |= extra;
                    continue block17;
                }
                case GENERIC: {
                    meta = (bitface == 3 ? 0 : bitface + 1) | bit4 | bit8;
                    continue block17;
                }
                case PISTON_CONTAINER: {
                    if ((meta -= meta > 7 ? 8 : 0) > 1) {
                        meta = meta == 2 ? 5 : (meta == 5 ? 3 : (meta == 3 ? 4 : 2));
                    }
                    meta |= bit8 | bit9 << 3;
                    continue block17;
                }
                case QUARTZ: {
                    meta = meta == 3 ? 4 : (meta == 4 ? 3 : meta);
                    continue block17;
                }
                case RAIL: {
                    if (meta < 2) {
                        meta ^= 1;
                        continue block17;
                    }
                    if (meta < 6) {
                        meta = meta == 2 ? 5 : (meta == 5 ? 3 : (meta == 3 ? 4 : 2));
                        continue block17;
                    }
                    meta = meta == 9 ? 6 : meta + 1;
                    continue block17;
                }
                case REPEATER: {
                    meta = (bitface == 3 ? 0 : bitface + 1) | tickDelay << 2;
                    continue block17;
                }
                case SIGNPOST: {
                    meta = meta < 12 ? meta + 4 : meta - 12;
                    continue block17;
                }
                case SKULL: {
                    meta = meta == 1 ? 1 : (meta == 4 ? 2 : (meta == 2 ? 5 : (meta == 5 ? 3 : 4)));
                    continue block17;
                }
                case STAIRS: {
                    meta = (bitface == 0 ? 2 : (bitface == 2 ? 1 : (bitface == 1 ? 3 : 0))) | bit4;
                    continue block17;
                }
                case TRAPDOOR: {
                    meta = (bitface == 0 ? 3 : (bitface == 3 ? 1 : (bitface == 1 ? 2 : 0))) | bit4 | bit8;
                    continue block17;
                }
                case VINE: {
                    meta = meta == 1 ? 2 : (meta == 2 ? 4 : (meta == 4 ? 8 : 1));
                    continue block17;
                }
                case WALL_MOUNTED: {
                    if (meta <= 0 || meta >= 5) continue block17;
                    meta = meta == 4 ? 1 : (meta == 1 ? 3 : (meta == 3 ? 2 : 4));
                    continue block17;
                }
                case LEVER: {
                    meta = (meta -= meta > 7 ? 8 : 0) > 0 && meta < 5 ? (meta == 4 ? 1 : (meta == 1 ? 3 : (meta == 3 ? 2 : 4))) : (meta == 5 || meta == 6 ? (meta == 5 ? 6 : 5) : (meta == 7 ? 0 : 7));
                    meta |= bit8;
                    continue block17;
                }
                case WOOD: {
                    if (meta <= 4 || meta >= 12) continue block17;
                    meta = meta < 8 ? meta + 4 : meta - 4;
                    continue block17;
                }
            }
        }
        return meta;
    }

    private final void setOffsetFromRotation() {
        for (int i = 0; i < this.manualRotations; ++i) {
            int x = -this.offsetZ;
            int z = this.offsetX;
            this.offsetX = x;
            this.offsetZ = z;
        }
    }

    private final void reset() {
        this.blockArrayList.clear();
        this.blockArray = null;
        this.offsetZ = 0;
        this.offsetY = 0;
        this.offsetX = 0;
    }

    static {
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150467_bQ), ROTATION.ANVIL);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150454_av), ROTATION.DOOR);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150466_ao), ROTATION.DOOR);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150324_C), ROTATION.GENERIC);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150375_by), ROTATION.GENERIC);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150396_be), ROTATION.GENERIC);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150423_aK), ROTATION.GENERIC);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150428_aP), ROTATION.GENERIC);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150378_br), ROTATION.GENERIC);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150479_bC), ROTATION.GENERIC);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150486_ae), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150447_bR), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150367_z), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150409_cd), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150477_bB), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150470_am), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150460_al), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150438_bZ), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150468_ap), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150444_as), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150331_J), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150326_M), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150332_K), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150320_F), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150408_cc), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150319_E), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150318_D), ROTATION.PISTON_CONTAINER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150449_bY), ROTATION.QUARTZ);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150448_aq), ROTATION.RAIL);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150455_bV), ROTATION.REPEATER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150441_bU), ROTATION.REPEATER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150416_aS), ROTATION.REPEATER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150413_aR), ROTATION.REPEATER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150472_an), ROTATION.SIGNPOST);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150465_bP), ROTATION.SKULL);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150389_bf), ROTATION.STAIRS);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150446_ar), ROTATION.STAIRS);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150387_bl), ROTATION.STAIRS);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150370_cb), ROTATION.STAIRS);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150372_bz), ROTATION.STAIRS);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150390_bg), ROTATION.STAIRS);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150487_bG), ROTATION.STAIRS);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150481_bH), ROTATION.STAIRS);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150476_ad), ROTATION.STAIRS);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150485_bF), ROTATION.STAIRS);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150400_ck), ROTATION.STAIRS);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150401_cl), ROTATION.STAIRS);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150415_aT), ROTATION.TRAPDOOR);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150395_bd), ROTATION.VINE);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150442_at), ROTATION.LEVER);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150430_aB), ROTATION.WALL_MOUNTED);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150471_bO), ROTATION.WALL_MOUNTED);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150429_aA), ROTATION.WALL_MOUNTED);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150437_az), ROTATION.WALL_MOUNTED);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150478_aa), ROTATION.WALL_MOUNTED);
        blockRotationData.put(Block.func_149682_b((Block)Blocks.field_150364_r), ROTATION.WOOD);
    }

    public static enum ROTATION {
        ANVIL,
        DOOR,
        GENERIC,
        PISTON_CONTAINER,
        QUARTZ,
        RAIL,
        REPEATER,
        SIGNPOST,
        SKULL,
        STAIRS,
        TRAPDOOR,
        VINE,
        WALL_MOUNTED,
        LEVER,
        WOOD;

    }
}

