/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.AI;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import mods.fossil.entity.mobs.EntityPrehistoric;
import mods.fossil.guiBlocks.TileEntityFeeder;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.chunk.Chunk;

public abstract class FossilAIWildIndividualBase
extends EntityAIBase {
    private static final int taskFleeNear = 0;
    private static final int taskFleeFar = 1;
    private static final int taskAvoid = 2;
    private static final int taskWanderFast = 3;
    private static final int taskWanderSlow = 4;
    private static final int taskFollow = 5;
    private static final int taskIdle = 6;
    private static final int taskTrackAndAttack = 7;
    private static final int taskFeedFromFeeder = 8;
    private static final int taskPickupItem = 9;
    private static final int taskEatBlock = 10;
    private static final int taskFormHerd = 11;
    private static final int taskAskJoinHerd = 12;
    private static final int taskFindAndDrinkWater = 13;
    private static final int fleeInterruptTicks = 5;
    private EntityPrehistoric entity;
    private Object target;
    private int task;
    private int tickCounter;
    private float radiusDimension;
    private boolean taskDone;
    private ArrayList<EntityPrehistoric> nearbyPrehistoricEntities = new ArrayList();
    private ArrayList<EntityPrehistoric> nearbyPrehistoricEntitiesOfSameSpecies = new ArrayList();
    private ArrayList<EntityLiving> nearbyLivingEntities = new ArrayList();
    private ArrayList<EntityItem> nearbyItemEntities = new ArrayList();
    private ArrayList<EntityPlayer> nearbyPlayers = new ArrayList();
    private ArrayList<EntityPrehistoric> fleeingTargets = new ArrayList();
    private ArrayList<TileEntityFeeder> feeders = new ArrayList();
    private ArrayList<EntityLiving> possibleFood = new ArrayList();
    private ArrayList<EntityItem> possibleItemFood = new ArrayList();
    private ArrayList<Vec3> foodBlocks = new ArrayList();
    private ArrayList<EntityPrehistoric> possibleFleeTargets = new ArrayList();
    private ArrayList<EntityPlayer> possibleFleeTargetPlayers = new ArrayList();
    private Chunk currentChunk;
    private Chunk tempChunk;

    public FossilAIWildIndividualBase(EntityPrehistoric entity) {
        this.entity = entity;
        this.func_75248_a(2);
    }

    public boolean func_75250_a() {
        return this.taskDone && !this.entity.hasOwner() && !this.entity.isInHerd();
    }

    public boolean func_75253_b() {
        return !this.taskDone && !this.entity.hasOwner() && !this.entity.isInHerd();
    }

    public void func_75249_e() {
        int k;
        this.taskDone = false;
        this.nearbyPrehistoricEntities.clear();
        this.nearbyPrehistoricEntitiesOfSameSpecies.clear();
        this.nearbyLivingEntities.clear();
        this.nearbyItemEntities.clear();
        this.nearbyPlayers.clear();
        this.fleeingTargets.clear();
        this.feeders.clear();
        this.possibleFood.clear();
        this.possibleItemFood.clear();
        this.foodBlocks.clear();
        Vec3 waterBlock = null;
        boolean checkedForWater = false;
        int chunkRadius = (int)Math.ceil(this.entity.getType().getMaxAwarenessRadius() / 16.0f);
        this.currentChunk = this.entity.field_70170_p.func_72964_e(this.entity.field_70176_ah, this.entity.field_70162_ai);
        for (int i = -chunkRadius; i <= chunkRadius; ++i) {
            for (int j = -chunkRadius; j <= chunkRadius; ++j) {
                this.tempChunk = this.entity.field_70170_p.func_72964_e(this.currentChunk.field_76635_g + i, this.currentChunk.field_76647_h + j);
                for (k = (int)((this.entity.field_70163_u - 4.0) / 16.0); k < (int)((this.entity.field_70163_u + 4.0) / 16.0) && k >= 0 && k < this.tempChunk.field_76645_j.length; ++k) {
                    for (Object tempEntity : this.tempChunk.field_76645_j[k]) {
                        if (tempEntity.getClass().isAssignableFrom(EntityPrehistoric.class)) {
                            if (!this.entity.canFindEntity((Entity)tempEntity)) continue;
                            this.nearbyPrehistoricEntities.add((EntityPrehistoric)((Object)tempEntity));
                            if (!tempEntity.getClass().isAssignableFrom(((Object)((Object)this.entity)).getClass())) continue;
                            this.nearbyPrehistoricEntitiesOfSameSpecies.add((EntityPrehistoric)((Object)tempEntity));
                            continue;
                        }
                        if (tempEntity.getClass().isAssignableFrom(EntityPlayer.class)) {
                            if (!this.entity.canFindEntity((Entity)tempEntity)) continue;
                            this.nearbyPlayers.add((EntityPlayer)tempEntity);
                            continue;
                        }
                        if (tempEntity.getClass().isAssignableFrom(EntityLiving.class)) {
                            if (!this.entity.canFindEntity((Entity)tempEntity)) continue;
                            this.nearbyLivingEntities.add((EntityLiving)tempEntity);
                            continue;
                        }
                        if (!tempEntity.getClass().isAssignableFrom(EntityItem.class) || !this.entity.canFindEntity((Entity)tempEntity)) continue;
                        this.nearbyItemEntities.add((EntityItem)tempEntity);
                    }
                }
            }
        }
        if (!this.nearbyPrehistoricEntities.isEmpty()) {
            for (EntityPrehistoric tempEntity : this.nearbyPrehistoricEntities) {
                if (!this.entity.getType().shouldRunFromEntity(tempEntity)) continue;
                this.fleeingTargets.add(tempEntity);
            }
            if (!this.fleeingTargets.isEmpty()) {
                Collections.sort(this.fleeingTargets, new Comparator<EntityPrehistoric>(){

                    @Override
                    public int compare(EntityPrehistoric o1, EntityPrehistoric o2) {
                        return (int)(o1.getStrength() - o2.getStrength());
                    }
                });
                switch (this.entity.distanceStatus((Entity)this.fleeingTargets.get(0))) {
                    case 1: {
                        this.task = 0;
                        break;
                    }
                    case 2: {
                        this.task = 1;
                    }
                }
                this.target = this.fleeingTargets.get(0);
                return;
            }
        } else if (this.nearbyPlayers.isEmpty()) {
            Collections.sort(this.nearbyPlayers, new Comparator<EntityPlayer>(){

                @Override
                public int compare(EntityPlayer arg0, EntityPlayer arg1) {
                    return (int)(FossilAIWildIndividualBase.this.entity.distanceToEntity((Entity)arg0) - FossilAIWildIndividualBase.this.entity.distanceToEntity((Entity)arg1));
                }
            });
            switch (this.entity.distanceStatus((Entity)this.nearbyPlayers.get(0))) {
                case 1: {
                    this.task = 1;
                    break;
                }
                case 2: {
                    this.task = 0;
                }
            }
            this.target = this.nearbyPlayers.get(0);
        }
        if (this.entity.hungerLevel() > 0) {
            for (Object tempTileEntity : this.entity.field_70170_p.field_147482_g) {
                if (!(tempTileEntity instanceof TileEntityFeeder) || !this.entity.canFindFeeder((TileEntityFeeder)((Object)tempTileEntity))) continue;
                this.feeders.add((TileEntityFeeder)((Object)tempTileEntity));
            }
            if (!this.feeders.isEmpty()) {
                Collections.sort(this.feeders, new Comparator<TileEntityFeeder>(){

                    @Override
                    public int compare(TileEntityFeeder o1, TileEntityFeeder o2) {
                        int totalFood1 = 0;
                        int totalFood2 = 0;
                        if (FossilAIWildIndividualBase.this.entity.getType().eatsMeat()) {
                            totalFood1 += o1.MeatCurrent;
                            totalFood2 += o2.MeatCurrent;
                        }
                        if (FossilAIWildIndividualBase.this.entity.getType().eatsVegetables()) {
                            totalFood1 += o1.VegCurrent;
                            totalFood2 += o2.VegCurrent;
                        }
                        return totalFood1 - totalFood2;
                    }
                });
                this.task = 8;
                this.target = this.feeders.get(0);
                return;
            }
            for (EntityPrehistoric food : this.nearbyPrehistoricEntities) {
                if (!this.entity.getType().willAttack((EntityLiving)food)) continue;
                this.possibleFood.add((EntityLiving)food);
            }
            for (EntityLiving food : this.nearbyLivingEntities) {
                if (!this.entity.getType().willAttack(food)) continue;
                this.possibleFood.add(food);
            }
            if (!this.possibleFood.isEmpty()) {
                Collections.sort(this.possibleFood, new Comparator<EntityLiving>(){

                    @Override
                    public int compare(EntityLiving o1, EntityLiving o2) {
                        return (int)(FossilAIWildIndividualBase.this.entity.distanceToEntity((Entity)o1) - FossilAIWildIndividualBase.this.entity.distanceToEntity((Entity)o2));
                    }
                });
                this.task = 7;
                this.target = this.possibleFood.get(0);
                return;
            }
            for (EntityItem item : this.nearbyItemEntities) {
                if (!this.entity.getType().willEat(item.func_92059_d().func_77973_b())) continue;
                this.possibleItemFood.add(item);
            }
            if (!this.possibleItemFood.isEmpty()) {
                Collections.sort(this.possibleItemFood, new Comparator<EntityItem>(){

                    @Override
                    public int compare(EntityItem o1, EntityItem o2) {
                        return (int)(FossilAIWildIndividualBase.this.entity.distanceToEntity((Entity)o1) - FossilAIWildIndividualBase.this.entity.distanceToEntity((Entity)o2));
                    }
                });
                this.task = 9;
                this.target = this.possibleItemFood.get(0);
                return;
            }
            if (this.entity.getType().eatsBlocks()) {
                for (int i = (int)(-this.entity.getType().getMaxAwarenessRadius()); i <= (int)this.entity.getType().getMaxAwarenessRadius(); ++i) {
                    int bound = (int)Math.sqrt(Math.pow(this.entity.getType().getMaxAwarenessRadius(), 2.0) - Math.pow(i, 2.0));
                    for (k = -bound; k <= bound; ++k) {
                        for (int j = -4; j <= 4; ++j) {
                            if (this.entity.getType().willEat(this.entity.field_70170_p.func_147439_a(i, j, k))) {
                                this.foodBlocks.add(Vec3.func_72443_a((double)i, (double)j, (double)k));
                                continue;
                            }
                            if (waterBlock != null || !this.entity.field_70170_p.func_147439_a(i, j, k).func_149688_o().equals(Material.field_151586_h)) continue;
                            waterBlock = Vec3.func_72443_a((double)i, (double)j, (double)k);
                            checkedForWater = true;
                        }
                    }
                }
                if (!this.foodBlocks.isEmpty()) {
                    Collections.sort(this.foodBlocks, new Comparator<Vec3>(){

                        @Override
                        public int compare(Vec3 o1, Vec3 o2) {
                            return (int)(FossilAIWildIndividualBase.this.entity.distanceToLocation(o1) - FossilAIWildIndividualBase.this.entity.distanceToLocation(o2));
                        }
                    });
                    this.task = 10;
                    this.target = this.foodBlocks.get(0);
                    return;
                }
            }
            if (this.entity.hungerLevel() > 1) {
                this.task = 3;
                this.setWanderTarget(true);
                return;
            }
        }
        if (!this.nearbyPrehistoricEntitiesOfSameSpecies.isEmpty() && this.entity.getType().isCanFormHerds()) {
            Collections.sort(this.nearbyPrehistoricEntitiesOfSameSpecies, new Comparator<EntityPrehistoric>(){

                @Override
                public int compare(EntityPrehistoric o1, EntityPrehistoric o2) {
                    return (int)(FossilAIWildIndividualBase.this.entity.distanceToEntity((Entity)o1) - FossilAIWildIndividualBase.this.entity.distanceToEntity((Entity)o2));
                }
            });
            this.task = this.nearbyPrehistoricEntitiesOfSameSpecies.get(0).isInHerd() ? 12 : 11;
            this.target = this.nearbyPrehistoricEntitiesOfSameSpecies.get(0);
            return;
        }
        if (!this.nearbyPlayers.isEmpty()) {
            Collections.sort(this.nearbyPlayers, new Comparator<EntityPlayer>(){

                @Override
                public int compare(EntityPlayer o1, EntityPlayer o2) {
                    return (int)(FossilAIWildIndividualBase.this.entity.distanceToEntity((Entity)o1) - FossilAIWildIndividualBase.this.entity.distanceToEntity((Entity)o2));
                }
            });
            if (this.entity.isAdult()) {
                this.task = this.entity.getType().attacksPlayersAsAdult() ? 7 : 5;
                this.target = this.nearbyPlayers.get(0);
                return;
            }
            if (this.entity.func_70631_g_()) {
                this.task = 2;
                this.target = this.nearbyPlayers.get(0);
                return;
            }
        }
        if (!checkedForWater) {
            for (int i = (int)(-this.entity.getType().getMaxAwarenessRadius()); i <= (int)this.entity.getType().getMaxAwarenessRadius(); ++i) {
                int bound = (int)Math.sqrt(Math.pow(this.entity.getType().getMaxAwarenessRadius(), 2.0) - Math.pow(i, 2.0));
                for (k = -bound; k <= bound; ++k) {
                    for (int j = -4; j <= 4; ++j) {
                        if (waterBlock != null || !this.entity.field_70170_p.func_147439_a(i, j, k).func_149688_o().equals(Material.field_151586_h)) continue;
                        waterBlock = Vec3.func_72443_a((double)i, (double)j, (double)k);
                        checkedForWater = true;
                        break;
                    }
                    if (checkedForWater) break;
                }
                if (checkedForWater) break;
            }
        }
        if (waterBlock == null) {
            Random random = new Random();
            if (random.nextDouble() >= 0.5) {
                this.task = 4;
                this.setWanderTarget(false);
            } else {
                this.task = 6;
            }
        } else {
            int i = 1;
            while (!this.entity.field_70170_p.func_147439_a((int)waterBlock.field_72450_a, (int)waterBlock.field_72448_b + i, (int)waterBlock.field_72449_c).func_149688_o().equals(Material.field_151579_a)) {
                ++i;
            }
            waterBlock = waterBlock.func_72441_c(0.0, (double)(--i), 0.0);
            Vec3 targetBlock = Vec3.func_72443_a((double)this.entity.field_70165_t, (double)waterBlock.field_72448_b, (double)this.entity.field_70161_v);
            MovingObjectPosition hit = this.entity.field_70170_p.func_72933_a(waterBlock, targetBlock);
            this.task = 13;
            this.target = Vec3.func_72443_a((double)hit.field_72311_b, (double)hit.field_72312_c, (double)hit.field_72309_d);
        }
    }

    public void func_75246_d() {
        if (this.tickCounter % 5 == 0 && this.task != 0 && this.task != 1) {
            int chunkRadius = (int)Math.ceil(this.entity.getType().getMaxAwarenessRadius() / 16.0f);
            this.possibleFleeTargets.clear();
            this.currentChunk = this.entity.field_70170_p.func_72964_e(this.entity.field_70176_ah, this.entity.field_70162_ai);
            for (int i = -chunkRadius; i <= chunkRadius; ++i) {
                for (int j = -chunkRadius; j <= chunkRadius; ++j) {
                    this.tempChunk = this.entity.field_70170_p.func_72964_e(this.currentChunk.field_76635_g + i, this.currentChunk.field_76647_h + j);
                    for (int k = (int)((this.entity.field_70163_u - 4.0) / 16.0); k < (int)((this.entity.field_70163_u + 4.0) / 16.0) && k >= 0 && k < this.tempChunk.field_76645_j.length; ++k) {
                        for (Object tempEntity : this.tempChunk.field_76645_j[k]) {
                            if (tempEntity.getClass().isAssignableFrom(EntityPrehistoric.class) && this.entity.getType().shouldRunFromEntity((EntityPrehistoric)((Object)tempEntity))) {
                                if (!this.entity.canFindEntity((Entity)tempEntity)) continue;
                                this.possibleFleeTargets.add((EntityPrehistoric)((Object)tempEntity));
                                continue;
                            }
                            if (!this.entity.func_70631_g_() || !tempEntity.getClass().isAssignableFrom(EntityPlayer.class) || !this.entity.canFindEntity((Entity)tempEntity)) continue;
                            this.possibleFleeTargetPlayers.add((EntityPlayer)tempEntity);
                        }
                    }
                }
            }
            if (!this.possibleFleeTargets.isEmpty()) {
                Collections.sort(this.possibleFleeTargets, new Comparator<EntityPrehistoric>(){

                    @Override
                    public int compare(EntityPrehistoric o1, EntityPrehistoric o2) {
                        return (int)(o1.getStrength() - o2.getStrength());
                    }
                });
                switch (this.entity.distanceStatus((Entity)this.possibleFleeTargets.get(0))) {
                    case 1: {
                        this.task = 1;
                        break;
                    }
                    case 2: {
                        this.task = 0;
                    }
                }
                this.target = this.possibleFleeTargets.get(0);
            } else if (!this.possibleFleeTargetPlayers.isEmpty()) {
                Collections.sort(this.possibleFleeTargetPlayers, new Comparator<EntityPlayer>(){

                    @Override
                    public int compare(EntityPlayer arg0, EntityPlayer arg1) {
                        return (int)(FossilAIWildIndividualBase.this.entity.distanceToEntity((Entity)arg0) - FossilAIWildIndividualBase.this.entity.distanceToEntity((Entity)arg1));
                    }
                });
                switch (this.entity.distanceStatus((Entity)this.possibleFleeTargetPlayers.get(0))) {
                    case 1: {
                        this.task = 1;
                        break;
                    }
                    case 2: {
                        this.task = 0;
                    }
                }
                this.target = this.possibleFleeTargetPlayers.get(0);
            }
        }
        ++this.tickCounter;
        switch (this.task) {
            case 0: {
                this.fleeFromEntity((Entity)this.target, true);
                break;
            }
            case 1: {
                this.fleeFromEntity((Entity)this.target, false);
                break;
            }
            case 2: {
                this.avoidEntity((Entity)this.target, this.radiusDimension);
                break;
            }
            case 3: {
                this.wander(true);
                break;
            }
            case 4: {
                this.wander(false);
                break;
            }
            case 5: {
                this.followEntity((Entity)this.target, this.radiusDimension);
                break;
            }
            case 6: {
                this.idle();
                break;
            }
            case 7: {
                this.trackAndAttackEntity((EntityLiving)this.target);
                break;
            }
            case 8: {
                this.feedFromFeeder((TileEntityFeeder)((Object)this.target));
                break;
            }
            case 9: {
                this.pickupItem((EntityItem)this.target);
                break;
            }
            case 10: {
                this.eatBlock((Vec3)this.target);
                break;
            }
            case 11: {
                this.formHerd((EntityPrehistoric)((Object)this.target));
                break;
            }
            case 12: {
                this.askToJoinHerd((EntityPrehistoric)((Object)this.target));
                break;
            }
            case 13: {
                this.findAndDrinkWater((Vec3)this.target);
            }
        }
    }

    private void taskDone() {
        this.taskDone = true;
    }

    abstract void setWanderTarget(boolean var1);

    abstract void fleeFromEntity(Entity var1, boolean var2);

    abstract void avoidEntity(Entity var1, float var2);

    abstract void wander(boolean var1);

    abstract void followEntity(Entity var1, float var2);

    abstract void idle();

    abstract void trackAndAttackEntity(EntityLiving var1);

    abstract void feedFromFeeder(TileEntityFeeder var1);

    abstract void eatBlock(Vec3 var1);

    abstract void pickupItem(EntityItem var1);

    abstract void formHerd(EntityPrehistoric var1);

    abstract void askToJoinHerd(EntityPrehistoric var1);

    abstract void findAndDrinkWater(Vec3 var1);
}

