/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.client;

import cpw.mods.fml.common.registry.LanguageRegistry;

public class Localizations {
    private static final String LANG_RESOURCE_LOCATION = "fossil:lang/";
    public static String[] localeFiles = new String[]{"fossil:lang/en_US.xml", "fossil:lang/es_ES.xml"};

    public static void loadLanguages() {
        for (String localizationFile : localeFiles) {
            LanguageRegistry.instance().loadLocalization(localizationFile, Localizations.getLocaleFromFileName(localizationFile), Localizations.isXMLLanguageFile(localizationFile));
        }
    }

    public static boolean isXMLLanguageFile(String fileName) {
        return fileName.endsWith(".xml");
    }

    public static String getLocaleFromFileName(String fileName) {
        return fileName.substring(fileName.lastIndexOf(47) + 1, fileName.lastIndexOf(46));
    }

    public static String getLocalizedString(String key) {
        return LanguageRegistry.instance().getStringLocalization(key);
    }
}

