/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mods.fossil.Fossil;
import mods.fossil.fossilEnums.EnumStoneboard;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityStoneboard
extends Entity
implements IEntityAdditionalSpawnData {
    private int tickCounter1 = 0;
    public int direction = 0;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public EnumStoneboard art;

    public EntityStoneboard(World var1) {
        super(var1);
        this.field_70129_M = 0.0f;
        this.field_70158_ak = true;
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityStoneboard(World var1, int var2, int var3, int var4, int var5) {
        this(var1);
        this.xPosition = var2;
        this.yPosition = var3;
        this.zPosition = var4;
        ArrayList<EnumStoneboard> var6 = new ArrayList<EnumStoneboard>();
        EnumStoneboard[] var7 = EnumStoneboard.values();
        int var8 = var7.length;
        for (int var9 = 0; var9 < var8; ++var9) {
            EnumStoneboard var10;
            this.art = var10 = var7[var9];
            this.setDirection(var5);
            if (!this.onValidSurface()) continue;
            var6.add(var10);
        }
        if (var6.size() > 0) {
            this.art = (EnumStoneboard)((Object)var6.get(this.field_70146_Z.nextInt(var6.size())));
        }
        this.setDirection(var5);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityStoneboard(World var1, int var2, int var3, int var4, int var5, String var6) {
        this(var1);
        this.xPosition = var2;
        this.yPosition = var3;
        this.zPosition = var4;
        for (EnumStoneboard var10 : EnumStoneboard.values()) {
            if (!var10.title.equals(var6)) continue;
            this.art = var10;
            break;
        }
        this.setDirection(var5);
    }

    protected void func_70088_a() {
    }

    public void setDirection(int var1) {
        this.direction = var1;
        this.field_70126_B = this.field_70177_z = (float)(var1 * 90);
        float var2 = this.art.sizeX;
        float var3 = this.art.sizeY;
        float var4 = this.art.sizeX;
        if (var1 != 0 && var1 != 2) {
            var2 = 0.5f;
        } else {
            var4 = 0.5f;
            this.field_70177_z = this.field_70126_B = (this.field_70177_z + 180.0f) % 360.0f;
        }
        var2 /= 32.0f;
        var3 /= 32.0f;
        var4 /= 32.0f;
        float var5 = (float)this.xPosition + 0.5f;
        float var6 = (float)this.yPosition + 0.5f;
        float var7 = (float)this.zPosition + 0.5f;
        float var8 = 0.5625f;
        if (var1 == 2) {
            var7 -= var8;
        }
        if (var1 == 1) {
            var5 -= var8;
        }
        if (var1 == 0) {
            var7 += var8;
        }
        if (var1 == 3) {
            var5 += var8;
        }
        if (var1 == 2) {
            var5 -= this.func_411_c(this.art.sizeX);
        }
        if (var1 == 1) {
            var7 += this.func_411_c(this.art.sizeX);
        }
        if (var1 == 0) {
            var5 += this.func_411_c(this.art.sizeX);
        }
        if (var1 == 3) {
            var7 -= this.func_411_c(this.art.sizeX);
        }
        this.func_70107_b(var5, var6 += this.func_411_c(this.art.sizeY), var7);
        float var9 = -0.00625f;
        this.field_70121_D.func_72324_b((double)(var5 - var2 - var9), (double)(var6 - var3 - var9), (double)(var7 - var4 - var9), (double)(var5 + var2 + var9), (double)(var6 + var3 + var9), (double)(var7 + var4 + var9));
    }

    private float func_411_c(int var1) {
        return var1 == 32 ? 0.5f : (var1 != 64 ? 0.0f : 0.5f);
    }

    public void func_70071_h_() {
        if (this.tickCounter1++ == 100 && !this.field_70170_p.field_72995_K) {
            this.tickCounter1 = 0;
            if (!this.onValidSurface()) {
                this.func_70106_y();
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Fossil.stoneboard)));
            }
        }
    }

    public float getXDimension() {
        return (float)this.art.sizeX * 0.0625f;
    }

    public float getYDimension() {
        return (float)this.art.sizeY * 0.0625f;
    }

    public boolean onValidSurface() {
        if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() > 0) {
            return false;
        }
        int Width = Math.max(1, this.art.sizeX / 16);
        int Height2 = Math.max(1, this.art.sizeY / 16);
        int xPos = this.xPosition;
        int yPos = MathHelper.func_76128_c((double)(this.field_70163_u - (double)((float)this.art.sizeY / 32.0f)));
        int zPos = this.zPosition;
        if (this.direction == 0 || this.direction == 2) {
            xPos = MathHelper.func_76128_c((double)(this.field_70165_t - (double)((float)this.art.sizeX / 32.0f)));
        }
        if (this.direction == 1 || this.direction == 3) {
            zPos = MathHelper.func_76128_c((double)(this.field_70161_v - (double)((float)this.art.sizeX / 32.0f)));
        }
        for (int side = 0; side < Width; ++side) {
            for (int up = 0; up < Height2; ++up) {
                if (!(this.direction != 2 || this.direction != 0 ? !this.field_70170_p.func_147439_a(this.xPosition, yPos + up, zPos + side).func_149688_o().func_76220_a() : !this.field_70170_p.func_147439_a(xPos + side, yPos + up, this.zPosition).func_149688_o().func_76220_a())) continue;
                return false;
            }
        }
        List collidingEntities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
        for (int i = 0; i < collidingEntities.size(); ++i) {
            if (!(collidingEntities.get(i) instanceof EntityStoneboard) && !(collidingEntities.get(i) instanceof EntityHanging)) continue;
            return false;
        }
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_70018_K();
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Fossil.stoneboard)));
        }
        return true;
    }

    public void func_70014_b(NBTTagCompound var1) {
        var1.func_74774_a("Dir", (byte)this.direction);
        var1.func_74778_a("Motive", this.art.title);
        var1.func_74768_a("TileX", this.xPosition);
        var1.func_74768_a("TileY", this.yPosition);
        var1.func_74768_a("TileZ", this.zPosition);
    }

    public void func_70037_a(NBTTagCompound var1) {
        this.direction = var1.func_74771_c("Dir");
        this.xPosition = var1.func_74762_e("TileX");
        this.yPosition = var1.func_74762_e("TileY");
        this.zPosition = var1.func_74762_e("TileZ");
        String var2 = var1.func_74779_i("Motive");
        for (EnumStoneboard var6 : EnumStoneboard.values()) {
            if (!var6.title.equals(var2)) continue;
            this.art = var6;
        }
        if (this.art == null) {
            this.art = EnumStoneboard.Portol;
        }
        this.setDirection(this.direction);
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void writeSpawnData(ByteBuf var1) {
        EnumStoneboard[] var2 = EnumStoneboard.values();
        var1.writeInt(this.direction);
        for (int var3 = 0; var3 < var2.length; ++var3) {
            if (var2[var3] != this.art) continue;
            var1.writeInt(var3);
            return;
        }
    }

    public void readSpawnData(ByteBuf var1) {
        this.direction = var1.readInt();
        int var2 = var1.readInt();
        this.art = EnumStoneboard.values()[var2];
    }
}

