/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.entity.mob;

import io.netty.buffer.ByteBuf;
import java.util.Vector;
import mods.fossil.client.FossilOptions;
import mods.fossil.entity.mob.EntityBrachiosaurus;
import mods.fossil.entity.mob.EntityDinosaur;
import mods.fossil.entity.mob.EntitySpinosaurus;
import mods.fossil.entity.mob.EntityTRex;
import mods.fossil.fossilAI.DinoAIAttackOnCollide;
import mods.fossil.fossilAI.DinoAIEat;
import mods.fossil.fossilAI.DinoAIFollowOwner;
import mods.fossil.fossilAI.DinoAIHunt;
import mods.fossil.fossilAI.DinoAIRaptorLeapAtTarget;
import mods.fossil.fossilAI.DinoAITargetNonTamedExceptSelfClass;
import mods.fossil.fossilAI.DinoAIWander;
import mods.fossil.fossilEnums.EnumDinoType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityDeinonychus
extends EntityDinosaur {
    public boolean PreyChecked = false;
    public boolean SupportChecked = false;
    public Vector MemberList = new Vector();
    public static final double baseHealth = EnumDinoType.Deinonychus.Health0;
    public static final double baseDamage = EnumDinoType.Deinonychus.Strength0;
    public static final double baseSpeed = EnumDinoType.Deinonychus.Speed0;
    public static final double maxHealth = EnumDinoType.Deinonychus.HealthMax;
    public static final double maxDamage = EnumDinoType.Deinonychus.StrengthMax;
    public static final double maxSpeed = EnumDinoType.Deinonychus.SpeedMax;
    private final String texturePath;

    public EntityDeinonychus(World var1) {
        super(var1, EnumDinoType.Deinonychus);
        this.updateSize();
        this.adultAge = EnumDinoType.Deinonychus.AdultAge;
        this.func_70105_a(1.75f, 1.75f);
        this.minSize = 0.3f;
        this.maxSize = 1.0f;
        this.texturePath = !FossilOptions.DeinonychusFeathers ? "fossil:textures/mob/" + this.SelfType.toString() + "/feathered/" + "Feathered_" : "fossil:textures/mob/" + this.SelfType.toString() + "/";
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoAIRaptorLeapAtTarget((EntityLiving)this, 0.5f, 0.5f, 0.5f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIAttackOnCollide(this, 1.2, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DinoAIEat(this, 48));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new DinoAIHunt(this, EntityLiving.class, 500, false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new DinoAITargetNonTamedExceptSelfClass(this, EntityLiving.class, 750, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityTRex.class, 16.0f, 0.8, 1.33));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntitySpinosaurus.class, 16.0f, 0.8, 1.33));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityBrachiosaurus.class, 16.0f, 0.8, 1.33));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(baseHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(baseDamage);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(baseDamage);
    }

    public void setBesideClimbableBlock(boolean isClollided) {
        byte b0 = this.field_70180_af.func_75683_a(30);
        b0 = isClollided ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(30, (Object)b0);
    }

    public boolean isBesideClimbableBlock() {
        return (this.field_70180_af.func_75683_a(30) & 1) != 0;
    }

    @Override
    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)new Byte(0));
    }

    protected boolean func_70041_e_() {
        return this.isAdult() || this.isTeen();
    }

    @Override
    public String getTexture() {
        if (this.isModelized()) {
            return super.getModelTexture();
        }
        if (this.isAdult()) {
            switch (this.getSubSpecies()) {
                default: {
                    return this.texturePath + "Deinonychus_Grey_Adult.png";
                }
                case 2: {
                    return this.texturePath + "Deinonychus_Black_Adult.png";
                }
                case 3: 
            }
            return this.texturePath + "Deinonychus_Brown_Adult.png";
        }
        if (this.isTeen()) {
            switch (this.getSubSpecies()) {
                default: {
                    return this.texturePath + "Deinonychus_Grey_Teen.png";
                }
                case 2: {
                    return this.texturePath + "Deinonychus_Black_Teen.png";
                }
                case 3: 
            }
            return this.texturePath + "Deinonychus_Brown_Teen.png";
        }
        switch (this.getSubSpecies()) {
            default: {
                return this.texturePath + "Deinonychus_Grey_Baby.png";
            }
            case 2: {
                return this.texturePath + "Deinonychus_Black_Baby.png";
            }
            case 3: 
        }
        return this.texturePath + "Deinonychus_Brown_Baby.png";
    }

    @Override
    public void func_70014_b(NBTTagCompound var1) {
        super.func_70014_b(var1);
    }

    @Override
    public void func_70037_a(NBTTagCompound var1) {
        super.func_70037_a(var1);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    protected void func_70069_a(float par1) {
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    @Override
    protected boolean func_70780_i() {
        return this.func_70906_o();
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float damageamount) {
        super.func_70097_a(damagesource, damageamount);
        if (this.func_85032_ar()) {
            return false;
        }
        Entity entity = damagesource.func_76346_g();
        this.field_70911_d.func_75270_a(false);
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            damageamount = (damageamount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(damagesource, damageamount);
    }

    @Override
    public boolean func_70085_c(EntityPlayer var1) {
        ItemStack var2 = var1.field_71071_by.func_70448_g();
        if (var2 != null && var2.func_77973_b().func_77661_b(var2) == EnumAction.bow) {
            return false;
        }
        return super.func_70085_c(var1);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    @Override
    public void func_70103_a(byte var1) {
        if (var1 == 7) {
            this.showHeartsOrSmokeFX(true, true);
        } else if (var1 == 6) {
            this.showHeartsOrSmokeFX(false, false);
        } else if (var1 != 8) {
            super.func_70103_a(var1);
        }
    }

    public EntityAnimal spawnBabyAnimal(EntityAnimal var1) {
        return new EntityDeinonychus(this.field_70170_p);
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable var1) {
        EntityDeinonychus baby = new EntityDeinonychus(this.field_70170_p);
        baby.setSubSpecies(this.getSubSpecies());
        return baby;
    }

    @Override
    public void updateSize() {
        double healthStep = (maxHealth - baseHealth) / (double)(this.adultAge + 1);
        double attackStep = (maxDamage - baseDamage) / (double)(this.adultAge + 1);
        double speedStep = (maxSpeed - baseSpeed) / (double)(this.adultAge + 1);
        if (this.getDinoAge() <= this.adultAge) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.round(baseHealth + healthStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Math.round(baseDamage + attackStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed + speedStep * (double)this.getDinoAge());
            if (this.isTeen()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
            } else if (this.isAdult()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(2.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
    }

    public void readSpawnData(ByteBuf additionalData) {
    }
}

