/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.entity.mob;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import java.util.Vector;
import mods.fossil.client.FossilOptions;
import mods.fossil.client.gui.GuiPedia;
import mods.fossil.entity.mob.EntityBrachiosaurus;
import mods.fossil.entity.mob.EntityDinosaur;
import mods.fossil.entity.mob.EntitySpinosaurus;
import mods.fossil.entity.mob.EntityTRex;
import mods.fossil.fossilAI.DinoAIAttackOnCollide;
import mods.fossil.fossilAI.DinoAIEat;
import mods.fossil.fossilAI.DinoAIFollowOwner;
import mods.fossil.fossilAI.DinoAIHunt;
import mods.fossil.fossilAI.DinoAITargetNonTamedExceptSelfClass;
import mods.fossil.fossilAI.DinoAIWander;
import mods.fossil.fossilEnums.EnumDinoType;
import mods.fossil.fossilEnums.EnumOrderType;
import mods.fossil.fossilEnums.EnumSituation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityDilophosaurus
extends EntityDinosaur {
    private boolean looksWithInterest = false;
    public int LearningChestTick = 900;
    public boolean PreyChecked = false;
    public boolean SupportChecked = false;
    public Vector MemberList = new Vector();
    public float SwingAngle = -1000.0f;
    public int FleeingTick = 0;
    public static final double baseHealth = EnumDinoType.Dilophosaurus.Health0;
    public static final double baseDamage = EnumDinoType.Dilophosaurus.Strength0;
    public static final double baseSpeed = EnumDinoType.Dilophosaurus.Speed0;
    public static final double maxHealth = EnumDinoType.Dilophosaurus.HealthMax;
    public static final double maxDamage = EnumDinoType.Dilophosaurus.StrengthMax;
    public static final double maxSpeed = EnumDinoType.Dilophosaurus.SpeedMax;
    private final String texturePath;

    public EntityDilophosaurus(World var1) {
        super(var1, EnumDinoType.Dilophosaurus);
        this.updateSize();
        this.adultAge = EnumDinoType.Dilophosaurus.AdultAge;
        this.func_70105_a(1.5f, 1.5f);
        this.minSize = 0.5f;
        this.maxSize = 2.0f;
        this.texturePath = !FossilOptions.DilophosaurusFeathers ? "fossil:textures/mob/" + this.SelfType.toString() + "/feathered/" + "Feathered_" : "fossil:textures/mob/" + this.SelfType.toString() + "/";
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIAttackOnCollide(this, 1.2, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 5.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIEat(this, 48));
        this.field_70715_bh.func_75776_a(7, (EntityAIBase)new DinoAIHunt(this, EntityLiving.class, 500, false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new DinoAITargetNonTamedExceptSelfClass(this, EntityLiving.class, 750, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityTRex.class, 16.0f, 0.8, 1.33));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntitySpinosaurus.class, 16.0f, 0.8, 1.33));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityBrachiosaurus.class, 16.0f, 0.8, 1.33));
    }

    @Override
    public boolean func_70652_k(Entity var1) {
        return super.func_70652_k(var1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(baseHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(baseDamage);
    }

    @Override
    public String getTexture() {
        if (this.isModelized()) {
            return super.getTexture();
        }
        if (this.isAdult()) {
            switch (this.getSubSpecies()) {
                default: {
                    return this.texturePath + "Dilophosaurus_Adult.png";
                }
                case 1: 
            }
            return this.texturePath + "Dilophosaurus_Adult_Orange.png";
        }
        switch (this.getSubSpecies()) {
            default: {
                return this.texturePath + "Dilophosaurus_Baby.png";
            }
            case 1: 
        }
        return this.texturePath + "Dilophosaurus_Baby_Orange.png";
    }

    @Override
    public void func_70014_b(NBTTagCompound var1) {
        super.func_70014_b(var1);
        var1.func_74768_a("LearningChestTick", this.LearningChestTick);
    }

    @Override
    public void func_70037_a(NBTTagCompound var1) {
        super.func_70037_a(var1);
        this.LearningChestTick = var1.func_74762_e("LearningChestTick");
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    @Override
    protected void func_70626_be() {
        super.func_70626_be();
        EntityLivingBase var1 = this.func_70902_q();
        if (!this.field_70787_b && !this.func_70781_l() && this.func_70909_n() && this.field_70154_o == null) {
            if (var1 != null) {
                EnumOrderType var10001 = this.OrderStatus;
                if (this.OrderStatus == EnumOrderType.Follow) {
                    float var2 = var1.func_70032_d((Entity)this);
                    if (var2 > 5.0f) {
                        this.getPathOrWalkableBlock((Entity)var1, var2);
                    }
                    if (!this.isAngry()) {
                        if (var2 < 5.0f) {
                            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(2.0);
                        } else {
                            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
                        }
                    }
                }
            } else if (!this.func_70090_H()) {
                this.func_70904_g(true);
            }
        } else if (this.func_70090_H()) {
            this.func_70904_g(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(this.func_110143_aJ()));
        }
    }

    private boolean isNearbyChest() {
        TileEntity var5 = null;
        for (int var6 = -10; var6 <= 10; ++var6) {
            for (int var7 = 0; var7 <= 3; ++var7) {
                for (int var8 = -10; var8 <= 10; ++var8) {
                    var5 = this.field_70170_p.func_147438_o((int)(this.field_70165_t + (double)var6), (int)(this.field_70163_u + (double)var7), (int)(this.field_70161_v + (double)var8));
                    if (!(var5 instanceof TileEntityChest)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.LearningChestTick > 0 && this.isNearbyChest() && this.isAdult()) {
            --this.LearningChestTick;
            if (this.LearningChestTick == 0) {
                this.SendStatusMessage(EnumSituation.LearningChest);
            }
        }
        if (this.looksWithInterest) {
            this.field_70700_bx = 10;
        }
    }

    public boolean getSelfShaking() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    @Override
    protected boolean func_70780_i() {
        return this.func_70906_o();
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float damageamount) {
        Entity entity = damagesource.func_76346_g();
        boolean var4 = false;
        this.func_70904_g(false);
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            damageamount = (damageamount + 1.0f) / 2.0f;
        }
        if (super.func_70097_a(damagesource, damageamount)) {
            if (!this.isAngry()) {
                if (entity instanceof EntityArrow && ((EntityArrow)entity).field_70250_c != null) {
                    entity = ((EntityArrow)entity).field_70250_c;
                }
                if (entity instanceof EntityLiving) {
                    this.func_70784_b((Entity)((EntityLiving)entity));
                }
                if (entity instanceof EntityPlayer && this.func_70909_n() && (EntityPlayer)entity == this.func_70902_q()) {
                    this.SendStatusMessage(EnumSituation.Betrayed);
                    this.func_70903_f(false);
                    this.setOwner("");
                    this.setOwnerDisplayName("");
                    this.ItemInMouth = null;
                    this.setAngry(true);
                    this.func_70784_b(entity);
                    this.PreyChecked = true;
                    var4 = true;
                }
            } else if (entity != this && entity != null) {
                this.field_70789_a = entity;
            }
            return true;
        }
        return false;
    }

    protected Entity func_70782_k() {
        return this.isAngry() ? this.field_70170_p.func_72856_b((Entity)this, 16.0) : null;
    }

    protected void func_70785_a(Entity var1, float var2) {
        if (var1.field_70128_L) {
            this.func_70784_b(null);
        }
        if (var2 > 2.0f && var2 < 5.0f && this.field_70146_Z.nextInt(10) == 0) {
            if (this.field_70122_E) {
                double var3 = var1.field_70165_t - this.field_70165_t;
                double var5 = var1.field_70161_v - this.field_70161_v;
                float var7 = MathHelper.func_76133_a((double)(var3 * var3 + var5 * var5));
                this.field_70159_w = var3 / (double)var7 * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
                this.field_70179_y = var5 / (double)var7 * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
                this.field_70170_p.func_72956_a((Entity)this, "Raptor_attack", this.func_70599_aP() * 2.0f, 1.0f);
                this.func_70664_aZ();
            }
        } else if ((double)var2 < (double)1.9f && var1.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && var1.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            var1.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(2 + this.getDinoAge()));
            if (this.field_70146_Z.nextInt(16) < 4 && var1 instanceof EntityLiving) {
                ((EntityLiving)var1).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, this.field_70146_Z.nextInt(110) + 10, 0));
            }
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer var1) {
        return super.func_70085_c(var1);
    }

    public int func_70641_bl() {
        return 10;
    }

    protected void func_70069_a(float var1) {
        int var2;
        if (this.field_70153_n != null) {
            this.field_70153_n.field_70143_R = var1;
        }
        if ((var2 = (int)Math.ceil(var1 - 3.0f)) > 0) {
            this.func_70097_a(DamageSource.field_76379_h, 0.0f);
        }
    }

    protected void func_70779_j() {
        boolean var1 = false;
        int var2 = -1;
        int var3 = -1;
        int var4 = -1;
        float var5 = -99999.0f;
        EnumOrderType var10001 = this.OrderStatus;
        if (this.OrderStatus == EnumOrderType.FreeMove || !this.func_70909_n()) {
            for (int var6 = 0; var6 < 10; ++var6) {
                int var9;
                int var8;
                int var7 = MathHelper.func_76128_c((double)(this.field_70165_t + (double)this.field_70146_Z.nextInt(13) - 6.0));
                float var10 = this.func_70783_a(var7, var8 = MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.field_70146_Z.nextInt(7) - 3.0)), var9 = MathHelper.func_76128_c((double)(this.field_70161_v + (double)this.field_70146_Z.nextInt(13) - 6.0)));
                if (!(var10 > var5)) continue;
                var5 = var10;
                var2 = var7;
                var3 = var8;
                var4 = var9;
                var1 = true;
            }
            if (var1) {
                this.func_70778_a(this.field_70170_p.func_72844_a((Entity)this, var2, var3, var4, 10.0f, true, false, true, false));
            }
        }
    }

    @Override
    public boolean CheckSpace() {
        return !this.func_70094_T();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void ShowPedia(GuiPedia p0) {
        super.ShowPedia(p0);
        if (this.LearningChestTick == 0) {
            p0.AddStringLR(StatCollector.func_74838_a((String)"pedia.text.chest"), true);
        }
    }

    public EntityDilophosaurus spawnBabyAnimal(EntityAgeable var1) {
        return new EntityDilophosaurus(this.field_70170_p);
    }

    public void func_70784_b(Entity var1) {
        super.func_70784_b(var1);
    }

    @Override
    public EnumOrderType getOrderType() {
        return this.OrderStatus;
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable var1) {
        EntityDilophosaurus baby = new EntityDilophosaurus(this.field_70170_p);
        baby.setSubSpecies(this.getSubSpecies());
        return baby;
    }

    @Override
    public void updateSize() {
        double healthStep = (maxHealth - baseHealth) / (double)(this.adultAge + 1);
        double attackStep = (maxDamage - baseDamage) / (double)(this.adultAge + 1);
        double speedStep = (maxSpeed - baseSpeed) / (double)(this.adultAge + 1);
        if (this.getDinoAge() <= this.adultAge) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.round(baseHealth + healthStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Math.round(baseDamage + attackStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed + speedStep * (double)this.getDinoAge());
            if (this.isTeen()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
            } else if (this.isAdult()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(2.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
            }
        }
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData par1EntityLivingData) {
        par1EntityLivingData = super.func_110161_a(par1EntityLivingData);
        Random random = new Random();
        this.setSubSpecies(random.nextInt(2));
        this.setDinoAge(this.SelfType.AdultAge);
        this.updateSize();
        this.func_70691_i(200.0f);
        return par1EntityLivingData;
    }

    public void writeSpawnData(ByteBuf buffer) {
    }

    public void readSpawnData(ByteBuf additionalData) {
    }
}

