/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.entity.mob;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import mods.fossil.Fossil;
import mods.fossil.client.FossilOptions;
import mods.fossil.client.gui.GuiPedia;
import mods.fossil.entity.EntityDinoEgg;
import mods.fossil.entity.mob.EntityPrehistoric;
import mods.fossil.fossilAI.DinoAIGrowup;
import mods.fossil.fossilAI.DinoAIStarvation;
import mods.fossil.fossilEnums.EnumDinoType;
import mods.fossil.fossilEnums.EnumOrderType;
import mods.fossil.fossilEnums.EnumSituation;
import mods.fossil.guiBlocks.TileEntityFeeder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIControlledByPlayer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public abstract class EntityDinosaur
extends EntityPrehistoric
implements IEntityAdditionalSpawnData {
    public static final int OWNER_NAME_DATA_INDEX = 17;
    public static final int HUNGER_TICK_DATA_INDEX = 18;
    public static final int HUNGER_DATA_INDEX = 19;
    public static final int AGE_TICK_DATA_INDEX = 20;
    public static final int AGE_DATA_INDEX = 21;
    public static final int SUBSPECIES_INDEX = 22;
    public static final int MODELIZED_INDEX = 23;
    public static final byte HEART_MESSAGE = 35;
    public static final byte SMOKE_MESSAGE = 36;
    public static final byte AGING_MESSAGE = 37;
    public float RiderStrafe = 0.0f;
    public float RiderForward = 0.0f;
    public boolean RiderJump = false;
    public boolean RiderSneak = false;
    public float minSize;
    public float maxSize;
    public int adultAge;
    public EnumDinoType SelfType = null;
    public int BreedTick;
    public ItemStack ItemInMouth = null;
    public EnumOrderType OrderStatus;
    private EntityAIControlledByPlayer aiControlledByPlayer;
    private int angerLevel;
    public double baseHealth;
    public double baseDamage;
    public double baseSpeed;
    public double maxHealth;
    public double maxDamage;
    public double maxSpeed;
    public double knockbackModValue;
    private static final ResourceLocation pediaclock = new ResourceLocation("fossil:textures/gui/PediaClock.png");
    private static final ResourceLocation pediafood = new ResourceLocation("fossil:textures/gui/PediaFood.png");
    private static final ResourceLocation pediaheart = new ResourceLocation("fossil:textures/gui/PediaHeart.png");

    public EntityDinosaur(World var1, EnumDinoType T0) {
        super(var1);
        this.SelfType = T0;
        this.OrderStatus = EnumOrderType.FreeMove;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIGrowup(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIStarvation(this));
        this.BreedTick = this.SelfType.BreedingTicks;
        this.setHunger(this.SelfType.MaxHunger / 2);
        this.func_70606_j((float)this.SelfType.Health0);
    }

    private void setBaseValues() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
    }

    public float getDinosaurSize() {
        float step = (this.maxSize - this.minSize) / (float)(this.adultAge + 1);
        if (this.getDinoAge() > this.adultAge) {
            return this.minSize + step * (float)this.adultAge;
        }
        return this.minSize + step * (float)this.getDinoAge();
    }

    public void func_98054_a(boolean par1) {
        this.func_98055_j(this.getDinosaurSize());
    }

    protected int func_70693_a(EntityPlayer par1EntityPlayer) {
        return MathHelper.func_76141_d((float)(this.SelfType.Exp0 + (float)this.getDinoAge() * this.SelfType.ExpInc));
    }

    public void updateSize() {
        this.func_70664_aZ();
    }

    public void breakBlock(float hardness) {
        if (FossilOptions.Dino_Block_Breaking && !this.isModelized() && this.isAdult() && this.IsHungry()) {
            for (int a = (int)Math.round(this.field_70121_D.field_72340_a) - 1; a <= (int)Math.round(this.field_70121_D.field_72336_d) + 1; ++a) {
                for (int b = (int)Math.round(this.field_70121_D.field_72338_b) + 1; b <= (int)Math.round(this.field_70121_D.field_72337_e) + 3 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.field_70121_D.field_72339_c) - 1; c <= (int)Math.round(this.field_70121_D.field_72334_f) + 1; ++c) {
                        Block block = this.field_70170_p.func_147439_a(a, b, c);
                        if (block instanceof BlockBush || block instanceof BlockDoublePlant || block instanceof BlockLiquid || block == Blocks.field_150357_h || block == Fossil.ancientGlass || block == Fossil.strongGlass || !(block.func_149712_f(this.field_70170_p, a, b, c) < hardness)) continue;
                        this.field_70159_w *= 0.6;
                        this.field_70179_y *= 0.6;
                        Item item = block.func_149650_a(this.field_70170_p.func_72805_g(a, b, c), this.func_70681_au(), 1);
                        int itemCount = block.func_149745_a(this.func_70681_au());
                        int itemMeta = block.func_149692_a(this.field_70170_p.func_72805_g(a, b, c));
                        if (block != null && block != Blocks.field_150350_a) {
                            this.func_85030_a(block.field_149762_H.func_150495_a(), 0.15f, 1.0f);
                        }
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70170_p.func_147449_b(a, b, c, Blocks.field_150350_a);
                        }
                        if (item == null) continue;
                        float f = 0.7f;
                        double d0 = (double)(this.func_70681_au().nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d1 = (double)(this.func_70681_au().nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d2 = (double)(this.func_70681_au().nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        if (this.field_70170_p.field_72995_K) continue;
                        EntityItem entityitem = new EntityItem(this.field_70170_p, (double)a + d0, (double)b + d1, (double)c + d2, new ItemStack(item, itemCount, itemMeta));
                        entityitem.field_145804_b = 10;
                        this.field_70170_p.func_72838_d((Entity)entityitem);
                    }
                }
            }
        }
    }

    public double knockbackMod() {
        return this.knockbackModValue;
    }

    private void setPedia() {
        Fossil.ToPedia = this;
    }

    public boolean isAdult() {
        return this.getDinoAge() >= this.SelfType.AdultAge;
    }

    public boolean isTeen() {
        return this.getDinoAge() >= this.SelfType.TeenAge && this.getDinoAge() < this.SelfType.AdultAge;
    }

    public boolean func_70631_g_() {
        return this.getDinoAge() < this.SelfType.TeenAge;
    }

    public int getMaxHunger() {
        return this.SelfType.MaxHunger;
    }

    public boolean isModelized() {
        return this.field_70180_af.func_75683_a(23) >= 0;
    }

    public void setModelized(boolean var1) {
        if (this.SelfType.isModelable()) {
            this.field_70180_af.func_75692_b(23, (Object)((byte)(var1 ? 0 : -1)));
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(19, (Object)new Integer(30));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(300));
        this.field_70180_af.func_75682_a(22, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(23, (Object)new Byte(-1));
    }

    public int getSubSpecies() {
        return this.field_70180_af.func_75679_c(22);
    }

    public void setSubSpecies(int var1) {
        this.field_70180_af.func_75692_b(22, (Object)var1);
    }

    public int getDinoAge() {
        return this.field_70180_af.func_75679_c(21);
    }

    public void setDinoAge(int var1) {
        this.field_70180_af.func_75692_b(21, (Object)var1);
    }

    public boolean increaseDinoAge() {
        if (this.getDinoAge() < this.SelfType.MaxAge) {
            this.setDinoAge(this.getDinoAge() + 1);
            return true;
        }
        return false;
    }

    public int getDinoAgeTick() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setDinoAgeTick(int var1) {
        this.field_70180_af.func_75692_b(20, (Object)var1);
    }

    public void increaseDinoAgeTick() {
        this.setDinoAgeTick(this.getDinoAgeTick() + 1);
    }

    public int getHunger() {
        return this.field_70180_af.func_75679_c(19);
    }

    public void setHunger(int var1) {
        this.field_70180_af.func_75692_b(19, (Object)var1);
    }

    public boolean increaseHunger(int var1) {
        if (this.getHunger() >= this.getMaxHunger()) {
            return false;
        }
        this.setHunger(this.getHunger() + var1);
        if (this.getHunger() > this.getMaxHunger()) {
            this.setHunger(this.getMaxHunger());
        }
        this.field_70170_p.func_72956_a((Entity)this, "random.eat", this.func_70599_aP(), this.func_70647_i());
        return true;
    }

    public void func_70074_a(EntityLivingBase var1) {
        super.func_70074_a(var1);
        this.increaseHunger(this.SelfType.FoodMobList.getMobFood(var1.getClass()));
        this.func_70691_i(this.SelfType.FoodMobList.getMobHeal(var1.getClass()));
    }

    public void decreaseHunger() {
        if (this.getHunger() > 0) {
            this.setHunger(this.getHunger() - 1);
        }
    }

    public boolean IsHungry() {
        return (float)this.getHunger() < (float)this.getMaxHunger() * this.SelfType.HungryLevel;
    }

    public boolean IsDeadlyHungry() {
        return (float)this.getHunger() < (float)this.getMaxHunger() * (1.0f - this.SelfType.HungryLevel);
    }

    public int getHungerTick() {
        return this.field_70180_af.func_75679_c(18);
    }

    public void setHungerTick(int var1) {
        this.field_70180_af.func_75692_b(18, (Object)var1);
    }

    public void decreaseHungerTick() {
        if (this.getHungerTick() > 0) {
            this.setHungerTick(this.getHungerTick() - 1);
        }
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        if (this.isInvulnerable(var1)) {
            return false;
        }
        if (var1 == DamageSource.field_76368_d) {
            return false;
        }
        return this.modelizedDrop() ? true : super.func_70097_a(var1, var2);
    }

    protected String getModelTexture() {
        return "fossil:textures/mob/DinosaurModels/DinoModel" + this.SelfType.toString() + ".png";
    }

    public String getTexture() {
        return this.isModelized() ? this.getModelTexture() : "fossil:textures/mob/DinoModel" + this.SelfType.toString() + ".png";
    }

    public void func_70612_e(float par1, float par2) {
        if (!this.isModelized()) {
            super.func_70612_e(par1, par2);
            if (this.field_70153_n != null || this.isAdult()) {
                this.field_70138_W = 1.0f;
            }
        } else {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
        }
    }

    public int func_70627_aG() {
        return 360;
    }

    protected String func_70639_aQ() {
        if (this.isModelized()) {
            return null;
        }
        return "fossil:" + this.SelfType.toString().toLowerCase() + "_living";
    }

    public String getAttackSound() {
        if (this.isModelized()) {
            return null;
        }
        return "fossil:" + this.SelfType.toString().toLowerCase() + "_living";
    }

    protected String func_70621_aR() {
        if (this.isModelized()) {
            return null;
        }
        return "fossil:" + this.SelfType.toString().toLowerCase() + "_hurt";
    }

    protected String func_70673_aS() {
        if (this.isModelized()) {
            return null;
        }
        return "fossil:" + this.SelfType.toString().toLowerCase() + "_death";
    }

    protected float func_70647_i() {
        return !this.isAdult() && !this.isTeen() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 2.5f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f;
    }

    protected float func_70599_aP() {
        return !this.isAdult() && !this.isTeen() ? 0.4f : 1.0f;
    }

    public boolean func_70617_f_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void ShowPedia(GuiPedia p0) {
        p0.reset();
        p0.PrintPictXY(new ResourceLocation("fossil:textures/items/" + this.SelfType.toString() + "_DNA.png"), p0.xGui / 2 + p0.xGui / 4, 7, 16, 16);
        if (this.func_94056_bM()) {
            p0.PrintStringXY(this.func_94057_bL(), 150, 24, 40, 90, 245);
        }
        p0.PrintStringXY(StatCollector.func_74838_a((String)("entity.fossil." + this.SelfType.toString() + ".name")), 150, 34, 0, 0, 0);
        p0.PrintPictXY(pediaclock, 150, 46, 8, 8);
        p0.PrintPictXY(pediaheart, 150, 58, 9, 9);
        p0.PrintPictXY(pediafood, 150, 70, 9, 9);
        if (this.getDinoAge() == 1) {
            p0.PrintStringXY(String.valueOf(this.getDinoAge()) + " " + StatCollector.func_74838_a((String)"pedia.eggDay"), 150 + 12, 46);
        } else {
            p0.PrintStringXY(String.valueOf(this.getDinoAge()) + " " + StatCollector.func_74838_a((String)"pedia.eggDays"), 150 + 12, 46);
        }
        p0.PrintStringXY(String.valueOf(this.func_110143_aJ()) + '/' + this.func_110138_aP(), 150 + 12, 58);
        p0.PrintStringXY(String.valueOf(this.getHunger()) + '/' + this.getMaxHunger(), 150 + 12, 70);
        if (this.SelfType.isTameable() && this.func_70909_n()) {
            if (this.getOwnerDisplayName().length() > 0) {
                p0.AddStringLR(StatCollector.func_74838_a((String)"pedia.text.owner"), true);
                String s0 = String.valueOf(this.getOwnerDisplayName());
                if (s0.length() > 11) {
                    s0 = this.getOwnerDisplayName().substring(0, 11);
                }
                p0.AddStringLR(s0, true);
            } else {
                p0.AddStringLR(StatCollector.func_74838_a((String)"Tamed"), true);
            }
        } else {
            p0.AddStringLR(StatCollector.func_74838_a((String)"Untamed"), true);
        }
        if (this.SelfType.isRideable() && this.isAdult()) {
            p0.AddStringLR(StatCollector.func_74838_a((String)"pedia.text.rideable"), true);
        }
        if (this.SelfType.OrderItem != null) {
            p0.AddStringLR(StatCollector.func_74838_a((String)("Order: " + new ItemStack(this.SelfType.OrderItem).func_82833_r())), true);
        }
        for (int i = 0; i < this.SelfType.FoodItemList.index; ++i) {
            if (this.SelfType.FoodItemList.getItem(i) == null) continue;
            p0.AddMiniItem(this.SelfType.FoodItemList.getItem(i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void ShowPedia2(GuiPedia p0) {
        p0.reset();
        p0.AddStringLR("", 150, false);
        String translatePath = "assets/fossil/dinopedia/" + Minecraft.func_71410_x().field_71474_y.field_74363_ab + "/";
        String bioFile = String.valueOf((Object)this.SelfType) + ".txt";
        if (((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(translatePath) == null) {
            translatePath = "assets/fossil/dinopedia/en_US/";
        }
        if (((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(translatePath + bioFile) != null) {
            InputStream fileReader = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(translatePath + bioFile);
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileReader));
                StringBuffer stringBuffer = new StringBuffer();
                while ((line = bufferedReader.readLine()) != null) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    p0.AddStringLR(line, 150, false);
                    GL11.glPopMatrix();
                }
                fileReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            p0.AddStringLR("File not found.", false);
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            p0.AddStringLR(translatePath + bioFile, 150, false);
            GL11.glPopMatrix();
        }
        if (Fossil.DebugMode()) {
            p0.AddStringLR(StatCollector.func_74838_a((String)("Command: " + (Object)((Object)this.getOrderType()))), true);
            p0.AddStringLR(StatCollector.func_74838_a((String)("Sitting: " + this.func_70906_o())), true);
        }
    }

    public int Eat(ItemStack itemstack) {
        int i;
        if (this.IsHungry() && (this.SelfType.FoodItemList.CheckItem(itemstack.func_77973_b()) || this.SelfType.FoodBlockList.CheckBlock(Block.func_149634_a((Item)itemstack.func_77973_b())))) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)36);
            for (i = itemstack.field_77994_a; i > 0 && this.getHunger() < this.getMaxHunger(); --i) {
                this.setHunger(this.getHunger() + this.SelfType.FoodItemList.getItemFood(itemstack.func_77973_b()));
                if (this.field_70170_p.field_72995_K) continue;
                this.func_70691_i(this.SelfType.FoodItemList.getItemHeal(itemstack.func_77973_b()));
            }
            if (this.getHunger() > this.getMaxHunger()) {
                if (this.func_70909_n()) {
                    this.SendStatusMessage(EnumSituation.Full);
                }
                this.setHunger(this.getMaxHunger());
            }
            this.field_70170_p.func_72956_a((Entity)this, "random.eat", this.func_70599_aP(), this.func_70647_i());
        }
        return i;
    }

    public void HoldItem(ItemStack var1) {
        this.ItemInMouth = new ItemStack(var1.func_77973_b(), 1, var1.func_77960_j());
    }

    public int PickUpItem(ItemStack var1) {
        int i = this.Eat(var1);
        if (i > 0 && (this.SelfType.canCarryItems() || this.SelfType.FoodItemList.CheckItem(var1.func_77973_b())) && this.ItemInMouth == null) {
            this.HoldItem(var1);
            --i;
        }
        return i;
    }

    public boolean func_70650_aV() {
        return !this.isModelized();
    }

    public boolean func_70906_o() {
        return this.getOrderType() == EnumOrderType.Stay;
    }

    public boolean func_70104_M() {
        return !this.func_70906_o();
    }

    protected boolean func_70780_i() {
        return this.getOrderType() == EnumOrderType.Stay;
    }

    public Vec3 getBlockToEat(int SEARCH_RANGE) {
        Vec3 pos = null;
        for (int r = 1; r <= SEARCH_RANGE; ++r) {
            int dy;
            int ds;
            for (ds = -r; ds <= r; ++ds) {
                for (dy = 4; dy > -5; --dy) {
                    if (this.field_70163_u + (double)dy >= 0.0 && this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K() && this.SelfType.FoodBlockList.CheckBlock(this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(this.field_70165_t + (double)ds)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy)), MathHelper.func_76128_c((double)(this.field_70161_v - (double)r))))) {
                        pos = Vec3.func_72443_a((double)MathHelper.func_76128_c((double)(this.field_70165_t + (double)ds)), (double)MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy)), (double)MathHelper.func_76128_c((double)(this.field_70161_v - (double)r)));
                        return pos;
                    }
                    if (!(this.field_70163_u + (double)dy >= 0.0) || !(this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K()) || !this.SelfType.FoodBlockList.CheckBlock(this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(this.field_70165_t + (double)ds)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)r))))) continue;
                    pos = Vec3.func_72443_a((double)MathHelper.func_76128_c((double)(this.field_70165_t + (double)ds)), (double)MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy)), (double)MathHelper.func_76128_c((double)(this.field_70161_v + (double)r)));
                    return pos;
                }
            }
            for (ds = -r + 1; ds <= r - 1; ++ds) {
                for (dy = 4; dy > -5; --dy) {
                    if (this.field_70163_u + (double)dy >= 0.0 && this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K() && this.SelfType.FoodBlockList.CheckBlock(this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(this.field_70165_t - (double)r)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)ds))))) {
                        pos = Vec3.func_72443_a((double)MathHelper.func_76128_c((double)(this.field_70165_t - (double)r)), (double)MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy)), (double)MathHelper.func_76128_c((double)(this.field_70161_v + (double)ds)));
                        return pos;
                    }
                    if (!(this.field_70163_u + (double)dy >= 0.0) || !(this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K()) || !this.SelfType.FoodBlockList.CheckBlock(this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(this.field_70165_t + (double)r)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)ds))))) continue;
                    pos = Vec3.func_72443_a((double)MathHelper.func_76128_c((double)(this.field_70165_t + (double)r)), (double)MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy)), (double)MathHelper.func_76128_c((double)(this.field_70161_v + (double)ds)));
                    return pos;
                }
            }
        }
        return null;
    }

    public TileEntityFeeder GetNearestFeeder(int SEARCH_RANGE) {
        for (int dx = -2; dx != -(SEARCH_RANGE + 1); dx += dx < 0 ? dx * -2 : -(2 * dx + 1)) {
            for (int dy = -5; dy < 4; ++dy) {
                for (int dz = -2; dz != -(SEARCH_RANGE + 1); dz += dz < 0 ? dz * -2 : -(2 * dz + 1)) {
                    TileEntity fed;
                    if (!(this.field_70163_u + (double)dy >= 0.0) || !(this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K()) || (fed = this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)(this.field_70165_t + (double)dx)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)dz)))) == null || !(fed instanceof TileEntityFeeder) || ((TileEntityFeeder)fed).CheckIsEmpty(this.SelfType)) continue;
                    return (TileEntityFeeder)fed;
                }
            }
        }
        return null;
    }

    public void HandleBreed() {
        if (this.isAdult()) {
            --this.BreedTick;
            if (this.BreedTick == 0) {
                int PartnerCount = 0;
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(16.0, 16.0, 16.0));
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof EntityDinosaur)) continue;
                    EntityDinosaur partner = (EntityDinosaur)((Object)list.get(i));
                    if (partner.SelfType == this.SelfType && partner.isAdult()) {
                        ++PartnerCount;
                    }
                    if (PartnerCount <= 20) continue;
                    return;
                }
                if (PartnerCount > 10) {
                    PartnerCount = 10;
                }
                if (new Random().nextInt(100) < PartnerCount) {
                    EntityDinoEgg var5 = null;
                    var5 = new EntityDinoEgg(this.field_70170_p, this.SelfType);
                    var5.func_70012_b(this.field_70165_t + (double)(new Random().nextInt(3) - 1), this.field_70163_u, this.field_70161_v + (double)(new Random().nextInt(3) - 1), this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    this.field_70170_p.func_72838_d((Entity)var5);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)35);
                }
                this.BreedTick = this.SelfType.BreedingTicks;
            }
        }
    }

    public boolean CheckSpace() {
        return !this.func_70094_T();
    }

    protected void getPathOrWalkableBlock(Entity var1, float var2) {
        PathEntity var3 = this.field_70170_p.func_72865_a((Entity)this, var1, 16.0f, true, false, true, false);
        this.func_70778_a(var3);
    }

    public boolean func_70652_k(Entity victim) {
        boolean attacked;
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (victim instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)victim));
            knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)victim));
        }
        if (attacked = victim.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage)) {
            if (knockback > 0) {
                double vx = -Math.sin(Math.toRadians(this.field_70177_z)) * (double)knockback * 0.5;
                double vy = 0.1;
                double vz = Math.cos(Math.toRadians(this.field_70177_z)) * (double)knockback * 0.5;
                victim.func_70024_g(vx, vy, vz);
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if (victim instanceof EntityLivingBase) {
                // empty if block
            }
            this.func_130011_c(victim);
        }
        return attacked;
    }

    public void SendOrderMessage(EnumOrderType var1) {
        String S = StatCollector.func_74838_a((String)"order.head") + StatCollector.func_74838_a((String)("order." + var1.toString()));
        Fossil.ShowMessage(S, (EntityPlayer)this.func_70902_q());
    }

    public void SendStatusMessage(EnumSituation var1) {
        if (this.func_70902_q() == null || this.func_70032_d((Entity)this.func_70902_q()) < 50.0f) {
            // empty if block
        }
        String Status1 = StatCollector.func_74838_a((String)("status." + var1.toString() + ".head"));
        String Dino = this.SelfType.toString();
        String Status2 = StatCollector.func_74838_a((String)("status." + var1.toString()));
        Fossil.ShowMessage(Status1 + Dino + " " + Status2, (EntityPlayer)this.func_70902_q());
    }

    public void showHeartsOrSmokeFX(boolean hearts, boolean poof) {
        String var2 = "heart";
        if (!hearts && !poof) {
            var2 = "smoke";
        }
        if (!hearts && poof) {
            var2 = "cloud";
        }
        for (int var3 = 0; var3 < 7; ++var3) {
            double var4 = this.field_70146_Z.nextGaussian() * 0.02;
            double var6 = this.field_70146_Z.nextGaussian() * 0.02;
            double var8 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(var2, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, var4, var6, var8);
        }
    }

    public float GetDistanceWithXYZ(double var1, double var3, double var5) {
        return (float)Math.sqrt(Math.pow(this.field_70165_t - var1, 2.0) + Math.pow(this.field_70163_u - var3, 2.0) + Math.pow(this.field_70161_v - var5, 2.0));
    }

    public void FaceToCoord(int var1, int var2, int var3) {
        if (!this.isModelized()) {
            double var4 = var1;
            double var6 = var3;
            float var8 = (float)(Math.atan2(var6, var4) * 180.0 / Math.PI) - 90.0f;
            this.field_70177_z = this.updateRotation(this.field_70177_z, var8, 360.0f);
        }
    }

    private float updateRotation(float var1, float var2, float var3) {
        float var4;
        for (var4 = var2 - var1; var4 < -180.0f; var4 += 360.0f) {
        }
        while (var4 >= 180.0f) {
            var4 -= 360.0f;
        }
        if (var4 > var3) {
            var4 = var3;
        }
        if (var4 < -var3) {
            var4 = -var3;
        }
        return var1 + var4;
    }

    public float GetDistanceWithTileEntity(TileEntity var1) {
        return var1 != null ? (float)Math.sqrt(Math.pow(this.field_70165_t - (double)var1.field_145851_c, 2.0) + Math.pow(this.field_70163_u - (double)var1.field_145848_d, 2.0) + Math.pow(this.field_70161_v - (double)var1.field_145849_e, 2.0)) : -1.0f;
    }

    public float GetDistanceWithEntity(Entity var1) {
        return (float)Math.sqrt(Math.pow(this.field_70165_t - var1.field_70165_t, 2.0) + Math.pow(this.field_70163_u - var1.field_70163_u, 2.0) + Math.pow(this.field_70161_v - var1.field_70161_v, 2.0));
    }

    protected Item func_146068_u() {
        if (this.isModelized()) {
            return Items.field_151103_aS;
        }
        return this.SelfType.DropItem;
    }

    protected void func_70600_l(int par1) {
        if (this.isModelized() || !this.isAdult()) {
            return;
        }
        int j = new Random().nextInt(7);
        Item item = null;
        switch (j) {
            case 0: {
                item = Fossil.legBone;
                break;
            }
            case 1: {
                item = Fossil.claw;
                break;
            }
            case 2: {
                item = Fossil.foot;
                break;
            }
            case 3: {
                item = Fossil.skull;
                break;
            }
            case 4: {
                item = Fossil.vertebrae;
                break;
            }
            case 5: {
                item = Fossil.armBone;
                break;
            }
            case 6: {
                item = Fossil.dinoRibCage;
            }
        }
        this.func_70099_a(new ItemStack(item, 1, this.SelfType.ordinal()), 0.5f);
        if (!this.isAdult()) {
            return;
        }
        if (new Random().nextInt(10000) < 500) {
            j = new Random().nextInt(7);
            switch (j) {
                case 0: {
                    item = Fossil.legBone;
                    break;
                }
                case 1: {
                    item = Fossil.claw;
                    break;
                }
                case 2: {
                    item = Fossil.foot;
                    break;
                }
                case 3: {
                    item = Fossil.skull;
                    break;
                }
                case 4: {
                    item = Fossil.vertebrae;
                    break;
                }
                case 5: {
                    item = Fossil.armBone;
                    break;
                }
                case 6: {
                    item = Fossil.dinoRibCage;
                }
            }
            this.func_70099_a(new ItemStack(item, 1, this.SelfType.ordinal()), 0.5f);
        }
    }

    public void func_70103_a(byte var1) {
        if (var1 == 35) {
            this.showHeartsOrSmokeFX(true, true);
        } else if (var1 == 36) {
            this.showHeartsOrSmokeFX(false, false);
        } else if (var1 == 37) {
            this.showHeartsOrSmokeFX(false, true);
        } else {
            super.func_70103_a(var1);
        }
    }

    protected void func_70628_a(boolean var1, int var2) {
        Item var3 = this.func_146068_u();
        if (var3 != null) {
            this.func_70099_a(new ItemStack(var3, MathHelper.func_76123_f((float)((float)this.getDinoAge() / 2.0f)), 0), 0.5f);
            this.func_70600_l(var2);
        }
    }

    public boolean isAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public void setAngry(boolean var1) {
        byte var2 = this.field_70180_af.func_75683_a(16);
        if (var1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 | 2)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 & 0xFFFFFFFD)));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.func_70909_n()) {
            this.func_110160_i(true, true);
        }
    }

    protected boolean modelizedInteract(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack == null) {
            if (player.func_70093_af()) {
                this.nudgeEntity(player);
            } else {
                this.func_70625_a((Entity)player, 360.0f, 360.0f);
            }
        } else if (itemstack.func_77973_b() == Items.field_151103_aS) {
            this.increaseDinoAge();
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            if (itemstack.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
            }
            return true;
        }
        return false;
    }

    public void nudgeEntity(EntityPlayer player) {
        this.func_70634_a(this.field_70165_t + (player.field_70165_t - this.field_70165_t) * (double)0.01f, this.field_70163_u, this.field_70161_v + (player.field_70161_v - this.field_70161_v) * (double)0.01f);
    }

    protected void func_70626_be() {
        if (!this.isModelized()) {
            super.func_70626_be();
        }
    }

    protected void func_145780_a(int x, int y, int z, Block blockId) {
        if (!this.field_70171_ac) {
            if (!this.isAdult()) {
                super.func_145780_a(x, y, z, blockId);
            } else {
                super.func_145780_a(x, y, z, blockId);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isModelized", this.isModelized());
        compound.func_74757_a("Angry", this.isAngry());
        compound.func_74768_a("Hunger", this.getHunger());
        compound.func_74768_a("HungerTick", this.getHungerTick());
        compound.func_74768_a("DinoAge", this.getDinoAge());
        compound.func_74768_a("AgeTick", this.getDinoAgeTick());
        compound.func_74768_a("SubSpecies", this.getSubSpecies());
        compound.func_74774_a("OrderStatus", (byte)this.OrderStatus.ordinal());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setModelized(compound.func_74767_n("isModelized"));
        this.setAngry(compound.func_74767_n("Angry"));
        this.setDinoAge(compound.func_74762_e("DinoAge"));
        this.setDinoAgeTick(compound.func_74762_e("AgeTick"));
        this.setHunger(compound.func_74762_e("Hunger"));
        this.setHungerTick(compound.func_74762_e("HungerTick"));
        this.setSubSpecies(compound.func_74762_e("SubSpecies"));
        short var3 = compound.func_74765_d("Itemid");
        byte var4 = compound.func_74771_c("ItemCount");
        short var5 = compound.func_74765_d("ItemDamage");
        this.SetOrder(EnumOrderType.values()[compound.func_74771_c("OrderStatus")]);
    }

    protected boolean modelizedDrop() {
        if (this.isModelized()) {
            if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                this.func_70099_a(new ItemStack(Fossil.biofossil, 1), 0.0f);
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public EnumOrderType getOrderType() {
        return this.OrderStatus;
    }

    public void func_70636_d() {
        if (!this.isModelized()) {
            if (!this.field_70170_p.field_72995_K) {
                if (FossilOptions.AllowBreeding) {
                    this.HandleBreed();
                }
            }
            super.func_70636_d();
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (this.isModelized()) {
            return this.modelizedInteract(player);
        }
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null) {
            if (itemstack.func_77973_b() == Fossil.chickenEss && !player.field_70170_p.field_72995_K) {
                if (this.getDinoAge() < this.SelfType.AdultAge && this.getHunger() > 0 && this.getHunger() > 0) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --itemstack.field_77994_a;
                    }
                    if (itemstack.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo, 1));
                    }
                    this.setDinoAgeTick(this.getDinoAgeTick() + 2000);
                    this.setHunger(1 + new Random().nextInt(this.getHunger()));
                    return true;
                }
                if (!this.field_70170_p.field_72995_K) {
                    Fossil.ShowMessage(StatCollector.func_74838_a((String)"status.essencefail"), player);
                }
                return false;
            }
            if (this.SelfType.FoodItemList.CheckItem(itemstack.func_77973_b()) || this.SelfType.FoodBlockList.CheckBlock(Block.func_149634_a((Item)itemstack.func_77973_b()))) {
                if (!player.field_70170_p.field_72995_K) {
                    if (this.getMaxHunger() > this.getHunger()) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)36);
                        this.increaseHunger(this.SelfType.FoodItemList.getItemFood(itemstack.func_77973_b()) + this.SelfType.FoodBlockList.getBlockFood(itemstack.func_77973_b()));
                        if (FossilOptions.Heal_Dinos) {
                            this.func_70691_i(this.SelfType.FoodItemList.getItemHeal(itemstack.func_77973_b()) + this.SelfType.FoodBlockList.getBlockHeal(Block.func_149634_a((Item)itemstack.func_77973_b())));
                        }
                        if (this.getHunger() >= this.getMaxHunger() && this.func_70909_n()) {
                            this.SendStatusMessage(EnumSituation.Full);
                        }
                        --itemstack.field_77994_a;
                        if (!this.func_70909_n() && this.SelfType.isTameable() && new Random().nextInt(10) == 1) {
                            this.func_70903_f(true);
                            this.setOwner(player.func_110124_au().toString());
                            this.setOwnerDisplayName(player.func_70005_c_());
                            this.field_70170_p.func_72960_a((Entity)this, (byte)35);
                        }
                        return true;
                    }
                    if (this.ItemInMouth == null) {
                        return true;
                    }
                    if (this.SelfType.FoodItemList.getItemFood(this.ItemInMouth.func_77973_b()) + this.SelfType.FoodBlockList.getBlockFood(this.ItemInMouth.func_77973_b()) < this.SelfType.FoodItemList.getItemFood(itemstack.func_77973_b()) + this.SelfType.FoodBlockList.getBlockFood(itemstack.func_77973_b())) {
                        // empty if block
                    }
                }
                return false;
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151058_ca && this.func_110164_bC() && this.func_152114_e((EntityLivingBase)player)) {
                this.func_110162_b((Entity)player, true);
                --itemstack.field_77994_a;
                return true;
            }
            if (FMLCommonHandler.instance().getSide().isClient() && itemstack.func_77973_b() == Fossil.dinoPedia) {
                this.setPedia();
                player.openGui((Object)Fossil.instance, 4, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
                return true;
            }
            if (itemstack.func_77973_b() == Fossil.whip && this.func_70909_n() && this.SelfType.isRideable() && this.isAdult() && !this.field_70170_p.field_72995_K && this.field_70153_n == null && this.func_152114_e((EntityLivingBase)player)) {
                this.func_70904_g(false);
                this.SetOrder(EnumOrderType.FreeMove);
                this.setRidingPlayer(player);
            }
            if (this.SelfType.OrderItem != null && itemstack.func_77973_b() == this.SelfType.OrderItem && this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && !player.func_70115_ae()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70703_bu = false;
                    this.func_70778_a(null);
                    this.OrderStatus = EnumOrderType.values()[(this.OrderStatus.ordinal() + 1) % 3];
                    this.SendOrderMessage(this.OrderStatus);
                    if (this.OrderStatus == EnumOrderType.Stay) {
                        this.func_70661_as().func_75499_g();
                        this.func_70778_a(null);
                        this.func_70904_g(true);
                    } else {
                        this.func_70904_g(false);
                    }
                }
                return true;
            }
            if (this.SelfType.canCarryItems() && itemstack.func_77973_b() != Fossil.dinoPedia && this.ItemInMouth == null && (this.func_70909_n() && player == this.func_70902_q() || new Random().nextInt(40) == 1)) {
                if (itemstack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
                return true;
            }
        }
        return super.func_70085_c(player);
    }

    public void setOwner(String ownerName) {
        this.func_152115_b(ownerName);
    }

    public boolean func_110164_bC() {
        return !this.func_110167_bD() && !(this instanceof IMob) && this.func_70909_n();
    }

    public int BlockInteractive() {
        return 0;
    }

    public void SetOrder(EnumOrderType var1) {
        this.OrderStatus = var1;
    }

    public void writeSpawnData(ByteArrayDataOutput var1) {
    }

    public void readSpawnData(ByteArrayDataInput var1) {
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable var1) {
        return null;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData par1EntityLivingData) {
        par1EntityLivingData = super.func_110161_a(par1EntityLivingData);
        Random random = new Random();
        this.setSubSpecies(random.nextInt(4) + 1);
        this.setDinoAge(this.SelfType.AdultAge);
        this.updateSize();
        this.func_70691_i(200.0f);
        return par1EntityLivingData;
    }

    public EntityAIControlledByPlayer getAIControlledByPlayer() {
        return this.aiControlledByPlayer;
    }

    @Override
    public EntityPlayer getRidingPlayer() {
        if (this.field_70153_n instanceof EntityPlayer) {
            return (EntityPlayer)this.field_70153_n;
        }
        return null;
    }

    public void setRidingPlayer(EntityPlayer player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        player.func_70078_a((Entity)this);
    }

    public void riderJump() {
        Fossil.Log.log(Level.INFO, "isRiderJumping");
        this.field_70181_x += 0.5;
    }

    public void func_70664_aZ() {
        super.func_70664_aZ();
        this.field_70181_x = 0.45;
    }

    public boolean isInvulnerable(DamageSource var1) {
        Entity srcEnt = var1.func_76346_g();
        if (srcEnt != null) {
            if (srcEnt == this) {
                return true;
            }
            if (srcEnt == this.field_70153_n) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void onWhipRightClick() {
    }
}

