/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.entity.mob;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import mods.fossil.Fossil;
import mods.fossil.entity.mob.EntitySwimmingDino;
import mods.fossil.fossilAI.WaterDinoAIAttack;
import mods.fossil.fossilAI.WaterDinoAIEat;
import mods.fossil.fossilAI.WaterDinoAIHunt;
import mods.fossil.fossilAI.WaterDinoAIWander;
import mods.fossil.fossilEnums.EnumDinoType;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityMosasaurus
extends EntitySwimmingDino {
    private Entity targetedEntity;
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    private double deltaX;
    private double deltaY;
    private double deltaZ;
    private double length;
    public static final double baseHealth = EnumDinoType.Mosasaurus.Health0;
    public static final double baseDamage = EnumDinoType.Mosasaurus.Strength0;
    public static final double baseSpeed = EnumDinoType.Mosasaurus.Speed0;
    public static final double maxHealth = EnumDinoType.Mosasaurus.HealthMax;
    public static final double maxDamage = EnumDinoType.Mosasaurus.StrengthMax;
    public static final double maxSpeed = EnumDinoType.Mosasaurus.SpeedMax;

    public EntityMosasaurus(World par1World) {
        super(par1World, EnumDinoType.Mosasaurus);
        this.adultAge = EnumDinoType.Mosasaurus.AdultAge;
        this.func_70105_a(1.5f, 0.6f);
        this.minSize = 1.2f;
        this.maxSize = 3.4f;
        this.field_70728_aV = 5;
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new WaterDinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new WaterDinoAIAttack(this, 0.009));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new WaterDinoAIEat(this, 50, 0.002));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new WaterDinoAIHunt(this, EntityLiving.class, 50, false, 0.003));
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public void func_70636_d() {
        this.breakBlock(5.0f);
        super.func_70636_d();
    }

    @Override
    public String getTexture() {
        if (this.isModelized()) {
            return super.getModelTexture();
        }
        switch (this.getSubSpecies()) {
            case 1: {
                return "fossil:textures/mob/Mosasaur_Blue.png";
            }
        }
        return "fossil:textures/mob/Mosasaur_Green.png";
    }

    @Override
    protected String func_70639_aQ() {
        if (this.isModelized()) {
            return null;
        }
        if (!this.func_70090_H()) {
            return "fossil:mosasaurus_living";
        }
        return "fossil:mosasaurus_outside";
    }

    @Override
    public String getAttackSound() {
        if (this.isModelized()) {
            return null;
        }
        return "fossil:" + this.SelfType.toString().toLowerCase() + "_attack";
    }

    @Override
    public boolean func_70650_aV() {
        return !this.isModelized();
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        return super.func_70097_a(par1DamageSource, par2);
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.isModelized() && par1EntityPlayer.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() + 1.0))) {
            this.func_85030_a("mob.attack", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(baseHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(baseDamage);
    }

    @Override
    public boolean func_70652_k(Entity victim) {
        boolean attacked;
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (victim instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)victim));
            knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)victim));
        }
        if (attacked = victim.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage)) {
            if (knockback > 0) {
                double vx = -Math.sin(Math.toRadians(this.field_70177_z)) * (double)knockback * 0.5;
                double vy = 0.1;
                double vz = Math.cos(Math.toRadians(this.field_70177_z)) * (double)knockback * 0.5;
                victim.func_70024_g(vx, vy, vz);
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if (victim instanceof EntityLivingBase) {
                // empty if block
            }
            this.func_130011_c(victim);
        }
        return attacked;
    }

    @Override
    protected float func_70599_aP() {
        return 1.0f;
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(20) == 0 && super.func_70601_bi() && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    public EntityMosasaurus spawnBabyAnimal(EntityAnimal var1) {
        return new EntityMosasaurus(this.field_70170_p);
    }

    @Override
    public boolean func_70085_c(EntityPlayer var1) {
        ItemStack var2 = var1.field_71071_by.func_70448_g();
        if (var2 != null && !Fossil.DebugMode() && var2.func_77973_b() == Fossil.chickenEss && !this.field_70170_p.field_72995_K) {
            Fossil.ShowMessage(StatCollector.func_74838_a((String)"status.essencefail"), var1);
            return true;
        }
        return super.func_70085_c(var1);
    }

    @Override
    public void updateSize() {
        double healthStep = (maxHealth - baseHealth) / (double)(this.adultAge + 1);
        double attackStep = (maxDamage - baseDamage) / (double)(this.adultAge + 1);
        double speedStep = (maxSpeed - baseSpeed) / (double)(this.adultAge + 1);
        if (this.getDinoAge() <= this.adultAge) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.round(baseHealth + healthStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Math.round(baseDamage + attackStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed + speedStep * (double)this.getDinoAge());
            if (this.isTeen()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
            } else if (this.isAdult()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(2.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
    }

    public void readSpawnData(ByteBuf additionalData) {
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData par1EntityLivingData) {
        par1EntityLivingData = super.func_110161_a(par1EntityLivingData);
        Random random = new Random();
        this.setSubSpecies(random.nextInt(2) + 1);
        this.setDinoAge(this.SelfType.AdultAge);
        this.updateSize();
        this.func_70691_i(200.0f);
        return par1EntityLivingData;
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable var1) {
        EntityMosasaurus baby = new EntityMosasaurus(this.field_70170_p);
        baby.setSubSpecies(this.getSubSpecies());
        return baby;
    }
}

