/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.entity.mob;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import mods.fossil.client.FossilOptions;
import mods.fossil.entity.mob.EntityNautilus;
import mods.fossil.entity.mob.EntitySwimmingDino;
import mods.fossil.fossilAI.DinoAIAttackOnCollide;
import mods.fossil.fossilAI.DinoAIEat;
import mods.fossil.fossilAI.DinoAIFishing;
import mods.fossil.fossilAI.DinoAIFollowOwner;
import mods.fossil.fossilAI.DinoAIRideGround;
import mods.fossil.fossilAI.DinoAIWander;
import mods.fossil.fossilAI.WaterDinoAIEat;
import mods.fossil.fossilAI.WaterDinoAIHunt;
import mods.fossil.fossilAI.WaterDinoAIWander;
import mods.fossil.fossilEnums.EnumDinoType;
import mods.fossil.fossilEnums.EnumOrderType;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityPlesiosaur
extends EntitySwimmingDino {
    private boolean looksWithInterest = false;
    public float TargetY = 0.0f;
    private float randomMotionSpeed;
    private float randomMotionVecX = 0.0f;
    private float randomMotionVecY = 0.0f;
    private float randomMotionVecZ = 0.0f;
    public static final double baseHealth = EnumDinoType.Plesiosaur.Health0;
    public static final double baseDamage = EnumDinoType.Plesiosaur.Strength0;
    public static final double baseSpeed = EnumDinoType.Plesiosaur.Speed0;
    public static final double maxHealth = EnumDinoType.Plesiosaur.HealthMax;
    public static final double maxDamage = EnumDinoType.Plesiosaur.StrengthMax;
    public static final double maxSpeed = EnumDinoType.Plesiosaur.SpeedMax;
    private WaterDinoAIWander aiWaterDinoWander = new WaterDinoAIWander(this, 1.0);
    private DinoAIWander aiDinoWander = new DinoAIWander(this, 1.0);
    private WaterDinoAIHunt aiWaterDinoHunt = new WaterDinoAIHunt(this, EntityLiving.class, 500, false, 0.002);
    private WaterDinoAIEat aiWaterDinoEat = new WaterDinoAIEat(this, 50, 0.0017);
    private DinoAIEat aiDinoEat = new DinoAIEat(this, 20);

    public EntityPlesiosaur(World var1) {
        super(var1, EnumDinoType.Plesiosaur);
        this.setSubSpecies(new Random().nextInt(3) + 1);
        this.updateSize();
        this.adultAge = EnumDinoType.Plesiosaur.AdultAge;
        this.func_70105_a(1.0f, 1.0f);
        this.minSize = 1.0f;
        this.maxSize = 6.0f;
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiWaterDinoWander);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiWaterDinoEat);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiWaterDinoHunt);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIAttackOnCollide(this, 1.1, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIFollowOwner(this, 5.0, 2.0f, 1.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIFishing(this, 1));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoAIRideGround(this, 3.0));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(baseHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(baseDamage);
    }

    @Override
    public boolean func_70650_aV() {
        return !this.isModelized();
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    @Override
    public void func_70636_d() {
        this.breakBlock(5.0f);
        super.func_70636_d();
    }

    @Override
    public String getTexture() {
        if (this.isModelized()) {
            return super.getTexture();
        }
        switch (this.getSubSpecies()) {
            default: 
        }
        return "fossil:textures/mob/Plesiosaur_adult.png";
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    public boolean isOnSurface() {
        return this.field_70170_p.func_147437_c((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u + (double)(this.func_70047_e() / 2.0f)), (int)Math.floor(this.field_70161_v));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public float func_70783_a(int var1, int var2, int var3) {
        return 0.5f - this.field_70170_p.func_72801_o(var1, var2, var3);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    @Override
    protected void getPathOrWalkableBlock(Entity var1, float var2) {
        PathEntity var3 = this.field_70170_p.func_72865_a((Entity)this, var1, 16.0f, true, false, true, false);
        this.func_70778_a(var3);
    }

    @Override
    protected boolean func_70780_i() {
        return this.func_70906_o() || this.isModelized();
    }

    @Override
    public boolean func_70097_a(DamageSource var1, float var2) {
        if (this.modelizedDrop()) {
            return true;
        }
        Entity var3 = var1.func_76346_g();
        if (var3 != null && !(var3 instanceof EntityPlayer) && !(var3 instanceof EntityArrow)) {
            var2 = (var2 + 1.0f) / 2.0f;
        }
        if (!super.func_70097_a(var1, var2)) {
            return false;
        }
        if (!this.func_70909_n() && !this.isSelfAngry()) {
            if (var3 instanceof EntityPlayer) {
                this.setSelfAngry(true);
                this.field_70789_a = var3;
            }
            if (var3 instanceof EntityArrow && ((EntityArrow)var3).field_70250_c != null) {
                var3 = ((EntityArrow)var3).field_70250_c;
            }
            if (var3 instanceof EntityLiving) {
                // empty if block
            }
        } else if (var3 != this && var3 != null) {
            if (this.func_70909_n() && var3 instanceof EntityPlayer && var3 == this.func_70902_q()) {
                return true;
            }
            this.field_70789_a = var3;
        }
        return true;
    }

    protected Entity func_70782_k() {
        return this.isSelfAngry() ? this.field_70170_p.func_72856_b((Entity)this, 16.0) : null;
    }

    @Override
    public boolean func_70085_c(EntityPlayer var1) {
        return super.func_70085_c(var1);
    }

    public boolean isSelfAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public void setSelfAngry(boolean var1) {
        byte var2 = this.field_70180_af.func_75683_a(16);
        if (var1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 | 2)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 & 0xFFFFFFFD)));
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    @Override
    public boolean CheckSpace() {
        if (!this.func_70090_H()) {
            return !this.func_70094_T();
        }
        for (int var1 = 0; var1 < 8; ++var1) {
            float var2 = ((float)((var1 >> 0) % 2) - 0.5f) * this.field_70130_N * 0.9f;
            float var3 = ((float)((var1 >> 1) % 2) - 0.5f) * 0.1f;
            float var4 = ((float)((var1 >> 2) % 2) - 0.5f) * this.field_70130_N * 0.9f;
            int var5 = MathHelper.func_76128_c((double)(this.field_70165_t + (double)var2));
            int var6 = MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e() + (double)var3));
            int var7 = MathHelper.func_76128_c((double)(this.field_70161_v + (double)var4));
            Block var8 = this.field_70170_p.func_147439_a(var1, var5, var6);
            if (var8 == null || var8 == Blocks.field_150355_j || var8 == Blocks.field_150358_i) continue;
            return false;
        }
        return true;
    }

    public float getMountHeight() {
        return this.field_70131_O / 2.0f;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.getMountHeight() + this.field_70153_n.func_70033_W(), this.field_70161_v);
        }
    }

    private boolean FindFish(int var1) {
        if (this.func_70906_o()) {
            return false;
        }
        List var2 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(1.0, 0.0, 1.0));
        if (var2 != null) {
            for (int var3 = 0; var3 < var2.size(); ++var3) {
                EntityItem var4;
                if (!(var2.get(var3) instanceof EntityItem) || (var4 = (EntityItem)var2.get(var3)).func_92059_d().func_77973_b() != Items.field_151115_aP && var4.func_92059_d().func_77973_b() != Items.field_151101_aQ) continue;
                this.increaseHunger(10);
                this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((new Random().nextFloat() - new Random().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                var4.func_70106_y();
                return true;
            }
        }
        return false;
    }

    public boolean func_70090_H() {
        return this.field_70170_p.func_72918_a(this.field_70121_D.func_72314_b(0.0, (double)-0.4f, 0.0).func_72331_e(0.001, 0.001, 0.001), Material.field_151586_h, (Entity)this);
    }

    public float HandleRiding(float Speed, float SpeedBoosted) {
        if (this.RiderForward > 0.0f) {
            Speed += (this.func_70689_ay() * (this.func_70090_H() ? 3.2f : 1.3f) - Speed) * 0.1f * this.RiderForward;
        } else if (Speed > 0.0f) {
            if ((Speed += (this.func_70689_ay() * (this.func_70090_H() ? 3.2f : 1.3f) - Speed) * 0.4f * this.RiderForward) < 0.0f) {
                Speed = 0.0f;
            }
        } else {
            Speed += (this.func_70689_ay() * (this.func_70090_H() ? 3.2f : 1.3f) - Speed) * 0.06f * this.RiderForward;
        }
        this.field_70177_z = MathHelper.func_76142_g((float)(this.field_70177_z - (this.func_70090_H() ? this.RiderStrafe * 2.0f : this.RiderStrafe * 5.0f)));
        if (this.func_70090_H()) {
            this.field_70181_x = this.RiderJump ? (this.field_70181_x += ((double)0.4f - this.field_70181_x) * (double)0.1f) : (this.RiderSneak ? (this.field_70181_x += ((double)-0.4f - this.field_70181_x) * (double)0.1f) : (this.field_70181_x += this.field_70181_x < 0.0 ? (double)0.01f : (double)-0.01f));
        } else if (this.RiderJump) {
            this.func_70683_ar().func_75660_a();
            this.RiderJump = false;
        }
        this.func_70612_e(0.0f, Speed + Speed * (0.3f + 0.85f * MathHelper.func_76126_a((float)(SpeedBoosted * (float)Math.PI))));
        return Speed;
    }

    public void func_70108_f(Entity var1) {
        if (var1 instanceof EntityLiving && !(var1 instanceof EntityPlayer) && this.field_70153_n != null && this.field_70122_E) {
            this.onKillEntity((EntityLiving)var1);
            ((EntityLiving)var1).func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
        } else if (!this.func_70090_H()) {
            super.func_70108_f(var1);
        }
    }

    public void onKillEntity(EntityLiving var1) {
        super.func_70074_a((EntityLivingBase)var1);
        if (var1 instanceof EntityNautilus) {
            this.increaseHunger(100);
        }
        if (FossilOptions.Heal_Dinos) {
            this.func_70691_i(5.0f);
        }
    }

    @Override
    public void SetOrder(EnumOrderType var1) {
        this.func_70778_a(null);
        this.func_70784_b(null);
        this.OrderStatus = var1;
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable var1) {
        EntityPlesiosaur baby = new EntityPlesiosaur(this.field_70170_p);
        baby.setSubSpecies(this.getSubSpecies());
        return baby;
    }

    @Override
    public void updateSize() {
        double healthStep = (maxHealth - baseHealth) / (double)(this.adultAge + 1);
        double attackStep = (maxDamage - baseDamage) / (double)(this.adultAge + 1);
        double speedStep = (maxSpeed - baseSpeed) / (double)(this.adultAge + 1);
        if (this.getDinoAge() <= this.adultAge) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.round(baseHealth + healthStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Math.round(baseDamage + attackStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed + speedStep * (double)this.getDinoAge());
            if (this.isTeen()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
            } else if (this.isAdult()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(2.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
    }

    public void readSpawnData(ByteBuf additionalData) {
    }
}

