/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.entity.mob;

import mods.fossil.Fossil;
import mods.fossil.client.gui.GuiPedia;
import mods.fossil.fossilEnums.EnumAnimalType;
import mods.fossil.fossilInterface.IViviparous;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class EntityPregnantHorse
implements IViviparous,
IExtendedEntityProperties {
    public static final String PREGNANT_HORSE_PROP = "EntityPregnantHorse";
    private final EntityHorse horse;
    public int EmbryoProgress;
    public EnumAnimalType Embryo;
    private World worldObj;

    public EntityPregnantHorse(EntityHorse horse) {
        this.horse = horse;
        this.EmbryoProgress = 0;
        this.Embryo = null;
    }

    public static final void register(EntityHorse horse) {
        horse.registerExtendedProperties(PREGNANT_HORSE_PROP, (IExtendedEntityProperties)new EntityPregnantHorse(horse));
    }

    public static final EntityPregnantHorse get(EntityHorse horse) {
        return (EntityPregnantHorse)horse.getExtendedProperties(PREGNANT_HORSE_PROP);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a("EmbryoProgress", this.EmbryoProgress);
        if (this.Embryo != null) {
            properties.func_74774_a("Inside", (byte)this.Embryo.ordinal());
        }
        compound.func_74782_a(PREGNANT_HORSE_PROP, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(PREGNANT_HORSE_PROP);
        if (compound.func_74764_b("EmbryoProgress")) {
            this.EmbryoProgress = properties.func_74762_e("EmbryoProgress");
        }
        if (compound.func_74764_b("Inside")) {
            this.Embryo = EnumAnimalType.values()[properties.func_74771_c("Inside")];
        }
    }

    public void init(Entity entity, World world) {
    }

    @Override
    public void SetEmbryo(EnumAnimalType animalType) {
        this.Embryo = animalType;
    }

    public void setPedia() {
        Fossil.ToPedia = this;
    }

    @Override
    public void ShowPedia(GuiPedia p0) {
        if (this.Embryo != null) {
            int quot = (int)Math.floor((float)this.EmbryoProgress / (float)this.Embryo.GrowTime * 100.0f);
            p0.reset();
            p0.AddStringLR(StatCollector.func_74838_a((String)"pedia.embryo.inside"), false);
            p0.AddStringLR(StatCollector.func_74838_a((String)("pedia.embryo." + this.Embryo.toString())), false, 40, 90, 245);
            p0.AddStringLR(StatCollector.func_74838_a((String)"pedia.embryo.growing"), false);
            p0.AddStringLR(String.valueOf(quot) + "/100", false);
        } else {
            p0.reset();
            p0.AddStringLR(StatCollector.func_74838_a((String)"pedia.embryo.inside"), false);
            p0.AddStringLR(StatCollector.func_74838_a((String)"pedia.embryo.growing"), false);
        }
    }
}

