/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.entity.mob;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.fossil.Fossil;
import mods.fossil.client.gui.GuiPedia;
import mods.fossil.entity.mob.EntityPrehistoric;
import mods.fossil.entity.mob.EntityTerrorBird;
import mods.fossil.fossilAI.DinoAINearestAttackableTarget;
import mods.fossil.fossilAI.QuaggaAITaming;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityQuagga
extends EntityAnimal
implements IInvBasic {
    private static final IAttribute horseJumpStrength = new RangedAttribute("horse.jumpStrength", 0.7, 0.0, 2.0).func_111117_a("Jump Strength").func_111112_a(true);
    private static final String[] horseArmorShortName = new String[]{"", "meo", "goo", "dio"};
    private static final String[] horseArmorTextures = new String[]{null, "textures/entity/horse/armor/horse_armor_iron.png", "textures/entity/horse/armor/horse_armor_gold.png", "textures/entity/horse/armor/horse_armor_diamond.png"};
    private static final int[] armorValues = new int[]{0, 5, 7, 11};
    private static final String[] horseTextures = new String[]{"fossil:textures/mob/Quagga_Brown.png"};
    private int eatingHaystackCounter;
    private int openMouthCounter;
    private int jumpRearingCounter;
    public int timer1;
    public int field_110279_bq;
    protected boolean horseJumping;
    public InventoryBasic quaggaChest;
    private boolean hasReproduced;
    protected int temper;
    protected float jumpPower;
    private boolean field_110294_bI;
    private float headLean;
    private float prevHeadLean;
    private float rearingAmount;
    private float prevRearingAmount;
    private float mouthOpenness;
    private float prevMouthOpenness;
    private int field_110285_bP;
    private String horseTexture;
    private String[] combinedTexturePath = new String[3];
    EntityPrehistoric entityPrehistoricClass = new EntityPrehistoric(this.field_70170_p);
    protected static final ResourceLocation pediaheart = new ResourceLocation("fossil:textures/gui/PediaHeart.png");

    public EntityQuagga(World par1World) {
        super(par1World);
        this.func_70105_a(1.4f, 1.6f);
        this.field_70178_ae = false;
        this.setChested(false);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new QuaggaAITaming(this, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityMob.class, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_110226_cD();
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new DinoAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 40, true, true, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityTerrorBird.class, 16.0f, 1.0, 1.2));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)String.valueOf(""));
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    private void setPedia() {
        Fossil.ToPedia = this;
    }

    public String getEntityName() {
        if (this.func_94056_bM()) {
            return this.func_94057_bL();
        }
        return StatCollector.func_74838_a((String)"entity.fossil.Quagga.name");
    }

    private boolean getHorseWatchableBoolean(int par1) {
        return (this.field_70180_af.func_75679_c(16) & par1) != 0;
    }

    private void setHorseWatchableBoolean(int par1, boolean par2) {
        int j = this.field_70180_af.func_75679_c(16);
        if (par2) {
            this.field_70180_af.func_75692_b(16, (Object)(j | par1));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)(j & ~par1));
        }
    }

    public boolean isAdultHorse() {
        return !this.func_70631_g_();
    }

    public boolean isTame() {
        return this.getHorseWatchableBoolean(2);
    }

    public boolean canBeTamed() {
        return this.isAdultHorse();
    }

    public String getOwnerName() {
        return this.field_70180_af.func_75681_e(21);
    }

    public void setOwnerName(String par1Str) {
        this.field_70180_af.func_75692_b(21, (Object)par1Str);
    }

    public float getHorseSize() {
        int i = this.func_70874_b();
        return i >= 0 ? 1.0f : 0.5f + (float)(-24000 - i) / -24000.0f * 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    private void setHorseTexturePaths() {
        this.horseTexture = "horse/";
        this.combinedTexturePath[0] = null;
        this.combinedTexturePath[1] = null;
        this.combinedTexturePath[0] = horseTextures[0];
        this.horseTexture = this.horseTexture + "";
        int k = this.horseArmor();
        this.combinedTexturePath[1] = horseArmorTextures[k];
        this.horseTexture = this.horseTexture + horseArmorShortName[k];
    }

    @SideOnly(value=Side.CLIENT)
    public String getHorseTexture() {
        if (this.horseTexture == null) {
            this.setHorseTexturePaths();
        }
        return this.horseTexture;
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getVariantTexturePaths() {
        if (this.horseTexture == null) {
            this.setHorseTexturePaths();
        }
        return this.combinedTexturePath;
    }

    public void func_98054_a(boolean par1) {
        if (par1) {
            this.func_98055_j(this.getHorseSize());
        } else {
            this.func_98055_j(1.0f);
        }
    }

    public boolean isHorseJumping() {
        return this.horseJumping;
    }

    public void setHorseTamed(boolean par1) {
        this.setHorseWatchableBoolean(2, par1);
    }

    public void setHorseJumping(boolean par1) {
        this.horseJumping = par1;
    }

    public boolean func_110164_bC() {
        return super.func_110164_bC();
    }

    protected void func_142017_o(float par1) {
        if (par1 > 6.0f && this.isEatingHaystack()) {
            this.setEatingHaystack(false);
        }
    }

    public boolean isChested() {
        return this.getHorseWatchableBoolean(8);
    }

    public int horseArmor() {
        return this.field_70180_af.func_75679_c(22);
    }

    public int getHorseArmorIndex(ItemStack par1ItemStack) {
        return par1ItemStack == null ? 0 : (par1ItemStack.func_77973_b() == Items.field_151138_bX ? 1 : (par1ItemStack.func_77973_b() == Items.field_151136_bY ? 2 : (par1ItemStack.func_77973_b() == Items.field_151125_bZ ? 3 : 0)));
    }

    public boolean isEatingHaystack() {
        return this.getHorseWatchableBoolean(32);
    }

    public boolean isRearing() {
        return this.getHorseWatchableBoolean(64);
    }

    public boolean getBred() {
        return this.getHorseWatchableBoolean(16);
    }

    public boolean getHasReproduced() {
        return this.hasReproduced;
    }

    public void setHorseArmor(int par1) {
        this.field_70180_af.func_75692_b(22, (Object)par1);
        this.func_110230_cF();
    }

    public void setBred(boolean par1) {
        this.setHorseWatchableBoolean(16, par1);
    }

    public void setChested(boolean par1) {
        this.setHorseWatchableBoolean(8, par1);
    }

    public void setHasReproduced(boolean par1) {
        this.hasReproduced = par1;
    }

    public void setHorseSaddled(boolean par1) {
        this.setHorseWatchableBoolean(4, par1);
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int par1) {
        this.temper = par1;
    }

    public int increaseTemper(int par1) {
        int j = MathHelper.func_76125_a((int)(this.getTemper() + par1), (int)0, (int)this.getMaxTemper());
        this.setTemper(j);
        return j;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        Entity entity = par1DamageSource.func_76346_g();
        return this.field_70153_n != null && this.field_70153_n.equals((Object)entity) ? false : super.func_70097_a(par1DamageSource, par2);
    }

    public int func_70658_aO() {
        return armorValues[this.horseArmor()];
    }

    public boolean func_70104_M() {
        return this.field_70153_n == null;
    }

    public boolean prepareChunkForSpawn() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70161_v);
        this.field_70170_p.func_72807_a(i, j);
        return true;
    }

    public void dropChests() {
        if (!this.field_70170_p.field_72995_K && this.isChested()) {
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150486_ae), 1);
            this.setChested(false);
        }
    }

    private void eatFood() {
        this.openHorseMouth();
        this.field_70170_p.func_72956_a((Entity)this, "eating", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
    }

    protected void func_70069_a(float par1) {
        int i;
        if (par1 > 1.0f) {
            this.func_85030_a("mob.horse.land", 0.4f, 1.0f);
        }
        if ((i = MathHelper.func_76123_f((float)(par1 * 0.5f - 3.0f))) > 0) {
            Block block;
            this.func_70097_a(DamageSource.field_76379_h, i);
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70097_a(DamageSource.field_76379_h, (float)i);
            }
            if ((block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2 - (double)this.field_70126_B)), MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.field_70170_p.func_72956_a((Entity)this, soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    private int func_110225_cC() {
        boolean i = false;
        return this.isChested() && !i ? 17 : 17;
    }

    private void func_110226_cD() {
        InventoryBasic animalchest = this.quaggaChest;
        this.quaggaChest = new AnimalChest("QuaggaChest", this.func_110225_cC());
        this.quaggaChest.func_110133_a(this.getEntityName());
        if (animalchest != null) {
            animalchest.func_110132_b((IInvBasic)this);
            int i = Math.min(animalchest.func_70302_i_(), this.quaggaChest.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.func_70301_a(j);
                if (itemstack == null) continue;
                this.quaggaChest.func_70299_a(j, itemstack.func_77946_l());
            }
            animalchest = null;
        }
        this.quaggaChest.func_110134_a((IInvBasic)this);
        this.func_110232_cE();
    }

    private void func_110232_cE() {
        if (!this.field_70170_p.field_72995_K) {
            this.setHorseSaddled(this.quaggaChest.func_70301_a(0) != null);
            this.setHorseArmor(this.getHorseArmorIndex(this.quaggaChest.func_70301_a(1)));
        }
    }

    public void func_76316_a(InventoryBasic par1InventoryBasic) {
        int i = this.horseArmor();
        boolean flag = this.isHorseSaddled();
        this.func_110232_cE();
        if (this.field_70173_aa > 20) {
            if (i == 0 && i != this.horseArmor()) {
                this.func_85030_a("mob.horse.armor", 0.5f, 1.0f);
            }
            if (!flag && this.isHorseSaddled()) {
                this.func_85030_a("mob.horse.leather", 0.5f, 1.0f);
            }
        }
    }

    public boolean func_70601_bi() {
        this.prepareChunkForSpawn();
        return super.func_70601_bi();
    }

    public double getHorseJumpStrength() {
        return this.func_110148_a(horseJumpStrength).func_111126_e();
    }

    protected String func_70673_aS() {
        this.openHorseMouth();
        return "mob.horse.death";
    }

    protected Item func_146068_u() {
        return Items.field_151116_aA;
    }

    protected String func_70621_aR() {
        this.openHorseMouth();
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.makeHorseRear();
        }
        return "mob.horse.hit";
    }

    public boolean isHorseSaddled() {
        return this.getHorseWatchableBoolean(4);
    }

    protected String func_70639_aQ() {
        this.openHorseMouth();
        if (this.field_70146_Z.nextInt(10) == 0 && !this.func_70610_aX()) {
            this.makeHorseRear();
        }
        return "mob.horse.idle";
    }

    protected String getAngrySoundName() {
        this.openHorseMouth();
        this.makeHorseRear();
        return "mob.horse.angry";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        Block.SoundType soundtype = block.field_149762_H;
        if (this.field_70170_p.func_147439_a(x, y + 1, z) == Blocks.field_150431_aC) {
            soundtype = Blocks.field_150431_aC.field_149762_H;
        }
        if (!block.func_149688_o().func_76224_d()) {
            if (this.field_70153_n != null) {
                ++this.field_110285_bP;
                if (this.field_110285_bP > 5 && this.field_110285_bP % 3 == 0) {
                    this.func_85030_a("mob.horse.gallop", soundtype.func_150497_c() * 0.15f, soundtype.func_150494_d());
                    if (this.field_70146_Z.nextInt(10) == 0) {
                        this.func_85030_a("mob.horse.breathe", soundtype.func_150497_c() * 0.6f, soundtype.func_150494_d());
                    }
                } else if (this.field_110285_bP <= 5) {
                    this.func_85030_a("mob.horse.wood", soundtype.func_150497_c() * 0.15f, soundtype.func_150494_d());
                }
            } else if (soundtype == Block.field_149766_f) {
                this.func_85030_a("mob.horse.wood", soundtype.func_150497_c() * 0.15f, soundtype.func_150494_d());
            } else {
                this.func_85030_a("mob.horse.soft", soundtype.func_150497_c() * 0.15f, soundtype.func_150494_d());
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(horseJumpStrength);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(53.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.225f);
    }

    public int func_70641_bl() {
        return 6;
    }

    public int getMaxTemper() {
        return 200;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public int func_70627_aG() {
        return 400;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_110239_cn() {
        return this.horseArmor() > 0;
    }

    private void func_110230_cF() {
        this.horseTexture = null;
    }

    public void openGUI(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && (this.field_70153_n == null || this.field_70153_n == player) && this.isTame()) {
            this.quaggaChest.func_110133_a(this.func_70005_c_());
            if (!this.field_70170_p.field_72995_K) {
                player.openGui((Object)Fossil.instance, 8, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151063_bx) {
            return super.func_70085_c(player);
        }
        if (itemstack != null && FMLCommonHandler.instance().getSide().isClient() && itemstack.func_77973_b() == Fossil.dinoPedia) {
            this.setPedia();
            player.openGui((Object)Fossil.instance, 4, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            return true;
        }
        if (this.isTame() && this.isAdultHorse() && player.func_70093_af()) {
            this.openGUI(player);
            return true;
        }
        if (this.canBeTamed() && this.field_70153_n != null) {
            return super.func_70085_c(player);
        }
        if (itemstack != null) {
            boolean flag = false;
            int b0 = -1;
            if (itemstack.func_77973_b() == Items.field_151138_bX) {
                b0 = 1;
            } else if (itemstack.func_77973_b() == Items.field_151136_bY) {
                b0 = 2;
            } else if (itemstack.func_77973_b() == Items.field_151125_bZ) {
                b0 = 3;
            }
            if (b0 >= 0) {
                if (!this.isTame()) {
                    this.makeHorseRearWithSound();
                    return true;
                }
                this.openGUI(player);
                return true;
            }
            if (!flag) {
                float f = 0.0f;
                int short1 = 0;
                int b1 = 0;
                if (itemstack.func_77973_b() == Items.field_151015_O) {
                    f = 2.0f;
                    short1 = 60;
                    b1 = 3;
                } else if (itemstack.func_77973_b() == Items.field_151102_aT) {
                    f = 1.0f;
                    short1 = 30;
                    b1 = 3;
                } else if (itemstack.func_77973_b() == Items.field_151025_P) {
                    f = 7.0f;
                    short1 = 180;
                    b1 = 3;
                } else if (Block.func_149634_a((Item)itemstack.func_77973_b()) == Blocks.field_150407_cf) {
                    f = 20.0f;
                    short1 = 180;
                } else if (itemstack.func_77973_b() == Items.field_151034_e) {
                    f = 3.0f;
                    short1 = 60;
                    b1 = 3;
                } else if (itemstack.func_77973_b() == Items.field_151150_bK) {
                    f = 4.0f;
                    short1 = 60;
                    b1 = 5;
                    if (this.isTame() && this.func_70874_b() == 0) {
                        flag = true;
                        this.func_146082_f(player);
                    }
                } else if (itemstack.func_77973_b() == Items.field_151153_ao) {
                    f = 10.0f;
                    short1 = 240;
                    b1 = 10;
                    if (this.isTame() && this.func_70874_b() == 0) {
                        flag = true;
                        this.func_146082_f(player);
                    }
                }
                if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
                    this.func_70691_i(f);
                    flag = true;
                }
                if (!this.isAdultHorse() && short1 > 0) {
                    this.func_110195_a(short1);
                    flag = true;
                }
                if (b1 > 0 && (flag || !this.isTame()) && b1 < this.getMaxTemper()) {
                    flag = true;
                    this.increaseTemper(b1);
                }
                if (flag) {
                    this.eatFood();
                }
            }
            if (!this.isTame() && !flag) {
                if (itemstack != null && itemstack.func_111282_a(player, (EntityLivingBase)this)) {
                    return true;
                }
                this.makeHorseRearWithSound();
                return true;
            }
            if (!flag && !this.isChested() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
                this.setChested(true);
                this.func_85030_a("mob.chickenplop", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                flag = true;
                this.func_110226_cD();
            }
            if (!flag && this.canBeTamed() && !this.isHorseSaddled() && itemstack.func_77973_b() == Items.field_151141_av) {
                this.openGUI(player);
                return true;
            }
            if (flag) {
                if (!player.field_71075_bZ.field_75098_d && --itemstack.field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
                return true;
            }
        }
        if (this.canBeTamed() && this.field_70153_n == null) {
            if (itemstack != null && itemstack.func_111282_a(player, (EntityLivingBase)this)) {
                return true;
            }
            this.mountQuagga(player);
            return true;
        }
        return super.func_70085_c(player);
    }

    private void mountQuagga(EntityPlayer player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        this.setEatingHaystack(false);
        this.setRearing(false);
        if (!this.field_70170_p.field_72995_K) {
            player.func_70078_a((Entity)this);
        }
    }

    protected boolean func_70610_aX() {
        return this.field_70153_n != null && this.isHorseSaddled() ? true : this.isEatingHaystack() || this.isRearing();
    }

    public boolean func_70877_b(ItemStack par1ItemStack) {
        return false;
    }

    private void func_110210_cH() {
        this.timer1 = 1;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (!this.field_70170_p.field_72995_K) {
            this.dropChestItems();
        }
    }

    public void func_70636_d() {
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.func_110210_cH();
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
            if (!this.isEatingHaystack() && this.field_70153_n == null && this.field_70146_Z.nextInt(300) == 0 && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u) - 1, MathHelper.func_76128_c((double)this.field_70161_v)) == Blocks.field_150349_c) {
                this.setEatingHaystack(true);
            }
            if (this.isEatingHaystack() && ++this.eatingHaystackCounter > 50) {
                this.eatingHaystackCounter = 0;
                this.setEatingHaystack(false);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_75684_a()) {
            this.field_70180_af.func_111144_e();
            this.func_110230_cF();
        }
        if (this.openMouthCounter > 0 && ++this.openMouthCounter > 30) {
            this.openMouthCounter = 0;
            this.setHorseWatchableBoolean(128, false);
        }
        if (!this.field_70170_p.field_72995_K && this.jumpRearingCounter > 0 && ++this.jumpRearingCounter > 20) {
            this.jumpRearingCounter = 0;
            this.setRearing(false);
        }
        if (this.timer1 > 0 && ++this.timer1 > 8) {
            this.timer1 = 0;
        }
        if (this.field_110279_bq > 0) {
            ++this.field_110279_bq;
            if (this.field_110279_bq > 300) {
                this.field_110279_bq = 0;
            }
        }
        this.prevHeadLean = this.headLean;
        if (this.isEatingHaystack()) {
            this.headLean += (1.0f - this.headLean) * 0.4f + 0.05f;
            if (this.headLean > 1.0f) {
                this.headLean = 1.0f;
            }
        } else {
            this.headLean += (0.0f - this.headLean) * 0.4f - 0.05f;
            if (this.headLean < 0.0f) {
                this.headLean = 0.0f;
            }
        }
        this.prevRearingAmount = this.rearingAmount;
        if (this.isRearing()) {
            this.headLean = 0.0f;
            this.prevHeadLean = 0.0f;
            this.rearingAmount += (1.0f - this.rearingAmount) * 0.4f + 0.05f;
            if (this.rearingAmount > 1.0f) {
                this.rearingAmount = 1.0f;
            }
        } else {
            this.field_110294_bI = false;
            this.rearingAmount += (0.8f * this.rearingAmount * this.rearingAmount * this.rearingAmount - this.rearingAmount) * 0.6f - 0.05f;
            if (this.rearingAmount < 0.0f) {
                this.rearingAmount = 0.0f;
            }
        }
        this.prevMouthOpenness = this.mouthOpenness;
        if (this.getHorseWatchableBoolean(128)) {
            this.mouthOpenness += (1.0f - this.mouthOpenness) * 0.7f + 0.05f;
            if (this.mouthOpenness > 1.0f) {
                this.mouthOpenness = 1.0f;
            }
        } else {
            this.mouthOpenness += (0.0f - this.mouthOpenness) * 0.7f - 0.05f;
            if (this.mouthOpenness < 0.0f) {
                this.mouthOpenness = 0.0f;
            }
        }
    }

    private void openHorseMouth() {
        if (!this.field_70170_p.field_72995_K) {
            this.openMouthCounter = 1;
            this.setHorseWatchableBoolean(128, true);
        }
    }

    public void func_70019_c(boolean par1) {
        this.setHorseWatchableBoolean(32, par1);
    }

    public void setEatingHaystack(boolean par1) {
        this.func_70019_c(par1);
    }

    public void setRearing(boolean par1) {
        if (par1) {
            this.setEatingHaystack(false);
        }
        this.setHorseWatchableBoolean(64, par1);
    }

    private void makeHorseRear() {
        if (!this.field_70170_p.field_72995_K) {
            this.jumpRearingCounter = 1;
            this.setRearing(true);
        }
    }

    public void makeHorseRearWithSound() {
        this.makeHorseRear();
        String s = this.getAngrySoundName();
        if (s != null) {
            this.func_85030_a(s, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void dropChestItems() {
        this.dropItemsInChest((Entity)this, this.quaggaChest);
        this.dropChests();
    }

    private void dropItemsInChest(Entity entity, InventoryBasic animalChest) {
        if (animalChest != null && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < animalChest.func_70302_i_(); ++i) {
                ItemStack itemstack = animalChest.func_70301_a(i);
                if (itemstack == null) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    public boolean setTamedBy(EntityPlayer player) {
        this.setOwnerName(player.func_70005_c_());
        this.setHorseTamed(true);
        return true;
    }

    public void func_70612_e(float par1, float par2) {
        if (this.field_70153_n != null && this.isHorseSaddled()) {
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            par1 = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f;
            par2 = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (par2 <= 0.0f) {
                par2 *= 0.25f;
                this.field_110285_bP = 0;
            }
            if (this.field_70122_E && this.jumpPower == 0.0f && this.isRearing() && !this.field_110294_bI) {
                par1 = 0.0f;
                par2 = 0.0f;
            }
            if (this.jumpPower > 0.0f && !this.isHorseJumping() && this.field_70122_E) {
                this.field_70181_x = this.getHorseJumpStrength() * (double)this.jumpPower;
                if (this.func_70644_a(Potion.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.setHorseJumping(true);
                this.field_70160_al = true;
                if (par2 > 0.0f) {
                    float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                    float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                    this.field_70159_w += (double)(-0.4f * f2 * this.jumpPower);
                    this.field_70179_y += (double)(0.4f * f3 * this.jumpPower);
                    this.func_85030_a("mob.horse.jump", 0.4f, 1.0f);
                }
                this.jumpPower = 0.0f;
            }
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(par1, par2);
            }
            if (this.field_70122_E) {
                this.jumpPower = 0.0f;
                this.setHorseJumping(false);
            }
            this.field_70722_aY = this.field_70721_aZ;
            double d0 = this.field_70165_t - this.field_70169_q;
            double d1 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(par1, par2);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("EatingHaystack", this.isEatingHaystack());
        compound.func_74757_a("ChestedHorse", this.isChested());
        compound.func_74757_a("HasReproduced", this.getHasReproduced());
        compound.func_74757_a("Bred", this.getBred());
        compound.func_74768_a("Temper", this.getTemper());
        compound.func_74757_a("Tame", this.isTame());
        compound.func_74778_a("OwnerName", this.getOwnerName());
        if (this.isChested()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 2; i < this.quaggaChest.func_70302_i_(); ++i) {
                ItemStack itemstack = this.quaggaChest.func_70301_a(i);
                if (itemstack == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        if (this.quaggaChest.func_70301_a(1) != null) {
            compound.func_74782_a("ArmorItem", (NBTBase)this.quaggaChest.func_70301_a(1).func_77955_b(new NBTTagCompound()));
        }
        if (this.quaggaChest.func_70301_a(0) != null) {
            compound.func_74782_a("SaddleItem", (NBTBase)this.quaggaChest.func_70301_a(0).func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        ItemStack itemstack;
        IAttributeInstance attributeinstance;
        super.func_70037_a(par1NBTTagCompound);
        this.setEatingHaystack(par1NBTTagCompound.func_74767_n("EatingHaystack"));
        this.setBred(par1NBTTagCompound.func_74767_n("Bred"));
        this.setChested(par1NBTTagCompound.func_74767_n("ChestedHorse"));
        this.setHasReproduced(par1NBTTagCompound.func_74767_n("HasReproduced"));
        this.setTemper(par1NBTTagCompound.func_74762_e("Temper"));
        this.setHorseTamed(par1NBTTagCompound.func_74767_n("Tame"));
        if (par1NBTTagCompound.func_74764_b("OwnerName")) {
            this.setOwnerName(par1NBTTagCompound.func_74779_i("OwnerName"));
        }
        if ((attributeinstance = this.func_110140_aT().func_111152_a("Speed")) != null) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(attributeinstance.func_111125_b() * 0.25);
        }
        if (this.isChested()) {
            NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
            this.func_110226_cD();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
                if (j < 2 || j >= this.quaggaChest.func_70302_i_()) continue;
                this.quaggaChest.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
            }
        }
        if (par1NBTTagCompound.func_74764_b("ArmorItem") && (itemstack = ItemStack.func_77949_a((NBTTagCompound)par1NBTTagCompound.func_74775_l("ArmorItem"))) != null && EntityQuagga.func_110211_v(itemstack.func_77973_b())) {
            this.quaggaChest.func_70299_a(1, itemstack);
        }
        if (par1NBTTagCompound.func_74764_b("SaddleItem")) {
            itemstack = ItemStack.func_77949_a((NBTTagCompound)par1NBTTagCompound.func_74775_l("SaddleItem"));
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151141_av) {
                this.quaggaChest.func_70299_a(0, itemstack);
            }
        } else if (par1NBTTagCompound.func_74767_n("Saddle")) {
            this.quaggaChest.func_70299_a(0, new ItemStack(Items.field_151141_av));
        }
        this.func_110232_cE();
    }

    public boolean func_70878_b(EntityAnimal par1EntityAnimal) {
        return par1EntityAnimal != this && par1EntityAnimal.getClass() == ((Object)((Object)this)).getClass();
    }

    public EntityAgeable func_90011_a(EntityAgeable par1EntityAgeable) {
        EntityQuagga entityQuagga = (EntityQuagga)par1EntityAgeable;
        EntityQuagga babyQuagga = new EntityQuagga(this.field_70170_p);
        double d0 = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + par1EntityAgeable.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + (double)this.randomHealthStat();
        babyQuagga.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(d0 / 3.0);
        double d1 = this.func_110148_a(horseJumpStrength).func_111125_b() + par1EntityAgeable.func_110148_a(horseJumpStrength).func_111125_b() + this.randomJumpStat();
        babyQuagga.func_110148_a(horseJumpStrength).func_111128_a(d1 / 3.0);
        double d2 = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + par1EntityAgeable.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.randomSpeedStat();
        babyQuagga.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(d2 / 3.0);
        return babyQuagga;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData par1EntityLivingData) {
        IEntityLivingData par1EntityLivingData1 = super.func_110161_a(par1EntityLivingData);
        boolean flag = false;
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70873_a(-24000);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.randomHealthStat());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.randomSpeedStat());
        this.func_110148_a(horseJumpStrength).func_111128_a(this.randomJumpStat());
        this.func_70606_j(this.func_110138_aP());
        return par1EntityLivingData1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getGrassEatingAmount(float par1) {
        return this.prevHeadLean + (this.headLean - this.prevHeadLean) * par1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getRearingAmount(float par1) {
        return this.prevRearingAmount + (this.rearingAmount - this.prevRearingAmount) * par1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getMouthOpenness(float par1) {
        return this.prevMouthOpenness + (this.mouthOpenness - this.prevMouthOpenness) * par1;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public void setJumpPower(int par1) {
        if (this.isHorseSaddled()) {
            if (par1 < 0) {
                par1 = 0;
            } else {
                this.field_110294_bI = true;
                this.makeHorseRear();
            }
            this.jumpPower = par1 >= 90 ? 1.0f : 0.4f + 0.4f * (float)par1 / 90.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnHorseParticles(boolean par1) {
        String s = par1 ? "heart" : "smoke";
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(s, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 7) {
            this.spawnHorseParticles(true);
        } else if (par1 == 6) {
            this.spawnHorseParticles(false);
        } else {
            super.func_70103_a(par1);
        }
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.prevRearingAmount > 0.0f) {
            float f = MathHelper.func_76126_a((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
            float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
            float f2 = 0.7f * this.prevRearingAmount;
            float f3 = 0.15f * this.prevRearingAmount;
            this.field_70153_n.func_70107_b(this.field_70165_t + (double)(f2 * f), this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W() + (double)f3, this.field_70161_v - (double)(f2 * f1));
            if (this.field_70153_n instanceof EntityLivingBase) {
                ((EntityLivingBase)this.field_70153_n).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    public float randomHealthStat() {
        return 15.0f + (float)this.field_70146_Z.nextInt(8) + (float)this.field_70146_Z.nextInt(9);
    }

    public double randomJumpStat() {
        return (double)0.4f + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2;
    }

    public double randomSpeedStat() {
        return ((double)0.45f + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3) * 0.25;
    }

    public static boolean func_110211_v(Item item) {
        return item == Items.field_151138_bX || item == Items.field_151136_bY || item == Items.field_151125_bZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected void func_70628_a(boolean hasBeenHit, int looting) {
        int j = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + looting);
        for (int k = 0; k < j; ++k) {
            if (this.func_70027_ad()) {
                this.func_145779_a(Fossil.quaggaMeatCooked, 1);
                continue;
            }
            this.func_145779_a(Fossil.quaggaMeat, 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void ShowPedia(GuiPedia p0) {
        p0.reset();
        p0.PrintPictXY(new ResourceLocation("fossil:textures/items/Quagga_DNA.png"), p0.xGui / 2 + p0.xGui / 4, 7, 16, 16);
        if (this.func_94056_bM()) {
            p0.PrintStringXY(this.func_94057_bL(), 150, 24, 40, 90, 245);
        }
        p0.PrintStringXY(StatCollector.func_74838_a((String)"entity.fossil.Quagga.name"), 150, 34, 0, 0, 0);
        p0.PrintPictXY(pediaheart, 150, 58, 9, 9);
        p0.PrintStringXY(String.valueOf(this.func_110143_aJ()) + '/' + this.func_110138_aP(), 150 + 12, 58);
        if (this.isTame()) {
            p0.AddStringLR(StatCollector.func_74838_a((String)"pedia.text.owner"), true);
            String s0 = this.getOwnerName();
            if (s0.length() > 11) {
                s0 = this.getOwnerName().substring(0, 11);
            }
            p0.AddStringLR(s0, true);
        }
        if (this.isAdultHorse()) {
            p0.AddStringLR(StatCollector.func_74838_a((String)"pedia.text.rideable"), true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void ShowPedia2(GuiPedia p0) {
        this.entityPrehistoricClass.ShowPedia2(p0, "Quagga");
    }
}

