/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.entity.mob;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import mods.fossil.entity.mob.EntityDinosaur;
import mods.fossil.fossilAI.DinoAIAttackOnCollide;
import mods.fossil.fossilAI.DinoAIEat;
import mods.fossil.fossilAI.DinoAIFollowOwner;
import mods.fossil.fossilAI.DinoAIWander;
import mods.fossil.fossilEnums.EnumDinoType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityStegosaurus
extends EntityDinosaur {
    private boolean looksWithInterest = false;
    public int RushTick = 0;
    public boolean Running = false;
    public static final double baseHealth = EnumDinoType.Stegosaurus.Health0;
    public static final double baseDamage = EnumDinoType.Stegosaurus.Strength0;
    public static final double baseSpeed = EnumDinoType.Stegosaurus.Speed0;
    public static final double maxHealth = EnumDinoType.Stegosaurus.HealthMax;
    public static final double maxDamage = EnumDinoType.Stegosaurus.StrengthMax;
    public static final double maxSpeed = EnumDinoType.Stegosaurus.SpeedMax;
    private final String texturePath;

    public EntityStegosaurus(World var1) {
        super(var1, EnumDinoType.Stegosaurus);
        this.updateSize();
        this.setSubSpecies(new Random().nextInt(3) + 1);
        this.adultAge = EnumDinoType.Stegosaurus.AdultAge;
        this.func_70105_a(1.0f, 0.8f);
        this.minSize = 1.0f;
        this.maxSize = 5.5f;
        this.texturePath = "fossil:textures/mob/" + this.SelfType.toString() + "/";
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIAttackOnCollide(this, 1.1, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 5.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIEat(this, 48));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(baseHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(baseDamage);
    }

    @Override
    public void func_70636_d() {
        this.breakBlock(5.0f);
        super.func_70636_d();
    }

    @Override
    public String getTexture() {
        if (this.isModelized()) {
            return super.getModelTexture();
        }
        if (this.isAdult()) {
            switch (this.getSubSpecies()) {
                default: {
                    return this.texturePath + "Stegosaurus_Green_Adult.png";
                }
                case 1: {
                    return this.texturePath + "Stegosaurus_Brown_Adult.png";
                }
                case 2: 
            }
            return this.texturePath + "Stegosaurus_Yellow_Adult.png";
        }
        if (this.isTeen()) {
            switch (this.getSubSpecies()) {
                default: {
                    return this.texturePath + "Stegosaurus_Green_Teen.png";
                }
                case 1: {
                    return this.texturePath + "Stegosaurus_Brown_Teen.png";
                }
                case 2: 
            }
            return this.texturePath + "Stegosaurus_Yellow_Teen.png";
        }
        switch (this.getSubSpecies()) {
            default: {
                return this.texturePath + "Stegosaurus_Green_Baby.png";
            }
            case 1: {
                return this.texturePath + "Stegosaurus_Brown_Baby.png";
            }
            case 2: 
        }
        return this.texturePath + "Stegosaurus_Yellow_Baby.png";
    }

    @Override
    protected void func_70626_be() {
        if (this.field_70153_n == null) {
            super.func_70626_be();
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.looksWithInterest) {
            this.field_70700_bx = 10;
        }
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    @Override
    protected boolean func_70780_i() {
        return this.func_70906_o();
    }

    public boolean attackEntityFrom(DamageSource var1, int var2) {
        Entity var3 = var1.func_76346_g();
        this.func_70904_g(false);
        if (!super.func_70097_a(var1, var2)) {
            return false;
        }
        if (!this.func_70909_n() && !this.isSelfAngry()) {
            if (var3 instanceof EntityPlayer) {
                this.setSelfAngry(true);
                this.field_70789_a = var3;
            }
            if (var3 instanceof EntityArrow && ((EntityArrow)var3).field_70250_c != null) {
                var3 = ((EntityArrow)var3).field_70250_c;
            }
            if (var3 instanceof EntityLiving) {
                // empty if block
            }
        } else if (var3 != this && var3 != null) {
            if (this.func_70909_n() && var3 instanceof EntityPlayer && var3 == this.func_70902_q()) {
                return true;
            }
            this.field_70789_a = var3;
        }
        return true;
    }

    protected Entity func_70782_k() {
        return this.isSelfAngry() ? this.field_70170_p.func_72856_b((Entity)this, 16.0) : null;
    }

    @Override
    public boolean func_70085_c(EntityPlayer var1) {
        return super.func_70085_c(var1);
    }

    @Override
    public void func_70103_a(byte var1) {
        if (var1 == 7) {
            this.showHeartsOrSmokeFX(true, true);
        } else if (var1 == 6) {
            this.showHeartsOrSmokeFX(false, false);
        } else if (var1 != 8) {
            super.func_70103_a(var1);
        }
    }

    public boolean isSelfAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public void setSelfAngry(boolean var1) {
        byte var2 = this.field_70180_af.func_75683_a(16);
        if (var1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 | 2)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 & 0xFFFFFFFD)));
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    @Override
    public boolean CheckSpace() {
        return !this.func_70094_T();
    }

    @Override
    public void FaceToCoord(int var1, int var2, int var3) {
        double var4 = var1;
        double var6 = var3;
        float var8 = (float)(Math.atan2(var6, var4) * 180.0 / Math.PI) - 90.0f;
        this.field_70177_z = this.updateRotation(this.field_70177_z, var8, 360.0f);
    }

    private float updateRotation(float var1, float var2, float var3) {
        float var4;
        for (var4 = var2 - var1; var4 < -180.0f; var4 += 360.0f) {
        }
        while (var4 >= 180.0f) {
            var4 -= 360.0f;
        }
        if (var4 > var3) {
            var4 = var3;
        }
        if (var4 < -var3) {
            var4 = -var3;
        }
        return var1 + var4;
    }

    public void func_70108_f(Entity var1) {
        if (var1 instanceof EntityLiving && !(var1 instanceof EntityPlayer) && this.field_70153_n != null && this.field_70122_E) {
            this.func_70074_a((EntityLivingBase)((EntityLiving)var1));
            ((EntityLiving)var1).func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
        } else {
            super.func_70108_f(var1);
        }
    }

    public EntityStegosaurus spawnBabyAnimal(EntityAgeable var1) {
        return new EntityStegosaurus(this.field_70170_p);
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable var1) {
        EntityStegosaurus baby = new EntityStegosaurus(this.field_70170_p);
        baby.setSubSpecies(this.getSubSpecies());
        return baby;
    }

    @Override
    public void updateSize() {
        double healthStep = (maxHealth - baseHealth) / (double)(this.adultAge + 1);
        double attackStep = (maxDamage - baseDamage) / (double)(this.adultAge + 1);
        double speedStep = (maxSpeed - baseSpeed) / (double)(this.adultAge + 1);
        if (this.getDinoAge() <= this.adultAge) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.round(baseHealth + healthStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Math.round(baseDamage + attackStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed + speedStep * (double)this.getDinoAge());
            if (this.isTeen()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
            } else if (this.isAdult()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(2.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
    }

    public void readSpawnData(ByteBuf additionalData) {
    }
}

