/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.entity.mob;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import mods.fossil.Fossil;
import mods.fossil.client.FossilOptions;
import mods.fossil.client.gui.GuiPedia;
import mods.fossil.entity.mob.EntityDinosaur;
import mods.fossil.fossilAI.DinoAIAttackOnCollide;
import mods.fossil.fossilAI.DinoAIEat;
import mods.fossil.fossilAI.DinoAIFollowOwner;
import mods.fossil.fossilAI.DinoAIHunt;
import mods.fossil.fossilAI.DinoAIRideGround;
import mods.fossil.fossilAI.DinoAITargetNonTamedExceptSelfClass;
import mods.fossil.fossilAI.DinoAIWander;
import mods.fossil.fossilEnums.EnumDinoType;
import mods.fossil.handler.FossilAchievementHandler;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIControlledByPlayer;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityTRex
extends EntityDinosaur {
    private static float health = 10.0f;
    public final int Areas = 15;
    private boolean looksWithInterest = false;
    public boolean Screaming;
    public int SkillTick = 0;
    public int WeakToDeath = 0;
    public int TooNearMessageTick = 0;
    public boolean SneakScream = false;
    final EntityAIControlledByPlayer aiControlledByPlayer;
    private int Timer;
    private final String texturePath;
    public static final double baseHealth = EnumDinoType.TRex.Health0;
    public static final double baseDamage = EnumDinoType.TRex.Strength0;
    public static final double baseSpeed = EnumDinoType.TRex.Speed0;
    public static final double maxHealth = EnumDinoType.TRex.HealthMax;
    public static final double maxDamage = EnumDinoType.TRex.StrengthMax;
    public static final double maxSpeed = EnumDinoType.TRex.SpeedMax;

    public EntityTRex(World var1) {
        super(var1, EnumDinoType.TRex);
        this.updateSize();
        this.adultAge = EnumDinoType.TRex.AdultAge;
        this.func_70105_a(1.5f, 1.25f);
        this.minSize = 1.0f;
        this.maxSize = 4.5f;
        this.texturePath = !FossilOptions.TRexFeathers ? "fossil:textures/mob/" + this.SelfType.toString() + "/feathered/" + "Feathered_" : "fossil:textures/mob/" + this.SelfType.toString() + "/";
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIAttackOnCollide(this, 1.3, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIEat(this, 60));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new DinoAITargetNonTamedExceptSelfClass(this, EntityLiving.class, 750, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoAIRideGround(this, 1.0));
        this.aiControlledByPlayer = new EntityAIControlledByPlayer((EntityLiving)this, 0.3f);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiControlledByPlayer);
        this.field_70138_W = 1.0f;
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new DinoAIHunt(this, EntityLiving.class, 200, false));
    }

    @Override
    public boolean func_70650_aV() {
        return !this.isModelized() && !this.isWeak();
    }

    @Override
    public EntityAIControlledByPlayer getAIControlledByPlayer() {
        return this.aiControlledByPlayer;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(baseHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(baseDamage);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    public void func_70612_e(float par1, float par2) {
        super.func_70612_e(par1, par2);
        if (this.isWeak()) {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
            this.field_70177_z = 0.0f;
            this.field_70125_A = 0.0f;
        }
    }

    public float func_70047_e() {
        return 2.0f + (float)this.getDinoAge() / 1.8f;
    }

    public float getRideHeight() {
        return this.func_70047_e() + 0.2f;
    }

    public int func_70646_bf() {
        return 50;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTimer() {
        return this.Timer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 4) {
            this.Timer = 20;
        }
    }

    @Override
    protected String func_70639_aQ() {
        if (this.isModelized()) {
            return null;
        }
        if (this.isWeak()) {
            return "fossil:" + this.SelfType.toString().toLowerCase() + "_weak";
        }
        return "fossil:" + this.SelfType.toString().toLowerCase() + "_living";
    }

    @Override
    protected boolean func_70780_i() {
        return this.func_70906_o() || this.isWeak();
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float var2) {
        if (this.isModelized()) {
            return super.func_70097_a(damageSource, var2);
        }
        if (this.func_85032_ar()) {
            return false;
        }
        Entity entity = damageSource.func_76346_g();
        if (damageSource.field_76373_n.equals("arrow") && this.getDinoAge() >= 3) {
            return false;
        }
        if (var2 < 6.0f && entity != null && this.getDinoAge() >= 3) {
            return false;
        }
        return super.func_70097_a(damageSource, var2);
    }

    @Override
    public boolean isAngry() {
        return true;
    }

    protected Entity func_70782_k() {
        return this.isAngry() && !this.func_70909_n() && !this.isWeak() ? this.field_70170_p.func_72856_b((Entity)this, 16.0) : null;
    }

    @Override
    public boolean func_70652_k(Entity victim) {
        Random random = new Random();
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (victim instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)victim));
            knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)victim));
        }
        boolean attacked = victim.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage);
        if (random.nextInt(10) == 1) {
            this.openMouth(true);
        }
        if (attacked) {
            if (knockback > 0) {
                double vx = -Math.sin(Math.toRadians(this.field_70177_z)) * (double)knockback * 0.5;
                double vy = 0.1;
                double vz = Math.cos(Math.toRadians(this.field_70177_z)) * (double)knockback * 0.5;
                victim.func_70024_g(vx, vy, vz);
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            this.func_130011_c(victim);
        }
        return attacked;
    }

    public void openMouth(boolean shouldScream) {
        this.Timer = 20;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        if (shouldScream) {
            this.field_70170_p.func_72956_a((Entity)this, "fossil:trex_scream", this.func_70599_aP(), this.func_70647_i());
        }
    }

    protected void func_70785_a(Entity entity, float var2) {
        super.func_70785_a(entity, var2);
    }

    @Override
    public void func_70074_a(EntityLivingBase var1) {
        this.openMouth(true);
        super.func_70074_a(var1);
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        if (itemStack != null) {
            if (itemStack.func_77973_b() == Fossil.gem) {
                if (this.isWeak() && !this.func_70909_n()) {
                    player.func_71029_a((StatBase)FossilAchievementHandler.theKing);
                    this.func_70691_i(200.0f);
                    this.increaseHunger(500);
                    this.func_70903_f(true);
                    this.func_70778_a(null);
                    this.func_70624_b(null);
                    this.setOwner(player.func_110124_au().toString());
                    this.setOwnerDisplayName(player.func_70005_c_());
                    --itemStack.field_77994_a;
                    if (itemStack.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                    return true;
                }
                if (!this.isWeak() && !this.field_70170_p.field_72995_K) {
                    Fossil.ShowMessage(StatCollector.func_74838_a((String)"status.GemErrorHealth"), player);
                }
                if (!this.isAdult() && !this.field_70170_p.field_72995_K) {
                    Fossil.ShowMessage(StatCollector.func_74838_a((String)"status.GemErrorYoung"), player);
                }
                return false;
            }
            if (this.SelfType.FoodItemList.CheckItem(itemStack.func_77973_b()) || this.SelfType.FoodBlockList.CheckBlock(Block.func_149634_a((Item)itemStack.func_77973_b()))) {
                return false;
            }
            if (!Fossil.DebugMode() && itemStack.func_77973_b() == Fossil.chickenEss && !this.field_70170_p.field_72995_K) {
                Fossil.ShowMessage(StatCollector.func_74838_a((String)"status.essencefail"), player);
                return true;
            }
        }
        return super.func_70085_c(player);
    }

    @Override
    public boolean CheckSpace() {
        return !this.func_70094_T();
    }

    public float getMountHeight() {
        return this.field_70131_O;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.getMountHeight() + this.field_70153_n.func_70033_W(), this.field_70161_v);
        }
    }

    @Override
    public void func_70636_d() {
        this.breakBlock(5.0f);
        if (this.Timer > 0) {
            --this.Timer;
        }
        super.func_70636_d();
    }

    @Override
    public String getTexture() {
        if (this.isModelized()) {
            return super.getTexture();
        }
        if (this.isWeak()) {
            switch (this.getSubSpecies()) {
                case 1: {
                    return this.texturePath + "TRex_Green_Weak.png";
                }
            }
            return this.texturePath + "TRex_Weak.png";
        }
        if (this.isAdult() && !this.func_70909_n()) {
            switch (this.getSubSpecies()) {
                case 1: {
                    return this.texturePath + "TRex_Green_Adult.png";
                }
            }
            return this.texturePath + "TRex_Adult.png";
        }
        if (this.isAdult() && this.func_70909_n()) {
            switch (this.getSubSpecies()) {
                case 1: {
                    return this.texturePath + "TRex_Green_Tame.png";
                }
            }
            return this.texturePath + "TRex_Tame.png";
        }
        if (this.func_70631_g_()) {
            switch (this.getSubSpecies()) {
                case 1: {
                    return this.texturePath + "TRex_Green_Baby.png";
                }
            }
            return this.texturePath + "TRex_Baby.png";
        }
        return this.texturePath + "TRex_Adult.png";
    }

    public boolean isWeak() {
        return this.func_110143_aJ() < 8.0f && this.getDinoAge() >= this.adultAge && !this.func_70909_n();
    }

    private void HandleWeak() {
        if (!this.field_70170_p.field_72995_K) {
            ++this.WeakToDeath;
            if (this.WeakToDeath >= 200) {
                this.func_70097_a(DamageSource.field_76377_j, 10.0f);
            } else {
                this.func_70784_b(null);
                this.func_70778_a(null);
                this.setAngry(false);
            }
        }
    }

    @Override
    public void ShowPedia(GuiPedia p0) {
        super.ShowPedia(p0);
        if (this.isWeak()) {
            p0.AddStringLR(StatCollector.func_74838_a((String)"pedia.text.weak"), true, 255, 40, 90);
        }
        if (!this.isWeak() && !this.func_70909_n() && this.isAdult()) {
            p0.AddStringLR(StatCollector.func_74838_a((String)"pedia.text.caution"), true, 255, 40, 90);
        }
    }

    public EntityTRex spawnBabyAnimal(EntityAgeable var1) {
        return new EntityTRex(this.field_70170_p);
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable var1) {
        EntityTRex baby = new EntityTRex(this.field_70170_p);
        baby.setSubSpecies(this.getSubSpecies());
        return baby;
    }

    @Override
    public void updateSize() {
        double healthStep = (maxHealth - baseHealth) / (double)(this.adultAge + 1);
        double attackStep = (maxDamage - baseDamage) / (double)(this.adultAge + 1);
        double speedStep = (maxSpeed - baseSpeed) / (double)(this.adultAge + 1);
        if (this.getDinoAge() <= this.adultAge) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.round(baseHealth + healthStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Math.round(baseDamage + attackStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed + speedStep * (double)this.getDinoAge());
            if (this.isTeen()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
            } else if (this.isAdult()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(2.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
    }

    public void readSpawnData(ByteBuf additionalData) {
    }
}

