/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.entity.mob;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import mods.fossil.Fossil;
import mods.fossil.client.FossilOptions;
import mods.fossil.entity.mob.EntityDinosaur;
import mods.fossil.fossilAI.DinoAIAttackOnCollide;
import mods.fossil.fossilAI.DinoAIEat;
import mods.fossil.fossilAI.DinoAIFollowOwner;
import mods.fossil.fossilAI.DinoAIRideGround;
import mods.fossil.fossilAI.DinoAIWander;
import mods.fossil.fossilEnums.EnumDinoType;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class EntityTriceratops
extends EntityDinosaur {
    private boolean looksWithInterest = false;
    public boolean Running = false;
    public static final double baseHealth = EnumDinoType.Triceratops.Health0;
    public static final double baseDamage = EnumDinoType.Triceratops.Strength0;
    public static final double baseSpeed = EnumDinoType.Triceratops.Speed0;
    public static final double maxHealth = EnumDinoType.Triceratops.HealthMax;
    public static final double maxDamage = EnumDinoType.Triceratops.StrengthMax;
    public static final double maxSpeed = EnumDinoType.Triceratops.SpeedMax;
    private final String texturePath;

    public EntityTriceratops(World var1) {
        super(var1, EnumDinoType.Triceratops);
        this.updateSize();
        this.setSubSpecies(new Random().nextInt(3) + 1);
        this.adultAge = EnumDinoType.Triceratops.AdultAge;
        this.func_70105_a(0.8f, 0.8f);
        this.minSize = 1.0f;
        this.maxSize = 8.0f;
        this.texturePath = FossilOptions.TriceratopsQuills ? "fossil:textures/mob/" + this.SelfType.toString() + "/quilled/" : "fossil:textures/mob/" + this.SelfType.toString() + "/";
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.2f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIAttackOnCollide(this, 1.1, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 5.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIEat(this, 48));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoAIRideGround(this, 1.1));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
    }

    @Override
    public void func_70636_d() {
        this.breakBlock(5.0f);
        super.func_70636_d();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(baseHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(baseDamage);
    }

    @Override
    public String getTexture() {
        if (this.isModelized()) {
            return super.getModelTexture();
        }
        if (this.isAdult()) {
            switch (this.getSubSpecies()) {
                default: {
                    return this.texturePath + "Triceratops_Green_Adult.png";
                }
                case 1: {
                    return this.texturePath + "Triceratops_Brown_Adult.png";
                }
                case 2: 
            }
            return this.texturePath + "Triceratops_Grey_Adult.png";
        }
        if (this.isTeen()) {
            switch (this.getSubSpecies()) {
                default: {
                    return this.texturePath + "Triceratops_Green_Teen.png";
                }
                case 1: {
                    return this.texturePath + "Triceratops_Brown_Teen.png";
                }
                case 2: 
            }
            return this.texturePath + "Triceratops_Grey_Teen.png";
        }
        switch (this.getSubSpecies()) {
            default: {
                return this.texturePath + "Triceratops_Green_Baby.png";
            }
            case 1: {
                return this.texturePath + "Triceratops_Brown_Baby.png";
            }
            case 2: 
        }
        return this.texturePath + "Triceratops_Grey_Baby.png";
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    @Override
    protected boolean func_70780_i() {
        return this.func_70906_o();
    }

    protected Entity func_70782_k() {
        return this.isSelfAngry() ? this.field_70170_p.func_72856_b((Entity)this, 16.0) : null;
    }

    @Override
    public boolean func_70085_c(EntityPlayer var1) {
        return super.func_70085_c(var1);
    }

    public boolean isSelfAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public void setSelfAngry(boolean var1) {
        byte var2 = this.field_70180_af.func_75683_a(16);
        if (var1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 | 2)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 & 0xFFFFFFFD)));
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public float func_70047_e() {
        return (float)this.getDinoAge() / 2.7f;
    }

    public float getMountHeight() {
        return this.field_70131_O * 0.75f;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.getMountHeight() + this.field_70153_n.func_70033_W(), this.field_70161_v);
        }
    }

    public EntityTriceratops spawnBabyAnimal(EntityAgeable var1) {
        return new EntityTriceratops(this.field_70170_p);
    }

    private boolean FindFren(int var1) {
        int var7;
        int var6;
        float var2 = var1 * 2;
        int var3 = 0;
        int var4 = 0;
        int var5 = 0;
        for (var6 = -var1; var6 <= var1; ++var6) {
            for (var7 = -2; var7 <= 2; ++var7) {
                for (int var8 = -var1; var8 <= var1; ++var8) {
                    if (this.field_70170_p.func_147439_a((int)Math.round(this.field_70165_t + (double)var6), (int)Math.round(this.field_70163_u + (double)var7), (int)Math.round(this.field_70161_v + (double)var8)) != Fossil.ferns || !(var2 > this.GetDistanceWithXYZ(this.field_70165_t + (double)var6, this.field_70163_u + (double)var7, this.field_70161_v + (double)var8))) continue;
                    var2 = this.GetDistanceWithXYZ(this.field_70165_t + (double)var6, this.field_70163_u + (double)var7, this.field_70161_v + (double)var8);
                    var3 = var6;
                    var4 = var7;
                    var5 = var8;
                }
            }
        }
        if (var2 == (float)(var1 * 2)) {
            return false;
        }
        if (Math.sqrt(var3 ^ 2 + var4 ^ 2 + var5 ^ 2) >= 2.0) {
            this.func_70778_a(this.field_70170_p.func_72844_a((Entity)this, (int)Math.round(this.field_70165_t + (double)var3), (int)Math.round(this.field_70163_u + (double)var4), (int)Math.round(this.field_70161_v + (double)var5), 10.0f, true, false, true, false));
            return true;
        }
        this.FaceToCoord((int)(-(this.field_70165_t + (double)var3)), (int)(this.field_70163_u + (double)var4), (int)(-(this.field_70161_v + (double)var5)));
        this.increaseHunger(10);
        for (var6 = -1; var6 <= 1; ++var6) {
            for (var7 = -1; var7 <= 1; ++var7) {
                if (this.field_70170_p.func_147439_a((int)Math.round(this.field_70165_t + (double)var3 + (double)var6), (int)Math.round(this.field_70163_u + (double)var4), (int)Math.round(this.field_70161_v + (double)var5 + (double)var7)) != Fossil.ferns) continue;
                this.field_70170_p.func_72926_e(2001, (int)Math.round(this.field_70165_t + (double)var3 + (double)var6), (int)Math.round(this.field_70163_u + (double)var4), (int)Math.round(this.field_70161_v + (double)var5 + (double)var7), Block.func_149682_b((Block)Blocks.field_150329_H));
                this.field_70170_p.func_147465_d((int)Math.round(this.field_70165_t + (double)var3 + (double)var6), (int)Math.round(this.field_70163_u + (double)var4), (int)Math.round(this.field_70161_v + (double)var5 + (double)var7), Blocks.field_150350_a, 0, 2);
                if (this.field_70170_p.func_147439_a((int)Math.round(this.field_70165_t + (double)var3 + (double)var6), (int)Math.round(this.field_70163_u + (double)var4) + 1, (int)Math.round(this.field_70161_v + (double)var5 + (double)var7)) == Fossil.ferns) {
                    this.field_70170_p.func_147465_d((int)Math.round(this.field_70165_t + (double)var3 + (double)var6), (int)Math.round(this.field_70163_u + (double)var4) + 1, (int)Math.round(this.field_70161_v + (double)var5 + (double)var7), Blocks.field_150350_a, 0, 2);
                }
                if (this.field_70170_p.func_147439_a((int)Math.round(this.field_70165_t + (double)var3 + (double)var6), (int)Math.round(this.field_70163_u + (double)var4) - 1, (int)Math.round(this.field_70161_v + (double)var5 + (double)var7)) != Blocks.field_150349_c) continue;
                this.field_70170_p.func_147449_b((int)Math.round(this.field_70165_t + (double)var3 + (double)var6), (int)Math.round(this.field_70163_u + (double)var4) - 1, (int)Math.round(this.field_70161_v + (double)var5 + (double)var7), Blocks.field_150346_d);
            }
            this.func_70691_i(3.0f);
            this.func_70778_a(null);
        }
        return true;
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable var1) {
        EntityTriceratops baby = new EntityTriceratops(this.field_70170_p);
        baby.setSubSpecies(this.getSubSpecies());
        return baby;
    }

    @Override
    public void updateSize() {
        double healthStep = (maxHealth - baseHealth) / (double)(this.adultAge + 1);
        double attackStep = (maxDamage - baseDamage) / (double)(this.adultAge + 1);
        double speedStep = (maxSpeed - baseSpeed) / (double)(this.adultAge + 1);
        if (this.getDinoAge() <= this.adultAge) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.round(baseHealth + healthStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Math.round(baseDamage + attackStep * (double)this.getDinoAge()));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseSpeed + speedStep * (double)this.getDinoAge());
            if (this.isTeen()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
            } else if (this.isAdult()) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(2.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
            }
        }
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData par1EntityLivingData) {
        par1EntityLivingData = super.func_110161_a(par1EntityLivingData);
        Random random = new Random();
        this.setSubSpecies(random.nextInt(3));
        this.setDinoAge(this.SelfType.AdultAge);
        this.updateSize();
        this.func_70691_i(200.0f);
        return par1EntityLivingData;
    }

    public void writeSpawnData(ByteBuf buffer) {
    }

    public void readSpawnData(ByteBuf additionalData) {
    }
}

