/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.entity.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import mods.fossil.Fossil;
import mods.fossil.client.gui.GuiPedia;
import mods.fossil.entity.mobs.EnumEdibleFoodstuff;
import mods.fossil.entity.mobs.EnumEntityPrehistoric;
import mods.fossil.guiBlocks.TileEntityFeeder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public abstract class EntityPrehistoric
extends EntityAgeable {
    public static int ticksPerAge = 12000;
    private int age;
    private float exp;
    private int hunger;
    private boolean inHerd;
    private boolean isWild;
    private boolean isStatue;
    private EnumEntityPrehistoric type;
    private String ownerDisplayName;
    private ItemStack itemCarrying;
    private EntityAIBase aiInControl;
    private int subSpecies;
    private boolean male;
    private Vec3 home;

    public EntityPrehistoric(World world, EnumEntityPrehistoric type, int subSpecies, ModelBase model) {
        super(world);
        this.type = type;
        this.exp = type.getBaseExp();
        this.subSpecies = subSpecies;
        this.hunger = type.getMaxHunger() / 2;
        this.func_70105_a(type.getBaseBoundingBoxHeight(), type.getBaseBoundingBoxWidth());
        this.male = new Random().nextBoolean();
    }

    abstract void addAI();

    abstract boolean tryTame(EntityPlayer var1);

    public boolean func_70085_c(EntityPlayer player) {
        if (this.isStatue) {
            return this.statueInteract(player);
        }
        return this.tryTame(player);
    }

    private boolean statueInteract(EntityPlayer player) {
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        if (itemStack.func_77973_b().equals(Items.field_151103_aS)) {
            ++this.age;
            if (!player.field_71075_bZ.field_75098_d) {
                --itemStack.field_77994_a;
                if (itemStack.field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
            }
            return true;
        }
        if (player.func_70093_af()) {
            this.func_70634_a(this.field_70165_t + (this.field_70165_t - player.field_70165_t) * (double)0.1f, this.field_70163_u, this.field_70161_v + (this.field_70161_v - player.field_70161_v) * (double)0.1f);
        } else {
            this.func_70625_a((Entity)player, 360.0f, 360.0f);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void ShowPedia2(GuiPedia p0) {
        p0.reset();
        p0.AddStringLR("", 150, false);
        String translatePath = "assets/fossil/dinopedia/" + Minecraft.func_71410_x().field_71474_y.field_74363_ab + "/";
        String bioFile = this.type.toString() + ".txt";
        if (((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(translatePath) == null) {
            translatePath = "assets/fossil/dinopedia/en_US/";
        }
        if (((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(translatePath + bioFile) != null) {
            InputStream fileReader = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(translatePath + bioFile);
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileReader));
                StringBuffer stringBuffer = new StringBuffer();
                while ((line = bufferedReader.readLine()) != null) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    p0.AddStringLR(line, 150, false);
                    GL11.glPopMatrix();
                }
                fileReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            p0.AddStringLR("File not found.", false);
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            p0.AddStringLR(translatePath + bioFile, 150, false);
            GL11.glPopMatrix();
        }
    }

    protected void func_70628_a(boolean var1, int numToDrop) {
        this.func_70099_a(new ItemStack(this.func_146068_u(), numToDrop, 0), 0.5f);
    }

    protected void func_70600_l(int numToDrop) {
        if (this.isStatue || this.func_70631_g_()) {
            return;
        }
        Item toDrop = null;
        switch (new Random().nextInt(7)) {
            case 0: {
                toDrop = Fossil.legBone;
                break;
            }
            case 1: {
                toDrop = Fossil.claw;
                break;
            }
            case 2: {
                toDrop = Fossil.foot;
                break;
            }
            case 3: {
                toDrop = Fossil.skull;
                break;
            }
            case 4: {
                toDrop = Fossil.vertebrae;
                break;
            }
            case 5: {
                toDrop = Fossil.armBone;
                break;
            }
            case 6: {
                toDrop = Fossil.dinoRibCage;
            }
        }
        this.func_70099_a(new ItemStack(toDrop, 1, this.type.ordinal()), 0.5f);
        if (!this.isAdult()) {
            return;
        }
        if (new Random().nextInt(20) == 0) {
            switch (new Random().nextInt(7)) {
                case 0: {
                    toDrop = Fossil.legBone;
                    break;
                }
                case 1: {
                    toDrop = Fossil.claw;
                    break;
                }
                case 2: {
                    toDrop = Fossil.foot;
                    break;
                }
                case 3: {
                    toDrop = Fossil.skull;
                    break;
                }
                case 4: {
                    toDrop = Fossil.vertebrae;
                    break;
                }
                case 5: {
                    toDrop = Fossil.armBone;
                    break;
                }
                case 6: {
                    toDrop = Fossil.dinoRibCage;
                }
            }
            this.func_70099_a(new ItemStack(toDrop, 1, this.type.ordinal()), 0.5f);
        }
    }

    public void spawnParticle(int particleID) {
        String particleString = "";
        switch (particleID) {
            case 0: {
                particleString = "heart";
                break;
            }
            case 1: {
                particleString = "smoke";
                break;
            }
            case 2: {
                particleString = "cloud";
            }
        }
        for (int i = 0; i < 7; ++i) {
            double var4 = this.field_70146_Z.nextGaussian() * 0.02;
            double var6 = this.field_70146_Z.nextGaussian() * 0.02;
            double var8 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(particleString, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, var4, var6, var8);
        }
    }

    public void eatFromFeeder(TileEntityFeeder feeder) {
        while (this.hunger <= this.type.getMaxHunger() && (feeder.MeatCurrent > 0 || feeder.VegCurrent > 0)) {
            if (feeder.MeatCurrent > 0) {
                ++this.hunger;
                --feeder.MeatCurrent;
            }
            if (feeder.VegCurrent <= 0) continue;
            ++this.hunger;
            --feeder.VegCurrent;
        }
    }

    public void func_70612_e(float xHeading, float yHeading) {
        if (!this.isStatue()) {
            super.func_70612_e(xHeading, yHeading);
            this.field_70138_W = this.field_70153_n != null || this.isAdult() ? 1.0f : 0.5f;
        }
    }

    public EntityPlayer getRidingPlayer() {
        if (this.field_70153_n instanceof EntityPlayer) {
            return (EntityPlayer)this.field_70153_n;
        }
        return null;
    }

    protected Item func_146068_u() {
        if (this.isStatue) {
            return Fossil.biofossil;
        }
        return this.type.getDropItem();
    }

    public boolean func_70652_k(Entity target) {
        boolean attacked = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getStrength());
        if (attacked) {
            // empty if block
        }
        return attacked;
    }

    public boolean func_70097_a(DamageSource attacker, float var2) {
        if (attacker.func_76346_g().equals((Object)this.field_70153_n) || attacker.func_76346_g().equals((Object)this)) {
            return false;
        }
        if (this.dropStatue()) {
            return true;
        }
        return super.func_70097_a(attacker, var2);
    }

    public void func_70074_a(EntityLivingBase entity) {
        if (entity instanceof EntityPrehistoric) {
            this.addHunger(((EntityPrehistoric)entity).getType().getHungerIfEaten());
            this.func_70691_i(((EntityPrehistoric)entity).getType().getHealthIfEaten());
        }
    }

    public int pickupItem(ItemStack item) {
        if (this.type.willEat(item.func_77973_b())) {
            this.eat(item);
        } else {
            this.holdItem(item);
        }
        return 0;
    }

    public void eat(ItemStack itemstack) {
        EnumEdibleFoodstuff food = EnumEdibleFoodstuff.getFromItem(itemstack.func_77973_b());
        while (this.hunger < this.type.getMaxHunger() && itemstack.field_77994_a > 0) {
            this.hunger += food.getBaseHungerHeal();
            this.func_70606_j(this.func_110143_aJ() + food.getBaseHealthHeal());
            --itemstack.field_77994_a;
        }
        if (this.hunger < this.type.getMaxHunger()) {
            this.hunger = this.type.getMaxHunger();
        }
    }

    public void holdItem(ItemStack item) {
        this.itemCarrying = new ItemStack(item.func_77973_b(), item.func_77960_j());
    }

    public boolean dropStatue() {
        if (this.isStatue()) {
            if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                this.func_70099_a(new ItemStack(Fossil.biofossil, 1), 0.0f);
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public void setPathToEntity(Entity entity) {
    }

    public void setPathToPosition(Vec3 location) {
    }

    public float func_70047_e() {
        return this.type.getBaseEyeHeight() * this.getSize();
    }

    public double getStrength() {
        double step = (this.type.getMaxStrength() - this.type.getBaseStrength()) / (double)this.type.getAdultAge();
        if (this.age > this.type.getAdultAge()) {
            return this.type.getBaseStrength() + step * (double)this.type.getAdultAge();
        }
        return this.type.getBaseStrength() + step * (double)this.age;
    }

    public float getSize() {
        float step = (this.type.getMaxSize() - this.type.getBaseSize()) / (float)this.type.getAdultAge();
        if (this.age > this.type.getAdultAge()) {
            return this.type.getBaseSize() + step * (float)this.type.getAdultAge();
        }
        return this.type.getBaseSize() + step * (float)this.age;
    }

    public void func_98054_a(boolean child) {
        this.func_98055_j(this.getSize());
    }

    private void setPedia() {
        Fossil.ToPedia = this;
    }

    public int getSubSpecies() {
        return this.subSpecies;
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected int func_70693_a(EntityPlayer player) {
        return (int)this.exp;
    }

    public boolean func_70650_aV() {
        return !this.isStatue && !this.field_70170_p.field_72995_K;
    }

    public boolean func_70104_M() {
        return !this.isStatue;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int func_70654_ax() {
        return this.age;
    }

    public void incrementAge() {
        ++this.age;
        this.exp += this.type.getExpDaily();
    }

    public int getHunger() {
        return this.hunger;
    }

    public void decrementHunger() {
        if (this.hunger > 0) {
            --this.hunger;
        }
    }

    public boolean addHunger(int hunger) {
        if (this.hunger >= this.type.getMaxHunger()) {
            this.hunger = this.type.getMaxHunger();
            return false;
        }
        this.hunger += hunger;
        if (this.hunger > this.type.getMaxHunger()) {
            this.hunger = this.type.getMaxHunger();
        }
        this.field_70170_p.func_72956_a((Entity)this, "random.eat", this.func_70599_aP(), this.func_70647_i());
        return true;
    }

    public EnumEntityPrehistoric getType() {
        return this.type;
    }

    public String getOwnerDisplayName() {
        return this.ownerDisplayName;
    }

    public void setOwnerDisplayName(String ownerDisplayName) {
        this.ownerDisplayName = ownerDisplayName;
    }

    public void setStatue(boolean isStatue) {
        this.isStatue = isStatue;
    }

    public boolean isStatue() {
        return this.isStatue;
    }

    public boolean isInHerd() {
        return this.inHerd;
    }

    public boolean isWild() {
        return this.isWild;
    }

    public boolean isAdult() {
        return this.age >= this.type.getAdultAge();
    }

    public boolean isTeen() {
        return this.age >= this.type.getTeenAge();
    }

    public boolean func_70631_g_() {
        return this.age < this.type.getTeenAge();
    }

    public boolean hasOwner() {
        return this.ownerDisplayName == null || this.ownerDisplayName.isEmpty();
    }

    public boolean isMale() {
        return this.male;
    }

    public int hungerLevel() {
        float hungerRatio = (float)this.hunger / (float)this.type.getMaxHunger();
        if (hungerRatio < this.type.getHungerLevel()) {
            if (hungerRatio < this.type.getHungerLevel() / 4.0f) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    protected String getModelTexture() {
        return "fossil:textures/mob/DinosaurModels/DinoModel" + this.type.toString() + ".png";
    }

    public String getTexture() {
        return null;
    }

    public void setHome(Vec3 home) {
        this.home = home;
    }

    public Vec3 getHome() {
        return this.home;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isStatue", this.isStatue);
        compound.func_74768_a("Hunger", this.hunger);
        compound.func_74768_a("DinoAge", this.age);
        compound.func_74768_a("SubSpecies", this.subSpecies);
        compound.func_74776_a("Experience", this.exp);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.isStatue = compound.func_74767_n("isStatue");
        this.hunger = compound.func_74762_e("Hunger");
        this.age = compound.func_74762_e("DinoAge");
        this.subSpecies = compound.func_74762_e("SubSpecies");
        this.exp = compound.func_74760_g("Experience");
    }

    public double distanceToLocation(Vec3 location) {
        return Math.sqrt(Math.pow(this.field_70165_t - location.field_72450_a + 0.5, 2.0) + Math.pow(this.field_70161_v - location.field_72449_c + 0.5, 2.0));
    }

    public double distanceToEntity(Entity entity) {
        return Math.sqrt(Math.pow(this.field_70165_t - entity.field_70165_t, 2.0) + Math.pow(this.field_70161_v - entity.field_70161_v, 2.0));
    }

    public double distanceToFeeder(TileEntityFeeder entity) {
        return Math.sqrt(Math.pow(this.field_70165_t - (double)entity.field_145851_c + 0.5, 2.0) + Math.pow(this.field_70163_u - (double)entity.field_145848_d + 0.5, 2.0));
    }

    public int distanceStatus(Vec3 location) {
        double distance = this.distanceToLocation(location);
        if (distance < (double)this.type.getImmediateAwarenessRadius()) {
            return 2;
        }
        if (distance < (double)this.type.getMaxAwarenessRadius()) {
            return 1;
        }
        return 0;
    }

    public int distanceStatus(Entity entity) {
        return this.distanceStatus(Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v));
    }

    public int distanceStatus(TileEntityFeeder entity) {
        return this.distanceStatus(Vec3.func_72443_a((double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e));
    }

    private boolean canSeeEntity(Entity entity) {
        boolean canSeeAnyDir = this.field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v)) == null;
        boolean entityWithinFieldOfView = Vec3.func_72443_a((double)(entity.field_70165_t - this.field_70165_t), (double)(entity.field_70163_u - this.field_70163_u), (double)(entity.field_70161_v - this.field_70161_v)).func_72432_b().func_72430_b(this.func_70040_Z()) > 0.8;
        return canSeeAnyDir && entityWithinFieldOfView;
    }

    private boolean rayTraceBlock(Vec3 position) {
        if (this.field_70163_u >= position.field_72448_b ? this.canSeeBlockFace(position, 0) : this.canSeeBlockFace(position, 1)) {
            return true;
        }
        if (Math.abs(this.field_70165_t - position.field_72450_a) >= Math.abs(this.field_70161_v - position.field_72449_c) ? (this.field_70165_t >= position.field_72450_a ? this.canSeeBlockFace(position, 2) : this.canSeeBlockFace(position, 3)) : (this.field_70161_v >= position.field_72449_c ? this.canSeeBlockFace(position, 4) : this.canSeeBlockFace(position, 5))) {
            return true;
        }
        return Math.abs(this.field_70165_t - position.field_72450_a) >= Math.abs(this.field_70161_v - position.field_72449_c) ? (this.field_70161_v >= position.field_72449_c ? this.canSeeBlockFace(position, 4) : this.canSeeBlockFace(position, 5)) : (this.field_70165_t >= position.field_72450_a ? this.canSeeBlockFace(position, 2) : this.canSeeBlockFace(position, 3));
    }

    private boolean canSeeBlockFace(Vec3 position, int face) {
        Vec3 target = null;
        switch (face) {
            case 0: {
                target = position.func_72441_c(0.5, 1.0, 0.5);
                break;
            }
            case 1: {
                target = position.func_72441_c(0.5, 0.0, 0.5);
                break;
            }
            case 2: {
                target = position.func_72441_c(1.0, 0.5, 0.5);
                break;
            }
            case 3: {
                target = position.func_72441_c(0.0, 0.5, 0.5);
                break;
            }
            case 4: {
                target = position.func_72441_c(0.5, 0.5, 1.0);
                break;
            }
            case 5: {
                target = position.func_72441_c(0.5, 0.5, 0.0);
            }
        }
        MovingObjectPosition hit = this.field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.field_70165_t, (double)(this.field_70163_u + (double)this.func_70047_e()), (double)this.field_70161_v), target);
        return this.vec3Equals(Vec3.func_72443_a((double)hit.field_72311_b, (double)hit.field_72312_c, (double)hit.field_72309_d), position);
    }

    private boolean canSeeBlock(Vec3 position) {
        boolean canSeeAnyDir = this.rayTraceBlock(position);
        boolean blockWithinFieldOfView = Vec3.func_72443_a((double)(position.field_72450_a - this.field_70165_t + 0.5), (double)(position.field_72448_b - this.field_70163_u + 0.5), (double)(position.field_72449_c - this.field_70161_v + 0.5)).func_72432_b().func_72430_b(this.func_70040_Z()) > 0.8;
        return canSeeAnyDir && blockWithinFieldOfView;
    }

    public boolean canFindEntity(Entity entity) {
        switch (this.distanceStatus(entity)) {
            case 0: {
                return false;
            }
            case 1: {
                return this.canSeeEntity(entity);
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean canFindFeeder(TileEntityFeeder entity) {
        return this.canFindBlock(Vec3.func_72443_a((double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e));
    }

    public boolean canFindBlock(Vec3 block) {
        switch (this.distanceStatus(block)) {
            case 0: {
                return false;
            }
            case 1: {
                return this.canSeeBlock(block);
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    private boolean vec3Equals(Vec3 v1, Vec3 v2) {
        return v1.field_72450_a == v2.field_72450_a && v1.field_72448_b == v2.field_72448_b && v1.field_72449_c == v2.field_72449_c;
    }
}

