/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.entity.mobs;

import java.util.ArrayList;
import mods.fossil.entity.mob.EntityAnkylosaurus;
import mods.fossil.entity.mob.EntityBrachiosaurus;
import mods.fossil.entity.mob.EntityCompsognathus;
import mods.fossil.entity.mob.EntityDeinonychus;
import mods.fossil.entity.mob.EntityDilophosaurus;
import mods.fossil.entity.mob.EntityGallimimus;
import mods.fossil.entity.mob.EntityLiopleurodon;
import mods.fossil.entity.mob.EntityMosasaurus;
import mods.fossil.entity.mob.EntityNautilus;
import mods.fossil.entity.mob.EntityPachycephalosaurus;
import mods.fossil.entity.mob.EntityPlesiosaur;
import mods.fossil.entity.mob.EntityPterosaur;
import mods.fossil.entity.mob.EntitySpinosaurus;
import mods.fossil.entity.mob.EntityStegosaurus;
import mods.fossil.entity.mob.EntityTRex;
import mods.fossil.entity.mob.EntityTriceratops;
import mods.fossil.entity.mob.EntityVelociraptor;
import mods.fossil.entity.mobs.EntityAllosaurus;
import mods.fossil.entity.mobs.EntityPrehistoric;
import mods.fossil.entity.mobs.EnumEdibleFoodBlocks;
import mods.fossil.entity.mobs.EnumEdibleFoodMob;
import mods.fossil.entity.mobs.EnumEdibleFoodstuff;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;

public enum EnumEntityPrehistoric {
    Allosaurus(EntityAllosaurus.class, true, true, true, false, true, 0),
    Ankylosaurus(EntityAnkylosaurus.class, true, true, true, false, true, 1),
    Brachiosaurus(EntityBrachiosaurus.class, true, true, true, true, false, 1),
    Compsognathus(EntityCompsognathus.class, true, false, true, true, true, 2),
    Deinonychus(EntityDeinonychus.class, true, false, true, false, false, 0),
    Dilophosaurus(EntityDilophosaurus.class, true, false, true, true, true, 0),
    Gallimimus(EntityGallimimus.class, true, true, true, true, false, 2),
    Liopleurodon(EntityLiopleurodon.class, true, false, true, false, true, 0),
    Mosasaurus(EntityMosasaurus.class, true, false, true, true, true, 0),
    Nautilus(EntityNautilus.class, false, false, false, false, false, 0),
    Pachycephalosaurus(EntityPachycephalosaurus.class, true, false, true, true, true, 1),
    Plesiosaur(EntityPlesiosaur.class, true, true, true, true, true, 0),
    Pterosaur(EntityPterosaur.class, true, false, true, true, true, 0),
    Spinosaurus(EntitySpinosaurus.class, true, false, true, false, true, 0),
    Stegosaurus(EntityStegosaurus.class, true, false, true, true, false, 1),
    Triceratops(EntityTriceratops.class, true, true, true, true, true, 1),
    TyrannosaurusRex(EntityTRex.class, true, false, true, true, true, 0),
    Velociraptor(EntityVelociraptor.class, true, false, true, true, true, 0);

    public static int FOOD_HABBIT_CARNIVORE;
    public static int FOOD_HABBIT_HERBIVORE;
    public static int FOOD_HABBIT_OMNIVORE;
    private ArrayList<EnumEdibleFoodstuff> foodItems = new ArrayList();
    private ArrayList<EnumEdibleFoodBlocks> foodBlocks = new ArrayList();
    private ArrayList<EnumEdibleFoodMob> foodMobs = new ArrayList();
    private ArrayList<EnumEntityPrehistoric> fleesFrom = new ArrayList();
    private Item dropItemMeat;
    private double baseHealth;
    private double baseDamage;
    private double baseSpeed;
    private double baseStrength;
    private double maxHealth;
    private double maxDamage;
    private double maxSpeed;
    private double maxStrength;
    private double speedRunMult;
    private float baseSize;
    private float maxSize;
    private float baseExp;
    private float baseEyeHeight;
    private float baseBoundingBoxHeight;
    private float baseBoundingBoxWidth;
    private float expDaily;
    private float maxAwarenessRadius;
    private float immediateAwarenessRadius;
    private float herdWanderRadius;
    private float hungerLevel;
    private float territorialRadius;
    private int maxHerdSize;
    private int targetFoodHabbit;
    private int maxHunger;
    private int adultAge;
    private int teenAge;
    private int hungerIfEaten;
    private int healIfEaten;
    private int ticksPerHungerDecrement;
    private boolean canFormHerds;
    private boolean tameable;
    private boolean rideable;
    private boolean canCarry;
    private boolean attacksPlayersAsAdult;
    private boolean territorial;
    private final Class entityClass;

    private EnumEntityPrehistoric(Class entityClass, boolean tameable, boolean rideable, boolean canCarry, boolean canFormHerds, boolean territorial, int targetFoodHabbit) {
        this.entityClass = entityClass;
        this.tameable = tameable;
        this.rideable = rideable;
        this.canCarry = canCarry;
        this.canFormHerds = canFormHerds;
        this.territorial = territorial;
        this.targetFoodHabbit = targetFoodHabbit;
    }

    public boolean shouldRunFromEntity(EntityPrehistoric e) {
        return this.fleesFrom.contains((Object)e.getType());
    }

    public boolean willEat(Item item) {
        for (EnumEdibleFoodstuff foodItem : this.foodItems) {
            if (!foodItem.isItem(item)) continue;
            return true;
        }
        return false;
    }

    public boolean willEat(Block block) {
        for (EnumEdibleFoodBlocks foodBlock : this.foodBlocks) {
            if (!foodBlock.isBlock(block)) continue;
            return true;
        }
        return false;
    }

    public boolean willAttack(EntityLiving entity) {
        for (EnumEdibleFoodMob foodMob : this.foodMobs) {
            if (!foodMob.isEntity(entity)) continue;
            return true;
        }
        return false;
    }

    private void setDimensions(float baseBoundingBoxHeight, float baseBoundingBoxWidth, float baseEyeHeight) {
        this.baseBoundingBoxHeight = baseBoundingBoxHeight;
        this.baseBoundingBoxWidth = baseBoundingBoxWidth;
        this.baseEyeHeight = baseEyeHeight;
    }

    private void setBaseValues(double health, double damage, double speed, double strength, float size, float exp) {
        this.baseHealth = health;
        this.baseDamage = damage;
        this.baseSpeed = speed;
        this.baseStrength = strength;
        this.baseSize = size;
        this.baseExp = exp;
    }

    private void setMaxValues(double health, double damage, double speed, double strength, float size) {
        this.maxHealth = health;
        this.maxDamage = damage;
        this.maxSpeed = speed;
        this.maxStrength = strength;
        this.maxSize = size;
    }

    private void setHerdProperties(int maxHerdSize, float maxAwarenessRadius, float immediateAwarenessRadius, float herdWanderRadius) {
        this.maxHerdSize = maxHerdSize;
        this.maxAwarenessRadius = maxAwarenessRadius;
        this.immediateAwarenessRadius = immediateAwarenessRadius;
        this.herdWanderRadius = herdWanderRadius;
    }

    private void setAges(int teenAge, int adultAge) {
        this.teenAge = teenAge;
        this.adultAge = adultAge;
    }

    private void setIfEaten(int hunger, int health) {
        this.hungerIfEaten = hunger;
        this.healIfEaten = health;
    }

    private void setExpDaily(float expDaily) {
        this.expDaily = expDaily;
    }

    private void setSpeedRunMultiplier(double speedRunMult) {
        this.speedRunMult = speedRunMult;
    }

    private void setHungerProperties(float hungerLevel, int ticksPerHungerDecrement) {
        this.hungerLevel = hungerLevel;
        this.ticksPerHungerDecrement = ticksPerHungerDecrement;
    }

    private void setAttacksPlayersAsAdult(boolean attacks) {
        this.attacksPlayersAsAdult = attacks;
    }

    private void setDropItem(Item item) {
        this.dropItemMeat = item;
    }

    private void setTerritorialRadius(float radius) {
        this.territorialRadius = radius;
    }

    public Item getDropItem() {
        return this.dropItemMeat;
    }

    public double getBaseHealth() {
        return this.baseHealth;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public double getBaseSpeed() {
        return this.baseSpeed;
    }

    public double getBaseStrength() {
        return this.baseStrength;
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public double getMaxDamage() {
        return this.maxDamage;
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    public double getMaxStrength() {
        return this.maxStrength;
    }

    public double getSpeedRunMult() {
        return this.speedRunMult;
    }

    public float getBaseSize() {
        return this.baseSize;
    }

    public float getMaxSize() {
        return this.maxSize;
    }

    public float getBaseEyeHeight() {
        return this.baseEyeHeight;
    }

    public float getBaseBoundingBoxHeight() {
        return this.baseBoundingBoxHeight;
    }

    public float getBaseBoundingBoxWidth() {
        return this.baseBoundingBoxWidth;
    }

    public float getBaseExp() {
        return this.baseExp;
    }

    public float getExpDaily() {
        return this.expDaily;
    }

    public float getMaxAwarenessRadius() {
        return this.maxAwarenessRadius;
    }

    public float getImmediateAwarenessRadius() {
        return this.immediateAwarenessRadius;
    }

    public float getHerdWanderRadius() {
        return this.herdWanderRadius;
    }

    public float getHungerLevel() {
        return this.hungerLevel;
    }

    public int getMaxHerdSize() {
        return this.maxHerdSize;
    }

    public int getTargetFoodHabbit() {
        return this.targetFoodHabbit;
    }

    public int getMaxHunger() {
        return this.maxHunger;
    }

    public int getAdultAge() {
        return this.adultAge;
    }

    public int getTeenAge() {
        return this.teenAge;
    }

    public int getHungerIfEaten() {
        return this.hungerIfEaten;
    }

    public int getHealthIfEaten() {
        return this.healIfEaten;
    }

    public int getTicksPerHungerDecrement() {
        return this.ticksPerHungerDecrement;
    }

    public boolean isCanFormHerds() {
        return this.canFormHerds;
    }

    public boolean isTameable() {
        return this.tameable;
    }

    public boolean isRideable() {
        return this.rideable;
    }

    public boolean isCanCarry() {
        return this.canCarry;
    }

    public boolean attacksPlayersAsAdult() {
        return this.attacksPlayersAsAdult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean eatsMeat() {
        if (this.targetFoodHabbit == FOOD_HABBIT_CARNIVORE) return true;
        if (this.targetFoodHabbit != FOOD_HABBIT_OMNIVORE) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean eatsVegetables() {
        if (this.targetFoodHabbit == FOOD_HABBIT_HERBIVORE) return true;
        if (this.targetFoodHabbit != FOOD_HABBIT_OMNIVORE) return false;
        return true;
    }

    public boolean eatsBlocks() {
        return !this.foodBlocks.isEmpty();
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public static void init() {
        Allosaurus.setBaseValues(10.0, 2.0, 0.25, 2.0, 0.55f, 1.0f);
        Allosaurus.setMaxValues(40.0, 11.0, 0.42, 11.0, 3.1f);
        Allosaurus.setDimensions(1.4f, 1.3f, 1.0f);
        Allosaurus.setAges(5, 10);
        Allosaurus.setAttacksPlayersAsAdult(true);
        Allosaurus.setExpDaily(0.2f);
        Allosaurus.setSpeedRunMultiplier(2.0);
        Allosaurus.setIfEaten(25, 1);
        Allosaurus.setTerritorialRadius(20.0f);
    }

    static {
        FOOD_HABBIT_CARNIVORE = 0;
        FOOD_HABBIT_HERBIVORE = 1;
        FOOD_HABBIT_OMNIVORE = 2;
    }
}

