/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.fossilAI;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import mods.fossil.entity.mob.EntityDinosaur;
import mods.fossil.fossilEnums.EnumDinoType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.Vec3;

public class DinoHerd {
    public static final int MODE_IDLE = 0;
    public static final int MODE_WANDER = 1;
    public static final int MODE_ATTACK = 2;
    public static final int MODE_CHASE = 3;
    public static final int MODE_DISPERSE = 4;
    private ArrayList<EntityDinosaur> herdDinos;
    private ArrayList<EntityLiving> targets;
    private ArrayList<EntityLiving> longTermTargets;
    private EntityDinosaur leader;
    private EnumDinoType dinoType;
    private float awarenessRadius;
    private float wanderRadius;
    private float heightAwareness;
    private float immediateAwarenessRadius;
    private float averageSize;
    private float averageAge;
    private float totalSize;
    private int maxHerdSize;
    private int maxTargets;
    private int totalAge;
    private int mode;
    private boolean carnivorous = false;
    private boolean fleeFromLarger = false;
    private boolean allowMultipleSpecies = false;
    private boolean allowCarnivoreHerbivoreMixing = false;
    private Vec3 generalTarget;
    private Entity fleeFrom;
    private Comparator<EntityLiving> comparatorDistanceFromLeader = new Comparator<EntityLiving>(){

        @Override
        public int compare(EntityLiving arg0, EntityLiving arg1) {
            return (int)(DinoHerd.this.entityDistance((Entity)DinoHerd.this.leader, (Entity)arg0) - DinoHerd.this.entityDistance((Entity)DinoHerd.this.leader, (Entity)arg1));
        }
    };

    public DinoHerd(EnumDinoType dinoType, int maxHerdSize, int maxTargets, float awarenessRadius, float immediateAwarenessRadius, float wanderRadius, float heightAwareness) {
        this.herdDinos = new ArrayList();
        this.dinoType = dinoType;
        this.carnivorous = dinoType.isCarnivore();
        this.maxHerdSize = maxHerdSize;
        this.maxTargets = maxTargets;
        this.awarenessRadius = awarenessRadius;
        this.wanderRadius = wanderRadius;
        this.immediateAwarenessRadius = immediateAwarenessRadius;
    }

    public DinoHerd(EnumDinoType dinoType, int maxHerdSize, int maxTargets, float awarenessRadius, float wanderRadius) {
        this(dinoType, maxHerdSize, maxTargets, awarenessRadius, awarenessRadius / 2.0f, wanderRadius, 5.0f + awarenessRadius / 5.0f);
    }

    public boolean addDinoToHerd(EntityDinosaur dino) {
        if (this.herdDinos.size() >= this.maxHerdSize) {
            return false;
        }
        if (!(dino.SelfType.equals((Object)this.dinoType) || this.allowMultipleSpecies && (this.allowCarnivoreHerbivoreMixing || dino.SelfType.isCarnivore() == this.carnivorous))) {
            return false;
        }
        if (!this.herdDinos.contains((Object)dino)) {
            this.herdDinos.add(dino);
            this.updateHerdData();
            return true;
        }
        return false;
    }

    public void removeDinoFromHerd(EntityDinosaur dino) {
        if (this.herdDinos.contains((Object)dino)) {
            this.herdDinos.remove((Object)dino);
            this.updateHerdData();
        }
    }

    public void updateHerdData() {
        this.totalAge = 0;
        this.totalSize = 0.0f;
        int maxAge = 0;
        EntityDinosaur oldest = null;
        for (int i = 0; i < this.herdDinos.size(); ++i) {
            EntityDinosaur dino = this.herdDinos.get(i);
            this.totalAge += dino.func_70654_ax();
            this.totalSize += dino.getDinosaurSize();
            if (dino.func_70654_ax() <= maxAge) continue;
            maxAge = dino.func_70654_ax();
            oldest = dino;
        }
        this.leader = oldest;
        this.averageAge = (float)this.totalAge / (float)this.herdDinos.size();
        this.averageSize = this.totalSize / (float)this.herdDinos.size();
    }

    public void updateHerd() {
        this.updateHerdData();
        if (this.fleeFromLarger && this.shouldDisperse()) {
            this.mode = 4;
        } else if (this.carnivorous) {
            this.removeDeadTargets();
            this.updateTargets();
            this.mode = this.targets.isEmpty() ? ((double)this.leader.getHunger() / (double)this.leader.getMaxHunger() < 0.5 ? 1 : 0) : (this.targets.size() < this.herdDinos.size() / 2 ? 3 : 2);
        } else {
            this.mode = (double)this.leader.getHunger() / (double)this.leader.getMaxHunger() < 0.5 ? 1 : 2;
        }
    }

    public void modeIdle() {
    }

    public void modeWander() {
    }

    public void modeAttack() {
    }

    public void modeChase() {
    }

    public void modeDisperse() {
    }

    public boolean shouldDisperse() {
        boolean toDisperse = false;
        for (Object tempEntity : this.leader.field_70170_p.field_72996_f) {
            if (!(tempEntity instanceof EntityDinosaur)) continue;
            EntityDinosaur tempDino = (EntityDinosaur)((Object)tempEntity);
            if (this.leader.SelfType.isCarnivore()) {
                if (!tempDino.SelfType.isCarnivore() || !(tempDino.getDinosaurSize() > this.leader.getDinosaurSize() + this.averageSize) || !((float)tempDino.func_70654_ax() > (float)this.leader.func_70654_ax() + this.averageAge)) continue;
                toDisperse = true;
                continue;
            }
            if (!tempDino.SelfType.isCarnivore() || !(tempDino.getDinosaurSize() > (this.leader.getDinosaurSize() + this.averageSize) / 2.0f) || !((float)tempDino.func_70654_ax() > ((float)this.leader.func_70654_ax() + this.averageAge) / 2.0f)) continue;
            toDisperse = true;
        }
        return toDisperse;
    }

    public void removeDeadTargets() {
        int i;
        for (i = 0; i < this.targets.size(); ++i) {
            if (!this.targets.get((int)i).field_70128_L) continue;
            this.targets.remove(i);
        }
        for (i = 0; i < this.longTermTargets.size(); ++i) {
            if (!this.longTermTargets.get((int)i).field_70128_L) continue;
            this.longTermTargets.remove(i);
        }
    }

    public void updateTargets() {
        int i;
        if (this.leader.SelfType.isHerbivore()) {
            return;
        }
        ArrayList<EntityLiving> possibleTargets = new ArrayList<EntityLiving>();
        for (Object tempEntity : this.leader.field_70170_p.field_72996_f) {
            float f;
            if (this.herdDinos.contains(tempEntity) || !(tempEntity instanceof EntityLiving)) continue;
            EntityLiving tempEntityLiving = (EntityLiving)tempEntity;
            float distance = this.entityDistance((Entity)tempEntityLiving, (Entity)this.leader);
            if (!(f < this.awarenessRadius) || !(Math.abs(tempEntityLiving.field_70161_v - this.leader.field_70161_v) < (double)this.heightAwareness) || this.targets.contains(tempEntity) || !(distance < this.immediateAwarenessRadius) && this.leader.field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.leader.field_70165_t, (double)this.leader.field_70163_u, (double)this.leader.field_70161_v), Vec3.func_72443_a((double)tempEntityLiving.field_70165_t, (double)tempEntityLiving.field_70163_u, (double)tempEntityLiving.field_70161_v)) != null) continue;
            possibleTargets.add((EntityLiving)tempEntity);
        }
        ArrayList<EntityLiving> pastTargets = new ArrayList<EntityLiving>();
        if (possibleTargets.size() + this.targets.size() > this.maxTargets) {
            possibleTargets.addAll(this.targets);
            pastTargets.addAll(this.targets);
            this.targets.clear();
        }
        Collections.sort(possibleTargets, this.comparatorDistanceFromLeader);
        int targetsToChoose = Math.min(this.maxTargets, possibleTargets.size());
        for (i = 0; i < targetsToChoose; ++i) {
            this.targets.add((EntityLiving)possibleTargets.get(i));
            if (!this.longTermTargets.contains(possibleTargets.get(i))) continue;
            this.longTermTargets.remove(possibleTargets.get(i));
        }
        for (i = targetsToChoose; i < possibleTargets.size(); ++i) {
            if (!pastTargets.contains(possibleTargets.get(i)) || this.longTermTargets.contains(possibleTargets.get(i))) continue;
            this.longTermTargets.add((EntityLiving)possibleTargets.get(i));
        }
        if (this.targets.size() < this.maxTargets && !this.longTermTargets.isEmpty()) {
            Collections.sort(this.longTermTargets, this.comparatorDistanceFromLeader);
            for (i = 0; i < this.maxTargets - this.targets.size() && !this.longTermTargets.isEmpty(); ++i) {
                this.targets.add(this.longTermTargets.get(0));
                this.longTermTargets.remove(0);
            }
        }
    }

    private float entityDistance(Entity e1, Entity e2) {
        return (float)Math.sqrt(Math.pow(e1.field_70165_t - e2.field_70165_t, 2.0) + Math.pow(e1.field_70163_u - e2.field_70163_u, 2.0));
    }

    public void setFleeFromLarger(boolean flee) {
        this.fleeFromLarger = flee;
    }

    public boolean fleesFromLarger() {
        return this.fleeFromLarger;
    }

    public EntityDinosaur getLeader() {
        return this.leader;
    }
}

