/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.fossilAI;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import mods.fossil.Fossil;
import mods.fossil.client.FossilOptions;
import mods.fossil.entity.mob.EntityDinosaur;
import mods.fossil.fossilAI.DinoAINearestAttackableTargetSorter;
import mods.fossil.guiBlocks.TileEntityFeeder;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class WaterDinoAIEat
extends EntityAIBase {
    private static final Logger Log = Fossil.Log;
    private EntityDinosaur dinosaur;
    private double destX;
    private double destY;
    private double destZ;
    protected EntityCreature taskOwner;
    private static final int NO_TARGET = -1;
    private static final int ITEM = 1;
    private static final int BLOCK = 2;
    private static final int MOB = 3;
    private static final int FEEDER = 4;
    private int typeofTarget = -1;
    private int TimeAtThisTarget = 0;
    private final int SEARCH_RANGE;
    private final int USE_RANGE = 3;
    private TileEntityFeeder targetFeeder;
    private EntityItem targetItem;
    private EntityLiving targetMob;
    private Vec3 targetBlock;
    private EntityLivingBase targetEntity;
    private DinoAINearestAttackableTargetSorter targetSorter;
    private World theWorld;
    private double deltaX;
    private double movePosX;
    private double movePosY;
    private double movePosZ;
    private double deltaY;
    private double deltaZ;
    private double speed;
    private int entityPosX;
    private int entityPosY;
    private int entityPosZ;

    public WaterDinoAIEat(EntityDinosaur Dino0, int Range0, double speed) {
        this.theWorld = Dino0.field_70170_p;
        this.targetMob = null;
        this.targetFeeder = null;
        this.dinosaur = Dino0;
        this.speed = speed;
        this.func_75248_a(1);
        this.SEARCH_RANGE = Range0;
        this.targetSorter = new DinoAINearestAttackableTargetSorter(this, (Entity)this.dinosaur);
        this.TimeAtThisTarget = 0;
    }

    public boolean func_75252_g() {
        return true;
    }

    public boolean func_75250_a() {
        int Range = this.SEARCH_RANGE;
        if (!this.theWorld.field_72995_K) {
            if (!FossilOptions.Dinos_Starve) {
                return false;
            }
        }
        if (!this.dinosaur.IsHungry() && !this.dinosaur.IsDeadlyHungry()) {
            this.typeofTarget = -1;
            return false;
        }
        PathNavigate pathnavigate = this.dinosaur.func_70661_as();
        PathEntity pathentity = pathnavigate.func_75505_d();
        if (pathentity != null && !pathentity.func_75879_b()) {
            PathPoint pathpoint = pathentity.func_75870_c();
            this.entityPosX = pathpoint.field_75839_a;
            this.entityPosY = pathpoint.field_75837_b + 1;
            this.entityPosZ = pathpoint.field_75838_c;
            if (this.dinosaur.func_70092_e(this.entityPosX, this.dinosaur.field_70163_u, this.entityPosZ) <= 5.25 && this.dinosaur.SelfType.useFeeder()) {
                this.targetFeeder = null;
                if (this.targetFeeder != null) {
                    Fossil.Console("Found Feeder at: " + this.targetFeeder.field_145851_c + ", " + this.targetFeeder.field_145848_d + ", " + this.targetFeeder.field_145849_e);
                    this.destX = this.targetFeeder.field_145851_c;
                    this.destY = this.targetFeeder.field_145848_d;
                    this.destZ = this.targetFeeder.field_145849_e;
                    this.typeofTarget = 4;
                    return true;
                }
            }
        }
        if (!this.dinosaur.SelfType.FoodItemList.IsEmpty()) {
            Vec3 targetBlock;
            this.targetItem = this.getNearestItem2(this.SEARCH_RANGE);
            if (this.targetItem != null) {
                this.destX = this.targetItem.field_70165_t;
                this.destY = this.targetItem.field_70163_u;
                this.destZ = this.targetItem.field_70161_v;
                this.typeofTarget = 1;
                return true;
            }
            if (!this.dinosaur.SelfType.FoodBlockList.IsEmpty() && (targetBlock = this.dinosaur.getBlockToEat(this.SEARCH_RANGE)) != null) {
                this.destX = targetBlock.field_72450_a;
                this.destY = targetBlock.field_72448_b;
                this.destZ = targetBlock.field_72449_c;
                this.typeofTarget = 2;
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        double Distance = Math.sqrt(Math.pow(this.dinosaur.field_70165_t - this.destX, 2.0) + Math.pow(this.dinosaur.field_70161_v - this.destZ, 2.0));
        if (!this.dinosaur.IsHungry()) {
            return false;
        }
        if (Distance > (double)this.SEARCH_RANGE) {
            Fossil.Console("Target too far, discontinuing task. Distance: " + Distance + ", Range: " + this.SEARCH_RANGE);
            return false;
        }
        switch (this.typeofTarget) {
            default: {
                return false;
            }
            case 1: {
                return this.targetItem.func_70089_S() && this.targetItem != null;
            }
            case 2: {
                return this.dinosaur.SelfType.FoodBlockList.CheckBlock(this.dinosaur.field_70170_p.func_147439_a((int)this.destX, (int)this.destY, (int)this.destZ)) && this.targetBlock != null;
            }
            case 3: {
                return this.targetMob != null && this.targetMob.func_70089_S();
            }
            case 4: 
        }
        return !this.targetFeeder.func_145837_r();
    }

    public void func_75246_d() {
        int Range = this.SEARCH_RANGE;
        this.dinosaur.func_70904_g(false);
        double Distance = Math.sqrt(Math.pow(this.dinosaur.field_70165_t - this.destX, 2.0) + Math.pow(this.dinosaur.field_70161_v - this.destZ, 2.0));
        if (Distance > (double)Range) {
            this.endTask();
        }
        if (this.typeofTarget == 4) {
            if (this.targetFeeder == null) {
                this.endTask();
            }
            if (Distance < (double)this.SEARCH_RANGE) {
                this.moveToTarget(this.destX, this.destY, this.destZ);
                ++this.TimeAtThisTarget;
                if (Distance < 4.5 && this.targetFeeder != null) {
                    int healval = MathHelper.func_76128_c((double)((double)this.targetFeeder.Feed(this.dinosaur, this.dinosaur.SelfType) / 15.0));
                    this.dinosaur.func_70691_i(healval);
                }
            }
            if (this.TimeAtThisTarget == 100) {
                this.endTask();
            } else {
                this.endTask();
            }
        }
        if (this.typeofTarget == 1) {
            if (this.targetItem == null) {
                this.endTask();
            }
            if (Distance < (double)this.SEARCH_RANGE) {
                this.moveToTarget(this.destX, this.destY, this.destZ);
                if (Distance < 2.5 && this.targetItem != null && this.targetItem.func_70089_S()) {
                    int i = this.dinosaur.PickUpItem(this.targetItem.func_92059_d());
                    if (i > 0) {
                        this.targetItem.func_92059_d().field_77994_a = i;
                        this.endTask();
                    } else {
                        this.targetItem.func_70106_y();
                        this.endTask();
                    }
                }
            } else {
                this.endTask();
            }
        }
        if (this.typeofTarget == 2) {
            if (!this.dinosaur.SelfType.FoodBlockList.CheckBlock(this.dinosaur.field_70170_p.func_147439_a((int)this.destX, (int)this.destY, (int)this.destZ))) {
                this.endTask();
            }
            if (Distance < (double)this.SEARCH_RANGE) {
                this.dinosaur.func_70661_as().func_75492_a(this.destX, this.destY, this.destZ, 1.0);
                if (Distance < 2.5 && this.dinosaur.SelfType.FoodBlockList.CheckBlock(this.dinosaur.field_70170_p.func_147439_a((int)this.destX, (int)this.destY, (int)this.destZ))) {
                    this.dinosaur.func_70691_i(this.dinosaur.SelfType.FoodBlockList.getBlockHeal(this.dinosaur.field_70170_p.func_147439_a((int)this.destX, (int)this.destY, (int)this.destZ)));
                    this.dinosaur.increaseHunger(this.dinosaur.SelfType.FoodBlockList.getBlockFood(Item.func_150898_a((Block)this.dinosaur.field_70170_p.func_147439_a((int)this.destX, (int)this.destY, (int)this.destZ))));
                    this.dinosaur.field_70170_p.func_147465_d((int)this.destX, (int)this.destY, (int)this.destZ, Blocks.field_150350_a, 0, 2);
                    ++this.TimeAtThisTarget;
                    if (this.TimeAtThisTarget == 20) {
                        this.endTask();
                    }
                }
            } else {
                this.endTask();
            }
        }
    }

    public void endTask() {
        this.TimeAtThisTarget = 0;
        this.targetItem = null;
        this.targetBlock = null;
        this.targetFeeder = null;
        this.targetEntity = null;
        this.typeofTarget = -1;
    }

    public void func_75251_c() {
        this.TimeAtThisTarget = 0;
        this.targetItem = null;
        this.targetBlock = null;
        this.targetFeeder = null;
        this.targetEntity = null;
        this.typeofTarget = -1;
    }

    private TileEntityFeeder getNearbyFeeder() {
        double range = 36.0;
        List nearbyEntities = this.theWorld.func_72872_a(TileEntityFeeder.class, this.dinosaur.field_70121_D.func_72314_b(range, range, range));
        for (TileEntity entityFeeder : nearbyEntities) {
            TileEntityFeeder nearbyFeeder = (TileEntityFeeder)entityFeeder;
            if (!this.dinosaur.SelfType.useFeeder()) continue;
            return nearbyFeeder;
        }
        return null;
    }

    private EntityItem getNearestItem2(int SEARCH_RANGE) {
        List nearbyItems = this.dinosaur.field_70170_p.func_72872_a(EntityItem.class, this.dinosaur.field_70121_D.func_72314_b((double)SEARCH_RANGE, (double)SEARCH_RANGE, (double)SEARCH_RANGE));
        Collections.sort(nearbyItems, this.targetSorter);
        Iterator iterateNearbyItems = nearbyItems.iterator();
        EntityItem entityItem = null;
        while (iterateNearbyItems.hasNext()) {
            EntityItem entityItem1 = (EntityItem)iterateNearbyItems.next();
            if (!this.dinosaur.SelfType.FoodItemList.CheckItem(entityItem1.func_92059_d().func_77973_b()) && (!this.dinosaur.SelfType.FoodBlockList.CheckBlock(Block.func_149634_a((Item)entityItem1.func_92059_d().func_77973_b())) || !(this.dinosaur.func_70068_e((Entity)entityItem1) < (double)SEARCH_RANGE))) continue;
            entityItem = entityItem1;
        }
        return entityItem;
    }

    private void moveToTarget(double destX, double destY, double destZ) {
        double distance = 64.0;
        this.deltaX = this.destX - this.dinosaur.field_70165_t;
        this.deltaY = this.destY - this.dinosaur.field_70163_u;
        this.deltaZ = this.destZ - this.dinosaur.field_70161_v;
        this.dinosaur.field_70761_aq = this.dinosaur.field_70177_z = -((float)Math.atan2(this.deltaX, this.deltaZ)) * 180.0f / (float)Math.PI;
        this.movePosX = this.deltaX;
        this.movePosY = this.deltaY;
        this.movePosZ = this.deltaZ;
        this.dinosaur.func_70024_g(this.deltaX * this.speed, this.deltaY * this.speed, this.deltaZ * this.speed);
    }
}

