/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.gens.structure;

import coolalias.structuregenapi.util.LogHelper;
import coolalias.structuregenapi.util.Structure;
import coolalias.structuregenapi.util.StructureGeneratorBase;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import mods.fossil.Fossil;
import mods.fossil.client.FossilOptions;
import mods.fossil.fossilEnums.EnumDinoType;
import mods.fossil.gens.structure.academy.Academy1;
import mods.fossil.gens.structure.academy.Academy2;
import mods.fossil.gens.structure.academy.Academy3;
import mods.fossil.gens.structure.academy.Academy4;
import mods.fossil.gens.structure.academy.Academy5;
import mods.fossil.gens.structure.academy.Academy6;
import mods.fossil.gens.structure.temple.Temple1;
import mods.fossil.gens.structure.temple.Temple2;
import mods.fossil.gens.structure.temple.Temple3;
import mods.fossil.guiBlocks.TileEntityFigurine;
import mods.fossil.guiBlocks.TileEntityVase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.logging.log4j.Level;

public class FossilStructureGenerator
extends StructureGeneratorBase {
    public static final List<Structure> structures = new LinkedList<Structure>();
    int random_hole;
    boolean value_set = false;
    int block_change;

    public FossilStructureGenerator(Entity entity, int[][][][] blocks) {
        super(entity, blocks);
    }

    public FossilStructureGenerator(Entity entity, int[][][][] blocks, int structureFacing) {
        super(entity, blocks, structureFacing);
    }

    public FossilStructureGenerator(Entity entity, int[][][][] blocks, int structureFacing, int offX, int offY, int offZ) {
        super(entity, blocks, structureFacing, offX, offY, offZ);
    }

    public FossilStructureGenerator() {
    }

    @Override
    public int getRealBlockID(int fakeID, int customData1) {
        LogHelper.log(Level.TRACE, "Getting real id from fake id: " + fakeID);
        switch (fakeID) {
            case 4097: {
                return Block.func_149682_b((Block)Blocks.field_150486_ae);
            }
            case 4099: {
                return Block.func_149682_b((Block)Blocks.field_150478_aa);
            }
            case 4100: {
                return Block.func_149682_b((Block)Blocks.field_150478_aa);
            }
            case 4101: {
                return Block.func_149682_b((Block)Blocks.field_150478_aa);
            }
            case 4102: {
                return Block.func_149682_b((Block)Blocks.field_150465_bP);
            }
            case 4103: {
                return Block.func_149682_b((Block)Blocks.field_150444_as);
            }
            case 4104: {
                return Block.func_149682_b((Block)Blocks.field_150472_an);
            }
            case 4105: {
                return customData1;
            }
            case 4106: {
                return customData1;
            }
            case 4107: {
                return customData1;
            }
            case 4108: {
                return customData1;
            }
        }
        return 0;
    }

    private EnumDinoType getDinosaur() {
        EnumDinoType[] var1 = EnumDinoType.values();
        int var2 = var1.length;
        Random var4 = new Random();
        EnumDinoType enumDinosaur = var1[var4.nextInt(var2)];
        return enumDinosaur;
    }

    @Override
    public void onCustomBlockAdded(World world, int x, int y, int z, int fakeID, int customData1, int customData2) {
        if (!this.value_set) {
            this.random_hole = world.field_73012_v.nextInt(5);
            this.value_set = true;
        }
        int meta = world.func_72805_g(x, y, z);
        LogHelper.log(Level.TRACE, "Setting custom block info for fake id " + fakeID + " and customData1 " + customData1);
        LogHelper.log(Level.TRACE, "Custom block metadata from world = " + meta);
        block0 : switch (fakeID) {
            case 4097: {
                int loot;
                Item i0;
                int i;
                int iterate;
                Random rand = new Random();
                ItemStack book = new ItemStack((Item)Items.field_151134_bR);
                if (customData1 == -1) {
                    for (iterate = 0; iterate < rand.nextInt(3) + 3; ++iterate) {
                        i = new Random().nextInt(EnumDinoType.values().length + 1);
                        i0 = null;
                        i0 = i == 0 ? Fossil.brokenSapling : EnumDinoType.values()[i - 1].DNAItem;
                        int loot2 = (int)(Math.random() * 100.0);
                        if (loot2 < 80) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(i0, rand.nextInt(4) + 1), x, y, z);
                            continue;
                        }
                        FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(i0, 1), x, y, z);
                    }
                }
                if (customData1 == -2) {
                    for (iterate = 0; iterate < rand.nextInt(12); ++iterate) {
                        loot = rand.nextInt(100);
                        if (loot < 30) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151121_aF, rand.nextInt(22)), x, y, z);
                            continue;
                        }
                        if (loot < 40) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151122_aG, rand.nextInt(12)), x, y, z);
                            continue;
                        }
                        if (loot < 50) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151103_aS, rand.nextInt(22)), x, y, z);
                            continue;
                        }
                        if (loot < 60) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151099_bA, rand.nextInt(5)), x, y, z);
                            continue;
                        }
                        if (loot < 75) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.biofossil, rand.nextInt(22)), x, y, z);
                            continue;
                        }
                        if (loot < 85) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.woodjavelin, rand.nextInt(16)), x, y, z);
                            continue;
                        }
                        if (loot < 95) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.stonejavelin, rand.nextInt(16)), x, y, z);
                            continue;
                        }
                        if (loot >= 101) continue;
                        FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.drum, 1), x, y, z);
                    }
                }
                if (customData1 == -3) {
                    for (iterate = 0; iterate < rand.nextInt(1) + 3; ++iterate) {
                        i = new Random().nextInt(10);
                        i0 = null;
                        Object i2 = null;
                        Object i1 = null;
                        if (i < 3) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.dinoPedia, rand.nextInt(1) + 1), x, y, z);
                            continue;
                        }
                        if (i < 7) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.relic, rand.nextInt(9) + 1), x, y, z);
                            continue;
                        }
                        FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.potteryShards, rand.nextInt(9) + 1), x, y, z);
                    }
                }
                if (customData1 == -4) {
                    for (iterate = 0; iterate < rand.nextInt(12); ++iterate) {
                        loot = rand.nextInt(100);
                        if (loot < 40) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151121_aF, rand.nextInt(22)), x, y, z);
                            continue;
                        }
                        if (loot < 60) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151100_aR, 0, rand.nextInt(10)), x, y, z);
                            continue;
                        }
                        if (loot < 80) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151007_F, rand.nextInt(10)), x, y, z);
                            continue;
                        }
                        if (loot < 90) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151111_aL, rand.nextInt(2)), x, y, z);
                            continue;
                        }
                        if (loot >= 101) continue;
                        FossilStructureGenerator.addItemToTileInventory(world, new ItemStack((Item)Items.field_151148_bJ, rand.nextInt(5)), x, y, z);
                    }
                }
                if (customData1 == -5) {
                    for (iterate = 0; iterate < rand.nextInt(4); ++iterate) {
                        loot = rand.nextInt(100);
                        if (loot < 20) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.ancientGlass, rand.nextInt(10)), x, y, z);
                            continue;
                        }
                        if (loot < 40) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.ancientWood, rand.nextInt(15)), x, y, z);
                            continue;
                        }
                        if (loot < 50) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.whip, 1), x, y, z);
                            continue;
                        }
                        if (loot < 60) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Item.func_150898_a((Block)Fossil.figurineBlock), rand.nextInt(2), rand.nextInt(15)), x, y, z);
                            continue;
                        }
                        if (loot < 80) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151042_j, rand.nextInt(15)), x, y, z);
                            continue;
                        }
                        if (loot < 90) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.fossilrecordBones, 1), x, y, z);
                            continue;
                        }
                        if (loot >= 101) continue;
                        FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151057_cb, rand.nextInt(2)), x, y, z);
                    }
                }
                if (customData1 == -7) {
                    for (iterate = 0; iterate < rand.nextInt(4); ++iterate) {
                        loot = rand.nextInt(100);
                        if (loot < 40) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151074_bl, rand.nextInt(16) + 12), x, y, z);
                            continue;
                        }
                        if (loot < 50) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.goldjavelin, rand.nextInt(10) + 1), x, y, z);
                            continue;
                        }
                        if (loot < 60) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Item.func_150898_a((Block)Fossil.figurineBlock), rand.nextInt(2), rand.nextInt(15)), x, y, z);
                            continue;
                        }
                        if (loot < 80) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151043_k, rand.nextInt(5) + 1), x, y, z);
                            continue;
                        }
                        if (loot < 90) {
                            FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.fossilrecordBones, 1), x, y, z);
                            continue;
                        }
                        if (loot >= 101) continue;
                        FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151057_cb, rand.nextInt(2)), x, y, z);
                    }
                }
                if (customData1 != -8) break;
                int loot3 = rand.nextInt(100);
                if (loot3 < 90) {
                    FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.goldjavelin, rand.nextInt(11) + 1), x, y, z);
                    FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151166_bC, rand.nextInt(5)), x, y, z);
                    break;
                }
                FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.goldjavelin, rand.nextInt(10) + 3), x, y, z);
                FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.diamondjavelin, rand.nextInt(10) + 1), x, y, z);
                FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.relic, rand.nextInt(20)), x, y, z);
                FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.skullStick, rand.nextInt(1)), x, y, z);
                FossilStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151166_bC, rand.nextInt(5) + 3), x, y, z);
                break;
            }
            case 4103: 
            case 4104: {
                String[] text = customData1 == 1 ? new String[]{EnumChatFormatting.DARK_RED + " BEWARE", EnumChatFormatting.DARK_RED + " NO ENTRY", EnumChatFormatting.DARK_BLUE + "Enter at your abcdefghijklm", EnumChatFormatting.DARK_GRAY + " own risk.", "Never prints!"} : new String[]{EnumChatFormatting.BLACK + "Sign Post Text"};
                FossilStructureGenerator.setSignText(world, text, x, y, z);
                break;
            }
            case 4102: {
                FossilStructureGenerator.setSkullData(world, customData1, x, y, z);
                break;
            }
            case 4099: {
                ItemStack frame = new ItemStack(Items.field_151160_bD);
                int facing = FossilStructureGenerator.setHangingEntity(world, frame, x, y, z);
                FossilStructureGenerator.setItemFrameStack(world, new ItemStack(Item.func_150899_d((int)customData1), 1, 0), x, y, z, facing);
                break;
            }
            case 4100: {
                ItemStack painting = new ItemStack(Items.field_151159_an);
                int facing = FossilStructureGenerator.setHangingEntity(world, painting, x, y, z);
                String custom = customData1 == 1 ? "Aztec" : "Bomb";
                FossilStructureGenerator.setPaintingArt(world, custom, x, y, z, facing);
                break;
            }
            case 4105: {
                if (!(world.field_73012_v.nextFloat() < 0.15f)) break;
                world.func_147468_f(x, y, z);
                break;
            }
            case 4106: {
                if (!(world.field_73012_v.nextFloat() < 0.2f)) break;
                world.func_147468_f(x, y, z);
                break;
            }
            case 4107: {
                if (!(world.field_73012_v.nextFloat() < 0.25f)) break;
                world.func_147468_f(x, y, z);
                break;
            }
            case 4109: {
                TileEntityFigurine figurine;
                if (!(world.field_73012_v.nextFloat() < 0.25f)) break;
                if (world.field_73012_v.nextFloat() < 0.5f) {
                    TileEntityVase vase;
                    int randomMeta = world.field_73012_v.nextInt(3);
                    int randomVaseType = world.field_73012_v.nextInt(2);
                    world.func_147465_d(x, y, z, Fossil.vaseKylixBlock, randomVaseType, 2);
                    TileEntityVase tileEntityVase = vase = world.func_147438_o(x, y, z) instanceof TileEntityVase ? (TileEntityVase)world.func_147438_o(x, y, z) : null;
                    if (vase == null) break;
                    vase.setVaseTypeMeta(randomVaseType);
                    vase.setVaseType(randomMeta);
                    break;
                }
                int randomMeta2 = world.field_73012_v.nextInt(4);
                int randomFigurineType = world.field_73012_v.nextInt(15);
                world.func_147465_d(x, y, z, Fossil.figurineBlock, randomMeta2, 2);
                TileEntityFigurine tileEntityFigurine = figurine = world.func_147438_o(x, y, z) instanceof TileEntityFigurine ? (TileEntityFigurine)world.func_147438_o(x, y, z) : null;
                if (figurine == null) break;
                figurine.setFigurineType(randomFigurineType);
                break;
            }
            case 4101: {
                EntityVillager bob = new EntityVillager(world, customData1);
                FossilStructureGenerator.spawnEntityInStructure(world, (Entity)bob, x, y, z);
                break;
            }
            case 4108: {
                BiomeGenBase biome = world.func_72959_q().func_76935_a(x, z);
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                    switch (customData1) {
                        case 1: {
                            world.func_147449_b(x, y, z, Blocks.field_150341_Y);
                            break;
                        }
                        case 2: {
                            world.func_147449_b(x, y, z, Fossil.ancientWood);
                            break;
                        }
                        default: {
                            world.func_147449_b(x, y, z, Blocks.field_150343_Z);
                            break;
                        }
                    }
                } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
                    switch (customData1) {
                        case 1: {
                            world.func_147449_b(x, y, z, Fossil.ancientStonebrick);
                            break;
                        }
                        case 2: {
                            world.func_147449_b(x, y, z, Blocks.field_150417_aV);
                            break;
                        }
                        default: {
                            world.func_147449_b(x, y, z, Blocks.field_150343_Z);
                            break;
                        }
                    }
                } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DESERT)) {
                    switch (customData1) {
                        case 1: {
                            world.func_147449_b(x, y, z, Blocks.field_150322_A);
                            break;
                        }
                        case 2: {
                            world.func_147449_b(x, y, z, Blocks.field_150322_A);
                            break;
                        }
                        default: {
                            world.func_147449_b(x, y, z, Blocks.field_150343_Z);
                            break;
                        }
                    }
                } else {
                    switch (customData1) {
                        case 1: {
                            world.func_147449_b(x, y, z, Fossil.ancientStonebrick);
                            break;
                        }
                        case 2: {
                            world.func_147449_b(x, y, z, Blocks.field_150417_aV);
                            break;
                        }
                        default: {
                            world.func_147449_b(x, y, z, Blocks.field_150343_Z);
                        }
                    }
                }
                switch (customData2) {
                    case 1: {
                        if (!(world.field_73012_v.nextFloat() < 0.15f)) break block0;
                        world.func_147468_f(x, y, z);
                        break;
                    }
                    case 2: {
                        if (!(world.field_73012_v.nextFloat() < 0.2f)) break block0;
                        world.func_147468_f(x, y, z);
                        break;
                    }
                    case 3: {
                        if (!(world.field_73012_v.nextFloat() < 0.25f)) break block0;
                        world.func_147468_f(x, y, z);
                        break;
                    }
                }
                break;
            }
            default: {
                LogHelper.log(Level.WARN, "No custom method defined for id " + fakeID);
            }
        }
    }

    static {
        Structure structure = new Structure("Academy");
        if (FossilOptions.Gen_Academy) {
            structure.addBlockArray(Academy1.blockArrayAcademy);
            structure.addBlockArray(Academy2.blockArrayAcademy);
            structure.addBlockArray(Academy3.blockArrayAcademy);
            structure.addBlockArray(Academy4.blockArrayAcademy);
            structure.addBlockArray(Academy5.blockArrayAcademy);
            structure.addBlockArray(Academy6.blockArrayAcademy);
            structure.setStructureOffset(0, -1, 0);
            structures.add(structure);
        }
        structure = new Structure("Temple");
        if (FossilOptions.Gen_Temple) {
            structure.addBlockArray(Temple1.blockArrayTemple);
            structure.addBlockArray(Temple2.blockArrayTemple);
            structure.addBlockArray(Temple3.blockArrayTemple);
            structure.setStructureOffset(0, -1, 0);
            structures.add(structure);
        }
    }
}

