/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.gens.structure;

import coolalias.structuregenapi.util.LogHelper;
import coolalias.structuregenapi.util.Structure;
import coolalias.structuregenapi.util.StructureGeneratorBase;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import mods.fossil.Fossil;
import mods.fossil.client.FossilOptions;
import mods.fossil.fossilEnums.EnumDinoType;
import mods.fossil.gens.structure.shipwreck.ShipWreck1;
import mods.fossil.gens.structure.shipwreck.ShipWreck2;
import mods.fossil.gens.structure.shipwreck.ShipWreck3;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class FossilWaterStructureGenerator
extends StructureGeneratorBase {
    public static final List<Structure> structures = new LinkedList<Structure>();
    int random_hole;
    boolean value_set = false;

    public FossilWaterStructureGenerator(Entity entity, int[][][][] blocks) {
        super(entity, blocks);
    }

    public FossilWaterStructureGenerator(Entity entity, int[][][][] blocks, int structureFacing) {
        super(entity, blocks, structureFacing);
    }

    public FossilWaterStructureGenerator(Entity entity, int[][][][] blocks, int structureFacing, int offX, int offY, int offZ) {
        super(entity, blocks, structureFacing, offX, offY, offZ);
    }

    public FossilWaterStructureGenerator() {
    }

    @Override
    public int getRealBlockID(int fakeID, int customData1) {
        LogHelper.log(Level.TRACE, "Getting real id from fake id: " + fakeID);
        switch (fakeID) {
            case 4097: {
                return Block.func_149682_b((Block)Blocks.field_150486_ae);
            }
            case 4098: {
                return Block.func_149682_b((Block)Blocks.field_150367_z);
            }
            case 4099: {
                return Block.func_149682_b((Block)Blocks.field_150478_aa);
            }
            case 4100: {
                return Block.func_149682_b((Block)Blocks.field_150478_aa);
            }
            case 4101: {
                return Block.func_149682_b((Block)Blocks.field_150478_aa);
            }
            case 4102: {
                return Block.func_149682_b((Block)Blocks.field_150465_bP);
            }
            case 4103: {
                return Block.func_149682_b((Block)Blocks.field_150444_as);
            }
            case 4104: {
                return Block.func_149682_b((Block)Blocks.field_150472_an);
            }
            case 4105: {
                return customData1;
            }
        }
        return 0;
    }

    private EnumDinoType getDinosaur() {
        EnumDinoType[] var1 = EnumDinoType.values();
        int var2 = var1.length;
        Random var4 = new Random();
        EnumDinoType enumDinosaur = var1[var4.nextInt(var2)];
        return enumDinosaur;
    }

    @Override
    public void onCustomBlockAdded(World world, int x, int y, int z, int fakeID, int customData1, int customData2) {
        if (!this.value_set) {
            this.random_hole = world.field_73012_v.nextInt(5);
            this.value_set = true;
        }
        int meta = world.func_72805_g(x, y, z);
        LogHelper.log(Level.TRACE, "Setting custom block info for fake id " + fakeID + " and customData1 " + customData1);
        LogHelper.log(Level.TRACE, "Custom block metadata from world = " + meta);
        switch (fakeID) {
            case 4097: {
                int loot;
                int iterate;
                Random rand = new Random();
                if (customData1 == -2) {
                    for (iterate = 0; iterate < rand.nextInt(4); ++iterate) {
                        loot = rand.nextInt(100);
                        if (loot < 20) {
                            FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151116_aA, rand.nextInt(20) + 1), x, y, z);
                            continue;
                        }
                        if (loot < 40) {
                            FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151010_B, rand.nextInt(2) + 1), x, y, z);
                            continue;
                        }
                        if (loot < 50) {
                            FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151111_aL, 1), x, y, z);
                            continue;
                        }
                        if (loot < 60) {
                            FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Item.func_150898_a((Block)Fossil.figurineBlock), rand.nextInt(2) + 1, rand.nextInt(15)), x, y, z);
                            continue;
                        }
                        if (loot < 80) {
                            FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151074_bl, rand.nextInt(32) + 1), x, y, z);
                            continue;
                        }
                        if (loot < 90) {
                            FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.ironjavelin, rand.nextInt(16) + 1), x, y, z);
                            continue;
                        }
                        if (loot >= 101) continue;
                        FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151057_cb, rand.nextInt(2) + 1), x, y, z);
                    }
                }
                if (customData1 != -1) break;
                for (iterate = 0; iterate < rand.nextInt(7); ++iterate) {
                    loot = (int)(Math.random() * 100.0);
                    if (loot < 20) {
                        FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151116_aA, rand.nextInt(6) + 1), x, y, z);
                        continue;
                    }
                    if (loot < 40) {
                        FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151122_aG, rand.nextInt(2) + 1), x, y, z);
                        continue;
                    }
                    if (loot < 60) {
                        FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack((Item)Items.field_151112_aM, rand.nextInt(1) + 1), x, y, z);
                        continue;
                    }
                    if (loot < 70) {
                        FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151016_H, rand.nextInt(10) + 1), x, y, z);
                        continue;
                    }
                    if (loot < 85) {
                        FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Fossil.woodjavelin, rand.nextInt(8) + 1), x, y, z);
                        continue;
                    }
                    if (loot < 95) {
                        FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151040_l, rand.nextInt(1) + 1), x, y, z);
                        continue;
                    }
                    FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Items.field_151042_j, rand.nextInt(8) + 1), x, y, z);
                }
                break;
            }
            case 4098: {
                boolean addmore = true;
                while (addmore) {
                    addmore = FossilWaterStructureGenerator.addItemToTileInventory(world, new ItemStack(Item.func_150899_d((int)customData1), 64, 0), x, y, z);
                }
                break;
            }
            case 4103: 
            case 4104: {
                String[] text = customData1 == 1 ? new String[]{EnumChatFormatting.DARK_RED + " BEWARE", EnumChatFormatting.DARK_RED + " NO ENTRY", EnumChatFormatting.DARK_BLUE + "Enter at your abcdefghijklm", EnumChatFormatting.DARK_GRAY + " own risk.", "Never prints!"} : new String[]{EnumChatFormatting.BLACK + "Sign Post Text"};
                FossilWaterStructureGenerator.setSignText(world, text, x, y, z);
                break;
            }
            case 4102: {
                FossilWaterStructureGenerator.setSkullData(world, customData1, x, y, z);
                break;
            }
            case 4099: {
                ItemStack frame = new ItemStack(Items.field_151160_bD);
                int facing = FossilWaterStructureGenerator.setHangingEntity(world, frame, x, y, z);
                FossilWaterStructureGenerator.setItemFrameStack(world, new ItemStack(Item.func_150899_d((int)customData1), 1, 0), x, y, z, facing);
                break;
            }
            case 4100: {
                ItemStack painting = new ItemStack(Items.field_151159_an);
                int facing = FossilWaterStructureGenerator.setHangingEntity(world, painting, x, y, z);
                String custom = customData1 == 1 ? "Aztec" : "Bomb";
                FossilWaterStructureGenerator.setPaintingArt(world, custom, x, y, z, facing);
                break;
            }
            case 4105: {
                if (!(world.field_73012_v.nextFloat() < 0.25f)) break;
                world.func_147468_f(x, y, z);
                break;
            }
            case 4101: {
                EntityVillager bob = new EntityVillager(world, customData1);
                FossilWaterStructureGenerator.spawnEntityInStructure(world, (Entity)bob, x, y, z);
                break;
            }
            default: {
                LogHelper.log(Level.WARN, "No custom method defined for id " + fakeID);
            }
        }
    }

    static {
        Structure structure = new Structure("ShipWreck");
        if (FossilOptions.Gen_Ships) {
            structure.addBlockArray(ShipWreck1.blockArrayShipWreck1);
            structure.addBlockArray(ShipWreck2.blockArrayShipWreck2);
            structure.addBlockArray(ShipWreck3.blockArrayShipWreck3);
            structure.setFacing(3);
            structure.setStructureOffset(0, -10, 0);
            structures.add(structure);
        }
    }
}

