/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.tags;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import mods.fossil.tags.ByteArrayTag;
import mods.fossil.tags.ByteTag;
import mods.fossil.tags.CompoundTag;
import mods.fossil.tags.DoubleTag;
import mods.fossil.tags.EndTag;
import mods.fossil.tags.FloatTag;
import mods.fossil.tags.IntTag;
import mods.fossil.tags.ListTag;
import mods.fossil.tags.LongTag;
import mods.fossil.tags.NBTConstants;
import mods.fossil.tags.NBTUtils;
import mods.fossil.tags.ShortTag;
import mods.fossil.tags.StringTag;
import mods.fossil.tags.Tag;

public final class NBTInputStream
implements Closeable {
    private final DataInputStream is;

    public NBTInputStream(InputStream var1) throws IOException {
        this.is = new DataInputStream(new GZIPInputStream(var1));
    }

    public Tag readTag() throws IOException {
        return this.readTag(0);
    }

    private Tag readTag(int var1) throws IOException {
        String var3;
        int var2 = this.is.readByte() & 0xFF;
        if (var2 != 0) {
            int var4 = this.is.readShort() & 0xFFFF;
            byte[] var5 = new byte[var4];
            this.is.readFully(var5);
            var3 = new String(var5, NBTConstants.CHARSET);
        } else {
            var3 = "";
        }
        return this.readTagPayload(var2, var3, var1);
    }

    private Tag readTagPayload(int var1, String var2, int var3) throws IOException {
        switch (var1) {
            case 0: {
                if (var3 == 0) {
                    throw new IOException("TAG_End found without a TAG_Compound/TAG_List tag preceding it.");
                }
                return new EndTag();
            }
            case 1: {
                return new ByteTag(var2, this.is.readByte());
            }
            case 2: {
                return new ShortTag(var2, this.is.readShort());
            }
            case 3: {
                return new IntTag(var2, this.is.readInt());
            }
            case 4: {
                return new LongTag(var2, this.is.readLong());
            }
            case 5: {
                return new FloatTag(var2, this.is.readFloat());
            }
            case 6: {
                return new DoubleTag(var2, this.is.readDouble());
            }
            case 7: {
                int var4 = this.is.readInt();
                byte[] var5 = new byte[var4];
                this.is.readFully(var5);
                return new ByteArrayTag(var2, var5);
            }
            case 8: {
                short var10 = this.is.readShort();
                byte[] var5 = new byte[var10];
                this.is.readFully(var5);
                return new StringTag(var2, new String(var5, NBTConstants.CHARSET));
            }
            case 9: {
                byte var6 = this.is.readByte();
                int var4 = this.is.readInt();
                ArrayList<Tag> var7 = new ArrayList<Tag>();
                for (int var11 = 0; var11 < var4; ++var11) {
                    Tag var9 = this.readTagPayload(var6, "", var3 + 1);
                    if (var9 instanceof EndTag) {
                        throw new IOException("TAG_End not permitted in a list.");
                    }
                    var7.add(var9);
                }
                return new ListTag(var2, NBTUtils.getTypeClass(var6), var7);
            }
            case 10: {
                HashMap<String, Tag> var8 = new HashMap<String, Tag>();
                Tag var9;
                while (!((var9 = this.readTag(var3 + 1)) instanceof EndTag)) {
                    var8.put(var9.getName(), var9);
                }
                return new CompoundTag(var2, var8);
            }
        }
        throw new IOException("Invalid tag type: " + var1 + ".");
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

