/*
 * Decompiled with CFR 0.152.
 */
package mods.fossil.util;

import net.minecraft.util.MathHelper;

public class MathX {
    public static final double PI_D = Math.PI;
    public static final float PI_F = (float)Math.PI;
    public static boolean useLUT = true;

    private MathX() {
    }

    public static float sin(float a) {
        if (useLUT) {
            return MathHelper.func_76126_a((float)a);
        }
        return (float)Math.sin(a);
    }

    public static float cos(float a) {
        if (useLUT) {
            return MathHelper.func_76134_b((float)a);
        }
        return (float)Math.cos(a);
    }

    public static float tan(float a) {
        return (float)Math.tan(a);
    }

    public static float atan2(float y, float x) {
        return (float)Math.atan2(y, x);
    }

    public static float toRadians(float angdeg) {
        return (float)Math.toRadians(angdeg);
    }

    public static float toDegrees(float angrad) {
        return (float)Math.toDegrees(angrad);
    }

    public static float normDeg(float a) {
        if ((a %= 360.0f) >= 180.0f) {
            a -= 360.0f;
        }
        if (a < -180.0f) {
            a += 360.0f;
        }
        return a;
    }

    public static double normDeg(double a) {
        if ((a %= 360.0) >= 180.0) {
            a -= 360.0;
        }
        if (a < -180.0) {
            a += 360.0;
        }
        return a;
    }

    public static float normRad(float a) {
        if ((a %= (float)Math.PI * 2) >= (float)Math.PI) {
            a -= (float)Math.PI * 2;
        }
        if (a < (float)(-Math.PI)) {
            a += (float)Math.PI * 2;
        }
        return a;
    }

    public static double normRad(double a) {
        if ((a %= Math.PI * 2) >= Math.PI) {
            a -= Math.PI * 2;
        }
        if (a < -Math.PI) {
            a += Math.PI * 2;
        }
        return a;
    }

    public static float sqrtf(float f) {
        return (float)Math.sqrt(f);
    }

    public static float clamp(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float lerp(float a, float b, float x) {
        return a * (1.0f - x) + b * x;
    }

    public static double lerp(double a, double b, double x) {
        return a * (1.0 - x) + b * x;
    }

    public static float slerp(float a, float b, float x) {
        if (x <= 0.0f) {
            return a;
        }
        if (x >= 1.0f) {
            return b;
        }
        return MathX.lerp(a, b, x * x * (3.0f - 2.0f * x));
    }

    public static double slerp(double a, double b, double x) {
        if (x <= 0.0) {
            return a;
        }
        if (x >= 1.0) {
            return b;
        }
        return MathX.lerp(a, b, x * x * (3.0 - 2.0 * x));
    }

    public static float terp(float a, float b, float x) {
        if (x <= 0.0f) {
            return a;
        }
        if (x >= 1.0f) {
            return b;
        }
        float mu2 = (1.0f - MathX.cos(x * (float)Math.PI)) / 2.0f;
        return a * (1.0f - mu2) + b * mu2;
    }

    public static double terp(double a, double b, double x) {
        if (x <= 0.0) {
            return a;
        }
        if (x >= 1.0) {
            return b;
        }
        double mu2 = (1.0 - Math.cos(x * Math.PI)) / 2.0;
        return a * (1.0 - mu2) + b * mu2;
    }

    public static float updateRotation(float r1, float r2, float step) {
        return r1 + MathX.clamp(MathX.normDeg(r2 - r1), -step, step);
    }
}

