/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.configuration.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.FMLClientHandler;
import portablejim.veinminer.VeinMiner;
import portablejim.veinminer.configuration.ConfigurationSettings;
import portablejim.veinminer.configuration.client.ItemlistConfigGuiScreen;
import portablejim.veinminer.configuration.client.ToolDisplay;
import portablejim.veinminer.configuration.client.elements.GuiElementSliderLog;
import portablejim.veinminer.configuration.client.elements.GuiElementSlotToolTypeList;
import portablejim.veinminer.configuration.client.elements.IGuiElementValuePersist;
import portablejim.veinminer.util.PreferredMode;

public class ConfigGuiScreen
extends GuiScreen
implements IGuiElementValuePersist {
    private GuiScreen parent;
    private ConfigurationSettings settings;
    private String[] currentModeStrings;
    GuiElementSlotToolTypeList toolTypeList;
    private ArrayList<ToolDisplay> toolIds;

    public ConfigGuiScreen(GuiScreen parent) {
        this.settings = VeinMiner.instance.configurationSettings;
        this.currentModeStrings = new String[]{"disabled", "pressed", "released", "sneak", "nosneak"};
        this.parent = parent;
        this.toolIds = new ArrayList();
        for (String toolType : this.settings.getToolTypeNames()) {
            this.toolIds.add(new ToolDisplay(toolType, this.settings.getToolTypeIcon(toolType), this.settings.getToolTypeName(toolType)));
        }
        Collections.sort(this.toolIds, new Comparator<ToolDisplay>(){

            @Override
            public int compare(ToolDisplay toolDisplay, ToolDisplay toolDisplay2) {
                if (toolDisplay.name == null) {
                    return -1;
                }
                if (toolDisplay2.name == null) {
                    return 1;
                }
                String s1 = toolDisplay.name.toLowerCase();
                String s2 = toolDisplay2.name.toLowerCase();
                return s1.compareTo(s2);
            }
        });
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 75, this.field_146295_m - 38, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.toolTypeList = new GuiElementSlotToolTypeList(this);
        int topOffset = 32;
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 + 2, topOffset, 150, 20, I18n.func_135052_a((String)String.format("gui.veinminer.config.%s", this.currentModeStrings[this.settings.getPreferredMode()]), (Object[])new Object[0])));
        this.field_146292_n.add(new GuiElementSliderLog(3, this.field_146294_l / 2 - 152, topOffset + 24, this, 1.0f, 1000.0f, 4));
        this.field_146292_n.add(new GuiElementSliderLog(4, this.field_146294_l / 2 + 2, topOffset + 24, this, 1.0f, 131073.0f, 3));
        this.field_146292_n.add(new GuiButton(5, this.field_146294_l / 2 + 2, 100, 150, 20, I18n.func_135052_a((String)"gui.veinminer.config.toollist", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(6, this.field_146294_l / 2 + 2, 122, 150, 20, I18n.func_135052_a((String)"gui.veinminer.config.blocklist", (Object[])new Object[0])));
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            switch (par1GuiButton.field_146127_k) {
                case 1: {
                    FMLClientHandler.instance().showGuiScreen((Object)this.parent);
                    break;
                }
                case 2: {
                    this.settings.setPreferredMode((this.settings.getPreferredMode() + 1) % PreferredMode.length());
                    this.settings.saveConfigs();
                    par1GuiButton.field_146126_j = I18n.func_135052_a((String)String.format("gui.veinminer.config.%s", this.currentModeStrings[this.settings.getPreferredMode()]), (Object[])new Object[0]);
                    break;
                }
                case 5: {
                    ToolDisplay toolDisplay = this.toolIds.get(this.toolTypeList.selectedItem);
                    ItemlistConfigGuiScreen newScreen = new ItemlistConfigGuiScreen(this, toolDisplay.id, 1);
                    this.field_146297_k.func_147108_a((GuiScreen)newScreen);
                    break;
                }
                case 6: {
                    ToolDisplay toolDisplay = this.toolIds.get(this.toolTypeList.selectedItem);
                    ItemlistConfigGuiScreen newScreen = new ItemlistConfigGuiScreen(this, toolDisplay.id, 0);
                    this.field_146297_k.func_147108_a((GuiScreen)newScreen);
                }
            }
        }
    }

    public void func_73876_c() {
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.toolTypeList.drawScreen(par1, par2, par3);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.veinminer.config", (Object[])new Object[0]), this.field_146294_l / 2, 15, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gui.veinminer.config.enable.text", (Object[])new Object[0]), this.field_146294_l / 2 - 95, 38, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.veinminer.config.toolTypes", (Object[])new Object[0]), this.field_146294_l / 2, 86, 0xFFFFFF);
        super.func_73863_a(par1, par2, par3);
    }

    @Override
    public void saveGuiElementValue(GuiButton element, Object value) {
        switch (element.field_146127_k) {
            case 3: {
                float floatValue = ((Float)value).floatValue();
                this.settings.setRadiusLimit((int)floatValue);
                this.settings.saveConfigs();
                break;
            }
            case 4: {
                float floatValue = ((Float)value).floatValue();
                int intValue = Math.round(floatValue);
                if (intValue == 131073) {
                    this.settings.setBlockLimit(-1);
                } else {
                    this.settings.setBlockLimit((int)floatValue);
                }
                this.settings.saveConfigs();
            }
        }
    }

    @Override
    public Object getGuiElementValue(GuiButton element) {
        switch (element.field_146127_k) {
            case 3: {
                return Float.valueOf(this.settings.getRadiusLimit());
            }
            case 4: {
                int blockLimit = this.settings.getBlockLimit();
                return Float.valueOf(blockLimit == -1 ? 131073.0f : (float)this.settings.getBlockLimit());
            }
        }
        return null;
    }

    @Override
    public String getGuiElementDisplayString(GuiButton element, Object value) {
        switch (element.field_146127_k) {
            case 3: {
                float floatValue = ((Float)value).floatValue();
                return I18n.func_135052_a((String)"gui.veinminer.config.range", (Object[])new Object[]{(int)floatValue});
            }
            case 4: {
                float floatValue = ((Float)value).floatValue();
                if (floatValue == 131073.0f) {
                    return I18n.func_135052_a((String)"gui.veinminer.config.blocklimit.infinite", (Object[])new Object[0]);
                }
                return I18n.func_135052_a((String)"gui.veinminer.config.blocklimit", (Object[])new Object[]{(int)floatValue});
            }
        }
        return "";
    }

    public double getZLevel() {
        return this.field_73735_i;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public ArrayList<ToolDisplay> getList() {
        return this.toolIds;
    }
}

