/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.core;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import portablejim.veinminer.VeinMiner;
import portablejim.veinminer.api.VeinminerHarvestFailedCheck;
import portablejim.veinminer.api.VeinminerInitalToolCheck;
import portablejim.veinminer.configuration.ConfigurationSettings;
import portablejim.veinminer.core.MinerInstance;
import portablejim.veinminer.lib.MinerLogger;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.util.BlockID;

public class InjectedCalls {
    public static void blockMined(World world, EntityPlayerMP player, BlockPos blockPos, boolean harvestBlockSuccess, BlockID blockName) {
        MinerLogger.debug("Block mined at %d,%d,%d, result %s, block id is %s/%d", blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), harvestBlockSuccess, blockName.name, blockName.metadata);
        if (blockName.name.isEmpty() || Block.func_149684_b((String)blockName.name) == null || !player.func_146099_a(Block.func_149684_b((String)blockName.name))) {
            return;
        }
        if (!harvestBlockSuccess) {
            VeinminerHarvestFailedCheck startEvent = new VeinminerHarvestFailedCheck(player, blockName.name, blockName.metadata);
            MinecraftForge.EVENT_BUS.post((Event)startEvent);
            if (startEvent.allowContinue.isDenied()) {
                return;
            }
        }
        ConfigurationSettings configurationSettings = VeinMiner.instance.configurationSettings;
        int radiusLimit = configurationSettings.getRadiusLimit();
        int blockLimit = configurationSettings.getBlockLimit();
        VeinminerInitalToolCheck startConfig = new VeinminerInitalToolCheck(player, radiusLimit, blockLimit, configurationSettings.getRadiusLimit(), configurationSettings.getBlockLimit());
        MinecraftForge.EVENT_BUS.post((Event)startConfig);
        if (startConfig.allowVeinminerStart.isAllowed()) {
            radiusLimit = Math.min(startConfig.radiusLimit, radiusLimit);
            blockLimit = Math.min(startConfig.blockLimit, blockLimit);
            MinerInstance ins = new MinerInstance(world, player, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockName, MinerServer.instance, radiusLimit, blockLimit);
            ins.mineVein(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }
    }
}

