/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminermodsupport;

import bluedart.api.IBreakable;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import portablejim.veinminer.api.IMCMessage;
import portablejim.veinminer.api.Permission;
import portablejim.veinminer.api.VeinminerHarvestFailedCheck;
import portablejim.veinminer.api.VeinminerPostUseTool;

@Mod(modid="VeinMinerModSupport", name="VeinMiner Mod Support")
public class VeinMinerModSupport {
    private boolean debugMode = false;
    @Mod.Instance(value="VeinMinerModSupport")
    public static VeinMinerModSupport instance;
    public boolean forceConsumerAvailable;
    private Boolean configLoaded = false;

    @NetworkCheckHandler
    public boolean checkClientModVersion(Map<String, String> mods, Side side) {
        return true;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File configDir = new File(event.getModConfigurationDirectory(), "veinminer");
        File loadedFile = new File(configDir, "modSupport.cfg");
        if (loadedFile.exists()) {
            this.configLoaded = true;
        } else {
            try {
                loadedFile.createNewFile();
                Files.write((CharSequence)"#Nothing to see here!\n", (File)loadedFile, (Charset)Charset.defaultCharset());
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        String fileName;
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModContainer thisMod = (ModContainer)Loader.instance().getIndexedModList().get("VeinMinerModSupport");
        if (thisMod != null && ((fileName = thisMod.getSource().getName()).contains("-dev") || !fileName.contains(".jar"))) {
            this.debugMode = true;
            this.devLog("DEV VERSION");
        }
        this.forceConsumerAvailable = false;
        if (!this.configLoaded.booleanValue()) {
            this.addTools();
        }
    }

    private void addTools() {
        if (Loader.isModLoaded((String)"IC2")) {
            IMCMessage.addTool("axe", "IC2:itemToolBronzeAxe");
            IMCMessage.addTool("axe", "IC2:itemToolChainsaw");
            IMCMessage.addTool("hoe", "IC2:itemToolBronzeHoe");
            IMCMessage.addTool("pickaxe", "IC2:itemToolBronzePickaxe");
            IMCMessage.addTool("pickaxe", "IC2:itemToolDrill");
            IMCMessage.addTool("pickaxe", "IC2:itemToolDDrill");
            IMCMessage.addTool("pickaxe", "IC2:itemToolIridiumDrill");
            IMCMessage.addTool("shears", "IC2:itemToolBronzeHoe");
            IMCMessage.addTool("shovel", "IC2:itemToolBronzeSpade");
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            IMCMessage.addTool("axe", "appliedenergistics2:item.ToolCertusQuartzAxe");
            IMCMessage.addTool("hoe", "appliedenergistics2:item.ToolCertusQuartzHoe");
            IMCMessage.addTool("pickaxe", "appliedenergistics2:item.ToolCertusQuartzPickaxe");
            IMCMessage.addTool("shovel", "appliedenergistics2:item.ToolCertusQuartzSpade");
            IMCMessage.addTool("axe", "appliedenergistics2:item.ToolNetherQuartzAxe");
            IMCMessage.addTool("hoe", "appliedenergistics2:item.ToolNetherQuartzHoe");
            IMCMessage.addTool("pickaxe", "appliedenergistics2:item.ToolNetherQuartzPickaxe");
            IMCMessage.addTool("shovel", "appliedenergistics2:item.ToolNetherQuartzSpade");
        }
        if (Loader.isModLoaded((String)"BiomesOPlenty")) {
            IMCMessage.addTool("axe", "BiomesOPlenty:axeMud");
            IMCMessage.addTool("hoe", "BiomesOPlenty:hoeMud");
            IMCMessage.addTool("pickaxe", "BiomesOPlenty:pickaxeMud");
            IMCMessage.addTool("shovel", "BiomesOPlenty:shovelMud");
            IMCMessage.addTool("axe", "BiomesOPlenty:axeAmethyst");
            IMCMessage.addTool("hoe", "BiomesOPlenty:hoeAmethyst");
            IMCMessage.addTool("pickaxe", "BiomesOPlenty:pickaxeAmethyst");
            IMCMessage.addTool("shovel", "BiomesOPlenty:shovelAmethyst");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheWood");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheStone");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheIron");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheGold");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheDiamond");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheMud");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheAmethyst");
        }
        if (Loader.isModLoaded((String)"TConstruct")) {
            this.devLog("Tinkers support loaded");
            IMCMessage.addTool("axe", "TConstruct:hatchet");
            IMCMessage.addTool("hoe", "TConstruct:mattock");
            IMCMessage.addTool("pickaxe", "TConstruct:pickaxe");
            IMCMessage.addTool("shovel", "TConstruct:shovel");
            IMCMessage.addTool("shovel", "TConstruct:mattock");
        }
        if (Loader.isModLoaded((String)"exnihilo")) {
            this.devLog("Ex Nihilo support loaded");
            IMCMessage.addToolType("crook", "Crook", "exnihilo:crook");
            IMCMessage.addTool("crook", "exnihilo:crook");
            IMCMessage.addTool("crook", "exnihilo:crook_bone");
            IMCMessage.addToolType("hammer", "Hammer", "exnihilo:hammer_stone");
            IMCMessage.addTool("hammer", "exnihilo:hammer_wood");
            IMCMessage.addTool("hammer", "exnihilo:hammer_stone");
            IMCMessage.addTool("hammer", "exnihilo:hammer_iron");
            IMCMessage.addTool("hammer", "exnihilo:hammer_gold");
            IMCMessage.addTool("hammer", "exnihilo:hammer_diamond");
            IMCMessage.addBlock("crook", "minecraft:leaves");
            IMCMessage.addBlock("crook", "minecraft:leaves2");
            IMCMessage.addBlock("crook", "minecraft:tallgrass");
            IMCMessage.addBlock("crook", "minecraft:vine");
            IMCMessage.addBlock("crook", "minecraft:web");
            IMCMessage.addBlock("crook", "minecraft:wool");
            IMCMessage.addBlock("hammer", "exnihilo:aluminum_dust");
            IMCMessage.addBlock("hammer", "exnihilo:aluminum_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:aluminum_sand");
            IMCMessage.addBlock("hammer", "exnihilo:copper_dust");
            IMCMessage.addBlock("hammer", "exnihilo:copper_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:copper_sand");
            IMCMessage.addBlock("hammer", "exnihilo:dust");
            IMCMessage.addBlock("hammer", "exnihilo:ender_lead_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:ender_platinum_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:ender_silver_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:ender_tin_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:exnihilo.gravel_ender");
            IMCMessage.addBlock("hammer", "exnihilo:exnihilo.gravel_nether");
            IMCMessage.addBlock("hammer", "exnihilo:gold_dust");
            IMCMessage.addBlock("hammer", "exnihilo:gold_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:gold_sand");
            IMCMessage.addBlock("hammer", "exnihilo:iron_dust");
            IMCMessage.addBlock("hammer", "exnihilo:iron_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:iron_sand");
            IMCMessage.addBlock("hammer", "exnihilo:lead_dust");
            IMCMessage.addBlock("hammer", "exnihilo:lead_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:lead_sand");
            IMCMessage.addBlock("hammer", "exnihilo:nether_copper_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:nether_gold_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:nether_iron_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:nether_nickel_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:nickel_dust");
            IMCMessage.addBlock("hammer", "exnihilo:nickel_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:nickel_sand");
            IMCMessage.addBlock("hammer", "exnihilo:platinum_dust");
            IMCMessage.addBlock("hammer", "exnihilo:platinum_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:platinum_sand");
            IMCMessage.addBlock("hammer", "exnihilo:silver_dust");
            IMCMessage.addBlock("hammer", "exnihilo:silver_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:silver_sand");
            IMCMessage.addBlock("hammer", "exnihilo:tin_dust");
            IMCMessage.addBlock("hammer", "exnihilo:tin_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:tin_sand");
            IMCMessage.addBlock("hammer", "minecraft:cobblestone");
            IMCMessage.addBlock("hammer", "minecraft:gravel");
            IMCMessage.addBlock("hammer", "minecraft:sand");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"DartCraft")) {
            this.devLog("Testing for dartcraft classes and functions.");
            try {
                Method obj = Class.forName("bluedart.api.IForceConsumer").getMethod("attemptRepair", ItemStack.class);
                this.forceConsumerAvailable = true;
            }
            catch (ClassNotFoundException e) {
                this.devLog("Failed to find Dartcraft force consumer. Disabling repair support");
            }
            catch (NoSuchMethodException e) {
                this.devLog("Failed to find Dartcraft force consumer function. Disabling repair support");
            }
        }
    }

    private void devLog(String string) {
        if (this.debugMode) {
            FMLLog.getLogger().info("[VeinMinerModSupport] " + string);
        }
    }

    @SubscribeEvent
    public void makeToolsWork(VeinminerHarvestFailedCheck event) {
        ItemStack currentEquipped = event.player.func_71045_bC();
        if (currentEquipped == null) {
            return;
        }
        Item currentEquippedItem = event.player.func_71045_bC().func_77973_b();
        if (Loader.isModLoaded((String)"DartCraft")) {
            this.devLog("Dartcraft detected");
            if (currentEquippedItem instanceof IBreakable && event.allowContinue == Permission.DENY) {
                this.devLog("Allowed start");
                event.allowContinue = Permission.ALLOW;
            }
        }
        if (Loader.isModLoaded((String)"TConstruct")) {
            this.devLog("Tinkers Construct detected");
            this.tinkersConstructToolEvent(event);
        }
        if (Loader.isModLoaded((String)"exnihilo")) {
            this.devLog("Ex Nihilo detected");
            if (currentEquippedItem != null && currentEquippedItem.getClass().getCanonicalName().startsWith("exnihilo.items.hammers") && event.allowContinue == Permission.DENY) {
                this.devLog("Allowed hammer start");
                event.allowContinue = Permission.ALLOW;
            } else if (currentEquippedItem != null) {
                this.devLog(currentEquippedItem.getClass().getCanonicalName());
            }
        }
    }

    private void tinkersConstructToolEvent(VeinminerHarvestFailedCheck event) {
        ItemStack currentItem = event.player.func_71045_bC();
        if (currentItem == null) {
            this.devLog("ERROR: Item is null");
            return;
        }
        if (!currentItem.func_77942_o()) {
            this.devLog("ERROR: No NBT data");
            return;
        }
        NBTTagCompound toolTags = currentItem.func_77978_p().func_74775_l("InfiTool");
        if (toolTags == null) {
            this.devLog("ERROR: Not Tinkers Construct Tool");
            return;
        }
        Block block = Block.func_149684_b((String)event.blockName);
        if (block == null) {
            this.devLog("ERROR: Block id wrong.");
            return;
        }
        this.devLog("Allowing event");
        if (event.allowContinue == Permission.DENY) {
            event.allowContinue = Permission.ALLOW;
        }
    }

    @SubscribeEvent
    public void applyForce(VeinminerPostUseTool event) {
        ItemStack currentEquippedItemStack = event.player.func_71045_bC();
        if (this.forceConsumerAvailable && currentEquippedItemStack != null && Loader.isModLoaded((String)"DartCraft")) {
            this.devLog("Reflecting on Dartcraft run repair method.");
            try {
                Class<?> IForceConsumer = Class.forName("bluedart.api.IForceConsumer");
                if (IForceConsumer != null && IForceConsumer.isInstance(currentEquippedItemStack.func_77973_b())) {
                    Method attemptRepair = IForceConsumer.getMethod("attemptRepair", ItemStack.class);
                    attemptRepair.invoke((Object)currentEquippedItemStack.func_77973_b(), currentEquippedItemStack);
                    this.devLog("Repairing dartcraft force consumer");
                }
            }
            catch (ClassNotFoundException e) {
                this.devLog("Strange, I thought we already found the Dartcraft class.");
                this.forceConsumerAvailable = false;
            }
            catch (NoSuchMethodException e) {
                this.devLog("Strange, I thought we already found the Dartcraft class and correct method.");
                this.forceConsumerAvailable = false;
            }
            catch (InvocationTargetException e) {
                this.devLog("Trying to repair Dartcraft tools didn't work. It threw a InvocationTargetException.");
                this.forceConsumerAvailable = false;
            }
            catch (IllegalAccessException e) {
                this.devLog("Trying to repair Dartcraft tools didn't work. It threw a IllegalAccessException.");
                this.forceConsumerAvailable = false;
            }
        }
    }
}

