/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.FoodStats;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import portablejim.veinminer.api.Permission;
import portablejim.veinminer.api.VeinminerHarvestFailedCheck;
import portablejim.veinminer.api.VeinminerNoToolCheck;
import portablejim.veinminer.api.VeinminerPostUseTool;
import portablejim.veinminer.configuration.ConfigurationSettings;
import portablejim.veinminer.lib.BlockLib;
import portablejim.veinminer.lib.MinerLogger;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.util.BlockID;
import portablejim.veinminer.util.ItemStackID;
import portablejim.veinminer.util.PlayerStatus;
import portablejim.veinminer.util.Point;

public class MinerInstance {
    public MinerServer serverInstance;
    private ConcurrentLinkedQueue<Point> destroyQueue = new ConcurrentLinkedQueue();
    private HashSet<Point> awaitingEntityDrop = new HashSet();
    private LinkedHashMap<ItemStackID, Integer> drops = new LinkedHashMap();
    private World world;
    private EntityPlayerMP player;
    private BlockID targetBlock;
    private boolean finished;
    private ItemStack usedItem;
    private int numBlocksMined;
    private Point initalBlock;
    private int radiusLimit;
    private int blockLimit;
    private static final int MIN_HUNGER = 1;

    public MinerInstance(World world, EntityPlayerMP player, int x, int y, int z, BlockID blockID, MinerServer server, int radiusLimit, int blockLimit) {
        this.world = world;
        this.player = player;
        this.targetBlock = blockID;
        this.finished = false;
        this.serverInstance = server;
        this.usedItem = player.func_71045_bC();
        this.numBlocksMined = 1;
        this.initalBlock = new Point(x, y, z);
        this.radiusLimit = radiusLimit;
        this.blockLimit = blockLimit;
        this.serverInstance.addInstance(this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void cleanUp() {
        FMLCommonHandler.instance().bus().unregister((Object)this);
    }

    private boolean shouldContinue() {
        UUID playerName;
        PlayerStatus playerStatus;
        if (!this.serverInstance.getConfigurationSettings().getEnableAllTools() && this.player.func_71045_bC() == null) {
            VeinminerNoToolCheck toolCheck = new VeinminerNoToolCheck(this.player);
            MinecraftForge.EVENT_BUS.post((Event)toolCheck);
            if (toolCheck.allowTool.isAllowed()) {
                this.finished = false;
            } else if (toolCheck.allowTool == Permission.FORCE_DENY) {
                this.finished = true;
            } else {
                Block testBlock = Blocks.field_150348_b;
                PlayerEvent.HarvestCheck event = new PlayerEvent.HarvestCheck((EntityPlayer)this.player, testBlock, false);
                MinecraftForge.EVENT_BUS.post((Event)event);
                boolean bl = this.finished = !event.success;
            }
        }
        if (this.usedItem == null) {
            if (this.player.func_71045_bC() != null) {
                this.finished = true;
            }
        } else if (this.player.func_71045_bC() == null || !this.player.func_71045_bC().func_77969_a(this.usedItem)) {
            this.finished = true;
        }
        if ((playerStatus = this.serverInstance.getPlayerStatus(playerName = this.player.func_110124_au())) == null) {
            this.finished = true;
        } else if (playerStatus == PlayerStatus.INACTIVE || playerStatus == PlayerStatus.SNEAK_ACTIVE && !this.player.func_70093_af() || playerStatus == PlayerStatus.SNEAK_INACTIVE && this.player.func_70093_af()) {
            this.finished = true;
        }
        if (this.finished) {
            return false;
        }
        FoodStats food = this.player.func_71024_bL();
        if (food.func_75116_a() < 1) {
            this.finished = true;
            String problem = "mod.veinminer.finished.tooHungry";
            if (this.serverInstance.playerHasClient(this.player.func_110124_au())) {
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation(problem, new Object[0]));
            } else {
                String translatedProblem = StatCollector.func_74838_a((String)problem);
                this.player.func_145747_a((IChatComponent)new ChatComponentText(translatedProblem));
            }
        }
        if (this.numBlocksMined >= this.blockLimit && this.blockLimit != -1) {
            this.finished = true;
        }
        return !this.finished;
    }

    private boolean toolAllowedForBlock(ItemStack tool, BlockID block) {
        boolean toolAllowed = false;
        ConfigurationSettings settings = this.serverInstance.getConfigurationSettings();
        for (String type : settings.getToolTypeNames()) {
            if (!settings.toolIsOfType(tool, type) || !this.serverInstance.getConfigurationSettings().whiteListHasBlockId(type, block)) continue;
            toolAllowed = true;
        }
        return toolAllowed;
    }

    private void mineBlock(int x, int y, int z) {
        Point newPoint = new Point(x, y, z);
        this.awaitingEntityDrop.add(newPoint);
        boolean success = this.player.field_71134_c.func_73084_b(x, y, z);
        ++this.numBlocksMined;
        VeinminerPostUseTool toolUsedEvent = new VeinminerPostUseTool(this.player);
        MinecraftForge.EVENT_BUS.post((Event)toolUsedEvent);
        VeinminerHarvestFailedCheck continueCheck = new VeinminerHarvestFailedCheck(this.player, this.targetBlock.name, this.targetBlock.metadata);
        MinecraftForge.EVENT_BUS.post((Event)continueCheck);
        if (success || continueCheck.allowContinue.isAllowed()) {
            this.destroyQueue.add(newPoint);
        } else {
            this.awaitingEntityDrop.remove(newPoint);
        }
    }

    public synchronized void mineVein(int x, int y, int z) {
        if (this.world == null || this.player == null || this.targetBlock == null) {
            this.finished = true;
        }
        if (this.finished || !this.shouldContinue()) {
            return;
        }
        this.player.func_71020_j(0.03f);
        int d = 1;
        for (int dx = -d; dx <= d; ++dx) {
            for (int dy = -d; dy <= d; ++dy) {
                for (int dz = -d; dz <= d; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    Point newBlockPos = new Point(x + dx, y + dy, z + dz);
                    BlockID newBlock = new BlockID(this.world, x + dx, y + dy, z + dz);
                    if (Block.func_149684_b((String)newBlock.name) == null) continue;
                    ConfigurationSettings configSettings = this.serverInstance.getConfigurationSettings();
                    if (!newBlock.wildcardEquals(this.targetBlock) && !configSettings.areBlocksCongruent(newBlock, this.targetBlock) && !BlockLib.arePickBlockEqual(newBlock, this.targetBlock) || !newBlockPos.isWithinRange(this.initalBlock, this.radiusLimit) && this.radiusLimit > 0 || this.awaitingEntityDrop.contains(newBlockPos)) continue;
                    MinerLogger.debug("Block limit is: %d | Blocks mined: %d", this.blockLimit, this.numBlocksMined);
                    if (this.numBlocksMined >= this.blockLimit && this.blockLimit != -1 || !configSettings.getEnableAllBlocks() && !this.toolAllowedForBlock(this.usedItem, newBlock)) continue;
                    this.mineBlock(x + dx, y + dy, z + dz);
                }
            }
        }
    }

    @SubscribeEvent
    public void mineScheduled(TickEvent.ServerTickEvent event) {
        int quantity = this.serverInstance.getConfigurationSettings().getBlocksPerTick();
        for (int i = 0; i < quantity; ++i) {
            if (!this.destroyQueue.isEmpty()) {
                Point target = (Point)this.destroyQueue.remove();
                this.mineVein(target.getX(), target.getY(), target.getZ());
                continue;
            }
            if (this.drops.isEmpty()) continue;
            this.serverInstance.removeInstance(this);
            this.spawnDrops();
            this.cleanUp();
            return;
        }
    }

    private void spawnDrops() {
        for (Map.Entry<ItemStackID, Integer> schedDrop : this.drops.entrySet()) {
            EntityItem newEntityItem;
            ItemStack newItemStack;
            int numItems;
            ItemStackID itemStack = schedDrop.getKey();
            String[] itemNames = itemStack.getItemId().split(":", 2);
            if (itemNames.length < 2 || GameRegistry.findItemStack((String)itemNames[0], (String)itemNames[1], (int)1) == null) continue;
            for (numItems = schedDrop.getValue().intValue(); numItems > itemStack.getMaxStackSize(); numItems -= itemStack.getMaxStackSize()) {
                newItemStack = GameRegistry.findItemStack((String)itemNames[0], (String)itemNames[1], (int)itemStack.getMaxStackSize());
                newItemStack.func_77964_b(itemStack.getDamage());
                newEntityItem = new EntityItem(this.world, (double)this.initalBlock.getX(), (double)this.initalBlock.getY(), (double)this.initalBlock.getZ(), newItemStack);
                this.world.func_72838_d((Entity)newEntityItem);
            }
            newItemStack = GameRegistry.findItemStack((String)itemNames[0], (String)itemNames[1], (int)numItems);
            newItemStack.func_77964_b(itemStack.getDamage());
            newEntityItem = new EntityItem(this.world, (double)this.initalBlock.getX(), (double)this.initalBlock.getY(), (double)this.initalBlock.getZ(), newItemStack);
            this.world.func_72838_d((Entity)newEntityItem);
        }
        this.drops.clear();
    }

    public boolean isRegistered(Point p) {
        return this.awaitingEntityDrop.contains(p);
    }

    public void addDrop(EntityItem entity) {
        ItemStack item = entity.func_92059_d();
        ItemStackID itemInfo = new ItemStackID(item.func_77973_b(), item.func_77960_j(), item.func_77976_d());
        if (this.drops.containsKey(itemInfo)) {
            int oldDropNumber = this.drops.get(itemInfo);
            int newDropNumber = oldDropNumber + item.field_77994_a;
            this.drops.put(itemInfo, newDropNumber);
        } else {
            this.drops.put(itemInfo, item.field_77994_a);
        }
    }
}

