/*
 * Decompiled with CFR 0.152.
 */
package me.tigreax.nova.gui.clickgui.element.panel;

import java.util.ArrayList;
import me.tigreax.nova.gui.clickgui.element.Element;
import me.tigreax.nova.module.mods.ModCategory;
import me.tigreax.nova.utils.render.NahrFont;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.StringUtils;
import org.lwjgl.input.Mouse;

public class Panel {
    private ModCategory category;
    private int x;
    private int y;
    private int x2;
    private int y2;
    private int width;
    private int height;
    private int scroll;
    private int dragged;
    private boolean open;
    private boolean drag;
    private final ArrayList<Element> elements = new ArrayList();
    private boolean scrollbar = false;

    public Panel(ModCategory category, int x, int y, int width, int height, boolean open) {
        this.category = category;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.open = open;
        this.setupItems();
    }

    public void setupItems() {
    }

    public int getElementsHeight() {
        int height = 0;
        int count = 0;
        for (Element element : this.elements) {
            if (count >= 10) continue;
            height += element.getHeight() + 1;
            ++count;
        }
        return height;
    }

    public boolean isHovering(int mouseX, int mouseY) {
        float textWidth = RenderHelper.getNahrFont().getStringWidth(StringUtils.stripControlCodes(String.valueOf(String.valueOf(this.category.name())) + " [\u00c2\u00a78" + this.elements.size() + "\u00c2\u00a7f]")) - 100.0f;
        if ((float)mouseX >= (float)this.x - textWidth / 2.0f - 4.0f) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(String.valueOf(this.category.name())));
            if ((float)mouseX <= (float)this.x - textWidth / 2.0f + RenderHelper.getNahrFont().getStringWidth(StringUtils.stripControlCodes(stringBuilder.append(" [\u00c2\u00a78").append(this.elements.size()).append("\u00c2\u00a7f]").toString())) + 4.0f && mouseY >= this.y && mouseY <= this.y + this.height - (this.open ? 2 : 0)) {
                return true;
            }
        }
        return false;
    }

    public void drag(int mouseX, int mouseY) {
        if (this.drag) {
            this.x = this.x2 + mouseX;
            this.y = this.y2 + mouseY;
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.isHovering(mouseX, mouseY)) {
            this.x2 = this.x - mouseX;
            this.y2 = this.y - mouseY;
            this.drag = true;
            return;
        }
        if (mouseButton == 1 && this.isHovering(mouseX, mouseY)) {
            this.open = !this.open;
            return;
        }
        if (!this.open) {
            return;
        }
        for (Element element : this.elements) {
            element.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int state) {
        if (state == 0) {
            this.drag = false;
        }
        if (!this.open) {
            return;
        }
        for (Element element : this.elements) {
            element.mouseReleased(mouseX, mouseY, state);
        }
    }

    public void drawScreen(int mouseX, int mouseY, float button) {
        boolean scrollbar;
        this.drag(mouseX, mouseY);
        float elementsHeight = this.open ? this.getElementsHeight() - 1 : 0;
        float textWidth = RenderHelper.getNahrFont().getStringWidth(StringUtils.stripControlCodes(String.valueOf(String.valueOf(this.category.name())) + " [\u00c2\u00a78" + this.elements.size() + "\u00c2\u00a7f]"));
        boolean bl = scrollbar = this.elements.size() >= 10;
        if (this.scrollbar != scrollbar) {
            this.scrollbar = scrollbar;
        }
        RenderHelper.drawBorderedRect((float)this.getX() - (textWidth - 100.0f) / 2.0f - 4.0f, this.getY(), (float)this.getX() - (textWidth - 100.0f) / 2.0f + textWidth + 4.0f, this.getY() + 16, 1.0f, -16777216, this.open ? -2142711348 : Integer.MIN_VALUE);
        RenderHelper.getNahrFont().drawString(this.getTitle(), (float)this.getX() - (textWidth - 100.0f) / 2.0f, this.getY(), NahrFont.FontType.SHADOW_THIN, -1, -16777216);
        if (Mouse.hasWheel() && mouseX >= this.getX() && mouseX <= this.getX() + 100 && mouseY >= this.getY() && (float)mouseY <= (float)(this.getY() + 19) + elementsHeight) {
            int wheel = Mouse.getDWheel();
            if (wheel < 0 && this.scroll < this.elements.size() - 10) {
                ++this.scroll;
                if (this.scroll < 0) {
                    this.scroll = 0;
                }
            } else if (wheel > 0) {
                --this.scroll;
                if (this.scroll < 0) {
                    this.scroll = 0;
                }
            }
            if (wheel < 0) {
                if (this.dragged < this.elements.size() - 10) {
                    ++this.dragged;
                }
            } else if (wheel > 0 && this.dragged >= 1) {
                --this.dragged;
            }
        }
        if (this.open) {
            RenderHelper.drawBorderedRect(this.getX() - (scrollbar ? 4 : 0), this.getY() + 18, this.getX() + 100, (float)(this.getY() + 19) + elementsHeight, 1.5f, -587202560, Integer.MIN_VALUE);
            if (scrollbar) {
                RenderHelper.drawBorderedRect(this.getX() - 2, this.getY() + 21, this.getX(), (float)(this.getY() + 16) + elementsHeight, 1.5f, -587202560, -2142711348);
                RenderHelper.drawRect(this.getX() - 2, (float)(this.getY() + 30) + (elementsHeight - 24.0f) / (float)(this.elements.size() - 10) * (float)this.dragged - 10.0f, this.getX(), (float)(this.getY() + 40) + (elementsHeight - 24.0f) / (float)(this.elements.size() - 10) * (float)this.dragged, -587202560);
            }
            int y = this.y + this.height - 2;
            int count = 0;
            this.elements.size();
            for (Element element : this.elements) {
                if (++count <= this.scroll || count >= this.scroll + 11 || this.scroll >= this.elements.size()) continue;
                element.setLocation(this.x + 2, y);
                element.setWidth(this.getWidth() - 4);
                element.drawScreen(mouseX, mouseY, button);
                y += element.getHeight() + 1;
            }
        }
    }

    public boolean getScrollbar() {
        return this.scrollbar;
    }

    public ModCategory getCategory() {
        return this.category;
    }

    public int getX() {
        return this.x;
    }

    public String getTitle() {
        return String.valueOf(String.valueOf(this.category.name())) + " [\u00c2\u00a78" + this.elements.size() + "\u00c2\u00a7f]";
    }

    public int getY() {
        return this.y;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean getOpen() {
        return this.open;
    }

    public ArrayList<Element> getElements() {
        return this.elements;
    }

    public void setX(int dragX) {
        this.x = dragX;
    }

    public void setY(int dragY) {
        this.y = dragY;
    }
}

