/*
 * Decompiled with CFR 0.152.
 */
package me.tigreax.nova.management;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import me.tigreax.nova.Nova;
import me.tigreax.nova.module.mods.Mod;
import me.tigreax.nova.module.mods.ModCategory;
import net.minecraft.client.Minecraft;
import org.darkstorm.minecraft.gui.AbstractGuiManager;
import org.darkstorm.minecraft.gui.component.Button;
import org.darkstorm.minecraft.gui.component.Component;
import org.darkstorm.minecraft.gui.component.Frame;
import org.darkstorm.minecraft.gui.component.basic.BasicButton;
import org.darkstorm.minecraft.gui.component.basic.BasicFrame;
import org.darkstorm.minecraft.gui.layout.GridLayoutManager;
import org.darkstorm.minecraft.gui.listener.ButtonListener;
import org.darkstorm.minecraft.gui.theme.Theme;

public final class GuiManager
extends AbstractGuiManager {
    private final AtomicBoolean setup = new AtomicBoolean();

    @Override
    public void setup() {
        if (!this.setup.compareAndSet(false, true)) {
            return;
        }
        HashMap<ModCategory, ModuleFrame> categoryFrames = new HashMap<ModCategory, ModuleFrame>();
        Nova.getInstance();
        for (final Mod module : Nova.getModManager().getMods()) {
            if (module.isCategory(ModCategory.GUI)) continue;
            ModuleFrame frame = (ModuleFrame)categoryFrames.get((Object)module.getCategory());
            if (frame == null) {
                String name = module.getCategory().toString().toLowerCase();
                name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
                frame = new ModuleFrame(name);
                frame.setTheme(this.getTheme());
                frame.setLayoutManager(new GridLayoutManager(1, 0));
                frame.setVisible(true);
                frame.setClosable(false);
                frame.setMinimized(true);
                this.addFrame(frame);
                categoryFrames.put(module.getCategory(), frame);
            }
            final Mod updateModule = module;
            BasicButton button = new BasicButton(module.getActualName()){

                @Override
                public void update() {
                    this.setText(module.getActualName());
                }
            };
            button.addButtonListener(new ButtonListener(){

                @Override
                public void onButtonPress(Button button) {
                    updateModule.toggle();
                    button.setText(module.getActualName());
                }
            });
            frame.add(button, GridLayoutManager.HorizontalGridConstraint.FILL);
        }
        this.resizeComponents();
        Minecraft minecraft = Minecraft.getMinecraft();
        Dimension maxSize = this.recalculateSizes();
        int offsetX = 5;
        int offsetY = 5;
        int scale = minecraft.gameSettings.guiScale;
        if (scale == 0) {
            scale = 1000;
        }
        int scaleFactor = 0;
        while (scaleFactor < scale && minecraft.displayWidth / (scaleFactor + 1) >= 320 && minecraft.displayHeight / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        Frame[] arrayOfFrame = this.getFrames();
        int j = arrayOfFrame.length;
        int i = 0;
        while (i < j) {
            Frame frame = arrayOfFrame[i];
            frame.setX(offsetX);
            frame.setY(offsetY);
            if ((offsetX += maxSize.width + 5) + maxSize.width + 5 > minecraft.displayWidth / scaleFactor) {
                offsetX = 5;
                offsetY += maxSize.height + 5;
            }
            ++i;
        }
    }

    @Override
    protected void resizeComponents() {
        Theme theme = this.getTheme();
        Frame[] frames = this.getFrames();
        BasicButton enable = new BasicButton("Enable");
        BasicButton disable = new BasicButton("Disable");
        Dimension enableSize = theme.getUIForComponent(enable).getDefaultSize(enable);
        Dimension disableSize = theme.getUIForComponent(disable).getDefaultSize(disable);
        int buttonWidth = Math.max(enableSize.width, disableSize.width);
        int buttonHeight = Math.max(enableSize.height, disableSize.height);
        Frame[] arrayOfFrame1 = frames;
        int j = frames.length;
        int i = 0;
        while (i < j) {
            Frame frame = arrayOfFrame1[i];
            if (frame instanceof ModuleFrame) {
                Component[] arrayOfComponent = frame.getChildren();
                int m = arrayOfComponent.length;
                int k = 0;
                while (k < m) {
                    Component component = arrayOfComponent[k];
                    if (component instanceof Button) {
                        component.setWidth(buttonWidth);
                        component.setHeight(buttonHeight);
                    }
                    ++k;
                }
            }
            ++i;
        }
        this.recalculateSizes();
    }

    private Dimension recalculateSizes() {
        Frame frame;
        Frame[] frames = this.getFrames();
        int maxWidth = 0;
        int maxHeight = 0;
        Frame[] arrayOfFrame1 = frames;
        int j = frames.length;
        int i = 0;
        while (i < j) {
            frame = arrayOfFrame1[i];
            Dimension defaultDimension = frame.getTheme().getUIForComponent(frame).getDefaultSize(frame);
            maxWidth = Math.max(maxWidth, defaultDimension.width);
            frame.setHeight(defaultDimension.height);
            if (frame.isMinimized()) {
                Rectangle[] arrayOfRectangle = frame.getTheme().getUIForComponent(frame).getInteractableRegions(frame);
                int m = arrayOfRectangle.length;
                int k = 0;
                while (k < m) {
                    Rectangle area = arrayOfRectangle[k];
                    maxHeight = Math.max(maxHeight, area.height);
                    ++k;
                }
            } else {
                maxHeight = Math.max(maxHeight, defaultDimension.height);
            }
            ++i;
        }
        arrayOfFrame1 = frames;
        j = frames.length;
        i = 0;
        while (i < j) {
            frame = arrayOfFrame1[i];
            frame.setWidth(maxWidth);
            frame.layoutChildren();
            ++i;
        }
        return new Dimension(maxWidth, maxHeight);
    }

    private class ModuleFrame
    extends BasicFrame {
        private ModuleFrame() {
        }

        private ModuleFrame(String title) {
        }
    }
}

