/*
 * Decompiled with CFR 0.152.
 */
package me.tigreax.nova.module.commands.misc;

import com.darkmagician6.eventapi.EventManager;
import com.darkmagician6.eventapi.EventTarget;
import me.tigreax.nova.Wrapper;
import me.tigreax.nova.events.EventReceivePacket;
import me.tigreax.nova.module.commands.Command;
import me.tigreax.nova.utils.Timer;
import net.minecraft.network.play.client.C14PacketTabComplete;
import net.minecraft.network.play.server.S3APacketTabComplete;

public class PluginDiscovery
extends Command {
    private final Timer timer = new Timer();

    public PluginDiscovery() {
        super(new String[]{"PluginDiscovery", "pldisc"});
        this.setDescription("Fetch plugins using tab completion.");
    }

    @EventTarget
    public void onReceivePacket(EventReceivePacket event) {
        if (event.getPacket() instanceof S3APacketTabComplete) {
            S3APacketTabComplete packet = (S3APacketTabComplete)event.getPacket();
            String[] commands = packet.func_149630_c();
            String message = "";
            int size = 0;
            String[] stringArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                String command = stringArray[n2];
                String pluginName = command.split(":")[0].substring(1);
                if (!message.contains(pluginName) && command.contains(":") && !pluginName.equalsIgnoreCase("minecraft") && !pluginName.equalsIgnoreCase("bukkit")) {
                    ++size;
                    message = message.isEmpty() ? String.valueOf(message) + pluginName : String.valueOf(message) + "\u00a78, \u00a77" + pluginName;
                }
                ++n2;
            }
            if (!message.isEmpty()) {
                Wrapper.addChatMessage("Plugins (" + size + "): " + message + "\u00a78.");
            } else {
                Wrapper.addChatMessage("Plugins: none.");
            }
            event.setCancelled(true);
            EventManager.unregister(this);
        }
        if (this.timer.check(20000.0f)) {
            EventManager.unregister(this);
            Wrapper.addChatMessage("Stopped listening for an S3APacketTabComplete! Took too long (20s)!");
        }
    }

    @Override
    public void runCommand(String message, String[] args) {
        if (args.length > 1) {
            this.timer.reset();
            EventManager.register(this);
            Wrapper.sendPacket(new C14PacketTabComplete(message.substring(args[0].length() + 1)));
        } else {
            this.timer.reset();
            EventManager.register(this);
            Wrapper.sendPacket(new C14PacketTabComplete("/"));
        }
        Wrapper.addChatMessage("Listening for a S3APacketTabComplete for 20s!");
    }
}

