/*
 * Decompiled with CFR 0.152.
 */
package me.tigreax.nova.module.commands.world;

import me.tigreax.nova.Wrapper;
import me.tigreax.nova.module.commands.Command;
import me.tigreax.nova.utils.player.inventory.Inventory;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class Give
extends Command {
    private static Item getItemByText(String itemName) throws NumberInvalidException {
        Item item = (Item)Item.itemRegistry.getObject(itemName);
        if (item == null) {
            try {
                item = Item.getItemById(Integer.parseInt(itemName));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (item == null) {
            throw new NumberInvalidException("commands.give.notFound", itemName);
        }
        return item;
    }

    private static int parseInt(String integer) throws NumberInvalidException {
        try {
            return Integer.parseInt(integer);
        }
        catch (NumberFormatException exception) {
            throw new NumberInvalidException("commands.generic.num.invalid", integer);
        }
    }

    private static int parseIntBounded(String integer, int min, int max) throws NumberInvalidException {
        int parsedInt = Give.parseInt(integer);
        if (parsedInt < min) {
            throw new NumberInvalidException("commands.generic.num.tooSmall", parsedInt, min);
        }
        if (parsedInt > max) {
            throw new NumberInvalidException("commands.generic.num.tooBig", parsedInt, max);
        }
        return parsedInt;
    }

    public Give() {
        super(new String[]{"give"});
        this.setDescription("Give yourself an item of choice.");
    }

    @Override
    public void runCommand(String message, String[] args) {
        if (args.length > 1) {
            Item item = Item.getItemById(0);
            try {
                item = Give.getItemByText(args[1]);
            }
            catch (Exception exception) {
                Wrapper.addChatMessage("Could not find item via item name, or ID.");
                return;
            }
            int amount = 1;
            int damage = 0;
            if (args.length > 2) {
                Integer newInt = Integer.parseInt(args[2]);
                if (newInt <= 0) {
                    Wrapper.addChatMessage("The stack size you provided is too small. Using 1.");
                } else if (newInt > 64) {
                    amount = 64;
                    Wrapper.addChatMessage("The stack size you provided is too big. Using 64.");
                } else {
                    try {
                        amount = Give.parseIntBounded(args[2], 1, 64);
                    }
                    catch (NumberInvalidException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (args.length > 3) {
                try {
                    damage = Give.parseInt(args[3]);
                }
                catch (NumberInvalidException e) {
                    e.printStackTrace();
                }
            }
            ItemStack itemStack = new ItemStack(item, amount, damage);
            if (args.length > 4) {
                String jsonData = message.substring(args[0].length() + args[1].length() + args[2].length() + args[3].length() + 4);
                try {
                    NBTTagCompound base = JsonToNBT.func_180713_a(jsonData);
                    if (!(base instanceof NBTTagCompound)) {
                        Wrapper.addChatMessage("Invalid NBT/JSON data given.");
                        return;
                    }
                    itemStack.setTagCompound(base);
                }
                catch (NBTException exception) {
                    Wrapper.addChatMessage("Invalid NBT/JSON data given.");
                    return;
                }
            }
            Wrapper.getPlayer().inventory.addItemStackToInventory(itemStack);
            Inventory.updateInventory();
            Wrapper.addChatMessage("Item \"" + itemStack.getDisplayName() + "\" has been given to your inventory.");
        } else {
            Wrapper.addChatMessage("Please provide a mode, or id to give.");
        }
    }
}

