/*
 * Decompiled with CFR 0.152.
 */
package me.tigreax.nova.module.commands.world;

import com.darkmagician6.eventapi.EventManager;
import com.darkmagician6.eventapi.EventTarget;
import me.tigreax.nova.Wrapper;
import me.tigreax.nova.events.EventSendPacket;
import me.tigreax.nova.module.commands.Command;
import me.tigreax.nova.utils.Timer;
import me.tigreax.nova.utils.player.inventory.Inventory;
import me.tigreax.nova.utils.reflection.SessionUtils;
import net.minecraft.event.ClickEvent;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.play.client.C12PacketUpdateSign;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;

public class ItemUtilities
extends Command {
    private String tempCommand = "";
    private int mode;
    private final Timer timer = new Timer();

    public ItemUtilities() {
        super(new String[]{"ItemUtilities", "ItemUtils", "ItemUs"});
        this.setDescription("Gives the user the ability to manipulate items.");
        this.setSyntax(".itemus <specific: <book: command> | <signop(:command)> | <coloredSigns/cS> | anvil | spawner>");
    }

    @EventTarget
    public void onSendPacket(EventSendPacket event) {
        if (this.mode == 1) {
            if (event.getPacket() instanceof C17PacketCustomPayload) {
                ItemStack stack;
                C17PacketCustomPayload payload = (C17PacketCustomPayload)event.getPacket();
                if (!payload.getChannelName().equals("MC|BSign")) {
                    return;
                }
                try {
                    stack = payload.getBufferData().readItemStackFromBuffer();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                payload.getBufferData().clear();
                NBTTagList pages = stack.getTagCompound().getTagList("pages", 8);
                int page = 0;
                while (page < pages.tagCount()) {
                    String text = pages.getStringTagAt(page);
                    text = text.substring(1, text.length() - 1);
                    ChatComponentText component = new ChatComponentText(text);
                    component.setChatStyle(new ChatStyle()).getChatStyle().setChatClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, this.tempCommand));
                    text = IChatComponent.Serializer.componentToJson(component);
                    pages.set(page, new NBTTagString(text));
                    ++page;
                }
                payload.getBufferData().writeItemStackToBuffer(stack);
                event.setPacket(new C17PacketCustomPayload("MC|BSign", payload.getBufferData()));
                this.tempCommand = "";
                EventManager.unregister(this);
                this.mode = -1;
            }
        } else if (this.mode == 3) {
            if (event.getPacket() instanceof C12PacketUpdateSign) {
                C12PacketUpdateSign packet = (C12PacketUpdateSign)event.getPacket();
                ChatComponentText cct = new ChatComponentText(packet.func_180768_b()[0].getUnformattedText());
                cct.setChatStyle(new ChatStyle()).getChatStyle().setChatClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, this.tempCommand));
                IChatComponent[] text = new IChatComponent[]{cct, new ChatComponentText(packet.func_180768_b()[1].getUnformattedText()), new ChatComponentText(packet.func_180768_b()[2].getUnformattedText()), new ChatComponentText(packet.func_180768_b()[3].getUnformattedText())};
                event.setPacket(new C12PacketUpdateSign(packet.func_179722_a(), text));
                EventManager.unregister(this);
                this.mode = -1;
                this.tempCommand = "";
            }
        } else if (this.mode == 4) {
            if (event.getPacket() instanceof C12PacketUpdateSign) {
                C12PacketUpdateSign packet = (C12PacketUpdateSign)event.getPacket();
                IChatComponent[] text = new IChatComponent[]{new ChatComponentText(packet.func_180768_b()[0].getUnformattedText().replaceAll("&", "\u00a7")), new ChatComponentText(packet.func_180768_b()[1].getUnformattedText().replaceAll("&", "\u00a7")), new ChatComponentText(packet.func_180768_b()[2].getUnformattedText().replaceAll("&", "\u00a7")), new ChatComponentText(packet.func_180768_b()[3].getUnformattedText().replaceAll("&", "\u00a7"))};
                event.setPacket(new C12PacketUpdateSign(packet.func_179722_a(), text));
                EventManager.unregister(this);
                this.mode = -1;
            }
        } else if (this.mode == 5 && event.getPacket() instanceof C17PacketCustomPayload) {
            C17PacketCustomPayload payload = (C17PacketCustomPayload)event.getPacket();
            if (!payload.getChannelName().equals("MC|ItemName")) {
                return;
            }
            payload.getBufferData().clear();
            StringBuilder sb = new StringBuilder();
            int a = 0;
            while (a < 25) {
                sb.append("a");
                ++a;
            }
            payload.getBufferData().writeString(sb.toString());
            event.setPacket(new C17PacketCustomPayload("MC|ItemName", payload.getBufferData()));
            EventManager.unregister(this);
            this.mode = -1;
        }
    }

    @Override
    public void runCommand(String message, String[] args) {
        if (args.length > 1) {
            if (args.length > 2) {
                if (args[1].equalsIgnoreCase("specific")) {
                    if (args[2].equalsIgnoreCase("book") && args.length > 3) {
                        if (Wrapper.getPlayer().getCurrentEquippedItem() == null || Wrapper.getPlayer().getCurrentEquippedItem().getItem() != Items.writable_book) {
                            Wrapper.addChatMessage("You must be holding a writable book.");
                        }
                        this.mode = 1;
                        this.tempCommand = message.substring(args[0].length() + args[1].length() + args[2].length() + 3);
                        EventManager.register(this);
                        Wrapper.getPlayer().displayGUIBook(Wrapper.getPlayer().getCurrentEquippedItem());
                        Wrapper.addChatMessage("Add the display text, sign the book, and the text will execute the given commands when clicked. Command: " + this.tempCommand);
                    }
                } else {
                    Wrapper.addChatMessage(this.getSyntax());
                }
            }
            if (args[1].equalsIgnoreCase("signOP")) {
                this.mode = 3;
                this.tempCommand = args.length > 2 ? message.substring(args[0].length() + args[1].length() + 2) : "/op " + SessionUtils.getSession().getUsername();
                Wrapper.addChatMessage("Place down a sign and it should OP you or execute a console command upon right clicking it (vanilla, below 1.8.3).");
                EventManager.register(this, EventSendPacket.class);
            } else if (args[1].equalsIgnoreCase("spawner")) {
                ItemStack spawner = new ItemStack(Item.getItemById(52), 1, 0);
                try {
                    spawner.setTagCompound(JsonToNBT.func_180713_a("{BlockEntityTag:{EntityId:Skeleton,SpawnData:{Equipment:[{id:diamond_sword},{id:iron_boots},{id:iron_leggings},{id:iron_chestplate},{id:iron_helmet}]},SpawnCount:2,SpawnRange:10,MinSpawnDelay:10,MaxSpawnDelay:60,MaxNearbyEntities:6,RequiredPlayerRange:15}}"));
                    Wrapper.getPlayer().inventory.addItemStackToInventory(spawner);
                    Inventory.updateInventory();
                }
                catch (NBTException e) {
                    e.printStackTrace();
                    Wrapper.addChatMessage("Item Utilities: Failed to give spawner.");
                }
            } else if (args[1].equalsIgnoreCase("coloredSigns") || args[1].equalsIgnoreCase("cS")) {
                this.mode = 4;
                Wrapper.addChatMessage("Place down a sign. All & symbols will be replaced with the color code symbol.");
                this.timer.reset();
                EventManager.register(this, EventSendPacket.class);
            } else if (args[1].equalsIgnoreCase("anvil")) {
                this.mode = 5;
                Wrapper.addChatMessage("Place an item in an anvil, type a character and take it out.");
                this.timer.reset();
                EventManager.register(this, EventSendPacket.class);
            }
        } else {
            Wrapper.addChatMessage(this.getSyntax());
        }
    }
}

