/*
 * Decompiled with CFR 0.152.
 */
package me.tigreax.nova.module.mods.render;

import com.darkmagician6.eventapi.EventTarget;
import me.tigreax.nova.Wrapper;
import me.tigreax.nova.events.EventRender3D;
import me.tigreax.nova.module.mods.Mod;
import me.tigreax.nova.module.mods.ModCategory;
import me.tigreax.nova.utils.render.Box;
import me.tigreax.nova.utils.render.OGLRender;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;
import org.lwjgl.opengl.GL11;

public class StorageESP
extends Mod {
    public static float mode = 1.0f;

    public StorageESP() {
        super(new String[]{"StorageESP"}, 15105570, ModCategory.RENDER);
        this.setDescription("Renders an ESP around storage containers.");
        this.setTabName("Storage ESP");
    }

    private final float[] getColor(TileEntity tileEntity) {
        if (tileEntity instanceof TileEntityChest) {
            return new float[]{0.4f, 1.0f, 0.5f};
        }
        if (tileEntity instanceof TileEntityEnderChest) {
            return new float[]{0.0f, 1.0f, 1.0f};
        }
        if (tileEntity instanceof TileEntityBrewingStand) {
            return new float[]{0.75f, 0.25f, 0.0f};
        }
        if (tileEntity instanceof TileEntityDropper) {
            return new float[]{0.5f, 0.5f, 0.5f};
        }
        if (tileEntity instanceof TileEntityDispenser || tileEntity instanceof TileEntityFurnace || tileEntity instanceof TileEntityHopper) {
            return new float[]{1.0f, 0.0f, 0.0f};
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    @Override
    public void onDisable() {
        Wrapper.getRenderArrayList().remove(this);
    }

    @Override
    public void onEnable() {
        Wrapper.getRenderArrayList().add(this);
    }

    @EventTarget
    public void onRender(EventRender3D event) {
        block17: {
            block16: {
                if (mode != 0.0f) break block16;
                for (TileEntity tileEntity : Wrapper.getWorld().loadedTileEntityList) {
                    if (!this.shouldDraw(tileEntity)) continue;
                    double x = (double)tileEntity.getPos().getX() - RenderManager.renderPosX;
                    double y = (double)tileEntity.getPos().getY() - RenderManager.renderPosY;
                    double z = (double)tileEntity.getPos().getZ() - RenderManager.renderPosZ;
                    float[] color = this.getColor(tileEntity);
                    Box box = new Box(x, y, z, x + 1.0, y + 1.0, z + 1.0);
                    if (tileEntity instanceof TileEntityChest) {
                        TileEntityChest chest = (TileEntityChest)TileEntityChest.class.cast(tileEntity);
                        if (chest.adjacentChestZNeg != null) {
                            box = new Box(x + 0.0625, y, z - 0.9375, x + 0.9375, y + 0.875, z + 0.9375);
                        } else if (chest.adjacentChestXNeg != null) {
                            box = new Box(x + 0.9375, y, z + 0.0625, x - 0.9375, y + 0.875, z + 0.9375);
                        } else {
                            if (chest.adjacentChestZNeg != null || chest.adjacentChestXNeg != null || chest.adjacentChestXPos != null || chest.adjacentChestZPos != null) continue;
                            box = new Box(x + 0.0625, y, z + 0.0625, x + 0.9375, y + 0.875, z + 0.9375);
                        }
                    } else if (tileEntity instanceof TileEntityEnderChest) {
                        box = new Box(x + 0.0625, y, z + 0.0625, x + 0.9375, y + 0.875, z + 0.9375);
                    }
                    GL11.glColor4f((float)color[0], (float)color[1], (float)color[2], (float)0.1f);
                    GL11.glColor4f((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
                    AxisAlignedBB boundingBox1 = new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0);
                    RenderHelper.drawOutlinedBoundingBox(boundingBox1);
                }
                break block17;
            }
            if (mode != 1.0f) break block17;
            for (TileEntity tileEntity : Wrapper.getWorld().loadedTileEntityList) {
                if (!this.shouldDraw(tileEntity)) continue;
                double x = (double)tileEntity.getPos().getX() - RenderManager.renderPosX;
                double y = (double)tileEntity.getPos().getY() - RenderManager.renderPosY;
                double z = (double)tileEntity.getPos().getZ() - RenderManager.renderPosZ;
                float[] color = this.getColor(tileEntity);
                Box box = new Box(x, y, z, x + 1.0, y + 1.0, z + 1.0);
                if (tileEntity instanceof TileEntityChest) {
                    TileEntityChest chest = (TileEntityChest)TileEntityChest.class.cast(tileEntity);
                    if (chest.adjacentChestZNeg != null) {
                        box = new Box(x + 0.0625, y, z - 0.9375, x + 0.9375, y + 0.875, z + 0.9375);
                    } else if (chest.adjacentChestXNeg != null) {
                        box = new Box(x + 0.9375, y, z + 0.0625, x - 0.9375, y + 0.875, z + 0.9375);
                    } else {
                        if (chest.adjacentChestZNeg != null || chest.adjacentChestXNeg != null || chest.adjacentChestXPos != null || chest.adjacentChestZPos != null) continue;
                        box = new Box(x + 0.0625, y, z + 0.0625, x + 0.9375, y + 0.875, z + 0.9375);
                    }
                } else if (tileEntity instanceof TileEntityEnderChest) {
                    box = new Box(x + 0.0625, y, z + 0.0625, x + 0.9375, y + 0.875, z + 0.9375);
                }
                GL11.glColor4f((float)color[0], (float)color[1], (float)color[2], (float)0.1f);
                OGLRender.drawBox(box);
                GL11.glColor4f((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
                OGLRender.drawOutlinedBox(box);
            }
        }
    }

    private final boolean shouldDraw(TileEntity tileEntity) {
        if (tileEntity instanceof TileEntityChest) {
            return true;
        }
        if (tileEntity instanceof TileEntityEnderChest) {
            return true;
        }
        return tileEntity instanceof TileEntityBrewingStand || tileEntity instanceof TileEntityDispenser || tileEntity instanceof TileEntityDropper || tileEntity instanceof TileEntityFurnace || tileEntity instanceof TileEntityHopper;
    }
}

