/*
 * Decompiled with CFR 0.152.
 */
package me.tigreax.nova.module.mods.world;

import com.darkmagician6.eventapi.EventTarget;
import java.util.Arrays;
import java.util.List;
import me.tigreax.nova.Wrapper;
import me.tigreax.nova.events.EventPreUpdate;
import me.tigreax.nova.events.EventSafewalk;
import me.tigreax.nova.events.EventSendPacket;
import me.tigreax.nova.events.EventUpdatePostMotion;
import me.tigreax.nova.events.EventUpdatePreMotion;
import me.tigreax.nova.module.mods.Mod;
import me.tigreax.nova.module.mods.ModCategory;
import me.tigreax.nova.utils.TimeHelper;
import me.tigreax.nova.utils.player.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.network.play.client.C03PacketPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;

public class Scaffold
extends Mod {
    private float lastYaw;
    private float lastPitch;
    private BlockData blockData = null;
    private TimeHelper time = new TimeHelper();
    private List<Block> blacklist = Arrays.asList(Blocks.air, Blocks.water, Blocks.flowing_water, Blocks.lava, Blocks.flowing_lava);

    public Scaffold() {
        super(new String[]{"Scaffold"}, ModCategory.WORLD);
    }

    @Override
    public void onEnable() {
        Wrapper.getRenderArrayList().add(this);
        this.blockData = null;
    }

    @Override
    public void onDisable() {
        Wrapper.getRenderArrayList().remove(this);
        if (Scaffold.mc.inGameHasFocus) {
            PlayerUtils.setBindingAsInput(Scaffold.mc.gameSettings.keyBindJump);
        } else {
            Scaffold.mc.gameSettings.keyBindJump.pressed = false;
        }
    }

    @EventTarget
    public void onUpdate(EventPreUpdate event) {
        if (Minecraft.thePlayer.getHeldItem() != null) {
            if (!Minecraft.thePlayer.isSneaking()) {
                if (Minecraft.thePlayer.getHeldItem().getItem() instanceof ItemBlock) {
                    Scaffold.mc.gameSettings.keyBindJump.pressed = false;
                }
            }
        }
    }

    @EventTarget
    public void onPreMotion(EventUpdatePreMotion event) {
        this.blockData = null;
        if (Minecraft.thePlayer.getHeldItem() != null) {
            if (!Minecraft.thePlayer.isSneaking()) {
                if (Minecraft.thePlayer.getHeldItem().getItem() instanceof ItemBlock) {
                    BlockPos blockBelow = new BlockPos(Minecraft.thePlayer.posX, Minecraft.thePlayer.posY - 1.0, Minecraft.thePlayer.posZ);
                    if (Minecraft.theWorld.getBlockState(blockBelow).getBlock() == Blocks.air) {
                        this.blockData = this.getBlockData(blockBelow);
                        if (this.blockData != null) {
                            this.lastPitch = Minecraft.thePlayer.rotationPitch;
                            this.lastYaw = Minecraft.thePlayer.rotationYaw;
                            float[] values = BlockHelper.getFacingRotations(this.blockData.position.getX(), this.blockData.position.getY(), this.blockData.position.getZ(), this.blockData.face);
                            Minecraft.thePlayer.rotationYaw = values[0];
                            Minecraft.thePlayer.rotationPitch = values[1];
                        }
                    }
                }
            }
        }
    }

    @EventTarget
    public void onSendPacket(EventSendPacket event) {
        C03PacketPlayer packet;
        if (event.getPacket() instanceof C03PacketPlayer && (packet = (C03PacketPlayer)event.getPacket()).getRotating() && this.blockData != null) {
            float[] values = BlockHelper.getFacingRotations(this.blockData.position.getX(), this.blockData.position.getY(), this.blockData.position.getZ(), this.blockData.face);
            packet.yaw = values[0];
            packet.pitch = values[1];
            Minecraft.thePlayer.rotationYaw = this.lastYaw;
            Minecraft.thePlayer.rotationPitch = this.lastPitch;
        }
    }

    @EventTarget
    public void onPostMotion(EventUpdatePostMotion event) {
        if (this.blockData == null) {
            return;
        }
        if (!this.time.hasReached(75L)) {
            return;
        }
        Scaffold.mc.rightClickDelayTimer = 0;
        if (Minecraft.playerController.func_178890_a(Minecraft.thePlayer, Minecraft.theWorld, Minecraft.thePlayer.getHeldItem(), this.blockData.position, this.blockData.face, new Vec3(this.blockData.position.getX(), this.blockData.position.getY(), this.blockData.position.getZ()))) {
            Minecraft.thePlayer.swingItem();
        }
    }

    @EventTarget
    public void onWalking(EventSafewalk event) {
        if (Minecraft.thePlayer.onGround) {
            event.setShouldWalkSafely(true);
        }
    }

    public BlockData getBlockData(BlockPos pos) {
        if (!this.blacklist.contains(Minecraft.theWorld.getBlockState(pos.add(0, -1, 0)).getBlock())) {
            return new BlockData(pos.add(0, -1, 0), EnumFacing.UP);
        }
        if (!this.blacklist.contains(Minecraft.theWorld.getBlockState(pos.add(-1, 0, 0)).getBlock())) {
            return new BlockData(pos.add(-1, 0, 0), EnumFacing.EAST);
        }
        if (!this.blacklist.contains(Minecraft.theWorld.getBlockState(pos.add(1, 0, 0)).getBlock())) {
            return new BlockData(pos.add(1, 0, 0), EnumFacing.WEST);
        }
        if (!this.blacklist.contains(Minecraft.theWorld.getBlockState(pos.add(0, 0, -1)).getBlock())) {
            return new BlockData(pos.add(0, 0, -1), EnumFacing.SOUTH);
        }
        if (!this.blacklist.contains(Minecraft.theWorld.getBlockState(pos.add(0, 0, 1)).getBlock())) {
            return new BlockData(pos.add(0, 0, 1), EnumFacing.NORTH);
        }
        return null;
    }

    private class BlockData {
        public BlockPos position;
        public EnumFacing face;

        public BlockData(BlockPos position, EnumFacing face) {
            this.position = position;
            this.face = face;
        }
    }
}

