/*
 * Decompiled with CFR 0.152.
 */
package me.tigreax.nova.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class EntityHelper {
    private static Minecraft mc = Minecraft.getMinecraft();

    public static float[] getRotations(Entity ent) {
        double x = ent.posX;
        double z = ent.posZ;
        double y = ent.boundingBox.maxY - 4.5;
        return EntityHelper.getRotationFromPosition(x, z, y);
    }

    public static float[] getRotationsforBow(Entity ent) {
        double x = ent.posX;
        double z = ent.posZ;
        double y = ent.boundingBox.maxY;
        return EntityHelper.getRotationFromPosition(x, z, y + 2.0);
    }

    public static float[] getRotationFromPosition(double x, double z, double y) {
        Minecraft.getMinecraft();
        double xDiff = x - Minecraft.thePlayer.posX;
        Minecraft.getMinecraft();
        double zDiff = z - Minecraft.thePlayer.posZ;
        Minecraft.getMinecraft();
        double d = y - Minecraft.thePlayer.posY;
        Minecraft.getMinecraft();
        double yDiff = d + (double)Minecraft.thePlayer.getEyeHeight();
        double dist = MathHelper.sqrt_double(xDiff * xDiff + zDiff * zDiff);
        float yaw = (float)(Math.atan2(zDiff, xDiff) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(yDiff, dist) * 180.0 / Math.PI));
        return new float[]{yaw, pitch};
    }

    public static float getYawChangeToEntity(Entity entity) {
        double deltaX = entity.posX - Minecraft.thePlayer.posX;
        double deltaZ = entity.posZ - Minecraft.thePlayer.posZ;
        double yawToEntity1 = 0.0;
        if (deltaZ < 0.0 && deltaX < 0.0) {
            yawToEntity1 = 90.0 + Math.toDegrees(Math.atan(deltaZ / deltaX));
        } else if (deltaZ < 0.0 && deltaX > 0.0) {
            double yawToEntity11 = -90.0 + Math.toDegrees(Math.atan(deltaZ / deltaX));
        } else {
            double d = Math.toDegrees(-Math.atan(deltaX / deltaZ));
        }
        return MathHelper.wrapAngleTo180_float(-(Minecraft.thePlayer.rotationYaw - (float)yawToEntity1));
    }

    public static float getPitchChangeToEntity(Entity entity) {
        double deltaX = entity.posX - Minecraft.thePlayer.posX;
        double deltaZ = entity.posZ - Minecraft.thePlayer.posZ;
        double deltaY = entity.posY - 1.6 + (double)entity.getEyeHeight() - Minecraft.thePlayer.posY;
        double distanceXZ = MathHelper.sqrt_double(deltaX * deltaX + deltaZ * deltaZ);
        double pitchToEntity = -Math.toDegrees(Math.atan(deltaY / distanceXZ));
        return -MathHelper.wrapAngleTo180_float(Minecraft.thePlayer.rotationPitch - (float)pitchToEntity);
    }

    public static float[] getAngles(Entity e) {
        return new float[]{EntityHelper.getYawChangeToEntity(e) + Minecraft.thePlayer.rotationYaw, EntityHelper.getPitchChangeToEntity(e) + Minecraft.thePlayer.rotationPitch};
    }

    public static double getDirectionCheckVal(Entity e, Vec3 lookVec) {
        return EntityHelper.directionCheck(Minecraft.thePlayer.posX, Minecraft.thePlayer.posY + (double)Minecraft.thePlayer.getEyeHeight(), Minecraft.thePlayer.posZ, lookVec.xCoord, lookVec.yCoord, lookVec.zCoord, e.posX, e.posY + (double)e.height / 2.0, e.posZ, e.width, e.height, 5.0);
    }

    private static double directionCheck(double sourceX, double sourceY, double sourceZ, double dirX, double dirY, double dirZ, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double precision) {
        double dirLength = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        if (dirLength == 0.0) {
            dirLength = 1.0;
        }
        double dX = targetX - sourceX;
        double dY = targetY - sourceY;
        double dZ = targetZ - sourceZ;
        double targetDist = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        double xPrediction = targetDist * dirX / dirLength;
        double yPrediction = targetDist * dirY / dirLength;
        double zPrediction = targetDist * dirZ / dirLength;
        double off = 0.0;
        off += Math.max(Math.abs(dX - xPrediction) - (targetWidth / 2.0 + precision), 0.0);
        off += Math.max(Math.abs(dZ - zPrediction) - (targetWidth / 2.0 + precision), 0.0);
        if ((off += Math.max(Math.abs(dY - yPrediction) - (targetHeight / 2.0 + precision), 0.0)) > 1.0) {
            off = Math.sqrt(off);
        }
        return off;
    }
}

