/*
 * Decompiled with CFR 0.152.
 */
package me.tigreax.nova.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;

public class GuiUtils {
    private static FontRenderer fr = Minecraft.getMinecraft().fontRendererObj;

    public static void drawCentredStringWithShadow(String s, int x, int y, int colour) {
        fr.drawString(s, x -= fr.getStringWidth(s) / 2, y, colour);
    }

    public static void drawRect(int x, int y, int x2, int y2, int color) {
        GuiUtils.drawRect(x, y, x2, y2, color);
    }

    public static void drawRect(float paramXStart, float paramYStart, float paramXEnd, float paramYEnd, int paramColor) {
        float alpha = (float)(paramColor >> 24 & 0xFF) / 255.0f;
        float red = (float)(paramColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(paramColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(paramColor & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glPushMatrix();
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)paramXEnd, (double)paramYStart);
        GL11.glVertex2d((double)paramXStart, (double)paramYStart);
        GL11.glVertex2d((double)paramXStart, (double)paramYEnd);
        GL11.glVertex2d((double)paramXEnd, (double)paramYEnd);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public static void drawPoint(int x, int y, int color) {
        GuiUtils.drawRect(x, y, x + 1, y + 1, color);
    }

    public static void drawVerticalLine(int x, int y, int height, int color) {
        GuiUtils.drawRect(x, y, x + 1, height, color);
    }

    public static void drawHorizontalLine(int x, int y, int width, int color) {
        GuiUtils.drawRect(x, y, width, y + 1, color);
    }

    public static void drawBorderedRect(int x, int y, int x1, int y1, int bord, int color) {
        GuiUtils.drawRect(x + 1, y + 1, x1, y1, color);
        GuiUtils.drawVerticalLine(x, y, y1, bord);
        GuiUtils.drawVerticalLine(x1, y, y1, bord);
        GuiUtils.drawHorizontalLine(x + 1, y, x1, bord);
        GuiUtils.drawHorizontalLine(x, y1, x1 + 1, bord);
    }

    public static void drawFineBorderedRect(int x, int y, int x1, int y1, int bord, int color) {
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GuiUtils.drawRect((x *= 2) + 1, (y *= 2) + 1, x1 *= 2, y1 *= 2, color);
        GuiUtils.drawVerticalLine(x, y, y1, bord);
        GuiUtils.drawVerticalLine(x1, y, y1, bord);
        GuiUtils.drawHorizontalLine(x + 1, y, x1, bord);
        GuiUtils.drawHorizontalLine(x, y1, x1 + 1, bord);
        GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
    }

    public static void drawBorderRectNoCorners(int x, int y, int x2, int y2, int bord, int color) {
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GuiUtils.drawRect((x *= 2) + 1, (y *= 2) + 1, x2 *= 2, y2 *= 2, color);
        GuiUtils.drawVerticalLine(x, y + 1, y2, bord);
        GuiUtils.drawVerticalLine(x2, y + 1, y2, bord);
        GuiUtils.drawHorizontalLine(x + 1, y, x2, bord);
        GuiUtils.drawHorizontalLine(x + 1, y2, x2, bord);
        GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
    }

    public static void drawBorderedGradient(int x, int y, int x1, int y1, int bord, int gradTop, int gradBot) {
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        x *= 2;
        y *= 2;
        x1 *= 2;
        y1 *= 2;
        float f = (float)(gradTop >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(gradTop >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(gradTop >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(gradTop & 0xFF) / 255.0f;
        float f4 = (float)(gradBot >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(gradBot >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(gradBot >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(gradBot & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        GL11.glBegin((int)7);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glVertex2d((double)x1, (double)(y + 1));
        GL11.glVertex2d((double)(x + 1), (double)(y + 1));
        GL11.glColor4f((float)f5, (float)f6, (float)f7, (float)f4);
        GL11.glVertex2d((double)(x + 1), (double)y1);
        GL11.glVertex2d((double)x1, (double)y1);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
        GL11.glShadeModel((int)7424);
        GuiUtils.drawVLine(x, y, y1 - 1, bord);
        GuiUtils.drawVLine(x1 - 1, y, y1 - 1, bord);
        GuiUtils.drawHLine(x, x1 - 1, y, bord);
        GuiUtils.drawHLine(x, x1 - 1, y1 - 1, bord);
        GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
    }

    public static void drawHLine(float par1, float par2, float par3, int par4) {
        if (par2 < par1) {
            float var5 = par1;
            par1 = par2;
            par2 = var5;
        }
        GuiUtils.drawRect(par1, par3, par2 + 1.0f, par3 + 1.0f, par4);
    }

    public static void drawVLine(float par1, float par2, float par3, int par4) {
        if (par3 < par2) {
            float var5 = par2;
            par2 = par3;
            par3 = var5;
        }
        GuiUtils.drawRect(par1, par2 + 1.0f, par1 + 1.0f, par3, par4);
    }

    public static void drawGradientBorderedRect(double x, double y, double x2, double y2, float l1, int col1, int col2, int col3) {
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glLineWidth((float)1.0f);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glPopMatrix();
        GuiUtils.drawGradientRect(x, y, x2, y2, col2, col3);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2848);
    }

    public static void drawGradientRect(double x, double y, double x2, double y2, int col1, int col2) {
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        float f4 = (float)(col2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(col2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(col2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(col2 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        GL11.glBegin((int)7);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glColor4f((float)f5, (float)f6, (float)f7, (float)f4);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
        GL11.glShadeModel((int)7424);
    }

    public static void drawSidewaysGradientRect(double x, double y, double x2, double y2, int col1, int col2) {
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        float f4 = (float)(col2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(col2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(col2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(col2 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        GL11.glBegin((int)7);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glColor4f((float)f5, (float)f6, (float)f7, (float)f4);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
        GL11.glShadeModel((int)7424);
    }

    public static void drawBorderedCircle(int x, int y, float radius, int outsideC, int insideC) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glPushMatrix();
        float scale = 0.1f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        x = (int)((float)x * (1.0f / scale));
        y = (int)((float)y * (1.0f / scale));
        GuiUtils.drawCircle(x, y, radius *= 1.0f / scale, insideC);
        GuiUtils.drawUnfilledCircle(x, y, radius, 1.0f, outsideC);
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public static void drawUnfilledCircle(int x, int y, float radius, float lineWidth, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glLineWidth((float)lineWidth);
        GL11.glEnable((int)2848);
        GL11.glBegin((int)2);
        int i = 0;
        while (i <= 360) {
            GL11.glVertex2d((double)((double)x + Math.sin((double)i * 3.141526 / 180.0) * (double)radius), (double)((double)y + Math.cos((double)i * 3.141526 / 180.0) * (double)radius));
            ++i;
        }
        GL11.glEnd();
        GL11.glDisable((int)2848);
    }

    public static void drawCircle(int x, int y, float radius, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glBegin((int)9);
        int i = 0;
        while (i <= 360) {
            GL11.glVertex2d((double)((double)x + Math.sin((double)i * 3.141526 / 180.0) * (double)radius), (double)((double)y + Math.cos((double)i * 3.141526 / 180.0) * (double)radius));
            ++i;
        }
        GL11.glEnd();
    }

    public static double getAlphaFromHex(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static double getRedFromHex(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static double getGreenFromHex(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static double getBlueFromHex(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }
}

