/*
 * Decompiled with CFR 0.152.
 */
package me.tigreax.nova.utils.yggdrasil;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;

public class EntityUtils {
    public static Minecraft MINECRAFT = Minecraft.getMinecraft();

    public static float[] getEntityRotations(Entity target) {
        double var4 = target.posX - Minecraft.thePlayer.posX;
        double var6 = target.posZ - Minecraft.thePlayer.posZ;
        double var8 = target.posY + (double)target.getEyeHeight() / 1.3 - (Minecraft.thePlayer.posY + (double)Minecraft.thePlayer.getEyeHeight());
        double var14 = MathHelper.sqrt_double(var4 * var4 + var6 * var6);
        float yaw = (float)(Math.atan2(var6, var4) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(var8, var14) * 180.0 / Math.PI));
        return new float[]{yaw, pitch};
    }

    public static float getAngle(float[] original, float[] rotations) {
        float curYaw = EntityUtils.normalizeAngle(original[0]);
        rotations[0] = EntityUtils.normalizeAngle(rotations[0]);
        float curPitch = EntityUtils.normalizeAngle(original[1]);
        rotations[1] = EntityUtils.normalizeAngle(rotations[1]);
        float fixedYaw = EntityUtils.normalizeAngle(curYaw - rotations[0]);
        float fixedPitch = EntityUtils.normalizeAngle(curPitch - rotations[1]);
        return Math.abs(EntityUtils.normalizeAngle(fixedYaw) + Math.abs(fixedPitch));
    }

    public static float getAngle(float[] rotations) {
        return EntityUtils.getAngle(new float[]{Minecraft.thePlayer.rotationYaw, Minecraft.thePlayer.rotationPitch}, rotations);
    }

    public static float normalizeAngle(float angle) {
        return MathHelper.wrapAngleTo180_float((angle + 180.0f) % 360.0f - 180.0f);
    }

    public static float getPitchChange(EntityLivingBase entity) {
        double deltaX = entity.posX - Minecraft.thePlayer.posX;
        double deltaZ = entity.posZ - Minecraft.thePlayer.posZ;
        double deltaY = entity.posY - 2.2 + (double)entity.getEyeHeight() - Minecraft.thePlayer.posY;
        double distanceXZ = MathHelper.sqrt_double(deltaX * deltaX + deltaZ * deltaZ);
        double pitchToEntity = -Math.toDegrees(Math.atan(deltaY / distanceXZ));
        return -MathHelper.wrapAngleTo180_float(Minecraft.thePlayer.rotationPitch - (float)pitchToEntity);
    }

    public static float getYawChange(EntityLivingBase entity) {
        double deltaX = entity.posX - Minecraft.thePlayer.posX;
        double deltaZ = entity.posZ - Minecraft.thePlayer.posZ;
        double yawToEntity = deltaZ < 0.0 && deltaX < 0.0 ? 90.0 + Math.toDegrees(Math.atan(deltaZ / deltaX)) : (deltaZ < 0.0 && deltaX > 0.0 ? -90.0 + Math.toDegrees(Math.atan(deltaZ / deltaX)) : Math.toDegrees(-Math.atan(deltaX / deltaZ)));
        return MathHelper.wrapAngleTo180_float(-(Minecraft.thePlayer.rotationYaw - (float)yawToEntity));
    }
}

