/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.state.pattern;

import com.google.common.base.Predicate;
import me.tigreax.nova.utils.EntityHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;

public class BlockHelper
implements Predicate {
    private final Block block;

    public static BlockHelper forBlock(Block p_177642_0_) {
        return new BlockHelper(p_177642_0_);
    }

    private BlockHelper(Block p_i45654_1_) {
        this.block = p_i45654_1_;
    }

    public boolean apply(Object p_apply_1_) {
        return this.isBlockEqualTo((IBlockState)p_apply_1_);
    }

    public boolean isBlockEqualTo(IBlockState p_177643_1_) {
        return p_177643_1_ != null && p_177643_1_.getBlock() == this.block;
    }

    public static Block getBlock(int x, int y, int z) {
        return Minecraft.theWorld.getBlockState(new BlockPos(x, y, z)).getBlock();
    }

    public static boolean isOnLiquid() {
        boolean onLiquid = false;
        int y = (int)Minecraft.thePlayer.getEntityBoundingBox().offset((double)0.0, (double)-0.01, (double)0.0).minY;
        int x = MathHelper.floor_double(Minecraft.thePlayer.getEntityBoundingBox().minX);
        while (x < MathHelper.floor_double(Minecraft.thePlayer.getEntityBoundingBox().maxX) + 1) {
            int z = MathHelper.floor_double(Minecraft.thePlayer.getEntityBoundingBox().minZ);
            while (z < MathHelper.floor_double(Minecraft.thePlayer.getEntityBoundingBox().maxZ) + 1) {
                Block block = BlockHelper.getBlock(x, y, z);
                if (block != null && !(block instanceof BlockAir)) {
                    if (!(block instanceof BlockLiquid)) {
                        return false;
                    }
                    onLiquid = true;
                }
                ++z;
            }
            ++x;
        }
        return onLiquid;
    }

    public static boolean isInLiquid() {
        boolean inLiquid = false;
        int y = (int)Minecraft.thePlayer.getEntityBoundingBox().minY;
        int x = MathHelper.floor_double(Minecraft.thePlayer.getEntityBoundingBox().minX);
        while (x < MathHelper.floor_double(Minecraft.thePlayer.getEntityBoundingBox().maxX) + 1) {
            int z = MathHelper.floor_double(Minecraft.thePlayer.getEntityBoundingBox().minZ);
            while (z < MathHelper.floor_double(Minecraft.thePlayer.getEntityBoundingBox().maxZ) + 1) {
                Block block = BlockHelper.getBlock(x, y, z);
                if (block != null && !(block instanceof BlockAir)) {
                    if (!(block instanceof BlockLiquid)) {
                        return false;
                    }
                    inLiquid = true;
                }
                ++z;
            }
            ++x;
        }
        return inLiquid;
    }

    public static boolean isOnLadder() {
        boolean onLadder = false;
        int y = (int)Minecraft.thePlayer.getEntityBoundingBox().offset((double)0.0, (double)1.0, (double)0.0).minY;
        int x = MathHelper.floor_double(Minecraft.thePlayer.getEntityBoundingBox().minX);
        while (x < MathHelper.floor_double(Minecraft.thePlayer.getEntityBoundingBox().maxX) + 1) {
            int z = MathHelper.floor_double(Minecraft.thePlayer.getEntityBoundingBox().minZ);
            while (z < MathHelper.floor_double(Minecraft.thePlayer.getEntityBoundingBox().maxZ) + 1) {
                Block block = BlockHelper.getBlock(x, y, z);
                if (block != null && !(block instanceof BlockAir)) {
                    if (!(block instanceof BlockLadder)) {
                        return false;
                    }
                    onLadder = true;
                }
                ++z;
            }
            ++x;
        }
        return onLadder || Minecraft.thePlayer.isOnLadder();
    }

    public static boolean canSeeBlock(int x, int y, int z) {
        return BlockHelper.getFacing(new BlockPos(x, y, z)) != null;
    }

    public static EnumFacing getFacing(BlockPos pos) {
        EnumFacing[] orderedValues;
        EnumFacing[] enumFacingArray = orderedValues = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.DOWN};
        int n = orderedValues.length;
        int n2 = 0;
        while (n2 < n) {
            EnumFacing facing = enumFacingArray[n2];
            EntitySnowball temp = new EntitySnowball(Minecraft.theWorld);
            temp.posX = (double)pos.getX() + 0.5;
            temp.posY = (double)pos.getY() + 0.5;
            temp.posZ = (double)pos.getZ() + 0.5;
            temp.posX += (double)facing.getDirectionVec().getX() * 0.5;
            temp.posY += (double)facing.getDirectionVec().getY() * 0.5;
            temp.posZ += (double)facing.getDirectionVec().getZ() * 0.5;
            if (Minecraft.thePlayer.canEntityBeSeen(temp)) {
                return facing;
            }
            ++n2;
        }
        return null;
    }

    public static float[] getFacingRotations(int x, int y, int z, EnumFacing facing) {
        EntitySnowball temp = new EntitySnowball(Minecraft.theWorld);
        temp.posX = (double)x + 0.5;
        temp.posY = (double)y + 0.5;
        temp.posZ = (double)z + 0.5;
        temp.posX += (double)facing.getDirectionVec().getX() * 0.25;
        temp.posY += (double)facing.getDirectionVec().getY() * 0.25;
        temp.posZ += (double)facing.getDirectionVec().getZ() * 0.25;
        return EntityHelper.getAngles(temp);
    }
}

