/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity;

import com.mojang.authlib.GameProfile;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.src.Config;
import net.minecraft.src.PlayerConfigurations;
import net.minecraft.src.Reflector;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractClientPlayer
extends EntityPlayer {
    private NetworkPlayerInfo field_175157_a;
    private ResourceLocation ofLocationCape = null;
    private ResourceLocation customCape = null;

    public static ThreadDownloadImageData getDownloadImageSkin(ResourceLocation resourceLocationIn, String username) {
        TextureManager var2 = Minecraft.getMinecraft().getTextureManager();
        ITextureObject var3 = var2.getTexture(resourceLocationIn);
        if (var3 == null) {
            var3 = new ThreadDownloadImageData(null, String.format("http://skins.minecraft.net/MinecraftSkins/%s.png", StringUtils.stripControlCodes(username)), DefaultPlayerSkin.func_177334_a(EntityPlayer.func_175147_b(username)), new ImageBufferDownload());
            var2.loadTexture(resourceLocationIn, var3);
        }
        return (ThreadDownloadImageData)var3;
    }

    public static ResourceLocation getLocationSkin(String username) {
        return new ResourceLocation("skins/" + StringUtils.stripControlCodes(username));
    }

    public AbstractClientPlayer(World worldIn, GameProfile p_i45074_2_) {
        super(worldIn, p_i45074_2_);
        String username = p_i45074_2_.getName();
        this.downloadCustomCape(username);
        this.downloadCape(username);
        PlayerConfigurations.getPlayerConfiguration(this);
    }

    private void downloadCape(String username) {
        if (username != null && !username.isEmpty()) {
            username = StringUtils.stripControlCodes(username);
            String ofCapeUrl = "";
            String mptHash = FilenameUtils.getBaseName((String)ofCapeUrl);
            final ResourceLocation rl = new ResourceLocation("capeof/" + mptHash);
            TextureManager textureManager = Minecraft.getMinecraft().getTextureManager();
            ITextureObject tex = textureManager.getTexture(rl);
            if (tex != null && tex instanceof ThreadDownloadImageData) {
                ThreadDownloadImageData iib = (ThreadDownloadImageData)tex;
                if (iib.imageFound != null) {
                    if (iib.imageFound.booleanValue()) {
                        this.ofLocationCape = rl;
                    }
                    return;
                }
            }
            IImageBuffer iib1 = new IImageBuffer(){
                ImageBufferDownload ibd = new ImageBufferDownload();

                @Override
                public void func_152634_a() {
                    AbstractClientPlayer.this.ofLocationCape = rl;
                }

                @Override
                public BufferedImage parseUserSkin(BufferedImage var1) {
                    return AbstractClientPlayer.this.parseCape(var1);
                }
            };
            ThreadDownloadImageData textureCape = new ThreadDownloadImageData(null, ofCapeUrl, null, iib1);
            textureManager.loadTexture(rl, textureCape);
        }
    }

    private void downloadCustomCape(String username) {
        if (username != null && !username.isEmpty()) {
            username = StringUtils.stripControlCodes(username);
            String ofCapeUrl = "http://minecraftcapes.co.uk/CapePictures/Minecon-capes/capeFile/2012.png";
            String mptHash = FilenameUtils.getBaseName((String)ofCapeUrl);
            final ResourceLocation rl = new ResourceLocation("capeof/" + mptHash);
            TextureManager textureManager = Minecraft.getMinecraft().getTextureManager();
            ITextureObject tex = textureManager.getTexture(rl);
            if (tex != null && tex instanceof ThreadDownloadImageData) {
                ThreadDownloadImageData iib = (ThreadDownloadImageData)tex;
                if (iib.imageFound != null) {
                    if (iib.imageFound.booleanValue()) {
                        this.customCape = rl;
                    }
                    return;
                }
            }
            IImageBuffer iib1 = new IImageBuffer(){
                ImageBufferDownload ibd = new ImageBufferDownload();

                @Override
                public void func_152634_a() {
                    AbstractClientPlayer.this.customCape = rl;
                }

                @Override
                public BufferedImage parseUserSkin(BufferedImage var1) {
                    return AbstractClientPlayer.this.parseCape(var1);
                }
            };
            ThreadDownloadImageData textureCape = new ThreadDownloadImageData(null, ofCapeUrl, null, iib1);
            textureManager.loadTexture(rl, textureCape);
        }
    }

    @Override
    public boolean func_175149_v() {
        NetworkPlayerInfo var1 = Minecraft.getMinecraft().getNetHandler().func_175102_a(this.getGameProfile().getId());
        return var1 != null && var1.getGameType() == WorldSettings.GameType.SPECTATOR;
    }

    public String func_175154_l() {
        NetworkPlayerInfo var1 = this.func_175155_b();
        return var1 == null ? DefaultPlayerSkin.func_177332_b(this.getUniqueID()) : var1.func_178851_f();
    }

    protected NetworkPlayerInfo func_175155_b() {
        if (this.field_175157_a == null) {
            this.field_175157_a = Minecraft.getMinecraft().getNetHandler().func_175102_a(this.getUniqueID());
        }
        return this.field_175157_a;
    }

    public float func_175156_o() {
        float var1 = 1.0f;
        if (this.capabilities.isFlying) {
            var1 *= 1.1f;
        }
        IAttributeInstance var2 = this.getEntityAttribute(SharedMonsterAttributes.movementSpeed);
        var1 = (float)((double)var1 * ((var2.getAttributeValue() / (double)this.capabilities.getWalkSpeed() + 1.0) / 2.0));
        if (this.capabilities.getWalkSpeed() == 0.0f || Float.isNaN(var1) || Float.isInfinite(var1)) {
            var1 = 1.0f;
        }
        if (this.isUsingItem() && this.getItemInUse().getItem() == Items.bow) {
            int var3 = this.getItemInUseDuration();
            float var4 = (float)var3 / 20.0f;
            var4 = var4 > 1.0f ? 1.0f : (var4 *= var4);
            var1 *= 1.0f - var4 * 0.15f;
        }
        return Reflector.ForgeHooksClient_getOffsetFOV.exists() ? Reflector.callFloat(Reflector.ForgeHooksClient_getOffsetFOV, this, Float.valueOf(var1)) : var1;
    }

    public ResourceLocation getLocationCape() {
        if (!Config.isShowCapes()) {
            return null;
        }
        if (this.customCape != null) {
            return this.customCape;
        }
        if (this.ofLocationCape != null) {
            return this.ofLocationCape;
        }
        NetworkPlayerInfo var1 = this.func_175155_b();
        return var1 == null ? null : var1.func_178861_h();
    }

    public ResourceLocation getLocationSkin() {
        NetworkPlayerInfo var1 = this.func_175155_b();
        return var1 == null ? DefaultPlayerSkin.func_177334_a(this.getUniqueID()) : var1.func_178837_g();
    }

    public boolean hasCape() {
        return this.func_175155_b() != null;
    }

    public boolean hasSkin() {
        NetworkPlayerInfo var1 = this.func_175155_b();
        return var1 != null && var1.func_178856_e();
    }

    private BufferedImage parseCape(BufferedImage img) {
        int imageWidth = 64;
        int imageHeight = 32;
        int srcWidth = img.getWidth();
        int srcHeight = img.getHeight();
        while (imageWidth < srcWidth || imageHeight < srcHeight) {
            imageWidth *= 2;
            imageHeight *= 2;
        }
        BufferedImage imgNew = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics g = imgNew.getGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return imgNew;
    }
}

