/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiOptionSlider;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.src.GuiAnimationSettingsOF;
import net.minecraft.src.GuiDetailSettingsOF;
import net.minecraft.src.GuiOtherSettingsOF;
import net.minecraft.src.GuiPerformanceSettingsOF;
import net.minecraft.src.GuiQualitySettingsOF;

public class GuiVideoSettings
extends GuiScreen {
    private static GameSettings.Options[] videoOptions = new GameSettings.Options[]{GameSettings.Options.GRAPHICS, GameSettings.Options.RENDER_DISTANCE, GameSettings.Options.AMBIENT_OCCLUSION, GameSettings.Options.FRAMERATE_LIMIT, GameSettings.Options.AO_LEVEL, GameSettings.Options.VIEW_BOBBING, GameSettings.Options.GUI_SCALE, GameSettings.Options.USE_VBO, GameSettings.Options.GAMMA, GameSettings.Options.BLOCK_ALTERNATIVES, GameSettings.Options.FOG_FANCY, GameSettings.Options.FOG_START, GameSettings.Options.ANAGLYPH};
    private final GuiScreen parentGuiScreen;
    protected String screenTitle = "Video Settings";
    private final GameSettings guiGameSettings;
    private boolean is64bit;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private long mouseStillTime = 0L;

    public static int getButtonHeight(GuiButton btn) {
        return btn.height;
    }

    public static int getButtonWidth(GuiButton btn) {
        return btn.width;
    }

    public GuiVideoSettings(GuiScreen par1GuiScreen, GameSettings par2GameSettings) {
        this.parentGuiScreen = par1GuiScreen;
        this.guiGameSettings = par2GameSettings;
    }

    @Override
    protected void actionPerformed(GuiButton par1GuiButton) throws IOException {
        if (par1GuiButton.enabled) {
            int var2 = this.guiGameSettings.guiScale;
            if (par1GuiButton.id < 200 && par1GuiButton instanceof GuiOptionButton) {
                this.guiGameSettings.setOptionValue(((GuiOptionButton)par1GuiButton).returnEnumOptions(), 1);
                par1GuiButton.displayString = this.guiGameSettings.getKeyBinding(GameSettings.Options.getEnumOptions(par1GuiButton.id));
            }
            if (par1GuiButton.id == 200) {
                this.mc.gameSettings.saveOptions();
                this.mc.displayGuiScreen(this.parentGuiScreen);
            }
            if (this.guiGameSettings.guiScale != var2) {
                ScaledResolution scr = new ScaledResolution(this.mc, this.mc.displayWidth, this.mc.displayHeight);
                int var4 = scr.getScaledWidth();
                int var5 = scr.getScaledHeight();
                this.setWorldAndResolution(this.mc, var4, var5);
            }
            if (par1GuiButton.id == 201) {
                this.mc.gameSettings.saveOptions();
                GuiDetailSettingsOF scr1 = new GuiDetailSettingsOF(this, this.guiGameSettings);
                this.mc.displayGuiScreen(scr1);
            }
            if (par1GuiButton.id == 202) {
                this.mc.gameSettings.saveOptions();
                GuiQualitySettingsOF scr2 = new GuiQualitySettingsOF(this, this.guiGameSettings);
                this.mc.displayGuiScreen(scr2);
            }
            if (par1GuiButton.id == 211) {
                this.mc.gameSettings.saveOptions();
                GuiAnimationSettingsOF scr3 = new GuiAnimationSettingsOF(this, this.guiGameSettings);
                this.mc.displayGuiScreen(scr3);
            }
            if (par1GuiButton.id == 212) {
                this.mc.gameSettings.saveOptions();
                GuiPerformanceSettingsOF scr4 = new GuiPerformanceSettingsOF(this, this.guiGameSettings);
                this.mc.displayGuiScreen(scr4);
            }
            if (par1GuiButton.id == 222) {
                this.mc.gameSettings.saveOptions();
                GuiOtherSettingsOF scr5 = new GuiOtherSettingsOF(this, this.guiGameSettings);
                this.mc.displayGuiScreen(scr5);
            }
            if (par1GuiButton.id == GameSettings.Options.AO_LEVEL.ordinal()) {
                return;
            }
        }
    }

    @Override
    public void drawScreen(int x, int y, float z) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, this.screenTitle, this.width / 2, this.is64bit ? 20 : 5, 0xFFFFFF);
        if (this.is64bit || this.guiGameSettings.renderDistanceChunks > 8) {
            // empty if block
        }
        super.drawScreen(x, y, z);
        if (Math.abs(x - this.lastMouseX) <= 5 && Math.abs(y - this.lastMouseY) <= 5) {
            int activateDelay = 700;
            if (System.currentTimeMillis() >= this.mouseStillTime + (long)activateDelay) {
                int x1 = this.width / 2 - 150;
                int y1 = height / 6 - 5;
                if (y <= y1 + 98) {
                    y1 += 105;
                }
                int x2 = x1 + 150 + 150;
                int y2 = y1 + 84 + 10;
                GuiButton btn = this.getSelectedButton(x, y);
                if (btn != null) {
                    String s = this.getButtonName(btn.displayString);
                    String[] lines = this.getTooltipLines(s);
                    if (lines == null) {
                        return;
                    }
                    this.drawGradientRect(x1, y1, x2, y2, -536870912, -536870912);
                    int i = 0;
                    while (i < lines.length) {
                        String line = lines[i];
                        this.fontRendererObj.func_175063_a(line, x1 + 5, y1 + 5 + i * 11, 0xDDDDDD);
                        ++i;
                    }
                }
            }
        } else {
            this.lastMouseX = x;
            this.lastMouseY = y;
            this.mouseStillTime = System.currentTimeMillis();
        }
    }

    private String getButtonName(String displayString) {
        int pos = displayString.indexOf(58);
        return pos < 0 ? displayString : displayString.substring(0, pos);
    }

    private GuiButton getSelectedButton(int i, int j) {
        int k = 0;
        while (k < this.buttonList.size()) {
            boolean flag;
            GuiButton btn = (GuiButton)this.buttonList.get(k);
            boolean bl = flag = i >= btn.xPosition && j >= btn.yPosition && i < btn.xPosition + btn.width && j < btn.yPosition + btn.height;
            if (flag) {
                return btn;
            }
            ++k;
        }
        return null;
    }

    private String[] getTooltipLines(String btnName) {
        String[] stringArray;
        if (btnName.equals("Graphics")) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "Visual quality";
            stringArray2[1] = "  Fast  - lower quality, faster";
            stringArray2[2] = "  Fancy - higher quality, slower";
            stringArray2[3] = "Changes the appearance of clouds, leaves, water,";
            stringArray = stringArray2;
            stringArray2[4] = "shadows and grass sides.";
        } else if (btnName.equals("Render Distance")) {
            String[] stringArray3 = new String[8];
            stringArray3[0] = "Visible distance";
            stringArray3[1] = "  2 Tiny - 32m (fastest)";
            stringArray3[2] = "  4 Short - 64m (faster)";
            stringArray3[3] = "  8 Normal - 128m";
            stringArray3[4] = "  16 Far - 256m (slower)";
            stringArray3[5] = "  32 Extreme - 512m (slowest!)";
            stringArray3[6] = "The Extreme view distance is very resource demanding!";
            stringArray = stringArray3;
            stringArray3[7] = "Values over 16 Far are only effective in local worlds.";
        } else if (btnName.equals("Smooth Lighting")) {
            String[] stringArray4 = new String[4];
            stringArray4[0] = "Smooth lighting";
            stringArray4[1] = "  OFF - no smooth lighting (faster)";
            stringArray4[2] = "  Minimum - simple smooth lighting (slower)";
            stringArray = stringArray4;
            stringArray4[3] = "  Maximum - complex smooth lighting (slowest)";
        } else if (btnName.equals("Smooth Lighting Level")) {
            String[] stringArray5 = new String[4];
            stringArray5[0] = "Smooth lighting level";
            stringArray5[1] = "  OFF - no shadows";
            stringArray5[2] = "  50% - light shadows";
            stringArray = stringArray5;
            stringArray5[3] = "  100% - dark shadows";
        } else if (btnName.equals("Max Framerate")) {
            String[] stringArray6 = new String[6];
            stringArray6[0] = "Max framerate";
            stringArray6[1] = "  VSync - limit to monitor framerate (60, 30, 20)";
            stringArray6[2] = "  5-255 - variable";
            stringArray6[3] = "  Unlimited - no limit (fastest)";
            stringArray6[4] = "The framerate limit decreases the FPS even if";
            stringArray = stringArray6;
            stringArray6[5] = "the limit value is not reached.";
        } else if (btnName.equals("View Bobbing")) {
            String[] stringArray7 = new String[2];
            stringArray7[0] = "More realistic movement.";
            stringArray = stringArray7;
            stringArray7[1] = "When using mipmaps set it to OFF for best results.";
        } else if (btnName.equals("GUI Scale")) {
            String[] stringArray8 = new String[2];
            stringArray8[0] = "GUI Scale";
            stringArray = stringArray8;
            stringArray8[1] = "Smaller GUI might be faster";
        } else if (btnName.equals("Server Textures")) {
            String[] stringArray9 = new String[2];
            stringArray9[0] = "Server textures";
            stringArray = stringArray9;
            stringArray9[1] = "Use the resource pack recommended by the server";
        } else if (btnName.equals("Advanced OpenGL")) {
            String[] stringArray10 = new String[6];
            stringArray10[0] = "Detect and render only visible geometry";
            stringArray10[1] = "  OFF - all geometry is rendered (slower)";
            stringArray10[2] = "  Fast - only visible geometry is rendered (fastest)";
            stringArray10[3] = "  Fancy - conservative, avoids visual artifacts (faster)";
            stringArray10[4] = "The option is available only if it is supported by the ";
            stringArray = stringArray10;
            stringArray10[5] = "graphic card.";
        } else if (btnName.equals("Fog")) {
            String[] stringArray11 = new String[6];
            stringArray11[0] = "Fog type";
            stringArray11[1] = "  Fast - faster fog";
            stringArray11[2] = "  Fancy - slower fog, looks better";
            stringArray11[3] = "  OFF - no fog, fastest";
            stringArray11[4] = "The fancy fog is available only if it is supported by the ";
            stringArray = stringArray11;
            stringArray11[5] = "graphic card.";
        } else if (btnName.equals("Fog Start")) {
            String[] stringArray12 = new String[4];
            stringArray12[0] = "Fog start";
            stringArray12[1] = "  0.2 - the fog starts near the player";
            stringArray12[2] = "  0.8 - the fog starts far from the player";
            stringArray = stringArray12;
            stringArray12[3] = "This option usually does not affect the performance.";
        } else if (btnName.equals("Brightness")) {
            String[] stringArray13 = new String[5];
            stringArray13[0] = "Increases the brightness of darker objects";
            stringArray13[1] = "  OFF - standard brightness";
            stringArray13[2] = "  100% - maximum brightness for darker objects";
            stringArray13[3] = "This options does not change the brightness of ";
            stringArray = stringArray13;
            stringArray13[4] = "fully black objects";
        } else if (btnName.equals("Chunk Loading")) {
            String[] stringArray14 = new String[8];
            stringArray14[0] = "Chunk Loading";
            stringArray14[1] = "  Default - unstable FPS when loading chunks";
            stringArray14[2] = "  Smooth - stable FPS";
            stringArray14[3] = "  Multi-Core - stable FPS, 3x faster world loading";
            stringArray14[4] = "Smooth and Multi-Core remove the stuttering and ";
            stringArray14[5] = "freezes caused by chunk loading.";
            stringArray14[6] = "Multi-Core can speed up 3x the world loading and";
            stringArray = stringArray14;
            stringArray14[7] = "increase FPS by using a second CPU core.";
        } else if (btnName.equals("Alternate Blocks")) {
            String[] stringArray15 = new String[3];
            stringArray15[0] = "Alternate Blocks";
            stringArray15[1] = "Uses alternative block models for some blocks.";
            stringArray = stringArray15;
            stringArray15[2] = "Depends on the selected resource pack.";
        } else if (btnName.equals("Use VBOs")) {
            String[] stringArray16 = new String[3];
            stringArray16[0] = "Vertex Buffer Objects";
            stringArray16[1] = "Uses an alternative rendering model which is usually";
            stringArray = stringArray16;
            stringArray16[2] = "faster (5-10%) than the default rendering.";
        } else if (btnName.equals("3D Anaglyph")) {
            String[] stringArray17 = new String[4];
            stringArray17[0] = "3D Anaglyph";
            stringArray17[1] = "Enables a stereoscopic 3D effect using different colors";
            stringArray17[2] = "for each eye.";
            stringArray = stringArray17;
            stringArray17[3] = "Requires red-cyan glasses for proper viewing.";
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @Override
    public void initGui() {
        String[] var1;
        this.screenTitle = I18n.format("options.videoTitle", new Object[0]);
        this.buttonList.clear();
        this.is64bit = false;
        String[] var2 = var1 = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"};
        int var3 = var1.length;
        int var8 = 0;
        while (var8 < var3) {
            String var9 = var2[var8];
            String var10 = System.getProperty(var9);
            if (var10 != null && var10.contains("64")) {
                this.is64bit = true;
                break;
            }
            ++var8;
        }
        GameSettings.Options[] var13 = videoOptions;
        int var14 = var13.length;
        int var15 = 0;
        while (var15 < var14) {
            GameSettings.Options y = var13[var15];
            if (y != null) {
                int x = this.width / 2 - 155 + var15 % 2 * 160;
                int y1 = height / 6 + 21 * (var15 / 2) - 10;
                if (y.getEnumFloat()) {
                    this.buttonList.add(new GuiOptionSlider(y.returnEnumOrdinal(), x, y1, y));
                } else {
                    this.buttonList.add(new GuiOptionButton(y.returnEnumOrdinal(), x, y1, y, this.guiGameSettings.getKeyBinding(y)));
                }
            }
            ++var15;
        }
        int var16 = height / 6 + 21 * (var15 / 2) - 10;
        int x = this.width / 2 - 155 + 160;
        this.buttonList.add(new GuiOptionButton(202, x, var16, "Quality..."));
        x = this.width / 2 - 155 + 0;
        this.buttonList.add(new GuiOptionButton(201, x, var16 += 21, "Details..."));
        x = this.width / 2 - 155 + 160;
        this.buttonList.add(new GuiOptionButton(212, x, var16, "Performance..."));
        x = this.width / 2 - 155 + 0;
        this.buttonList.add(new GuiOptionButton(211, x, var16 += 21, "Animations..."));
        x = this.width / 2 - 155 + 160;
        this.buttonList.add(new GuiOptionButton(222, x, var16, "Other..."));
        this.buttonList.add(new GuiButton(200, this.width / 2 - 100, height / 6 + 168 + 11, I18n.format("gui.done", new Object[0])));
    }
}

