/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.IIconCreator;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.src.Config;
import net.minecraft.src.ConnectedTextures;
import net.minecraft.src.Reflector;
import net.minecraft.src.TextureUtils;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureMap
extends AbstractTexture
implements ITickableTextureObject {
    private static final Logger logger = LogManager.getLogger();
    public static final ResourceLocation field_174945_f = new ResourceLocation("missingno");
    public static final ResourceLocation locationBlocksTexture = new ResourceLocation("textures/atlas/blocks.png");
    private final List listAnimatedSprites = Lists.newArrayList();
    private final Map mapRegisteredSprites = Maps.newHashMap();
    private final Map mapUploadedSprites = Maps.newHashMap();
    private final String basePath;
    private final IIconCreator field_174946_m;
    private int mipmapLevels;
    private final TextureAtlasSprite missingImage = new TextureAtlasSprite("missingno");

    public TextureMap(String p_i46099_1_) {
        this(p_i46099_1_, null);
    }

    public TextureMap(String p_i46100_1_, IIconCreator p_i46100_2_) {
        this.basePath = p_i46100_1_;
        this.field_174946_m = p_i46100_2_;
    }

    private ResourceLocation completeResourceLocation(ResourceLocation p_147634_1_, int p_147634_2_) {
        return this.isAbsoluteLocation(p_147634_1_) ? (p_147634_2_ == 0 ? new ResourceLocation(p_147634_1_.getResourceDomain(), String.valueOf(p_147634_1_.getResourcePath()) + ".png") : new ResourceLocation(p_147634_1_.getResourceDomain(), String.valueOf(p_147634_1_.getResourcePath()) + "mipmap" + p_147634_2_ + ".png")) : (p_147634_2_ == 0 ? new ResourceLocation(p_147634_1_.getResourceDomain(), String.format("%s/%s%s", this.basePath, p_147634_1_.getResourcePath(), ".png")) : new ResourceLocation(p_147634_1_.getResourceDomain(), String.format("%s/mipmaps/%s.%d%s", this.basePath, p_147634_1_.getResourcePath(), p_147634_2_, ".png")));
    }

    private int detectMaxMipmapLevel(Map mapSprites, IResourceManager rm) {
        int minLevel;
        int minSize = this.detectMinimumSpriteSize(mapSprites, rm, 20);
        if (minSize < 16) {
            minSize = 16;
        }
        if ((minSize = MathHelper.roundUpToPowerOfTwo(minSize)) > 16) {
            Config.log("Sprite size: " + minSize);
        }
        if ((minLevel = MathHelper.calculateLogBaseTwo(minSize)) < 4) {
            minLevel = 4;
        }
        return minLevel;
    }

    private int detectMinimumSpriteSize(Map mapSprites, IResourceManager rm, int percentScale) {
        int count;
        HashMap<Integer, Integer> mapSizeCounts = new HashMap<Integer, Integer>();
        Set entrySetSprites = mapSprites.entrySet();
        for (Map.Entry setSizes : entrySetSprites) {
            TextureAtlasSprite setSizesSorted = (TextureAtlasSprite)setSizes.getValue();
            ResourceLocation minSize = new ResourceLocation(setSizesSorted.getIconName());
            ResourceLocation countScale = this.completeResourceLocation(minSize, 0);
            if (setSizesSorted.hasCustomLoader(rm, minSize)) continue;
            try {
                Dimension size;
                InputStream it;
                IResource countScaleMax = rm.getResource(countScale);
                if (countScaleMax == null || (it = countScaleMax.getInputStream()) == null || (size = TextureUtils.getImageSize(it, "png")) == null) continue;
                count = size.width;
                int width2 = MathHelper.roundUpToPowerOfTwo(count);
                if (!mapSizeCounts.containsKey(width2)) {
                    mapSizeCounts.put(width2, 1);
                    continue;
                }
                int count1 = (Integer)mapSizeCounts.get(width2);
                mapSizeCounts.put(width2, count1 + 1);
            }
            catch (Exception countScaleMax) {
                // empty catch block
            }
        }
        int countSprites1 = 0;
        Set setSizes1 = mapSizeCounts.keySet();
        TreeSet setSizesSorted1 = new TreeSet(setSizes1);
        Iterator minSize1 = setSizesSorted1.iterator();
        while (minSize1.hasNext()) {
            int countScale1 = (Integer)minSize1.next();
            int countScaleMax1 = (Integer)mapSizeCounts.get(countScale1);
            countSprites1 += countScaleMax1;
        }
        int minSize2 = 16;
        int countScale1 = 0;
        int countScaleMax1 = countSprites1 * percentScale / 100;
        Iterator it1 = setSizesSorted1.iterator();
        do {
            if (!it1.hasNext()) {
                return minSize2;
            }
            int size1 = (Integer)it1.next();
            count = (Integer)mapSizeCounts.get(size1);
            countScale1 += count;
            if (size1 <= minSize2) continue;
            minSize2 = size1;
        } while (countScale1 <= countScaleMax1);
        return minSize2;
    }

    public TextureAtlasSprite func_174942_a(ResourceLocation p_174942_1_) {
        if (p_174942_1_ == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        TextureAtlasSprite var2 = (TextureAtlasSprite)this.mapRegisteredSprites.get(p_174942_1_.toString());
        if (var2 == null && Reflector.ModLoader_getCustomAnimationLogic.exists()) {
            var2 = (TextureAtlasSprite)Reflector.call(Reflector.ModLoader_getCustomAnimationLogic, p_174942_1_);
        }
        if (var2 == null) {
            var2 = TextureAtlasSprite.func_176604_a(p_174942_1_);
            this.mapRegisteredSprites.put(p_174942_1_.toString(), var2);
            if (var2 instanceof TextureAtlasSprite && var2.getIndexInMap() < 0) {
                var2.setIndexInMap(this.mapRegisteredSprites.size());
            }
        }
        return var2;
    }

    public void func_174943_a(IResourceManager p_174943_1_, IIconCreator p_174943_2_) {
        this.mapRegisteredSprites.clear();
        p_174943_2_.func_177059_a(this);
        if (this.mipmapLevels >= 4) {
            this.mipmapLevels = this.detectMaxMipmapLevel(this.mapRegisteredSprites, p_174943_1_);
            Config.log("Mipmap levels: " + this.mipmapLevels);
        }
        this.initMissingImage();
        this.deleteGlTexture();
        ConnectedTextures.updateIcons(this);
        this.loadTextureAtlas(p_174943_1_);
    }

    public TextureAtlasSprite func_174944_f() {
        return this.missingImage;
    }

    public TextureAtlasSprite getAtlasSprite(String p_110572_1_) {
        TextureAtlasSprite var2 = (TextureAtlasSprite)this.mapUploadedSprites.get(p_110572_1_);
        if (var2 == null) {
            var2 = this.missingImage;
        }
        return var2;
    }

    public int getCountRegisteredSprites() {
        return this.mapRegisteredSprites.size();
    }

    private int getMinSpriteSize() {
        int minSize = 1 << this.mipmapLevels;
        if (minSize < 16) {
            minSize = 16;
        }
        return minSize;
    }

    private int[] getMissingImageData(int size) {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        bi.setRGB(0, 0, 16, 16, TextureUtil.missingTextureData, 0, 16);
        BufferedImage bi2 = TextureUtils.scaleToPowerOfTwo(bi, size);
        int[] data = new int[size * size];
        bi2.getRGB(0, 0, size, size, data, 0, size);
        return data;
    }

    public TextureAtlasSprite getSpriteSafe(String name) {
        ResourceLocation loc = new ResourceLocation(name);
        return (TextureAtlasSprite)this.mapRegisteredSprites.get(loc.toString());
    }

    public TextureAtlasSprite getTextureExtry(String name) {
        ResourceLocation loc = new ResourceLocation(name);
        return (TextureAtlasSprite)this.mapRegisteredSprites.get(loc.toString());
    }

    private void initMissingImage() {
        int size = this.getMinSpriteSize();
        int[] var1 = this.getMissingImageData(size);
        this.missingImage.setIconWidth(size);
        this.missingImage.setIconHeight(size);
        int[][] var2 = new int[this.mipmapLevels + 1][];
        var2[0] = var1;
        this.missingImage.setFramesTextureData(Lists.newArrayList((Object[])new int[][][]{var2}));
        this.missingImage.setIndexInMap(0);
    }

    private boolean isAbsoluteLocation(ResourceLocation loc) {
        String path = loc.getResourcePath();
        return this.isAbsoluteLocationPath(path);
    }

    private boolean isAbsoluteLocationPath(String resPath) {
        String path = resPath.toLowerCase();
        return path.startsWith("mcpatcher/") || path.startsWith("optifine/");
    }

    private boolean isTerrainAnimationActive(TextureAtlasSprite ts) {
        return ts != TextureUtils.iconWaterStill && ts != TextureUtils.iconWaterFlow ? (ts != TextureUtils.iconLavaStill && ts != TextureUtils.iconLavaFlow ? (ts != TextureUtils.iconFireLayer0 && ts != TextureUtils.iconFireLayer1 ? (ts == TextureUtils.iconPortal ? Config.isAnimatedPortal() : Config.isAnimatedTerrain()) : Config.isAnimatedFire()) : Config.isAnimatedLava()) : Config.isAnimatedWater();
    }

    @Override
    public void loadTexture(IResourceManager p_110551_1_) throws IOException {
        if (this.field_174946_m != null) {
            this.func_174943_a(p_110551_1_, this.field_174946_m);
        }
    }

    public void loadTextureAtlas(IResourceManager p_110571_1_) {
        List listSprites1;
        int sheetHeight;
        BufferedImage[] var311;
        Config.dbg("Multitexture: " + Config.isMultiTexture());
        if (Config.isMultiTexture()) {
            for (TextureAtlasSprite var3 : this.mapUploadedSprites.values()) {
                var3.deleteSpriteTexture();
            }
        }
        int var21 = Minecraft.getGLMaximumTextureSize();
        Stitcher var31 = new Stitcher(var21, var21, true, 0, this.mipmapLevels);
        this.mapUploadedSprites.clear();
        this.listAnimatedSprites.clear();
        int var4 = Integer.MAX_VALUE;
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPre, this);
        int minSpriteSize = this.getMinSpriteSize();
        int var5 = 1 << this.mipmapLevels;
        for (Map.Entry var25 : this.mapRegisteredSprites.entrySet()) {
            TextureAtlasSprite var26 = (TextureAtlasSprite)var25.getValue();
            ResourceLocation var27 = new ResourceLocation(var26.getIconName());
            ResourceLocation var28 = this.completeResourceLocation(var27, 0);
            if (!var26.hasCustomLoader(p_110571_1_, var27)) {
                try {
                    TextureMetadataSection sheetHeight1;
                    IResource var30 = p_110571_1_.getResource(var28);
                    var311 = new BufferedImage[1 + this.mipmapLevels];
                    var311[0] = TextureUtil.func_177053_a(var30.getInputStream());
                    if (this.mipmapLevels > 0 && var311 != null) {
                        sheetHeight = var311[0].getWidth();
                        var311[0] = TextureUtils.scaleToPowerOfTwo(var311[0], minSpriteSize);
                        int listSprites = var311[0].getWidth();
                        if (!TextureUtils.isPowerOfTwo(sheetHeight)) {
                            Config.log("Scaled non power of 2: " + var26.getIconName() + ", " + sheetHeight + " -> " + listSprites);
                        }
                    }
                    if ((sheetHeight1 = (TextureMetadataSection)var30.getMetadata("texture")) != null) {
                        int it;
                        listSprites1 = sheetHeight1.getListMipmaps();
                        if (!listSprites1.isEmpty()) {
                            int tas = var311[0].getWidth();
                            it = var311[0].getHeight();
                            if (MathHelper.roundUpToPowerOfTwo(tas) != tas || MathHelper.roundUpToPowerOfTwo(it) != it) {
                                throw new RuntimeException("Unable to load extra miplevels, source-texture is not power of two");
                            }
                        }
                        Iterator tas1 = listSprites1.iterator();
                        while (tas1.hasNext()) {
                            it = (Integer)tas1.next();
                            if (it <= 0 || it >= var311.length - 1 || var311[it] != null) continue;
                            ResourceLocation ss = this.completeResourceLocation(var27, it);
                            try {
                                var311[it] = TextureUtil.func_177053_a(p_110571_1_.getResource(ss).getInputStream());
                            }
                            catch (IOException var251) {
                                logger.error("Unable to load miplevel {} from: {}", new Object[]{it, ss, var251});
                            }
                        }
                    }
                    AnimationMetadataSection listSprites2 = (AnimationMetadataSection)var30.getMetadata("animation");
                    var26.func_180598_a(var311, listSprites2);
                }
                catch (RuntimeException var261) {
                    logger.error("Unable to parse metadata from " + var28, (Throwable)var261);
                    continue;
                }
                catch (IOException var271) {
                    logger.error("Using missing texture, unable to load " + var28 + ", " + var271.getClass().getName());
                    continue;
                }
                var4 = Math.min(var4, Math.min(var26.getIconWidth(), var26.getIconHeight()));
                int var301 = Math.min(Integer.lowestOneBit(var26.getIconWidth()), Integer.lowestOneBit(var26.getIconHeight()));
                if (var301 < var5) {
                    logger.warn("Texture {} with size {}x{} limits mip level from {} to {}", new Object[]{var28, var26.getIconWidth(), var26.getIconHeight(), MathHelper.calculateLogBaseTwo(var5), MathHelper.calculateLogBaseTwo(var301)});
                    var5 = var301;
                }
                var31.addSprite(var26);
                continue;
            }
            if (var26.load(p_110571_1_, var27)) continue;
            var4 = Math.min(var4, Math.min(var26.getIconWidth(), var26.getIconHeight()));
            var31.addSprite(var26);
        }
        int var252 = Math.min(var4, var5);
        int var262 = MathHelper.calculateLogBaseTwo(var252);
        if (var262 < 0) {
            var262 = 0;
        }
        if (var262 < this.mipmapLevels) {
            logger.info("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", new Object[]{this.basePath, this.mipmapLevels, var262, var252});
            this.mipmapLevels = var262;
        }
        for (final TextureAtlasSprite var281 : this.mapRegisteredSprites.values()) {
            try {
                var281.generateMipmaps(this.mipmapLevels);
            }
            catch (Throwable var24) {
                var311 = CrashReport.makeCrashReport(var24, "Applying mipmap");
                CrashReportCategory sheetWidth = var311.makeCategory("Sprite being mipmapped");
                sheetWidth.addCrashSectionCallable("Sprite name", new Callable(){

                    public String call() {
                        return var281.getIconName();
                    }
                });
                sheetWidth.addCrashSectionCallable("Sprite size", new Callable(){

                    public String call() {
                        return String.valueOf(var281.getIconWidth()) + " x " + var281.getIconHeight();
                    }
                });
                sheetWidth.addCrashSectionCallable("Sprite frames", new Callable(){

                    public String call() {
                        return String.valueOf(var281.getFrameCount()) + " frames";
                    }
                });
                sheetWidth.addCrashSection("Mipmap levels", this.mipmapLevels);
                throw new ReportedException((CrashReport)var311);
            }
        }
        this.missingImage.generateMipmaps(this.mipmapLevels);
        var31.addSprite(this.missingImage);
        var31.doStitch();
        logger.info("Created: {}x{} {}-atlas", new Object[]{var31.getCurrentWidth(), var31.getCurrentHeight(), this.basePath});
        TextureUtil.func_180600_a(this.getGlTextureId(), this.mipmapLevels, var31.getCurrentWidth(), var31.getCurrentHeight());
        HashMap var282 = Maps.newHashMap((Map)this.mapRegisteredSprites);
        for (TextureAtlasSprite var312 : var31.getStichSlots()) {
            String sheetWidth1 = var312.getIconName();
            var282.remove(sheetWidth1);
            this.mapUploadedSprites.put(sheetWidth1, var312);
            try {
                TextureUtil.uploadTextureMipmap(var312.getFrameTextureData(0), var312.getIconWidth(), var312.getIconHeight(), var312.getOriginX(), var312.getOriginY(), false, false);
            }
            catch (Throwable var22) {
                CrashReport listSprites3 = CrashReport.makeCrashReport(var22, "Stitching texture atlas");
                CrashReportCategory it1 = listSprites3.makeCategory("Texture being stitched together");
                it1.addCrashSection("Atlas path", this.basePath);
                it1.addCrashSection("Sprite", var312);
                throw new ReportedException(listSprites3);
            }
            if (!var312.hasAnimationMetadata()) continue;
            this.listAnimatedSprites.add(var312);
        }
        for (TextureAtlasSprite var312 : var282.values()) {
            var312.copyFrom(this.missingImage);
        }
        if (Config.isMultiTexture()) {
            int sheetWidth2 = var31.getCurrentWidth();
            sheetHeight = var31.getCurrentHeight();
            listSprites1 = var31.getStichSlots();
            for (TextureAtlasSprite tas2 : listSprites1) {
                tas2.sheetWidth = sheetWidth2;
                tas2.sheetHeight = sheetHeight;
                tas2.mipmapLevels = this.mipmapLevels;
                TextureAtlasSprite ss1 = tas2.spriteSingle;
                if (ss1 == null) continue;
                ss1.sheetWidth = sheetWidth2;
                ss1.sheetHeight = sheetHeight;
                ss1.mipmapLevels = this.mipmapLevels;
                tas2.bindSpriteTexture();
                boolean texBlur = false;
                boolean texClamp = true;
                TextureUtil.uploadTextureMipmap(ss1.getFrameTextureData(0), ss1.getIconWidth(), ss1.getIconHeight(), ss1.getOriginX(), ss1.getOriginY(), texBlur, texClamp);
            }
            Config.getMinecraft().getTextureManager().bindTexture(locationBlocksTexture);
        }
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPost, this);
        if (Config.equals(System.getProperty("saveTextureMap"), "true")) {
            TextureUtil.func_177055_a(this.basePath.replaceAll("/", "_"), this.getGlTextureId(), this.mipmapLevels, var31.getCurrentWidth(), var31.getCurrentHeight());
        }
    }

    public void setMipmapLevels(int p_147633_1_) {
        this.mipmapLevels = p_147633_1_;
    }

    public boolean setTextureEntry(String name, TextureAtlasSprite entry) {
        if (!this.mapRegisteredSprites.containsKey(name)) {
            this.mapRegisteredSprites.put(name, entry);
            if (entry.getIndexInMap() < 0) {
                entry.setIndexInMap(this.mapRegisteredSprites.size());
            }
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        this.updateAnimations();
    }

    public void updateAnimations() {
        TextureUtil.bindTexture(this.getGlTextureId());
        for (TextureAtlasSprite it : this.listAnimatedSprites) {
            if (!this.isTerrainAnimationActive(it)) continue;
            it.updateAnimation();
        }
        if (Config.isMultiTexture()) {
            for (TextureAtlasSprite ts : this.listAnimatedSprites) {
                TextureAtlasSprite spriteSingle;
                if (!this.isTerrainAnimationActive(ts) || (spriteSingle = ts.spriteSingle) == null) continue;
                ts.bindSpriteTexture();
                spriteSingle.updateAnimation();
            }
            TextureUtil.bindTexture(this.getGlTextureId());
        }
    }
}

