/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.world.WorldServer;

public class CommandTime
extends CommandBase {
    @Override
    public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
        return args.length == 1 ? CommandBase.getListOfStringsMatchingLastWord(args, "set", "add", "query") : (args.length == 2 && args[0].equals("set") ? CommandBase.getListOfStringsMatchingLastWord(args, "day", "night") : (args.length == 2 && args[0].equals("query") ? CommandBase.getListOfStringsMatchingLastWord(args, "daytime", "gametime") : null));
    }

    protected void addTime(ICommandSender p_71553_1_, int p_71553_2_) {
        WorldServer[] worldServerArray = MinecraftServer.getServer().worldServers;
        int n = MinecraftServer.getServer().worldServers.length;
        int n2 = 0;
        while (n2 < n) {
            WorldServer var4 = worldServerArray[n2];
            var4.setWorldTime(var4.getWorldTime() + (long)p_71553_2_);
            ++n2;
        }
    }

    @Override
    public String getCommandName() {
        return "time";
    }

    @Override
    public String getCommandUsage(ICommandSender sender) {
        return "commands.time.usage";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void processCommand(ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 1) {
            if (args[0].equals("set")) {
                int var3 = args[1].equals("day") ? 1000 : (args[1].equals("night") ? 13000 : CommandBase.parseInt(args[1], 0));
                this.setTime(sender, var3);
                CommandBase.notifyOperators(sender, (ICommand)this, "commands.time.set", var3);
                return;
            }
            if (args[0].equals("add")) {
                int var3 = CommandBase.parseInt(args[1], 0);
                this.addTime(sender, var3);
                CommandBase.notifyOperators(sender, (ICommand)this, "commands.time.added", var3);
                return;
            }
            if (args[0].equals("query")) {
                if (args[1].equals("daytime")) {
                    int var3 = (int)(sender.getEntityWorld().getWorldTime() % Integer.MAX_VALUE);
                    sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, var3);
                    CommandBase.notifyOperators(sender, (ICommand)this, "commands.time.query", var3);
                    return;
                }
                if (args[1].equals("gametime")) {
                    int var3 = (int)(sender.getEntityWorld().getTotalWorldTime() % Integer.MAX_VALUE);
                    sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, var3);
                    CommandBase.notifyOperators(sender, (ICommand)this, "commands.time.query", var3);
                    return;
                }
            }
        }
        throw new WrongUsageException("commands.time.usage", new Object[0]);
    }

    protected void setTime(ICommandSender p_71552_1_, int p_71552_2_) {
        WorldServer[] worldServerArray = MinecraftServer.getServer().worldServers;
        int n = MinecraftServer.getServer().worldServers.length;
        int n2 = 0;
        while (n2 < n) {
            WorldServer worldServer = worldServerArray[n2];
            worldServer.setWorldTime(p_71552_2_);
            ++n2;
        }
    }
}

