/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityEnderPearl
extends EntityThrowable {
    public EntityEnderPearl(World worldIn, double p_i1784_2_, double p_i1784_4_, double p_i1784_6_) {
        super(worldIn, p_i1784_2_, p_i1784_4_, p_i1784_6_);
    }

    public EntityEnderPearl(World worldIn, EntityLivingBase p_i1783_2_) {
        super(worldIn, p_i1783_2_);
    }

    @Override
    protected void onImpact(MovingObjectPosition p_70184_1_) {
        EntityLivingBase var2 = this.getThrower();
        if (p_70184_1_.entityHit != null) {
            p_70184_1_.entityHit.attackEntityFrom(DamageSource.causeThrownDamage(this, var2), 0.0f);
        }
        int var3 = 0;
        while (var3 < 32) {
            this.worldObj.spawnParticle(EnumParticleTypes.PORTAL, this.posX, this.posY + this.rand.nextDouble() * 2.0, this.posZ, this.rand.nextGaussian(), 0.0, this.rand.nextGaussian(), new int[0]);
            ++var3;
        }
        if (!this.worldObj.isRemote) {
            if (var2 instanceof EntityPlayerMP) {
                EntityPlayerMP var5 = (EntityPlayerMP)var2;
                if (var5.playerNetServerHandler.getNetworkManager().isChannelOpen() && var5.worldObj == this.worldObj && !var5.isPlayerSleeping()) {
                    if (this.rand.nextFloat() < 0.05f && this.worldObj.getGameRules().getGameRuleBooleanValue("doMobSpawning")) {
                        EntityEndermite var4 = new EntityEndermite(this.worldObj);
                        var4.setSpawnedByPlayer(true);
                        var4.setLocationAndAngles(var2.posX, var2.posY, var2.posZ, var2.rotationYaw, var2.rotationPitch);
                        this.worldObj.spawnEntityInWorld(var4);
                    }
                    if (var2.isRiding()) {
                        var2.mountEntity(null);
                    }
                    var2.setPositionAndUpdate(this.posX, this.posY, this.posZ);
                    var2.fallDistance = 0.0f;
                    var2.attackEntityFrom(DamageSource.fall, 5.0f);
                }
            }
            this.setDead();
        }
    }

    @Override
    public void onUpdate() {
        EntityLivingBase var1 = this.getThrower();
        if (var1 != null && var1 instanceof EntityPlayer && !var1.isEntityAlive()) {
            this.setDead();
        } else {
            super.onUpdate();
        }
    }
}

