/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;

public class NBTTagIntArray
extends NBTBase {
    private int[] intArray;

    NBTTagIntArray() {
    }

    public NBTTagIntArray(int[] p_i45132_1_) {
        this.intArray = p_i45132_1_;
    }

    @Override
    public NBTBase copy() {
        int[] var1 = new int[this.intArray.length];
        System.arraycopy(this.intArray, 0, var1, 0, this.intArray.length);
        return new NBTTagIntArray(var1);
    }

    @Override
    public boolean equals(Object p_equals_1_) {
        return super.equals(p_equals_1_) ? Arrays.equals(this.intArray, ((NBTTagIntArray)p_equals_1_).intArray) : false;
    }

    @Override
    public byte getId() {
        return 11;
    }

    public int[] getIntArray() {
        return this.intArray;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.intArray);
    }

    @Override
    void read(DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        int var4 = input.readInt();
        sizeTracker.read(32 * var4);
        this.intArray = new int[var4];
        int var5 = 0;
        while (var5 < var4) {
            this.intArray[var5] = input.readInt();
            ++var5;
        }
    }

    @Override
    public String toString() {
        String var1 = "[";
        int[] var2 = this.intArray;
        int var3 = var2.length;
        int var4 = 0;
        while (var4 < var3) {
            int var5 = var2[var4];
            var1 = String.valueOf(var1) + var5 + ",";
            ++var4;
        }
        return String.valueOf(var1) + "]";
    }

    @Override
    void write(DataOutput output) throws IOException {
        output.writeInt(this.intArray.length);
        int[] nArray = this.intArray;
        int n = this.intArray.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            output.writeInt(element);
            ++n2;
        }
    }
}

