/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiOptionSlider;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiVideoSettings;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;

public class GuiPerformanceSettingsOF
extends GuiScreen {
    private static GameSettings.Options[] enumOptions = new GameSettings.Options[]{GameSettings.Options.SMOOTH_FPS, GameSettings.Options.SMOOTH_WORLD, GameSettings.Options.FAST_RENDER, GameSettings.Options.FAST_MATH, GameSettings.Options.CHUNK_UPDATES, GameSettings.Options.CHUNK_UPDATES_DYNAMIC, GameSettings.Options.LAZY_CHUNK_LOADING};
    private final GuiScreen prevScreen;
    protected String title = "Performance Settings";
    private final GameSettings settings;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private long mouseStillTime = 0L;

    public GuiPerformanceSettingsOF(GuiScreen guiscreen, GameSettings gamesettings) {
        this.prevScreen = guiscreen;
        this.settings = gamesettings;
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (guibutton.enabled) {
            if (guibutton.id < 200 && guibutton instanceof GuiOptionButton) {
                this.settings.setOptionValue(((GuiOptionButton)guibutton).returnEnumOptions(), 1);
                guibutton.displayString = this.settings.getKeyBinding(GameSettings.Options.getEnumOptions(guibutton.id));
            }
            if (guibutton.id == 200) {
                this.mc.gameSettings.saveOptions();
                this.mc.displayGuiScreen(this.prevScreen);
            }
            if (guibutton.id != GameSettings.Options.CLOUD_HEIGHT.ordinal()) {
                ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.displayWidth, this.mc.displayHeight);
                int i = scaledresolution.getScaledWidth();
                int j = scaledresolution.getScaledHeight();
                this.setWorldAndResolution(this.mc, i, j);
            }
        }
    }

    @Override
    public void drawScreen(int x, int y, float f) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(x, y, f);
        if (Math.abs(x - this.lastMouseX) <= 5 && Math.abs(y - this.lastMouseY) <= 5) {
            int activateDelay = 700;
            if (System.currentTimeMillis() >= this.mouseStillTime + (long)activateDelay) {
                int x1 = this.width / 2 - 150;
                int y1 = height / 6 - 5;
                if (y <= y1 + 98) {
                    y1 += 105;
                }
                int x2 = x1 + 150 + 150;
                int y2 = y1 + 84 + 10;
                GuiButton btn = this.getSelectedButton(x, y);
                if (btn != null) {
                    String s = this.getButtonName(btn.displayString);
                    String[] lines = this.getTooltipLines(s);
                    if (lines == null) {
                        return;
                    }
                    this.drawGradientRect(x1, y1, x2, y2, -536870912, -536870912);
                    int i = 0;
                    while (i < lines.length) {
                        String line = lines[i];
                        this.fontRendererObj.func_175063_a(line, x1 + 5, y1 + 5 + i * 11, 0xDDDDDD);
                        ++i;
                    }
                }
            }
        } else {
            this.lastMouseX = x;
            this.lastMouseY = y;
            this.mouseStillTime = System.currentTimeMillis();
        }
    }

    private String getButtonName(String displayString) {
        int pos = displayString.indexOf(58);
        return pos < 0 ? displayString : displayString.substring(0, pos);
    }

    private GuiButton getSelectedButton(int i, int j) {
        int k = 0;
        while (k < this.buttonList.size()) {
            boolean flag;
            GuiButton btn = (GuiButton)this.buttonList.get(k);
            int btnWidth = GuiVideoSettings.getButtonWidth(btn);
            int btnHeight = GuiVideoSettings.getButtonHeight(btn);
            boolean bl = flag = i >= btn.xPosition && j >= btn.yPosition && i < btn.xPosition + btnWidth && j < btn.yPosition + btnHeight;
            if (flag) {
                return btn;
            }
            ++k;
        }
        return null;
    }

    private String[] getTooltipLines(String btnName) {
        String[] stringArray;
        if (btnName.equals("Smooth FPS")) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "Stabilizes FPS by flushing the graphic driver buffers";
            stringArray2[1] = "  OFF - no stabilization, FPS may fluctuate";
            stringArray2[2] = "  ON - FPS stabilization";
            stringArray2[3] = "This option is graphics driver dependant and its effect";
            stringArray = stringArray2;
            stringArray2[4] = "is not always visible";
        } else if (btnName.equals("Smooth World")) {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "Removes lag spikes caused by the internal server.";
            stringArray3[1] = "  OFF - no stabilization, FPS may fluctuate";
            stringArray3[2] = "  ON - FPS stabilization";
            stringArray3[3] = "Stabilizes FPS by distributing the internal server load.";
            stringArray = stringArray3;
            stringArray3[4] = "Effective only for local worlds (single player).";
        } else if (btnName.equals("Load Far")) {
            String[] stringArray4 = new String[6];
            stringArray4[0] = "Loads the world chunks at distance Far.";
            stringArray4[1] = "Switching the render distance does not cause all chunks ";
            stringArray4[2] = "to be loaded again.";
            stringArray4[3] = "  OFF - world chunks loaded up to render distance";
            stringArray4[4] = "  ON - world chunks loaded at distance Far, allows";
            stringArray = stringArray4;
            stringArray4[5] = "       fast render distance switching";
        } else if (btnName.equals("Preloaded Chunks")) {
            String[] stringArray5 = new String[6];
            stringArray5[0] = "Defines an area in which no chunks will be loaded";
            stringArray5[1] = "  OFF - after 5m new chunks will be loaded";
            stringArray5[2] = "  2 - after 32m  new chunks will be loaded";
            stringArray5[3] = "  8 - after 128m new chunks will be loaded";
            stringArray5[4] = "Higher values need more time to load all the chunks";
            stringArray = stringArray5;
            stringArray5[5] = "and may decrease the FPS.";
        } else if (btnName.equals("Chunk Updates")) {
            String[] stringArray6 = new String[6];
            stringArray6[0] = "Chunk updates";
            stringArray6[1] = " 1 - slower world loading, higher FPS (default)";
            stringArray6[2] = " 3 - faster world loading, lower FPS";
            stringArray6[3] = " 5 - fastest world loading, lowest FPS";
            stringArray6[4] = "Number of chunk updates per rendered frame,";
            stringArray = stringArray6;
            stringArray6[5] = "higher values may destabilize the framerate.";
        } else if (btnName.equals("Dynamic Updates")) {
            String[] stringArray7 = new String[5];
            stringArray7[0] = "Dynamic chunk updates";
            stringArray7[1] = " OFF - (default) standard chunk updates per frame";
            stringArray7[2] = " ON - more updates while the player is standing still";
            stringArray7[3] = "Dynamic updates force more chunk updates while";
            stringArray = stringArray7;
            stringArray7[4] = "the player is standing still to load the world faster.";
        } else if (btnName.equals("Lazy Chunk Loading")) {
            String[] stringArray8 = new String[7];
            stringArray8[0] = "Lazy Chunk Loading";
            stringArray8[1] = " OFF - default server chunk loading";
            stringArray8[2] = " ON - lazy server chunk loading (smoother)";
            stringArray8[3] = "Smooths the integrated server chunk loading by";
            stringArray8[4] = "distributing the chunks over several ticks.";
            stringArray8[5] = "Turn it OFF if parts of the world do not load correctly.";
            stringArray = stringArray8;
            stringArray8[6] = "Effective only for local worlds and single-core CPU.";
        } else if (btnName.equals("Fast Math")) {
            String[] stringArray9 = new String[5];
            stringArray9[0] = "Fast Math";
            stringArray9[1] = " OFF - standard math (default)";
            stringArray9[2] = " ON - faster math";
            stringArray9[3] = "Uses optimized sin() and cos() functions which can";
            stringArray = stringArray9;
            stringArray9[4] = "better utilize the CPU cache and increase the FPS.";
        } else if (btnName.equals("Fast Render")) {
            String[] stringArray10 = new String[5];
            stringArray10[0] = "Fast Render";
            stringArray10[1] = " OFF - standard rendering (default)";
            stringArray10[2] = " ON - optimized rendering (faster)";
            stringArray10[3] = "Uses optimized rendering algorithm which decreases";
            stringArray = stringArray10;
            stringArray10[4] = "the GPU load and may substantionally increase the FPS.";
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @Override
    public void initGui() {
        int i = 0;
        GameSettings.Options[] aenumoptions = enumOptions;
        int j = aenumoptions.length;
        int k = 0;
        while (k < j) {
            GameSettings.Options enumoptions = aenumoptions[k];
            int x = this.width / 2 - 155 + i % 2 * 160;
            int y = height / 6 + 21 * (i / 2) - 10;
            if (!enumoptions.getEnumFloat()) {
                this.buttonList.add(new GuiOptionButton(enumoptions.returnEnumOrdinal(), x, y, enumoptions, this.settings.getKeyBinding(enumoptions)));
            } else {
                this.buttonList.add(new GuiOptionSlider(enumoptions.returnEnumOrdinal(), x, y, enumoptions));
            }
            ++i;
            ++k;
        }
        this.buttonList.add(new GuiButton(200, this.width / 2 - 100, height / 6 + 168 + 11, I18n.format("gui.done", new Object[0])));
    }
}

