/*
 * Decompiled with CFR 0.152.
 */
package org.darkstorm.minecraft.gui.theme.simple;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.darkstorm.minecraft.gui.component.ComboBox;
import org.darkstorm.minecraft.gui.component.Container;
import org.darkstorm.minecraft.gui.theme.AbstractComponentUI;
import org.darkstorm.minecraft.gui.theme.simple.SimpleTheme;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class SimpleComboBoxUI
extends AbstractComponentUI<ComboBox> {
    private final SimpleTheme theme;

    SimpleComboBoxUI(SimpleTheme theme) {
        super(ComboBox.class);
        this.theme = theme;
        this.foreground = Color.WHITE;
        this.background = new Color(128, 128, 128, 192);
    }

    @Override
    protected void renderComponent(ComboBox component) {
        this.translateComponent(component, false);
        Rectangle area = component.getArea();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3553);
        boolean maxWidth = false;
        String[] stringArray = component.getElements();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            RenderUtil.setColor(component.getBackgroundColor());
            ++n2;
        }
        GL11.glBegin((int)7);
        GL11.glEnd();
        Point mouse = RenderUtil.calculateMouseLocation();
        Container parent = component.getParent();
        while (parent != null) {
            mouse.x -= parent.getX();
            mouse.y -= parent.getY();
            parent = parent.getParent();
        }
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)(Mouse.isButtonDown((int)0) ? 0.5f : 0.3f));
        if (area.contains(mouse)) {
            GL11.glBegin((int)7);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)area.width, (double)0.0);
            GL11.glVertex2d((double)area.width, (double)area.height);
            GL11.glVertex2d((double)0.0, (double)area.height);
            GL11.glEnd();
        } else if (component.isSelected() && mouse.x >= area.x) {
            int cfr_ignored_0 = mouse.x;
            int cfr_ignored_1 = area.x;
            int cfr_ignored_2 = area.width;
        }
    }
}

