/*
 * Decompiled with CFR 0.152.
 */
package org.darkstorm.minecraft.gui.theme.simple;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.darkstorm.minecraft.gui.component.Container;
import org.darkstorm.minecraft.gui.component.Frame;
import org.darkstorm.minecraft.gui.theme.AbstractComponentUI;
import org.darkstorm.minecraft.gui.theme.simple.SimpleTheme;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.opengl.GL11;

public abstract class SimpleFrameUI
extends AbstractComponentUI<Frame> {
    private final SimpleTheme theme;

    SimpleFrameUI(SimpleTheme theme) {
        super(Frame.class);
        this.theme = theme;
        this.foreground = Color.WHITE;
        this.background = new Color(128, 128, 128, 128);
    }

    @Override
    protected void renderComponent(Frame component) {
        Rectangle area = new Rectangle(component.getArea());
        this.translateComponent(component, false);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        if (component.isMinimized()) {
            RenderUtil.setColor(component.getBackgroundColor());
        }
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)area.height);
        GL11.glVertex2d((double)0.0, (double)area.height);
        GL11.glEnd();
        int offset = component.getWidth() - 2;
        Point mouse = RenderUtil.calculateMouseLocation();
        Container parent = component;
        while (parent != null) {
            mouse.x -= parent.getX();
            mouse.y -= parent.getY();
            parent = parent.getParent();
        }
        boolean[] checks = new boolean[]{component.isClosable(), component.isPinnable(), component.isMinimizable()};
        boolean[] blArray = new boolean[3];
        blArray[1] = component.isPinned();
        blArray[2] = component.isMinimized();
        boolean[] overlays = blArray;
        int i = 0;
        while (i < checks.length) {
            if (checks[i]) {
                RenderUtil.setColor(component.getBackgroundColor());
                GL11.glBegin((int)7);
            }
            ++i;
        }
    }
}

